/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.version;

public class JavaVersion {
    private final int[] versionNumbers;
    private final boolean isEarlyAccess;
    public static final int UNKNOWN = -1;

    public JavaVersion(String version) {
        if (version == null) {
            this.versionNumbers = null;
            this.isEarlyAccess = false;
            return;
        }
        String[] numbers = version.split("[\\._]");
        int offset = 0;
        int versionNumbersLength = numbers.length;
        if (numbers.length > 0 && this.parseNumber(0, numbers) == 1) {
            offset = 1;
            versionNumbersLength = numbers.length - 1;
        }
        this.versionNumbers = new int[versionNumbersLength];
        for (int i = 0; i < versionNumbersLength; ++i) {
            this.versionNumbers[i] = this.parseNumber(i + offset, numbers);
        }
        this.isEarlyAccess = version.contains("ea");
    }

    public JavaVersion(int ... versionNumbers) {
        this(false, versionNumbers);
    }

    public JavaVersion(boolean isEarlyAccess, int ... versionNumbers) {
        this.versionNumbers = versionNumbers;
        this.isEarlyAccess = isEarlyAccess;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (int versionNumber : this.versionNumbers) {
            result = 31 * result + versionNumber;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaVersion other = (JavaVersion)obj;
        return this.isGreaterOrEqualThan(other) && other.isGreaterOrEqualThan(this);
    }

    public boolean isGreaterOrEqualThan(JavaVersion otherVersion) {
        return this.isGreaterOrEqualThan(otherVersion, true);
    }

    public boolean isGreaterOrEqualThanDisregardEa(JavaVersion otherVersion) {
        return this.isGreaterOrEqualThan(otherVersion, false);
    }

    private boolean isGreaterOrEqualThan(JavaVersion otherVersion, boolean compareEa) {
        int maxLength = Math.max(this.versionNumbers.length, otherVersion.versionNumbers.length);
        for (int i = 0; i < maxLength; ++i) {
            int otherNumber;
            int thisNumber = this.versionNumbers.length > i ? this.versionNumbers[i] : 0;
            int n = otherNumber = otherVersion.versionNumbers.length > i ? otherVersion.versionNumbers[i] : 0;
            if (thisNumber == otherNumber) continue;
            return thisNumber > otherNumber;
        }
        return !compareEa || !this.isEarlyAccess || otherVersion.isEarlyAccess;
    }

    public boolean isSameMajorVersion(JavaVersion otherVersion) {
        return otherVersion != null && this.versionNumbers.length > 0 && otherVersion.versionNumbers.length > 0 && this.versionNumbers[0] == otherVersion.versionNumbers[0];
    }

    public int getMajorVersion() {
        if (this.versionNumbers == null) {
            return -1;
        }
        return this.versionNumbers[0];
    }

    public String toString() {
        if (this.versionNumbers.length == 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append(this.versionNumbers[0]);
        for (int i = 1; i < this.versionNumbers.length; ++i) {
            b.append('.');
            b.append(this.versionNumbers[i]);
        }
        return b.toString();
    }

    public boolean isEarlyAccess() {
        return this.isEarlyAccess;
    }

    private int parseNumber(int index, String[] numbers) {
        char c;
        if (index + 1 > numbers.length) {
            return -1;
        }
        StringBuilder numberStringBuilder = new StringBuilder();
        for (int i = 0; i < numbers[index].length() && Character.isDigit(c = numbers[index].charAt(i)); ++i) {
            numberStringBuilder.append(c);
        }
        try {
            return Integer.parseInt(numberStringBuilder.toString());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }
}

