/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Arrays;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SharedGroup;

public class OrderedGroup
extends Group {
    private boolean[] checkArr = null;
    public static final int ALLOW_CHILD_INDEX_ORDER_READ = 17;
    public static final int ALLOW_CHILD_INDEX_ORDER_WRITE = 18;
    private static final int[] readCapabilities = new int[]{17};

    public OrderedGroup() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public void setChildIndexOrder(int[] nArray) {
        this.verifyChildIndexOrderArray(nArray, 0);
        ((OrderedGroupRetained)this.retained).setChildIndexOrder(nArray);
    }

    public int[] getChildIndexOrder() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrderedGroup5"));
        }
        return ((OrderedGroupRetained)this.retained).getChildIndexOrder();
    }

    public void addChild(Node node, int[] nArray) {
        this.verifyAddStates(node);
        this.verifyChildIndexOrderArray(nArray, 1);
        ((OrderedGroupRetained)this.retained).addChild(node, nArray);
    }

    @Override
    public void addChild(Node node) {
        super.addChild(node);
    }

    @Override
    public void insertChild(Node node, int n) {
        if (((OrderedGroupRetained)this.retained).userChildIndexOrder != null) {
            throw new IllegalStateException(J3dI18N.getString("OrderedGroup6"));
        }
        super.insertChild(node, n);
    }

    @Override
    public void removeChild(int n) {
        super.removeChild(n);
    }

    @Override
    public void moveTo(BranchGroup branchGroup) {
        super.moveTo(branchGroup);
    }

    @Override
    public void removeChild(Node node) {
        super.removeChild(node);
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
    }

    @Override
    void createRetained() {
        this.retained = new OrderedGroupRetained();
        this.retained.setSource(this);
    }

    void verifyAddStates(Node node) {
        if (node instanceof SharedGroup) {
            throw new IllegalArgumentException(J3dI18N.getString("Group2"));
        }
        if (this.isLiveOrCompiled()) {
            if (!(node instanceof BranchGroup)) {
                throw new RestrictedAccessException(J3dI18N.getString("Group12"));
            }
            if (!this.getCapability(14)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Group16"));
            }
        }
    }

    void verifyChildIndexOrderArray(int[] nArray, int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("OrderedGroup4"));
        }
        if (nArray != null) {
            if (nArray.length != ((GroupRetained)this.retained).children.size() + n) {
                throw new IllegalArgumentException(J3dI18N.getString("OrderedGroup0"));
            }
            if (this.checkArr == null || this.checkArr.length != nArray.length) {
                this.checkArr = new boolean[nArray.length];
            }
            Arrays.fill(this.checkArr, false);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0) {
                    throw new IllegalArgumentException(J3dI18N.getString("OrderedGroup1"));
                }
                if (nArray[i] >= nArray.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("OrderedGroup2"));
                }
                if (this.checkArr[nArray[i]]) {
                    throw new IllegalArgumentException(J3dI18N.getString("OrderedGroup3"));
                }
                this.checkArr[nArray[i]] = true;
            }
        }
    }

    @Override
    public Node cloneNode(boolean bl) {
        OrderedGroup orderedGroup = new OrderedGroup();
        orderedGroup.duplicateNode(this, bl);
        return orderedGroup;
    }
}

