/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.Map;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.basictypes.ArrayIndexer;
import hughai.basictypes.Int2;
import hughai.basictypes.TerrainPos;
import hughai.mapping.HeightMap;
import hughai.mapping.SlopeMap;
import hughai.ui.MainUI;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.Config;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MovementMaps {
    public static final int granularity = 2;
    CSAI csai;
    OOAICallback aicallback;
    UnitDefHelp unitDefHelp;
    LogFile logfile;
    Map gameMap;
    DrawingUtils drawingUtils;
    Config config;
    PlayerObjects playerObjects;
    public final int SQUARE_SIZE = 8;
    private List<Float> heightmap;
    private boolean[][] infantrymap;
    private boolean[][] vehiclemap;
    private boolean[][] boatmap;
    private int[][] infantryareas;
    private int[][] vehicleareas;
    private int[][] boatareas;
    public Integer[] infantryareasizes = null;
    public Integer[] vehicleareasizes = null;
    public Integer[] boatareasizes = null;
    public int mapwidth;
    public int mapheight;
    SlopeMap slopeMap;

    public MovementMaps(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.unitDefHelp = playerObjects.getUnitDefHelp();
        this.gameMap = this.aicallback.getMap();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.config = playerObjects.getConfig();
        this.playerObjects = playerObjects;
    }

    void Init() {
        this.GenerateMaps();
        this.playerObjects.getMainUI().registerButton("Show vehicle areas", new ShowVehicleAreasButton());
        this.playerObjects.getMainUI().registerButton("Show infantry areas", new ShowInfantryAreasButton());
    }

    public boolean infantryCanMoveOk(MovementMapPos movementMapPos) {
        return this.infantrymap[movementMapPos.x][movementMapPos.y];
    }

    public boolean vehicleCanMoveOk(MovementMapPos movementMapPos) {
        return this.vehiclemap[movementMapPos.x][movementMapPos.y];
    }

    public boolean boatCanMoveOk(MovementMapPos movementMapPos) {
        return this.boatmap[movementMapPos.x][movementMapPos.y];
    }

    public int GetVehicleArea(TerrainPos terrainPos) {
        MovementMapPos movementMapPos = MovementMapPos.fromTerrainPos(terrainPos);
        return this.vehicleareas[movementMapPos.x][movementMapPos.y];
    }

    public int GetBoatArea(TerrainPos terrainPos) {
        MovementMapPos movementMapPos = MovementMapPos.fromTerrainPos(terrainPos);
        return this.boatareas[movementMapPos.x][movementMapPos.y];
    }

    public int GetInfantryArea(TerrainPos terrainPos) {
        MovementMapPos movementMapPos = MovementMapPos.fromTerrainPos(terrainPos);
        return this.infantryareas[movementMapPos.x][movementMapPos.y];
    }

    public int GetArea(UnitDef unitDef, TerrainPos terrainPos) {
        if (this.unitDefHelp.IsAirCraft(unitDef)) {
            return 1;
        }
        if (this.unitDefHelp.IsBoat(unitDef)) {
            return this.GetBoatArea(terrainPos);
        }
        if (unitDef.getMoveData().getMaxSlope() >= this.config.getMaxinfantryslope().floatValue()) {
            return this.GetInfantryArea(terrainPos);
        }
        if (unitDef.getMoveData().getMaxSlope() >= this.config.getMaxvehicleslope().floatValue()) {
            return this.GetVehicleArea(terrainPos);
        }
        this.csai.sendTextMessage("Error: maxVehicleslope in configuration is set too high, because unit " + unitDef.getHumanName() + " only has a maxslope of " + unitDef.getMoveData().getMaxSlope() + " compared to in confiig file " + this.config.getMaxvehicleslope());
        return 0;
    }

    public void GenerateMaps() {
        this.logfile.WriteLine("MovementMaps.GenerateMaps start");
        this.slopeMap = this.playerObjects.getMaps().getSlopeMap();
        this.heightmap = this.gameMap.getHeightMap();
        this.mapwidth = this.gameMap.getWidth();
        this.mapheight = this.gameMap.getHeight();
        this.GenerateInfantryAccessibleMap();
        this.GenerateVehicleAccessibleMap();
        this.GenerateBoatAccessibleMap();
        this.infantryareas = this.CreateAreas(this.infantryareasizes, this.infantrymap);
        this.vehicleareas = this.CreateAreas(this.vehicleareasizes, this.vehiclemap);
        this.boatareas = this.CreateAreas(this.boatareasizes, this.boatmap);
        this.logfile.WriteLine("MovementMaps.GenerateMaps done");
    }

    int[][] CreateAreas(Integer[] integerArray, boolean[][] blArray) {
        this.logfile.WriteLine("CreateAreas");
        boolean[][] blArray2 = new boolean[this.mapwidth / 2][this.mapheight / 2];
        int[][] nArray = new int[this.mapwidth / 2][this.mapheight / 2];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        int n = 1;
        for (int i = 0; i < this.mapheight / 2; ++i) {
            for (int j = 0; j < this.mapwidth / 2; ++j) {
                if (!blArray[j][i] || blArray2[j][i]) continue;
                int n2 = this.Bfs(nArray, n, j, i, blArray, blArray2);
                arrayList.add(n2);
                ++n;
            }
        }
        this.logfile.WriteLine("number areas: " + (n - 1));
        integerArray = arrayList.toArray(new Integer[0]);
        return nArray;
    }

    int Bfs(int[][] nArray, int n, int n2, int n3, boolean[][] blArray, boolean[][] blArray2) {
        Direction[] directionArray = new Direction[]{new Direction(0, 1), new Direction(0, -1), new Direction(1, 0), new Direction(-1, 0)};
        int n4 = 1;
        blArray2[n2][n3] = true;
        nArray[n2][n3] = n;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.offer((n2 << 16) + n3);
        while (!linkedList.isEmpty()) {
            int n5 = (Integer)linkedList.poll();
            int n6 = n5 >> 16;
            int n7 = n5 & 0xFFFF;
            for (Direction direction : directionArray) {
                int n8 = direction.x;
                int n9 = direction.y;
                int n10 = n6 + n8;
                int n11 = n7 + n9;
                if (n10 < 0 || n11 < 0 || n10 >= this.mapwidth / 2 || n11 >= this.mapheight / 2 || blArray2[n10][n11] || !blArray[n10][n11]) continue;
                blArray2[n10][n11] = true;
                ++n4;
                nArray[n10][n11] = n;
                linkedList.offer((n10 << 16) + n11);
            }
        }
        return n4;
    }

    void GenerateInfantryAccessibleMap() {
        this.logfile.WriteLine("GenerateInfantryAccessibleMap");
        this.infantrymap = new boolean[this.mapwidth / 2][this.mapheight / 2];
        for (int i = 0; i < this.mapheight / 2; ++i) {
            for (int j = 0; j < this.mapwidth / 2; ++j) {
                this.infantrymap[j][i] = true;
            }
        }
        ArrayIndexer arrayIndexer = new ArrayIndexer(this.mapwidth, this.mapheight);
        float f = this.config.getMaxinfantryslope().floatValue();
        for (int i = 0; i < this.mapheight; ++i) {
            for (int j = 0; j < this.mapwidth; ++j) {
                HeightMap.HeightMapPos heightMapPos = new HeightMap.HeightMapPos(j, i);
                SlopeMap.SlopeMapPos slopeMapPos = SlopeMap.SlopeMapPos.fromHeightMapPos(heightMapPos);
                if (this.slopeMap.getSlopeAt(slopeMapPos) > f) {
                    this.infantrymap[j / 2][i / 2] = false;
                }
                if (!(this.heightmap.get(arrayIndexer.GetIndex(j, i)).floatValue() < 0.0f)) continue;
                this.infantrymap[j / 2][i / 2] = false;
            }
        }
    }

    void GenerateVehicleAccessibleMap() {
        this.logfile.WriteLine("GenerateVehicleAccessibleMap");
        this.vehiclemap = new boolean[this.mapwidth / 2][this.mapheight / 2];
        for (int i = 0; i < this.mapheight / 2; ++i) {
            for (int j = 0; j < this.mapwidth / 2; ++j) {
                this.vehiclemap[j][i] = true;
            }
        }
        ArrayIndexer arrayIndexer = new ArrayIndexer(this.mapwidth, this.mapheight);
        float f = this.config.getMaxvehicleslope().floatValue();
        for (int i = 0; i < this.mapheight; ++i) {
            for (int j = 0; j < this.mapwidth; ++j) {
                HeightMap.HeightMapPos heightMapPos = new HeightMap.HeightMapPos(j, i);
                SlopeMap.SlopeMapPos slopeMapPos = SlopeMap.SlopeMapPos.fromHeightMapPos(heightMapPos);
                if (this.slopeMap.getSlopeAt(slopeMapPos) > f) {
                    this.vehiclemap[j / 2][i / 2] = false;
                }
                if (!(this.heightmap.get(arrayIndexer.GetIndex(j, i)).floatValue() < 0.0f)) continue;
                this.vehiclemap[j / 2][i / 2] = false;
            }
        }
    }

    void GenerateBoatAccessibleMap() {
        int n;
        this.logfile.WriteLine("GenerateBoatAccessibleMap");
        this.boatmap = new boolean[this.mapwidth / 2][this.mapheight / 2];
        for (int i = 0; i < this.mapheight / 2; ++i) {
            for (n = 0; n < this.mapwidth / 2; ++n) {
                this.boatmap[n][i] = true;
            }
        }
        ArrayIndexer arrayIndexer = new ArrayIndexer(this.mapwidth, this.mapheight);
        for (n = 0; n < this.mapheight; ++n) {
            for (int i = 0; i < this.mapwidth; ++i) {
                if (!(this.heightmap.get(arrayIndexer.GetIndex(i, n)).floatValue() > 0.0f)) continue;
                this.boatmap[i / 2][n / 2] = false;
            }
        }
    }

    class Direction {
        public int x;
        public int y;

        public Direction(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }

    class ShowInfantryAreasButton
    implements MainUI.ButtonHandler {
        ShowInfantryAreasButton() {
        }

        @Override
        public void go() {
            MovementMaps.this.drawingUtils.DrawMap(MovementMaps.this.infantryareas);
            MovementMaps.this.csai.sendTextMessage("infantry areas drawn");
        }
    }

    class ShowVehicleAreasButton
    implements MainUI.ButtonHandler {
        ShowVehicleAreasButton() {
        }

        @Override
        public void go() {
            MovementMaps.this.drawingUtils.DrawMap(MovementMaps.this.vehicleareas);
            MovementMaps.this.csai.sendTextMessage("vehicle areas drawn");
        }
    }

    public static class MovementMapPos
    extends Int2 {
        public MovementMapPos() {
        }

        public MovementMapPos(Int2 int2) {
            this.x = int2.x;
            this.y = int2.y;
        }

        public MovementMapPos(int n, int n2) {
            super(n, n2);
        }

        public TerrainPos toTerrainPos() {
            return new TerrainPos(this.x * 8 * 2, 0.0f, this.y * 8 * 2);
        }

        public static MovementMapPos fromHeightMapPos(HeightMap.HeightMapPos heightMapPos) {
            return new MovementMapPos(heightMapPos.x / 2, heightMapPos.y / 2);
        }

        public static MovementMapPos fromTerrainPos(TerrainPos terrainPos) {
            return new MovementMapPos((int)terrainPos.x / 8 / 2, (int)terrainPos.z / 8 / 2);
        }
    }
}

