/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import tim.prune.App;
import tim.prune.data.SourceInfo;
import tim.prune.load.FileToBeLoaded;
import tim.prune.load.FileTypeLoader;
import tim.prune.load.MediaLinkInfo;
import tim.prune.load.xml.GpxHandler;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.XmlHandler;

public class ZipFileLoader {
    private App _app = null;
    private XmlFileLoader _xmlLoader = null;

    public ZipFileLoader(App app, XmlFileLoader xmlFileLoader) {
        this._app = app;
        this._xmlLoader = xmlFileLoader;
    }

    public void openFile(FileToBeLoaded fileToBeLoaded, boolean bl) {
        try {
            ZipFile zipFile = new ZipFile(fileToBeLoaded.getFile());
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            boolean bl2 = false;
            while (enumeration.hasMoreElements() && !bl2) {
                String string;
                ZipEntry zipEntry = enumeration.nextElement();
                String string2 = zipEntry.toString();
                if (string2 == null || string2.length() <= 4 || !(string = string2.substring(string2.length() - 4).toLowerCase()).equals(".kml") && !string.equals(".gpx") && !string.equals(".xml")) continue;
                this._xmlLoader.reset();
                this._xmlLoader.parseXmlStream(zipFile.getInputStream(zipEntry));
                XmlHandler xmlHandler = this._xmlLoader.getHandler();
                if (xmlHandler == null) {
                    this._app.showErrorMessage("error.load.dialogtitle", "error.load.othererror");
                    continue;
                }
                SourceInfo sourceInfo = new SourceInfo(fileToBeLoaded.getFile(), xmlHandler instanceof GpxHandler ? SourceInfo.FILE_TYPE.GPX : SourceInfo.FILE_TYPE.KML);
                new FileTypeLoader(this._app).loadData(xmlHandler, sourceInfo, bl, new MediaLinkInfo(fileToBeLoaded.getFile(), xmlHandler.getLinkArray()));
                bl2 = true;
            }
            zipFile.close();
            if (!bl2) {
                this._app.showErrorMessage("error.load.dialogtitle", "error.load.noxmlinzip");
            }
        }
        catch (Exception exception) {
            this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(exception.getClass().getName()) + "\n - " + exception.getMessage());
        }
    }
}

