//=================================================================================================
/*!
//  \file blaze/Util.h
//  \brief Header file for the inclusion of the utility module of the Blaze library
//
//  Copyright (C) 2012-2020 Klaus Iglberger - All Rights Reserved
//
//  This file is part of the Blaze library. You can redistribute it and/or modify it under
//  the terms of the New (Revised) BSD License. Redistribution and use in source and binary
//  forms, with or without modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright notice, this list of
//     conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright notice, this list
//     of conditions and the following disclaimer in the documentation and/or other materials
//     provided with the distribution.
//  3. Neither the names of the Blaze development group nor the names of its contributors
//     may be used to endorse or promote products derived from this software without specific
//     prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
//  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
//  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
//  SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
//  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
//  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
//  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
*/
//=================================================================================================

#ifndef _BLAZE_UTIL_MODULE_H_
#define _BLAZE_UTIL_MODULE_H_


//*************************************************************************************************
// Includes
//*************************************************************************************************

#include <blaze/util/AlignedAllocator.h>
#include <blaze/util/AlignedArray.h>
#include <blaze/util/AlignmentCheck.h>
#include <blaze/util/Algorithms.h>
#include <blaze/util/AsConst.h>
#include <blaze/util/Assert.h>
#include <blaze/util/CheckedDelete.h>
#include <blaze/util/ColorMacros.h>
#include <blaze/util/Complex.h>
#include <blaze/util/Constraints.h>
#include <blaze/util/DimensionOf.h>
#include <blaze/util/EmptyType.h>
#include <blaze/util/EnableIf.h>
#include <blaze/util/Exception.h>
#include <blaze/util/FunctionTrace.h>
#include <blaze/util/Indices.h>
#include <blaze/util/InitializerList.h>
#include <blaze/util/IntegerSequence.h>
#include <blaze/util/IntegralConstant.h>
#include <blaze/util/InvalidType.h>
#include <blaze/util/Limits.h>
#include <blaze/util/Memory.h>
#include <blaze/util/MemoryPool.h>
#include <blaze/util/MPL.h>
#include <blaze/util/NonCopyable.h>
#include <blaze/util/NonCreatable.h>
#include <blaze/util/NullAllocator.h>
#include <blaze/util/NullType.h>
#include <blaze/util/NumericCast.h>
#include <blaze/util/PointerCast.h>
#include <blaze/util/Policies.h>
#include <blaze/util/Random.h>
#include <blaze/util/Serialization.h>
#include <blaze/util/Singleton.h>
#include <blaze/util/SmallArray.h>
#include <blaze/util/StaticAssert.h>
#include <blaze/util/Suffix.h>
#include <blaze/util/Thread.h>
#include <blaze/util/ThreadPool.h>
#include <blaze/util/Time.h>
#include <blaze/util/Timing.h>
#include <blaze/util/TypeList.h>
#include <blaze/util/Types.h>
#include <blaze/util/TypeTraits.h>
#include <blaze/util/UnsignedValue.h>
#include <blaze/util/ValueTraits.h>

#endif
