/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.stream;

import java.io.FilterInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.logging.Log;
import org.signal.core.util.stream.StreamFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/signal/core/util/stream/TailerInputStream;", "Ljava/io/FilterInputStream;", "streamFactory", "Lorg/signal/core/util/stream/StreamFactory;", "bytesLength", "", "<init>", "(Lorg/signal/core/util/stream/StreamFactory;J)V", "TAG", "", "position", "input", "Ljava/io/InputStream;", "currentStream", "getCurrentStream", "()Ljava/io/InputStream;", "setCurrentStream", "(Ljava/io/InputStream;)V", "skip", "requestedSkipCount", "read", "", "destination", "", "offset", "length", "util-jvm"})
public final class TailerInputStream
extends FilterInputStream {
    @NotNull
    private final StreamFactory streamFactory;
    private final long bytesLength;
    @NotNull
    private final String TAG;
    private long position;

    public TailerInputStream(@NotNull StreamFactory streamFactory, long bytesLength) {
        Intrinsics.checkNotNullParameter((Object)streamFactory, (String)"streamFactory");
        super(streamFactory.openStream());
        this.streamFactory = streamFactory;
        this.bytesLength = bytesLength;
        this.TAG = Log.tag(Reflection.getOrCreateKotlinClass(TailerInputStream.class));
    }

    private final InputStream getCurrentStream() {
        InputStream inputStream = this.in;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"in");
        return inputStream;
    }

    private final void setCurrentStream(InputStream input) {
        this.in = input;
    }

    @Override
    public long skip(long requestedSkipCount) {
        long bytesSkipped = this.getCurrentStream().skip(requestedSkipCount);
        this.position += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public int read() {
        byte[] bytes = new byte[1];
        int result = this.read(bytes);
        while (result == 0) {
            result = this.read(bytes);
        }
        if (result == -1) {
            return result;
        }
        return bytes[0] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.read(destination, 0, destination.length);
    }

    @Override
    public int read(@NotNull byte[] destination, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (this.position >= this.bytesLength) {
            return -1;
        }
        int bytesRead = this.getCurrentStream().read(destination, offset, length);
        while (bytesRead < 0 && this.position < this.bytesLength) {
            this.getCurrentStream().close();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Log.w(this.TAG, "Ignoring interrupted exception while waiting for input stream", e);
            }
            this.setCurrentStream(this.streamFactory.openStream());
            this.getCurrentStream().skip(this.position);
            bytesRead = this.getCurrentStream().read(destination, offset, length);
        }
        if (bytesRead > 0) {
            this.position += (long)bytesRead;
        }
        return bytesRead;
    }
}

