/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.stream;

import java.io.FilterOutputStream;
import java.io.OutputStream;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/signal/core/util/stream/MacOutputStream;", "Ljava/io/FilterOutputStream;", "wrapped", "Ljava/io/OutputStream;", "mac", "Ljavax/crypto/Mac;", "<init>", "(Ljava/io/OutputStream;Ljavax/crypto/Mac;)V", "getWrapped", "()Ljava/io/OutputStream;", "getMac", "()Ljavax/crypto/Mac;", "write", "", "byte", "", "data", "", "offset", "length", "util-jvm"})
public final class MacOutputStream
extends FilterOutputStream {
    @NotNull
    private final OutputStream wrapped;
    @NotNull
    private final Mac mac;

    public MacOutputStream(@NotNull OutputStream wrapped, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super(wrapped);
        this.wrapped = wrapped;
        this.mac = mac;
    }

    @NotNull
    public final OutputStream getWrapped() {
        return this.wrapped;
    }

    @NotNull
    public final Mac getMac() {
        return this.mac;
    }

    @Override
    public void write(int n) {
        this.wrapped.write(n);
        this.mac.update((byte)n);
    }

    @Override
    public void write(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.write(data, 0, data.length);
    }

    @Override
    public void write(@NotNull byte[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.wrapped.write(data, offset, length);
        this.mac.update(data, offset, length);
    }
}

