/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.stream;

import java.io.FilterInputStream;
import java.io.InputStream;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/signal/core/util/stream/MacInputStream;", "Ljava/io/FilterInputStream;", "wrapped", "Ljava/io/InputStream;", "mac", "Ljavax/crypto/Mac;", "<init>", "(Ljava/io/InputStream;Ljavax/crypto/Mac;)V", "getWrapped", "()Ljava/io/InputStream;", "getMac", "()Ljavax/crypto/Mac;", "read", "", "destination", "", "offset", "length", "util-jvm"})
public final class MacInputStream
extends FilterInputStream {
    @NotNull
    private final InputStream wrapped;
    @NotNull
    private final Mac mac;

    public MacInputStream(@NotNull InputStream wrapped, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super(wrapped);
        this.wrapped = wrapped;
        this.mac = mac;
    }

    @NotNull
    public final InputStream getWrapped() {
        return this.wrapped;
    }

    @NotNull
    public final Mac getMac() {
        return this.mac;
    }

    @Override
    public int read() {
        int n;
        int n2 = n = this.wrapped.read();
        boolean bl = false;
        if (n2 >= 0) {
            this.mac.update((byte)n2);
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.read(destination, 0, destination.length);
    }

    @Override
    public int read(@NotNull byte[] destination, int offset, int length) {
        int n;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        int bytesRead = n = this.wrapped.read(destination, offset, length);
        boolean bl = false;
        if (bytesRead > 0) {
            this.mac.update(destination, offset, bytesRead);
        }
        return n;
    }
}

