/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0014H\u0007J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0014H\u0007J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0014H\u0007J\u0012\u0010\u001d\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0014H\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u0014J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#J\u001e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050'R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/signal/core/util/UuidUtil;", "", "<init>", "()V", "UNKNOWN_UUID", "Ljava/util/UUID;", "UNKNOWN_UUID_STRING", "", "getUNKNOWN_UUID_STRING", "()Ljava/lang/String;", "UUID_PATTERN", "Ljava/util/regex/Pattern;", "parse", "Ljava/util/Optional;", "uuid", "parseOrNull", "parseOrUnknown", "parseOrThrow", "bytes", "", "Lokio/ByteString;", "isUuid", "", "toByteArray", "toByteString", "fromByteString", "fromByteStringOrNull", "getStringUUID", "stringId", "fromByteStringOrUnknown", "byteArray", "byteString", "fromByteStrings", "", "byteStringCollection", "", "filterKnown", "", "uuids", "", "util-jvm"})
@SourceDebugExtension(value={"SMAP\nUuidUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UuidUtil.kt\norg/signal/core/util/UuidUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class UuidUtil {
    @NotNull
    public static final UuidUtil INSTANCE = new UuidUtil();
    @JvmField
    @NotNull
    public static final UUID UNKNOWN_UUID = new UUID(0L, 0L);
    @NotNull
    private static final String UNKNOWN_UUID_STRING;
    @NotNull
    private static final Pattern UUID_PATTERN;

    private UuidUtil() {
    }

    @NotNull
    public final String getUNKNOWN_UUID_STRING() {
        return UNKNOWN_UUID_STRING;
    }

    @NotNull
    public final Optional<UUID> parse(@Nullable String uuid) {
        Optional<UUID> optional = Optional.ofNullable(UuidUtil.parseOrNull(uuid));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final UUID parseOrNull(@Nullable String uuid) {
        String string;
        String string2 = uuid;
        String string3 = string2;
        if (string2 == null) return null;
        String it = string = string3;
        boolean bl = false;
        if (!INSTANCE.isUuid(it)) return null;
        String string4 = string;
        string3 = string4;
        if (string4 == null) return null;
        it = string3;
        boolean bl2 = false;
        UUID uUID = UuidUtil.parseOrThrow(it);
        return uUID;
    }

    @NotNull
    public final UUID parseOrUnknown(@Nullable String uuid) {
        UUID uUID = UuidUtil.parseOrNull(uuid);
        if (uUID == null) {
            uUID = UNKNOWN_UUID;
        }
        return uUID;
    }

    @JvmStatic
    @NotNull
    public static final UUID parseOrThrow(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        UUID uUID = UUID.fromString(uuid);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return uUID;
    }

    @JvmStatic
    @NotNull
    public static final UUID parseOrThrow(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        long high = byteBuffer.getLong();
        long low = byteBuffer.getLong();
        return new UUID(high, low);
    }

    @NotNull
    public final UUID parseOrThrow(@NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        UUID uUID = this.parseOrNull(bytes.toByteArray());
        Intrinsics.checkNotNull((Object)uUID);
        return uUID;
    }

    public final boolean isUuid(@Nullable String uuid) {
        return uuid != null && UUID_PATTERN.matcher(uuid).matches();
    }

    @JvmStatic
    @NotNull
    public static final byte[] toByteArray(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final ByteString toByteString(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        byte[] byArray = UuidUtil.toByteArray(uuid);
        return ByteString.Companion.of(Arrays.copyOf(byArray, byArray.length));
    }

    @JvmStatic
    @NotNull
    public static final UUID fromByteString(@NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return UuidUtil.parseOrThrow(bytes.toByteArray());
    }

    @JvmStatic
    @Nullable
    public static final UUID fromByteStringOrNull(@Nullable ByteString bytes) {
        if (bytes == null) {
            return null;
        }
        return INSTANCE.parseOrNull(bytes.toByteArray());
    }

    @JvmStatic
    @Nullable
    public static final String getStringUUID(@Nullable String stringId, @Nullable ByteString bytes) {
        UUID uuid = INSTANCE.parseOrNull(bytes);
        Object object = uuid;
        if (object == null || (object = ((UUID)object).toString()) == null) {
            object = stringId;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final UUID fromByteStringOrUnknown(@Nullable ByteString bytes) {
        UUID uuid = UuidUtil.fromByteStringOrNull(bytes);
        UUID uUID = uuid;
        if (uUID == null) {
            uUID = UNKNOWN_UUID;
        }
        return uUID;
    }

    @Nullable
    public final UUID parseOrNull(@Nullable byte[] byteArray) {
        return byteArray != null && byteArray.length == 16 ? UuidUtil.parseOrThrow(byteArray) : null;
    }

    @Nullable
    public final UUID parseOrNull(@Nullable ByteString byteString) {
        ByteString byteString2 = byteString;
        return byteString2 != null ? this.parseOrNull(byteString2.toByteArray()) : null;
    }

    @NotNull
    public final List<UUID> fromByteStrings(@NotNull Collection<? extends ByteString> byteStringCollection) {
        Intrinsics.checkNotNullParameter(byteStringCollection, (String)"byteStringCollection");
        ArrayList<UUID> result = new ArrayList<UUID>(byteStringCollection.size());
        for (ByteString byteString : byteStringCollection) {
            result.add(UuidUtil.fromByteString(byteString));
        }
        return result;
    }

    @NotNull
    public final List<UUID> filterKnown(@NotNull Collection<UUID> uuids) {
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        ArrayList<UUID> result = new ArrayList<UUID>(uuids.size());
        for (UUID uuid : uuids) {
            if (Intrinsics.areEqual((Object)UNKNOWN_UUID, (Object)uuid)) continue;
            result.add(uuid);
        }
        return result;
    }

    static {
        String string = UNKNOWN_UUID.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        UNKNOWN_UUID_STRING = string;
        Pattern pattern = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        UUID_PATTERN = pattern;
    }
}

