/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.DoubleExtensionsKt;
import org.signal.core.util.logging.Log;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0013B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/signal/core/util/Stopwatch;", "", "title", "", "decimalPlaces", "", "<init>", "(Ljava/lang/String;I)V", "startTimeNanos", "", "splits", "", "Lorg/signal/core/util/Stopwatch$Split;", "split", "", "label", "stop", "tag", "stopAndGetLogString", "Split", "util-jvm"})
public final class Stopwatch {
    @NotNull
    private final String title;
    private final int decimalPlaces;
    private final long startTimeNanos;
    @NotNull
    private final List<Split> splits;

    @JvmOverloads
    public Stopwatch(@NotNull String title, int decimalPlaces) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.title = title;
        this.decimalPlaces = decimalPlaces;
        this.startTimeNanos = System.nanoTime();
        this.splits = new ArrayList();
    }

    public /* synthetic */ Stopwatch(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(string, n);
    }

    public final void split(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        long now = System.nanoTime();
        long previousTime = this.splits.isEmpty() ? this.startTimeNanos : ((Split)CollectionsKt.last(this.splits)).getNanoTime();
        ((Collection)this.splits).add(new Split(now, now - previousTime, label));
    }

    public final void stop(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Log.d(tag, this.stopAndGetLogString());
    }

    @NotNull
    public final String stopAndGetLogString() {
        long now = System.nanoTime();
        ((Collection)this.splits).add(new Split(now, now - this.startTimeNanos, "total"));
        String splitString = CollectionsKt.joinToString$default((Iterable)this.splits, (CharSequence)", ", null, null, (int)0, null, arg_0 -> Stopwatch.stopAndGetLogString$lambda$0(this, arg_0), (int)30, null);
        return "[" + this.title + "] " + splitString;
    }

    @JvmOverloads
    public Stopwatch(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this(title, 0, 2, null);
    }

    private static final CharSequence stopAndGetLogString$lambda$0(Stopwatch this$0, Split it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.displayString(this$0.decimalPlaces);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/signal/core/util/Stopwatch$Split;", "", "nanoTime", "", "durationNanos", "label", "", "<init>", "(JJLjava/lang/String;)V", "getNanoTime", "()J", "getDurationNanos", "getLabel", "()Ljava/lang/String;", "displayString", "decimalPlaces", "", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "util-jvm"})
    private static final class Split {
        private final long nanoTime;
        private final long durationNanos;
        @NotNull
        private final String label;

        public Split(long nanoTime, long durationNanos, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.nanoTime = nanoTime;
            this.durationNanos = durationNanos;
            this.label = label;
        }

        public final long getNanoTime() {
            return this.nanoTime;
        }

        public final long getDurationNanos() {
            return this.durationNanos;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final String displayString(int decimalPlaces) {
            String timeMs = DoubleExtensionsKt.roundedString(Duration.toDouble-impl((long)DurationKt.toDuration((long)this.durationNanos, (DurationUnit)DurationUnit.NANOSECONDS), (DurationUnit)DurationUnit.MILLISECONDS), decimalPlaces);
            return this.label + ": " + timeMs;
        }

        public final long component1() {
            return this.nanoTime;
        }

        public final long component2() {
            return this.durationNanos;
        }

        @NotNull
        public final String component3() {
            return this.label;
        }

        @NotNull
        public final Split copy(long nanoTime, long durationNanos, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            return new Split(nanoTime, durationNanos, label);
        }

        public static /* synthetic */ Split copy$default(Split split, long l, long l2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = split.nanoTime;
            }
            if ((n & 2) != 0) {
                l2 = split.durationNanos;
            }
            if ((n & 4) != 0) {
                string = split.label;
            }
            return split.copy(l, l2, string);
        }

        @NotNull
        public String toString() {
            return "Split(nanoTime=" + this.nanoTime + ", durationNanos=" + this.durationNanos + ", label=" + this.label + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.nanoTime);
            result = result * 31 + Long.hashCode(this.durationNanos);
            result = result * 31 + this.label.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Split)) {
                return false;
            }
            Split split = (Split)other;
            if (this.nanoTime != split.nanoTime) {
                return false;
            }
            if (this.durationNanos != split.durationNanos) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.label, (Object)split.label);
        }
    }
}

