/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.StreamUtil;
import org.signal.core.util.stream.LimitedInputStream;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0003\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0001\u001a\u0012\u0010\u000b\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000e\u001a&\u0010\u0012\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u0006\u001a\u001e\u0010\u0017\u001a\u00020\u0006*\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00060\u0019\u00a8\u0006\u001b"}, d2={"readVarInt32", "", "Ljava/io/InputStream;", "readFully", "", "autoClose", "", "", "buffer", "readNBytesOrThrow", "length", "readAtMostNBytes", "byteLimit", "readLength", "", "drain", "limit", "Lorg/signal/core/util/stream/LimitedInputStream;", "copyTo", "outputStream", "Ljava/io/OutputStream;", "closeInputStream", "closeOutputStream", "allMatch", "predicate", "Lkotlin/Function1;", "", "util-jvm"})
@SourceDebugExtension(value={"SMAP\nInputStreamExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputStreamExtensions.kt\norg/signal/core/util/InputStreamExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class InputStreamExtensionsKt {
    public static final int readVarInt32(@NotNull InputStream $this$readVarInt32) {
        Intrinsics.checkNotNullParameter((Object)$this$readVarInt32, (String)"<this>");
        int result = 0;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)32)), (int)7);
        int shift = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && shift <= n || n2 < 0 && n <= shift) {
            while (true) {
                int n3;
                if ((n3 = $this$readVarInt32.read()) < 0) {
                    return -1;
                }
                int lowestSevenBits = n3 & 0x7F;
                int shiftedBits = lowestSevenBits << shift;
                result |= shiftedBits;
                if ((n3 & 0x80) == 0) {
                    return result;
                }
                if (shift == n) break;
                shift += n2;
            }
        }
        throw new IOException("Malformed varint!");
    }

    @NotNull
    public static final byte[] readFully(@NotNull InputStream $this$readFully, boolean autoClose) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readFully, (String)"<this>");
        byte[] byArray = StreamUtil.readFully($this$readFully, Integer.MAX_VALUE, autoClose);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readFully(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] readFully$default(InputStream inputStream, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        return InputStreamExtensionsKt.readFully(inputStream, bl);
    }

    public static final void readFully(@NotNull InputStream $this$readFully, @NotNull byte[] buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        StreamUtil.readFully($this$readFully, buffer);
    }

    @NotNull
    public static final byte[] readNBytesOrThrow(@NotNull InputStream $this$readNBytesOrThrow, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readNBytesOrThrow, (String)"<this>");
        byte[] buffer = new byte[length];
        InputStreamExtensionsKt.readFully($this$readNBytesOrThrow, buffer);
        return buffer;
    }

    @NotNull
    public static final byte[] readAtMostNBytes(@NotNull InputStream $this$readAtMostNBytes, int byteLimit) {
        int bytesToRead;
        int read;
        Intrinsics.checkNotNullParameter((Object)$this$readAtMostNBytes, (String)"<this>");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] readBuffer = new byte[4096];
        for (int remaining = byteLimit; remaining > 0 && (read = $this$readAtMostNBytes.read(readBuffer, 0, bytesToRead = Math.min(remaining, readBuffer.length))) != -1; remaining -= read) {
            buffer.write(readBuffer, 0, read);
        }
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public static final long readLength(@NotNull InputStream $this$readLength) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$readLength, (String)"<this>");
        byte[] buffer = new byte[4096];
        long count = 0L;
        do {
            int it = n = $this$readLength.read(buffer);
            boolean bl = false;
            if (it <= 0) continue;
            count += (long)it;
        } while (n != -1);
        return count;
    }

    public static final void drain(@NotNull InputStream $this$drain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$drain, (String)"<this>");
        InputStreamExtensionsKt.readLength($this$drain);
    }

    @NotNull
    public static final LimitedInputStream limit(@NotNull InputStream $this$limit, long limit) {
        Intrinsics.checkNotNullParameter((Object)$this$limit, (String)"<this>");
        return new LimitedInputStream($this$limit, limit);
    }

    public static final long copyTo(@NotNull InputStream $this$copyTo, @NotNull OutputStream outputStream, boolean closeInputStream, boolean closeOutputStream) {
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        return StreamUtil.copy($this$copyTo, outputStream, closeInputStream, closeOutputStream);
    }

    public static /* synthetic */ long copyTo$default(InputStream inputStream, OutputStream outputStream, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return InputStreamExtensionsKt.copyTo(inputStream, outputStream, bl, bl2);
    }

    public static final boolean allMatch(@NotNull InputStream $this$allMatch, @NotNull Function1<? super Byte, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$allMatch, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        byte[] buffer = new byte[4096];
        int readCount = 0;
        block0: while (true) {
            int n;
            int it = n = $this$allMatch.read(buffer);
            boolean bl = false;
            readCount = it;
            if (n == -1) break;
            int i = 0;
            int n2 = readCount;
            while (true) {
                if (i >= n2) continue block0;
                if (!((Boolean)predicate.invoke((Object)buffer[i])).booleanValue()) {
                    return false;
                }
                ++i;
            }
            break;
        }
        return true;
    }
}

