/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static String getStringIfNotBlank(Optional<String> value) {
        String string = value.orElse(null);
        if (string == null || string.isBlank()) {
            return null;
        }
        return string;
    }

    public static String dashSeparatedToCamelCaseString(String s) {
        String[] parts = s.split("-");
        return Util.toCamelCaseString(Arrays.asList(parts));
    }

    private static String toCamelCaseString(List<String> strings) {
        if (strings.isEmpty()) {
            return "";
        }
        return strings.getFirst() + strings.stream().skip(1L).filter(s -> !s.isEmpty()).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining());
    }

    public static String formatSafetyNumber(String digits) {
        if (digits == null) {
            return null;
        }
        int partCount = 12;
        int partSize = digits.length() / 12;
        StringBuilder f = new StringBuilder(digits.length() + 12);
        for (int i = 0; i < 12; ++i) {
            f.append(digits, i * partSize, i * partSize + partSize);
            if (i == 11) continue;
            f.append(" ");
        }
        return f.toString();
    }

    public static ObjectMapper createJsonObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.PUBLIC_ONLY);
        objectMapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        return objectMapper;
    }

    public static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String[] paramParts = param.split("=", 2);
            String name = URLDecoder.decode(paramParts[0], StandardCharsets.UTF_8);
            String value = paramParts.length == 1 ? null : URLDecoder.decode(paramParts[1], StandardCharsets.UTF_8);
            map.put(name, value);
        }
        return map;
    }
}

