/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.util;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.function.Supplier;
import jdk.net.ExtendedSocketOptions;
import jdk.net.UnixDomainPrincipal;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static Charset getConsoleCharset() {
        Console console = System.console();
        return console == null ? Charset.defaultCharset() : console.charset();
    }

    public static String readAll(InputStream in, Charset charset) throws IOException {
        return new String(in.readAllBytes(), charset);
    }

    public static void createPrivateDirectories(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        Path path = file.toPath();
        try {
            EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
            Files.createDirectories(path, PosixFilePermissions.asFileAttribute(perms));
        }
        catch (UnsupportedOperationException e) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    public static File getDataHomeDir() {
        String dataHome = System.getenv("XDG_DATA_HOME");
        if (dataHome != null) {
            return new File(dataHome);
        }
        logger.debug("XDG_DATA_HOME not set, falling back to home dir");
        return new File(new File(System.getProperty("user.home"), ".local"), "share");
    }

    public static File getRuntimeDir() {
        String runtimeDir = System.getenv("XDG_RUNTIME_DIR");
        if (runtimeDir != null) {
            return new File(runtimeDir);
        }
        logger.debug("XDG_RUNTIME_DIR not set, falling back to temp dir");
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static Supplier<String> getLineSupplier(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        return () -> {
            try {
                return bufferedReader.readLine();
            }
            catch (ClosedChannelException ignored) {
                logger.trace("Line supplier has been interrupted.");
                return null;
            }
            catch (IOException e) {
                logger.error("Error occurred while reading line", (Throwable)e);
                return null;
            }
        };
    }

    public static InetSocketAddress parseInetSocketAddress(String tcpAddress) throws UserErrorException {
        int port;
        int colonIndex = tcpAddress.lastIndexOf(58);
        if (colonIndex < 0) {
            throw new UserErrorException("Invalid tcp bind address (expected host:port): " + tcpAddress);
        }
        String host = tcpAddress.substring(0, colonIndex);
        String portString = tcpAddress.substring(colonIndex + 1);
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw new UserErrorException("Invalid tcp port: " + portString, e);
        }
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        if (socketAddress.isUnresolved()) {
            throw new UserErrorException("Invalid tcp bind address, invalid host: " + host);
        }
        return socketAddress;
    }

    public static String getUnixDomainPrincipal(SocketChannel channel) throws IOException {
        UnixDomainPrincipal principal = null;
        try {
            principal = channel.getOption(ExtendedSocketOptions.SO_PEERCRED);
        }
        catch (NoClassDefFoundError | UnsupportedOperationException throwable) {
            // empty catch block
        }
        return principal == null ? null : principal.toString();
    }

    public static ServerSocketChannel bindSocket(SocketAddress address) throws IOErrorException {
        ServerSocketChannel serverChannel;
        try {
            IOUtils.preBind(address);
            serverChannel = address instanceof UnixDomainSocketAddress ? ServerSocketChannel.open(StandardProtocolFamily.UNIX) : ServerSocketChannel.open();
            serverChannel.bind(address);
            logger.debug("Listening on socket: " + String.valueOf(address));
            IOUtils.postBind(address);
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to bind socket " + String.valueOf(address) + ": " + e.getMessage(), e);
        }
        return serverChannel;
    }

    private static void preBind(SocketAddress address) throws IOException {
        if (address instanceof UnixDomainSocketAddress) {
            UnixDomainSocketAddress usa = (UnixDomainSocketAddress)address;
            IOUtils.createPrivateDirectories(usa.getPath().toFile().getParentFile());
        }
    }

    private static void postBind(SocketAddress address) {
        if (address instanceof UnixDomainSocketAddress) {
            UnixDomainSocketAddress usa = (UnixDomainSocketAddress)address;
            usa.getPath().toFile().deleteOnExit();
        }
    }
}

