/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.jsonrpc;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.channels.OverlappingFileLockException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.asamk.signal.commands.Command;
import org.asamk.signal.commands.JsonRpcCommand;
import org.asamk.signal.commands.JsonRpcMultiCommand;
import org.asamk.signal.commands.JsonRpcRegistrationCommand;
import org.asamk.signal.commands.JsonRpcSingleCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.RateLimitErrorException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UntrustedKeyErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.jsonrpc.JsonRpcException;
import org.asamk.signal.jsonrpc.JsonRpcResponse;
import org.asamk.signal.jsonrpc.SignalJsonRpcDispatcherHandler;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.RegistrationManager;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.output.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalJsonRpcCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(SignalJsonRpcDispatcherHandler.class);
    private static final int USER_ERROR = -1;
    private static final int IO_ERROR = -3;
    private static final int UNTRUSTED_KEY_ERROR = -4;
    private static final int RATELIMIT_ERROR = -5;
    private final Manager m;
    private final MultiAccountManager c;
    private final Function<String, Command> commandProvider;

    public SignalJsonRpcCommandHandler(Manager m, Function<String, Command> commandProvider) {
        this.c = null;
        this.m = m;
        this.commandProvider = commandProvider;
    }

    public SignalJsonRpcCommandHandler(MultiAccountManager c, Function<String, Command> commandProvider) {
        this.c = c;
        this.m = null;
        this.commandProvider = commandProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode handleRequest(ObjectMapper objectMapper, String method, ContainerNode<?> params) throws JsonRpcException {
        List managers;
        Manager manager;
        JsonRpcCommand jsonRpcCommand;
        Command command = this.getCommand(method);
        if (this.c != null) {
            if (command instanceof JsonRpcSingleCommand) {
                jsonRpcCommand = (JsonRpcSingleCommand)command;
                manager = this.getManagerFromParams(params);
                if (manager != null) {
                    return this.runCommand(objectMapper, params, new CommandRunnerImpl(manager, jsonRpcCommand));
                }
            }
            if (command instanceof JsonRpcMultiCommand) {
                jsonRpcCommand = (JsonRpcMultiCommand)command;
                return this.runCommand(objectMapper, params, new MultiCommandRunnerImpl(this.c, jsonRpcCommand));
            }
            if (command instanceof JsonRpcRegistrationCommand) {
                jsonRpcCommand = (JsonRpcRegistrationCommand)command;
                Pair<String, RegistrationManager> pair = this.getRegistrationManagerFromParams(params);
                if (pair == null) {
                    throw new JsonRpcException(new JsonRpcResponse.Error(-32602, "Method requires account parameter", null));
                }
                String account = (String)pair.first();
                try (RegistrationManager manager2 = (RegistrationManager)pair.second();){
                    if (manager2 == null) throw new JsonRpcException(new JsonRpcResponse.Error(-32602, "Failed to load the given account", null));
                    JsonNode jsonNode = this.runCommand(objectMapper, params, new RegistrationCommandRunnerImpl(manager2, this.c, jsonRpcCommand));
                    return jsonNode;
                }
                catch (IOException e) {
                    logger.warn("Failed to close registration manager", (Throwable)e);
                }
            }
        }
        if (!(command instanceof JsonRpcSingleCommand)) throw new JsonRpcException(new JsonRpcResponse.Error(-32601, "Method not implemented", null));
        jsonRpcCommand = (JsonRpcSingleCommand)command;
        if (this.m != null) {
            return this.runCommand(objectMapper, params, new CommandRunnerImpl(this.m, jsonRpcCommand));
        }
        manager = this.getManagerFromParams(params);
        if (manager == null && (managers = this.c.getManagers()).size() == 1) {
            manager = (Manager)managers.getFirst();
        }
        if (manager == null) throw new JsonRpcException(new JsonRpcResponse.Error(-32602, "Method requires valid account parameter", null));
        return this.runCommand(objectMapper, params, new CommandRunnerImpl(manager, jsonRpcCommand));
    }

    private Manager getManagerFromParams(ContainerNode<?> params) throws JsonRpcException {
        if (params != null && params.hasNonNull("account")) {
            Manager manager = this.c.getManager(params.get("account").asText());
            ((ObjectNode)params).remove("account");
            if (manager == null) {
                throw new JsonRpcException(new JsonRpcResponse.Error(-32602, "Specified account does not exist", null));
            }
            return manager;
        }
        return null;
    }

    private Pair<String, RegistrationManager> getRegistrationManagerFromParams(ContainerNode<?> params) {
        if (params != null && params.has("account")) {
            String account = params.get("account").asText();
            ((ObjectNode)params).remove("account");
            try {
                return new Pair((Object)account, (Object)this.c.getNewRegistrationManager(account));
            }
            catch (OverlappingFileLockException e) {
                logger.warn("Account is already in use, attempting to close existing manager and retry: {}", (Object)account);
                try {
                    Manager existingManager = this.c.getManager(account);
                    if (existingManager != null) {
                        existingManager.close();
                    }
                }
                catch (Throwable closeError) {
                    logger.warn("Failed to close existing manager for {}: {}", (Object)account, (Object)closeError.getMessage());
                }
                try {
                    return new Pair((Object)account, (Object)this.c.getNewRegistrationManager(account));
                }
                catch (OverlappingFileLockException e2) {
                    logger.warn("Account still in use after closing manager: {}", (Object)account);
                    return new Pair((Object)account, null);
                }
                catch (IOException | IllegalStateException e2) {
                    logger.warn("Failed to load registration manager after retry", (Throwable)e2);
                    return new Pair((Object)account, null);
                }
            }
            catch (IOException | IllegalStateException e) {
                logger.warn("Failed to load registration manager", (Throwable)e);
                return new Pair((Object)account, null);
            }
        }
        return null;
    }

    private Command getCommand(String method) {
        return this.commandProvider.apply(method);
    }

    private JsonNode runCommand(ObjectMapper objectMapper, ContainerNode<?> params, CommandRunner<?> command) throws JsonRpcException {
        Object[] result = new Object[]{null};
        JsonWriter commandJsonWriter = s -> {
            if (result[0] != null) {
                throw new AssertionError((Object)"Command may only write one json result");
            }
            result[0] = s;
        };
        try {
            this.parseParamsAndRunCommand(objectMapper, (TreeNode)params, commandJsonWriter, command);
        }
        catch (JsonMappingException e) {
            throw new JsonRpcException(new JsonRpcResponse.Error(-32600, e.getMessage(), null));
        }
        catch (CommandException ce) {
            CommandException commandException = ce;
            Objects.requireNonNull(commandException);
            CommandException commandException2 = commandException;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UserErrorException.class, IOErrorException.class, UntrustedKeyErrorException.class, RateLimitErrorException.class, UnexpectedErrorException.class}, (Object)commandException2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    UserErrorException e = (UserErrorException)commandException2;
                    throw new JsonRpcException(new JsonRpcResponse.Error(-1, e.getMessage(), this.getErrorDataNode(objectMapper, result)));
                }
                case 1: {
                    IOErrorException e = (IOErrorException)commandException2;
                    throw new JsonRpcException(new JsonRpcResponse.Error(-3, e.getMessage(), this.getErrorDataNode(objectMapper, result)));
                }
                case 2: {
                    UntrustedKeyErrorException e = (UntrustedKeyErrorException)commandException2;
                    throw new JsonRpcException(new JsonRpcResponse.Error(-4, e.getMessage(), this.getErrorDataNode(objectMapper, result)));
                }
                case 3: {
                    RateLimitErrorException e = (RateLimitErrorException)commandException2;
                    throw new JsonRpcException(new JsonRpcResponse.Error(-5, e.getMessage(), this.getErrorDataNode(objectMapper, result)));
                }
                case 4: 
            }
            UnexpectedErrorException e = (UnexpectedErrorException)commandException2;
            logger.error("Command execution failed with unexpected error", (Throwable)e);
            throw new JsonRpcException(new JsonRpcResponse.Error(-32603, e.getMessage() + " (" + e.getClass().getSimpleName() + ")", this.getErrorDataNode(objectMapper, result)));
        }
        catch (Throwable e) {
            logger.error("Command execution failed", e);
            throw new JsonRpcException(new JsonRpcResponse.Error(-32603, e.getMessage() + " (" + e.getClass().getSimpleName() + ")", this.getErrorDataNode(objectMapper, result)));
        }
        Map output = result[0] == null ? Map.of() : result[0];
        return objectMapper.valueToTree(output);
    }

    private JsonNode getErrorDataNode(ObjectMapper objectMapper, Object[] result) {
        if (result[0] == null) {
            return null;
        }
        return objectMapper.valueToTree(Map.of("response", result[0]));
    }

    private <T> void parseParamsAndRunCommand(ObjectMapper objectMapper, TreeNode params, JsonWriter jsonWriter, CommandRunner<T> command) throws CommandException, JsonMappingException {
        Object requestParams = null;
        TypeReference<T> requestType = command.getRequestType();
        if (params != null && requestType != null) {
            try {
                requestParams = objectMapper.readValue(objectMapper.treeAsTokens(params), requestType);
            }
            catch (JsonMappingException e) {
                throw e;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        command.handleCommand(requestParams, jsonWriter);
    }

    private record CommandRunnerImpl<T>(Manager m, JsonRpcSingleCommand<T> command) implements CommandRunner<T>
    {
        @Override
        public void handleCommand(T request, JsonWriter jsonWriter) throws CommandException {
            this.command.handleCommand(request, this.m, jsonWriter);
        }

        @Override
        public TypeReference<T> getRequestType() {
            return this.command.getRequestType();
        }
    }

    static interface CommandRunner<T> {
        public void handleCommand(T var1, JsonWriter var2) throws CommandException;

        public TypeReference<T> getRequestType();
    }

    private record MultiCommandRunnerImpl<T>(MultiAccountManager c, JsonRpcMultiCommand<T> command) implements CommandRunner<T>
    {
        @Override
        public void handleCommand(T request, JsonWriter jsonWriter) throws CommandException {
            this.command.handleCommand(request, this.c, jsonWriter);
        }

        @Override
        public TypeReference<T> getRequestType() {
            return this.command.getRequestType();
        }
    }

    private record RegistrationCommandRunnerImpl<T>(RegistrationManager m, MultiAccountManager c, JsonRpcRegistrationCommand<T> command) implements CommandRunner<T>
    {
        @Override
        public void handleCommand(T request, JsonWriter jsonWriter) throws CommandException {
            this.command.handleCommand(request, this.m, jsonWriter);
        }

        @Override
        public TypeReference<T> getRequestType() {
            return this.command.getRequestType();
        }
    }
}

