/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.output.OutputWriter;

public class UpdateDeviceCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "updateDevice";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Update a linked device.");
        subparser.addArgument(new String[]{"-d", "--device-id", "--deviceId"}).type(Integer.TYPE).required(true).help("Specify the device you want to update. Use listDevices to see the deviceIds.");
        subparser.addArgument(new String[]{"-n", "--device-name"}).required(true).help("Specify a name to describe the given device.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        try {
            Integer deviceId = ns.getInt("device-id");
            String deviceName = ns.getString("device-name");
            m.updateLinkedDevice(deviceId.intValue(), deviceName);
        }
        catch (NotPrimaryDeviceException e) {
            throw new UserErrorException("This command doesn't work on linked devices.");
        }
        catch (IOException e) {
            throw new IOErrorException("Error while updating device: " + e.getMessage(), e);
        }
    }
}

