/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.SendMessageResultUtils;

public class SendReactionCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "sendReaction";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Send reaction to a previously received or sent message.");
        subparser.addArgument(new String[]{"-g", "--group-id", "--group"}).help("Specify the recipient group ID.").nargs("*");
        subparser.addArgument(new String[]{"recipient"}).help("Specify the recipients' phone number.").nargs("*");
        subparser.addArgument(new String[]{"-u", "--username"}).help("Specify the recipient username or username link.").nargs("*");
        subparser.addArgument(new String[]{"--note-to-self"}).help("Send the reaction to self.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--notify-self"}).help("If self is part of recipients/groups send a normal message, not a sync message.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"-e", "--emoji"}).required(true).help("Specify the emoji, should be a single unicode grapheme cluster.");
        subparser.addArgument(new String[]{"-a", "--target-author"}).required(true).help("Specify the number of the author of the message to which to react.");
        subparser.addArgument(new String[]{"-t", "--target-timestamp"}).required(true).type(Long.TYPE).help("Specify the timestamp of the message to which to react.");
        subparser.addArgument(new String[]{"-r", "--remove"}).help("Remove a reaction.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--story"}).help("React to a story instead of a normal message").action((ArgumentAction)Arguments.storeTrue());
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        RecipientIdentifier.Single single;
        Object e;
        boolean notifySelf = Boolean.TRUE.equals(ns.getBoolean("notify-self"));
        boolean isNoteToSelf = Boolean.TRUE.equals(ns.getBoolean("note-to-self"));
        List recipientStrings = ns.getList("recipient");
        List groupIdStrings = ns.getList("group-id");
        List usernameStrings = ns.getList("username");
        Set<RecipientIdentifier> recipientIdentifiers = CommandUtil.getRecipientIdentifiers(m, isNoteToSelf, recipientStrings, groupIdStrings, usernameStrings);
        String emoji = ns.getString("emoji");
        boolean isRemove = Boolean.TRUE.equals(ns.getBoolean("remove"));
        String targetAuthor = ns.getString("target-author");
        Long targetTimestamp = ns.getLong("target-timestamp");
        boolean isStory = Boolean.TRUE.equals(ns.getBoolean("story"));
        RecipientIdentifier.Single targetAuthorIdentifier = targetAuthor == null && recipientIdentifiers.size() == 1 && (e = recipientIdentifiers.stream().findFirst().get()) instanceof RecipientIdentifier.Single ? (single = (RecipientIdentifier.Single)e) : CommandUtil.getSingleRecipientIdentifier(targetAuthor, m.getSelfNumber());
        try {
            SendMessageResults results = m.sendMessageReaction(emoji, isRemove, targetAuthorIdentifier, targetTimestamp.longValue(), recipientIdentifiers, notifySelf, isStory);
            SendMessageResultUtils.outputResult(outputWriter, results);
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e2) {
            throw new UserErrorException(e2.getMessage());
        }
        catch (IOException e3) {
            throw new UnexpectedErrorException("Failed to send message: " + e3.getMessage() + " (" + e3.getClass().getSimpleName() + ")", e3);
        }
        catch (UnregisteredRecipientException e4) {
            throw new UserErrorException("The user " + e4.getSender().getIdentifier() + " is not registered.");
        }
    }
}

