/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.SendMessageResultUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendPollVoteCommand
implements JsonRpcLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(SendPollVoteCommand.class);

    @Override
    public String getName() {
        return "sendPollVote";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Vote on a poll and send it to another user or group.");
        subparser.addArgument(new String[]{"recipient"}).help("Specify the recipients' phone number.").nargs("*");
        subparser.addArgument(new String[]{"-g", "--group-id", "--group"}).help("Specify the recipient group ID.").nargs("*");
        subparser.addArgument(new String[]{"-u", "--username"}).help("Specify the recipient username or username link.").nargs("*");
        subparser.addArgument(new String[]{"--note-to-self"}).help("Send the message to self").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--notify-self"}).help("If self is part of recipients/groups send a normal message, not a sync message.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--poll-author"}).help("Specify the number of the author of the poll message.");
        subparser.addArgument(new String[]{"--poll-timestamp"}).type(Long.TYPE).help("Specify the timestamp of the original poll message.").required(true);
        subparser.addArgument(new String[]{"-o", "--option"}).type(Integer.class).help("The option indexes of the poll to vote for").nargs("*");
        subparser.addArgument(new String[]{"--vote-count"}).type(Integer.TYPE).help("Specify the number of this vote (increase by one for every time you vote).").required(true);
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        boolean notifySelf = Boolean.TRUE.equals(ns.getBoolean("notify-self"));
        boolean isNoteToSelf = Boolean.TRUE.equals(ns.getBoolean("note-to-self"));
        List recipientStrings = ns.getList("recipient");
        List groupIdStrings = ns.getList("group-id");
        List usernameStrings = ns.getList("username");
        Set<RecipientIdentifier> recipientIdentifiers = CommandUtil.getRecipientIdentifiers(m, isNoteToSelf, recipientStrings, groupIdStrings, usernameStrings);
        String selfNumber = m.getSelfNumber();
        Long pollTimestamp = ns.getLong("poll-timestamp");
        String pollAuthorString = ns.getString("poll-author");
        RecipientIdentifier.Single pollAuthor = CommandUtil.getSingleRecipientIdentifier(pollAuthorString, selfNumber);
        List options = ns.getList("option");
        Integer voteCount = ns.getInt("vote-count");
        try {
            SendMessageResults results = m.sendPollVoteMessage(pollAuthor, pollTimestamp.longValue(), options, voteCount.intValue(), recipientIdentifiers, notifySelf);
            SendMessageResultUtils.outputResult(outputWriter, results);
        }
        catch (IOException e) {
            if (e.getMessage().contains("No prekeys available")) {
                throw new UnexpectedErrorException("Failed to send message: " + e.getMessage() + " (" + e.getClass().getSimpleName() + "), maybe one of the devices of the recipient wasn't online for a while.", e);
            }
            throw new UnexpectedErrorException("Failed to send message: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
        catch (GroupNotFoundException | GroupSendingNotAllowedException | NotAGroupMemberException e) {
            throw new UserErrorException(e.getMessage());
        }
        catch (UnregisteredRecipientException e) {
            throw new UserErrorException("The user " + e.getSender().getIdentifier() + " is not registered.");
        }
    }
}

