/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.asamk.signal.commands.AddDeviceCommand;
import org.asamk.signal.commands.AddStickerPackCommand;
import org.asamk.signal.commands.BlockCommand;
import org.asamk.signal.commands.CliCommand;
import org.asamk.signal.commands.Command;
import org.asamk.signal.commands.DaemonCommand;
import org.asamk.signal.commands.DeleteLocalAccountDataCommand;
import org.asamk.signal.commands.FinishChangeNumberCommand;
import org.asamk.signal.commands.FinishLinkCommand;
import org.asamk.signal.commands.GetAttachmentCommand;
import org.asamk.signal.commands.GetAvatarCommand;
import org.asamk.signal.commands.GetStickerCommand;
import org.asamk.signal.commands.GetUserStatusCommand;
import org.asamk.signal.commands.JoinGroupCommand;
import org.asamk.signal.commands.JsonRpcDispatcherCommand;
import org.asamk.signal.commands.LinkCommand;
import org.asamk.signal.commands.ListAccountsCommand;
import org.asamk.signal.commands.ListContactsCommand;
import org.asamk.signal.commands.ListDevicesCommand;
import org.asamk.signal.commands.ListGroupsCommand;
import org.asamk.signal.commands.ListIdentitiesCommand;
import org.asamk.signal.commands.ListStickerPacksCommand;
import org.asamk.signal.commands.QuitGroupCommand;
import org.asamk.signal.commands.ReceiveCommand;
import org.asamk.signal.commands.RegisterCommand;
import org.asamk.signal.commands.RemoteDeleteCommand;
import org.asamk.signal.commands.RemoveContactCommand;
import org.asamk.signal.commands.RemoveDeviceCommand;
import org.asamk.signal.commands.RemovePinCommand;
import org.asamk.signal.commands.SendCommand;
import org.asamk.signal.commands.SendContactsCommand;
import org.asamk.signal.commands.SendMessageRequestResponseCommand;
import org.asamk.signal.commands.SendPaymentNotificationCommand;
import org.asamk.signal.commands.SendPollCreateCommand;
import org.asamk.signal.commands.SendPollTerminateCommand;
import org.asamk.signal.commands.SendPollVoteCommand;
import org.asamk.signal.commands.SendReactionCommand;
import org.asamk.signal.commands.SendReceiptCommand;
import org.asamk.signal.commands.SendSyncRequestCommand;
import org.asamk.signal.commands.SendTypingCommand;
import org.asamk.signal.commands.SetPinCommand;
import org.asamk.signal.commands.StartChangeNumberCommand;
import org.asamk.signal.commands.StartLinkCommand;
import org.asamk.signal.commands.SubmitRateLimitChallengeCommand;
import org.asamk.signal.commands.SubparserAttacher;
import org.asamk.signal.commands.TrustCommand;
import org.asamk.signal.commands.UnblockCommand;
import org.asamk.signal.commands.UnregisterCommand;
import org.asamk.signal.commands.UpdateAccountCommand;
import org.asamk.signal.commands.UpdateConfigurationCommand;
import org.asamk.signal.commands.UpdateContactCommand;
import org.asamk.signal.commands.UpdateDeviceCommand;
import org.asamk.signal.commands.UpdateGroupCommand;
import org.asamk.signal.commands.UpdateProfileCommand;
import org.asamk.signal.commands.UploadStickerPackCommand;
import org.asamk.signal.commands.VerifyCommand;
import org.asamk.signal.commands.VersionCommand;

public class Commands {
    private static final Map<String, Command> commands = new HashMap<String, Command>();
    private static final Map<String, SubparserAttacher> commandSubparserAttacher = new TreeMap<String, SubparserAttacher>();

    public static Map<String, SubparserAttacher> getCommandSubparserAttachers() {
        return commandSubparserAttacher;
    }

    public static Command getCommand(String commandKey) {
        if (!commands.containsKey(commandKey)) {
            return null;
        }
        return commands.get(commandKey);
    }

    private static void addCommand(Command command) {
        commands.put(command.getName(), command);
        if (command instanceof CliCommand) {
            CliCommand cliCommand = (CliCommand)command;
            commandSubparserAttacher.put(command.getName(), cliCommand::attachToSubparser);
        }
    }

    static {
        Commands.addCommand(new AddDeviceCommand());
        Commands.addCommand(new BlockCommand());
        Commands.addCommand(new DaemonCommand());
        Commands.addCommand(new DeleteLocalAccountDataCommand());
        Commands.addCommand(new FinishChangeNumberCommand());
        Commands.addCommand(new FinishLinkCommand());
        Commands.addCommand(new GetAttachmentCommand());
        Commands.addCommand(new GetAvatarCommand());
        Commands.addCommand(new GetStickerCommand());
        Commands.addCommand(new GetUserStatusCommand());
        Commands.addCommand(new AddStickerPackCommand());
        Commands.addCommand(new JoinGroupCommand());
        Commands.addCommand(new JsonRpcDispatcherCommand());
        Commands.addCommand(new LinkCommand());
        Commands.addCommand(new ListAccountsCommand());
        Commands.addCommand(new ListContactsCommand());
        Commands.addCommand(new ListDevicesCommand());
        Commands.addCommand(new ListGroupsCommand());
        Commands.addCommand(new ListIdentitiesCommand());
        Commands.addCommand(new ListStickerPacksCommand());
        Commands.addCommand(new QuitGroupCommand());
        Commands.addCommand(new ReceiveCommand());
        Commands.addCommand(new RegisterCommand());
        Commands.addCommand(new RemoveContactCommand());
        Commands.addCommand(new RemoveDeviceCommand());
        Commands.addCommand(new RemovePinCommand());
        Commands.addCommand(new RemoteDeleteCommand());
        Commands.addCommand(new SendCommand());
        Commands.addCommand(new SendContactsCommand());
        Commands.addCommand(new SendMessageRequestResponseCommand());
        Commands.addCommand(new SendPaymentNotificationCommand());
        Commands.addCommand(new SendPollCreateCommand());
        Commands.addCommand(new SendPollVoteCommand());
        Commands.addCommand(new SendPollTerminateCommand());
        Commands.addCommand(new SendReactionCommand());
        Commands.addCommand(new SendReceiptCommand());
        Commands.addCommand(new SendSyncRequestCommand());
        Commands.addCommand(new SendTypingCommand());
        Commands.addCommand(new SetPinCommand());
        Commands.addCommand(new SubmitRateLimitChallengeCommand());
        Commands.addCommand(new StartChangeNumberCommand());
        Commands.addCommand(new StartLinkCommand());
        Commands.addCommand(new TrustCommand());
        Commands.addCommand(new UnblockCommand());
        Commands.addCommand(new UnregisterCommand());
        Commands.addCommand(new UpdateAccountCommand());
        Commands.addCommand(new UpdateConfigurationCommand());
        Commands.addCommand(new UpdateContactCommand());
        Commands.addCommand(new UpdateDeviceCommand());
        Commands.addCommand(new UpdateGroupCommand());
        Commands.addCommand(new UpdateProfileCommand());
        Commands.addCommand(new UploadStickerPackCommand());
        Commands.addCommand(new VerifyCommand());
        Commands.addCommand(new VersionCommand());
    }
}

