/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.Group;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.TextStyle;
import org.asamk.signal.manager.api.UntrustedIdentityException;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.DateUtils;
import org.asamk.signal.util.Hex;
import org.slf4j.helpers.MessageFormatter;

public class ReceiveMessageHandler
implements Manager.ReceiveMessageHandler {
    final Manager m;
    final PlainTextWriter writer;

    public ReceiveMessageHandler(Manager m, PlainTextWriter writer) {
        this.m = m;
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(MessageEnvelope envelope, Throwable exception) {
        PlainTextWriter plainTextWriter = this.writer;
        synchronized (plainTextWriter) {
            this.handleMessageInternal(envelope, exception);
        }
    }

    private void handleMessageInternal(MessageEnvelope envelope, Throwable exception) {
        MessageEnvelope.Data message;
        Optional source = envelope.sourceAddress();
        this.writer.println("Envelope from: {} (device: {}) to {}", source.map(this::formatContact).orElse("unknown source"), envelope.sourceDevice(), this.m.getSelfNumber());
        this.writer.println("Timestamp: {}", DateUtils.formatTimestamp(envelope.timestamp()));
        this.writer.println("Server timestamps: received: {} delivered: {}", DateUtils.formatTimestamp(envelope.serverReceivedTimestamp()), DateUtils.formatTimestamp(envelope.serverDeliveredTimestamp()));
        if (envelope.isUnidentifiedSender()) {
            this.writer.println("Sent by unidentified/sealed sender", new Object[0]);
        }
        if (exception != null) {
            if (exception instanceof UntrustedIdentityException) {
                UntrustedIdentityException e = (UntrustedIdentityException)exception;
                this.writer.println("The user\u2019s key is untrusted, either the user has reinstalled Signal or a third party sent this message.", new Object[0]);
                String recipientName = e.getSender().getLegacyIdentifier();
                this.writer.println("Use 'signal-cli -a {} listIdentities -n {}', verify the key and run 'signal-cli -a {} trust -v \"FINGER_PRINT\" {}' to mark it as trusted", this.m.getSelfNumber(), recipientName, this.m.getSelfNumber(), recipientName);
                this.writer.println("If you don't care about security, use 'signal-cli -a {} trust -a {}' to trust it without verification", this.m.getSelfNumber(), recipientName);
            } else {
                this.writer.println("Exception: {} ({})", exception.getMessage(), exception.getClass().getSimpleName());
            }
        }
        if (envelope.data().isPresent()) {
            message = (MessageEnvelope.Data)envelope.data().get();
            this.printDataMessage(this.writer, message);
        }
        if (envelope.edit().isPresent()) {
            message = (MessageEnvelope.Edit)envelope.edit().get();
            this.printEditMessage(this.writer, (MessageEnvelope.Edit)message);
        }
        if (envelope.story().isPresent()) {
            message = (MessageEnvelope.Story)envelope.story().get();
            this.printStoryMessage(this.writer.indentedWriter(), (MessageEnvelope.Story)message);
        }
        if (envelope.sync().isPresent()) {
            this.writer.println("Received a sync message", new Object[0]);
            MessageEnvelope.Sync syncMessage = (MessageEnvelope.Sync)envelope.sync().get();
            this.printSyncMessage(this.writer, syncMessage);
        }
        if (envelope.call().isPresent()) {
            this.writer.println("Received a call message", new Object[0]);
            MessageEnvelope.Call callMessage = (MessageEnvelope.Call)envelope.call().get();
            this.printCallMessage(this.writer.indentedWriter(), callMessage);
        }
        if (envelope.receipt().isPresent()) {
            this.writer.println("Received a receipt message", new Object[0]);
            MessageEnvelope.Receipt receiptMessage = (MessageEnvelope.Receipt)envelope.receipt().get();
            this.printReceiptMessage(this.writer.indentedWriter(), receiptMessage);
        }
        if (envelope.typing().isPresent()) {
            this.writer.println("Received a typing message", new Object[0]);
            MessageEnvelope.Typing typingMessage = (MessageEnvelope.Typing)envelope.typing().get();
            this.printTypingMessage(this.writer.indentedWriter(), typingMessage);
        }
        this.writer.println();
    }

    private void printDataMessage(PlainTextWriter writer, MessageEnvelope.Data message) {
        writer.println("Message timestamp: {}", DateUtils.formatTimestamp(message.timestamp()));
        if (message.isViewOnce()) {
            writer.println("=VIEW ONCE=", new Object[0]);
        }
        if (message.body().isPresent()) {
            writer.println("Body: {}", message.body().get());
        }
        if (message.groupContext().isPresent()) {
            writer.println("Group info:", new Object[0]);
            MessageEnvelope.Data.GroupContext groupContext = (MessageEnvelope.Data.GroupContext)message.groupContext().get();
            this.printGroupContext(writer.indentedWriter(), groupContext);
        }
        if (message.storyContext().isPresent()) {
            writer.println("Story reply:", new Object[0]);
            MessageEnvelope.Data.StoryContext storyContext = (MessageEnvelope.Data.StoryContext)message.storyContext().get();
            this.printStoryContext(writer.indentedWriter(), storyContext);
        }
        if (message.groupCallUpdate().isPresent()) {
            writer.println("Group call update:", new Object[0]);
            MessageEnvelope.Data.GroupCallUpdate groupCallUpdate = (MessageEnvelope.Data.GroupCallUpdate)message.groupCallUpdate().get();
            writer.indentedWriter().println("Era id: {}", groupCallUpdate.eraId());
        }
        if (!message.previews().isEmpty()) {
            writer.println("Previews:", new Object[0]);
            List previews = message.previews();
            Iterator iterator = previews.iterator();
            while (iterator.hasNext()) {
                MessageEnvelope.Data.Preview preview = (MessageEnvelope.Data.Preview)iterator.next();
                writer.println("- Preview", new Object[0]);
                this.printPreview(writer.indentedWriter(), preview);
            }
        }
        if (!message.sharedContacts().isEmpty()) {
            writer.println("Contacts:", new Object[0]);
            for (MessageEnvelope.Data.SharedContact contact : message.sharedContacts()) {
                writer.println("- Contact:", new Object[0]);
                this.printSharedContact(writer.indentedWriter(), contact);
            }
        }
        if (message.sticker().isPresent()) {
            MessageEnvelope.Data.Sticker sticker = (MessageEnvelope.Data.Sticker)message.sticker().get();
            writer.println("Sticker:", new Object[0]);
            this.printSticker(writer.indentedWriter(), sticker);
        }
        if (message.isEndSession()) {
            writer.println("Is end session", new Object[0]);
        }
        if (message.isExpirationUpdate()) {
            writer.println("Is Expiration update: true", new Object[0]);
        }
        if (message.expiresInSeconds() > 0) {
            writer.println("Expires in: {} seconds", message.expiresInSeconds());
        }
        if (message.isProfileKeyUpdate()) {
            writer.println("Profile key update", new Object[0]);
        }
        if (message.hasProfileKey()) {
            writer.println("With profile key", new Object[0]);
        }
        if (message.reaction().isPresent()) {
            writer.println("Reaction:", new Object[0]);
            MessageEnvelope.Data.Reaction reaction = (MessageEnvelope.Data.Reaction)message.reaction().get();
            this.printReaction(writer.indentedWriter(), reaction);
        }
        if (message.quote().isPresent()) {
            writer.println("Quote:", new Object[0]);
            MessageEnvelope.Data.Quote quote = (MessageEnvelope.Data.Quote)message.quote().get();
            this.printQuote(writer.indentedWriter(), quote);
        }
        if (message.remoteDeleteId().isPresent()) {
            Iterator remoteDelete = (Long)message.remoteDeleteId().get();
            writer.println("Remote delete message: timestamp = {}", remoteDelete);
        }
        if (!message.mentions().isEmpty()) {
            writer.println("Mentions:", new Object[0]);
            for (MessageEnvelope.Data.Mention mention : message.mentions()) {
                this.printMention(writer, mention);
            }
        }
        if (!message.textStyles().isEmpty()) {
            writer.println("Text styles:", new Object[0]);
            for (TextStyle textStyle : message.textStyles()) {
                this.printTextStyle(writer, textStyle);
            }
        }
        if (!message.attachments().isEmpty()) {
            writer.println("Attachments:", new Object[0]);
            for (MessageEnvelope.Data.Attachment attachment : message.attachments()) {
                writer.println("- Attachment:", new Object[0]);
                this.printAttachment(writer.indentedWriter(), attachment);
            }
        }
        if (!message.pollCreate().isEmpty()) {
            MessageEnvelope.Data.PollCreate pollCreate = (MessageEnvelope.Data.PollCreate)message.pollCreate().get();
            writer.println("Poll Create: \"{}\" ({})", pollCreate.question(), pollCreate.allowMultiple() ? "multi" : "single");
            for (String option : pollCreate.options()) {
                writer.println("- {}", option);
            }
        }
        if (!message.pollVote().isEmpty()) {
            MessageEnvelope.Data.PollVote pollVote = (MessageEnvelope.Data.PollVote)message.pollVote().get();
            writer.println("Poll Vote: \"{}\" ({}) selected {} (vote #{})", this.formatContact(pollVote.targetAuthor()), DateUtils.formatTimestamp(pollVote.targetSentTimestamp()), pollVote.optionIndexes().stream().map(Object::toString).collect(Collectors.joining(",")), pollVote.voteCount());
        }
        if (!message.pollTerminate().isEmpty()) {
            MessageEnvelope.Data.PollTerminate pollTerminate = (MessageEnvelope.Data.PollTerminate)message.pollTerminate().get();
            writer.println("Poll Terminate: {}", DateUtils.formatTimestamp(pollTerminate.targetSentTimestamp()));
        }
    }

    private void printEditMessage(PlainTextWriter writer, MessageEnvelope.Edit message) {
        writer.println("Edit: Target message timestamp: {}", DateUtils.formatTimestamp(message.targetSentTimestamp()));
        this.printDataMessage(writer.indentedWriter(), message.dataMessage());
    }

    private void printStoryMessage(PlainTextWriter writer, MessageEnvelope.Story message) {
        writer.println("Story: with replies: {}", message.allowsReplies());
        if (message.groupId().isPresent()) {
            writer.println("Group info:", new Object[0]);
            this.printGroupInfo(writer.indentedWriter(), (GroupId)message.groupId().get());
        }
        if (message.textAttachment().isPresent()) {
            writer.println("Body: {}", ((MessageEnvelope.Story.TextAttachment)message.textAttachment().get()).text().orElse(""));
            if (((MessageEnvelope.Story.TextAttachment)message.textAttachment().get()).preview().isPresent()) {
                writer.println("Preview:", new Object[0]);
                this.printPreview(writer.indentedWriter(), (MessageEnvelope.Data.Preview)((MessageEnvelope.Story.TextAttachment)message.textAttachment().get()).preview().get());
            }
        }
        if (message.fileAttachment().isPresent()) {
            writer.println("Attachments:", new Object[0]);
            this.printAttachment(writer.indentedWriter(), (MessageEnvelope.Data.Attachment)message.fileAttachment().get());
        }
    }

    private void printTypingMessage(PlainTextWriter writer, MessageEnvelope.Typing typingMessage) {
        writer.println("Action: {}", typingMessage.type());
        writer.println("Timestamp: {}", DateUtils.formatTimestamp(typingMessage.timestamp()));
        if (typingMessage.groupId().isPresent()) {
            writer.println("Group Info:", new Object[0]);
            GroupId groupId = (GroupId)typingMessage.groupId().get();
            this.printGroupInfo(writer.indentedWriter(), groupId);
        }
    }

    private void printReceiptMessage(PlainTextWriter writer, MessageEnvelope.Receipt receiptMessage) {
        writer.println("When: {}", DateUtils.formatTimestamp(receiptMessage.when()));
        if (receiptMessage.type() == MessageEnvelope.Receipt.Type.DELIVERY) {
            writer.println("Is delivery receipt", new Object[0]);
        }
        if (receiptMessage.type() == MessageEnvelope.Receipt.Type.READ) {
            writer.println("Is read receipt", new Object[0]);
        }
        if (receiptMessage.type() == MessageEnvelope.Receipt.Type.VIEWED) {
            writer.println("Is viewed receipt", new Object[0]);
        }
        writer.println("Timestamps:", new Object[0]);
        Iterator iterator = receiptMessage.timestamps().iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            writer.println("- {}", DateUtils.formatTimestamp(timestamp));
        }
    }

    private void printCallMessage(PlainTextWriter writer, MessageEnvelope.Call callMessage) {
        if (callMessage.destinationDeviceId().isPresent()) {
            Integer deviceId = (Integer)callMessage.destinationDeviceId().get();
            writer.println("Destination device id: {}", deviceId);
        }
        if (callMessage.groupId().isPresent()) {
            GroupId groupId = (GroupId)callMessage.groupId().get();
            writer.println("Destination group id: {}", groupId);
        }
        if (callMessage.timestamp().isPresent()) {
            writer.println("Timestamp: {}", DateUtils.formatTimestamp((Long)callMessage.timestamp().get()));
        }
        if (callMessage.answer().isPresent()) {
            MessageEnvelope.Call.Answer answerMessage = (MessageEnvelope.Call.Answer)callMessage.answer().get();
            writer.println("Answer message: {}, opaque length: {})", answerMessage.id(), answerMessage.opaque().length);
        }
        if (callMessage.busy().isPresent()) {
            MessageEnvelope.Call.Busy busyMessage = (MessageEnvelope.Call.Busy)callMessage.busy().get();
            writer.println("Busy message: {}", busyMessage.id());
        }
        if (callMessage.hangup().isPresent()) {
            MessageEnvelope.Call.Hangup hangupMessage = (MessageEnvelope.Call.Hangup)callMessage.hangup().get();
            writer.println("Hangup message: {}", hangupMessage.id());
        }
        if (!callMessage.iceUpdate().isEmpty()) {
            writer.println("Ice update messages:", new Object[0]);
            List iceUpdateMessages = callMessage.iceUpdate();
            for (MessageEnvelope.Call.IceUpdate iceUpdateMessage : iceUpdateMessages) {
                writer.println("- {}, opaque length: {}", iceUpdateMessage.id(), iceUpdateMessage.opaque().length);
            }
        }
        if (callMessage.offer().isPresent()) {
            MessageEnvelope.Call.Offer offerMessage = (MessageEnvelope.Call.Offer)callMessage.offer().get();
            writer.println("Offer message: {}, opaque length: {}", offerMessage.id(), offerMessage.opaque().length);
        }
        if (callMessage.opaque().isPresent()) {
            MessageEnvelope.Call.Opaque opaqueMessage = (MessageEnvelope.Call.Opaque)callMessage.opaque().get();
            writer.println("Opaque message: size {}, urgency: {}", opaqueMessage.opaque().length, opaqueMessage.urgency().name());
        }
    }

    private void printSyncMessage(PlainTextWriter writer, MessageEnvelope.Sync syncMessage) {
        if (syncMessage.contacts().isPresent()) {
            MessageEnvelope.Sync.Contacts contactsMessage = (MessageEnvelope.Sync.Contacts)syncMessage.contacts().get();
            String type = contactsMessage.isComplete() ? "complete" : "partial";
            writer.println("Received {} sync contacts:", type);
        }
        if (syncMessage.groups().isPresent()) {
            writer.println("Received sync groups.", new Object[0]);
        }
        if (!syncMessage.read().isEmpty()) {
            writer.println("Received sync read messages list", new Object[0]);
            for (MessageEnvelope.Sync.Read rm : syncMessage.read()) {
                writer.println("- From: {} Message timestamp: {}", this.formatContact(rm.sender()), DateUtils.formatTimestamp(rm.timestamp()));
            }
        }
        if (!syncMessage.viewed().isEmpty()) {
            writer.println("Received sync viewed messages list", new Object[0]);
            for (MessageEnvelope.Sync.Viewed vm : syncMessage.viewed()) {
                writer.println("- From: {} Message timestamp: {}", this.formatContact(vm.sender()), DateUtils.formatTimestamp(vm.timestamp()));
            }
        }
        if (syncMessage.sent().isPresent()) {
            MessageEnvelope.Data message;
            writer.println("Received sync sent message", new Object[0]);
            MessageEnvelope.Sync.Sent sentTranscriptMessage = (MessageEnvelope.Sync.Sent)syncMessage.sent().get();
            String to = sentTranscriptMessage.destination().isPresent() ? this.formatContact((RecipientAddress)sentTranscriptMessage.destination().get()) : (!sentTranscriptMessage.recipients().isEmpty() ? sentTranscriptMessage.recipients().stream().map(this::formatContact).collect(Collectors.joining(", ")) : "<unknown>");
            writer.indentedWriter().println("To: {}", to);
            writer.indentedWriter().println("Timestamp: {}", DateUtils.formatTimestamp(sentTranscriptMessage.timestamp()));
            if (sentTranscriptMessage.expirationStartTimestamp() > 0L) {
                writer.indentedWriter().println("Expiration started at: {}", DateUtils.formatTimestamp(sentTranscriptMessage.expirationStartTimestamp()));
            }
            if (sentTranscriptMessage.message().isPresent()) {
                message = (MessageEnvelope.Data)sentTranscriptMessage.message().get();
                this.printDataMessage(writer.indentedWriter(), message);
            }
            if (sentTranscriptMessage.story().isPresent()) {
                message = (MessageEnvelope.Story)sentTranscriptMessage.story().get();
                this.printStoryMessage(writer.indentedWriter(), (MessageEnvelope.Story)message);
            }
        }
        if (syncMessage.blocked().isPresent()) {
            writer.println("Received sync message with block list", new Object[0]);
            writer.println("Blocked:", new Object[0]);
            MessageEnvelope.Sync.Blocked blockedList = (MessageEnvelope.Sync.Blocked)syncMessage.blocked().get();
            for (RecipientAddress address : blockedList.recipients()) {
                writer.println("- {}", address.getLegacyIdentifier());
            }
            for (GroupId groupId : blockedList.groupIds()) {
                writer.println("- {}", groupId.toBase64());
            }
        }
        if (syncMessage.viewOnceOpen().isPresent()) {
            MessageEnvelope.Sync.ViewOnceOpen viewOnceOpenMessage = (MessageEnvelope.Sync.ViewOnceOpen)syncMessage.viewOnceOpen().get();
            writer.println("Received sync message with view once open message:", new Object[0]);
            writer.indentedWriter().println("Sender: {}", this.formatContact(viewOnceOpenMessage.sender()));
            writer.indentedWriter().println("Timestamp: {}", DateUtils.formatTimestamp(viewOnceOpenMessage.timestamp()));
        }
        if (syncMessage.messageRequestResponse().isPresent()) {
            MessageEnvelope.Sync.MessageRequestResponse requestResponseMessage = (MessageEnvelope.Sync.MessageRequestResponse)syncMessage.messageRequestResponse().get();
            writer.println("Received message request response:", new Object[0]);
            writer.indentedWriter().println("Type: {}", requestResponseMessage.type());
            if (requestResponseMessage.groupId().isPresent()) {
                writer.println("For group:", new Object[0]);
                this.printGroupInfo(writer.indentedWriter(), (GroupId)requestResponseMessage.groupId().get());
            }
            if (requestResponseMessage.person().isPresent()) {
                writer.indentedWriter().println("For Person: {}", this.formatContact((RecipientAddress)requestResponseMessage.person().get()));
            }
        }
    }

    private void printPreview(PlainTextWriter writer, MessageEnvelope.Data.Preview preview) {
        writer.println("Title: {}", preview.title());
        writer.println("Description: {}", preview.description());
        writer.println("Date: {}", DateUtils.formatTimestamp(preview.date()));
        writer.println("Url: {}", preview.url());
        if (preview.image().isPresent()) {
            writer.println("Image:", new Object[0]);
            this.printAttachment(writer.indentedWriter(), (MessageEnvelope.Data.Attachment)preview.image().get());
        }
    }

    private void printSticker(PlainTextWriter writer, MessageEnvelope.Data.Sticker sticker) {
        writer.println("Pack id: {}", Hex.toStringCondensed(sticker.packId().serialize()));
        writer.println("Sticker id: {}", sticker.stickerId());
    }

    private void printReaction(PlainTextWriter writer, MessageEnvelope.Data.Reaction reaction) {
        writer.println("Emoji: {}", reaction.emoji());
        writer.println("Target author: {}", this.formatContact(reaction.targetAuthor()));
        writer.println("Target timestamp: {}", DateUtils.formatTimestamp(reaction.targetSentTimestamp()));
        writer.println("Is remove: {}", reaction.isRemove());
    }

    private void printQuote(PlainTextWriter writer, MessageEnvelope.Data.Quote quote) {
        writer.println("Id: {}", quote.id());
        writer.println("Author: {}", this.formatContact(quote.author()));
        if (quote.text().isPresent()) {
            writer.println("Text: {}", quote.text().get());
        }
        if (quote.mentions() != null && !quote.mentions().isEmpty()) {
            writer.println("Mentions:", new Object[0]);
            for (MessageEnvelope.Data.Mention mention : quote.mentions()) {
                this.printMention(writer, mention);
            }
        }
        if (!quote.attachments().isEmpty()) {
            writer.println("Attachments:", new Object[0]);
            for (MessageEnvelope.Data.Attachment attachment : quote.attachments()) {
                writer.println("- Attachment:", new Object[0]);
                this.printAttachment(writer.indentedWriter(), attachment);
            }
        }
    }

    private void printSharedContact(PlainTextWriter writer, MessageEnvelope.Data.SharedContact contact) {
        writer.println("Name:", new Object[0]);
        MessageEnvelope.Data.SharedContact.Name name = contact.name();
        writer.indent(w -> {
            if (name.given().isPresent() && !((String)name.given().get()).isBlank()) {
                w.println("First name: {}", name.given().get());
            }
            if (name.middle().isPresent() && !((String)name.middle().get()).isBlank()) {
                w.println("Middle name: {}", name.middle().get());
            }
            if (name.family().isPresent() && !((String)name.family().get()).isBlank()) {
                w.println("Family name: {}", name.family().get());
            }
            if (name.prefix().isPresent() && !((String)name.prefix().get()).isBlank()) {
                w.println("Prefix name: {}", name.prefix().get());
            }
            if (name.suffix().isPresent() && !((String)name.suffix().get()).isBlank()) {
                w.println("Suffix name: {}", name.suffix().get());
            }
            if (name.nickname().isPresent() && !((String)name.nickname().get()).isBlank()) {
                w.println("Display name: {}", name.nickname().get());
            }
        });
        if (contact.avatar().isPresent()) {
            MessageEnvelope.Data.SharedContact.Avatar avatar = (MessageEnvelope.Data.SharedContact.Avatar)contact.avatar().get();
            writer.println("Avatar: (profile: {})", avatar.isProfile());
            this.printAttachment(writer.indentedWriter(), avatar.attachment());
        }
        if (contact.organization().isPresent()) {
            writer.println("Organisation: {}", contact.organization().get());
        }
        if (!contact.phone().isEmpty()) {
            writer.println("Phone details:", new Object[0]);
            for (MessageEnvelope.Data.SharedContact.Phone phone : contact.phone()) {
                writer.println("- Phone:", new Object[0]);
                writer.indent(w -> {
                    w.println("Number: {}", phone.value());
                    w.println("Type: {}", phone.type());
                    if (phone.label().isPresent() && !((String)phone.label().get()).isBlank()) {
                        w.println("Label: {}", phone.label().get());
                    }
                });
            }
        }
        if (!contact.email().isEmpty()) {
            writer.println("Email details:", new Object[0]);
            for (MessageEnvelope.Data.SharedContact.Email email : contact.email()) {
                writer.println("- Email:", new Object[0]);
                writer.indent(w -> {
                    w.println("Address: {}", email.value());
                    w.println("Type: {}", email.type());
                    if (email.label().isPresent() && !((String)email.label().get()).isBlank()) {
                        w.println("Label: {}", email.label().get());
                    }
                });
            }
        }
        if (!contact.address().isEmpty()) {
            writer.println("Address details:", new Object[0]);
            for (MessageEnvelope.Data.SharedContact.Address address : contact.address()) {
                writer.println("- Address:", new Object[0]);
                writer.indent(w -> {
                    w.println("Type: {}", address.type());
                    if (address.label().isPresent() && !((String)address.label().get()).isBlank()) {
                        w.println("Label: {}", address.label().get());
                    }
                    if (address.street().isPresent() && !((String)address.street().get()).isBlank()) {
                        w.println("Street: {}", address.street().get());
                    }
                    if (address.pobox().isPresent() && !((String)address.pobox().get()).isBlank()) {
                        w.println("Pobox: {}", address.pobox().get());
                    }
                    if (address.neighborhood().isPresent() && !((String)address.neighborhood().get()).isBlank()) {
                        w.println("Neighbourhood: {}", address.neighborhood().get());
                    }
                    if (address.city().isPresent() && !((String)address.city().get()).isBlank()) {
                        w.println("City: {}", address.city().get());
                    }
                    if (address.region().isPresent() && !((String)address.region().get()).isBlank()) {
                        w.println("Region: {}", address.region().get());
                    }
                    if (address.postcode().isPresent() && !((String)address.postcode().get()).isBlank()) {
                        w.println("Postcode: {}", address.postcode().get());
                    }
                    if (address.country().isPresent() && !((String)address.country().get()).isBlank()) {
                        w.println("Country: {}", address.country().get());
                    }
                });
            }
        }
    }

    private void printGroupContext(PlainTextWriter writer, MessageEnvelope.Data.GroupContext groupContext) {
        this.printGroupInfo(writer, groupContext.groupId());
        writer.println("Revision: {}", groupContext.revision());
        writer.println("Type: {}", groupContext.isGroupUpdate() ? "UPDATE" : "DELIVER");
    }

    private void printStoryContext(PlainTextWriter writer, MessageEnvelope.Data.StoryContext storyContext) {
        writer.println("Sender: {}", this.formatContact(storyContext.author()));
        writer.println("Sent timestamp: {}", storyContext.sentTimestamp());
    }

    private void printGroupInfo(PlainTextWriter writer, GroupId groupId) {
        writer.println("Id: {}", groupId.toBase64());
        Group group = this.m.getGroup(groupId);
        if (group != null) {
            writer.println("Name: {}", group.title());
        } else {
            writer.println("Name: <Unknown group>", new Object[0]);
        }
    }

    private void printMention(PlainTextWriter writer, MessageEnvelope.Data.Mention mention) {
        writer.println("- {}: {} (length: {})", this.formatContact(mention.recipient()), mention.start(), mention.length());
    }

    private void printTextStyle(PlainTextWriter writer, TextStyle textStyle) {
        writer.println("- {}: {} (length: {})", textStyle.style().name(), textStyle.start(), textStyle.length());
    }

    private void printAttachment(PlainTextWriter writer, MessageEnvelope.Data.Attachment attachment) {
        File file;
        writer.println("Content-Type: {}", attachment.contentType());
        writer.println("Type: {}", attachment.id().isPresent() ? "Pointer" : "Stream");
        if (attachment.id().isPresent()) {
            writer.println("Id: {}", attachment.id().get());
        }
        if (attachment.uploadTimestamp().isPresent()) {
            writer.println("Upload timestamp: {}", DateUtils.formatTimestamp((Long)attachment.uploadTimestamp().get()));
        }
        if (attachment.caption().isPresent()) {
            writer.println("Caption: {}", attachment.caption().get());
        }
        if (attachment.fileName().isPresent()) {
            writer.println("Filename: {}", attachment.fileName().get());
        }
        if (attachment.size().isPresent() || attachment.preview().isPresent()) {
            writer.println("Size: {}{}", attachment.size().isPresent() ? String.valueOf(attachment.size().get()) + " bytes" : "<unavailable>", attachment.preview().isPresent() ? " (Preview is available: " + ((byte[])attachment.preview().get()).length + " bytes)" : "");
        }
        if (attachment.thumbnail().isPresent()) {
            writer.println("Thumbnail:", new Object[0]);
            this.printAttachment(writer.indentedWriter(), (MessageEnvelope.Data.Attachment)attachment.thumbnail().get());
        }
        ArrayList<String> flags = new ArrayList<String>();
        if (attachment.isVoiceNote()) {
            flags.add("voice note");
        }
        if (attachment.isBorderless()) {
            flags.add("borderless");
        }
        if (attachment.isGif()) {
            flags.add("video gif");
        }
        if (!flags.isEmpty()) {
            writer.println("Flags: {}", String.join((CharSequence)", ", flags));
        }
        if (attachment.width().isPresent() || attachment.height().isPresent()) {
            writer.println("Dimensions: {}x{}", attachment.width().orElse(0), attachment.height().orElse(0));
        }
        if (attachment.file().isPresent() && (file = (File)attachment.file().get()).exists()) {
            writer.println("Stored plaintext in: {}", file);
        }
    }

    private String formatContact(RecipientAddress address) {
        String number = address.getLegacyIdentifier();
        String name = this.m.getContactOrProfileName(RecipientIdentifier.Single.fromAddress((RecipientAddress)address));
        if (name == null || name.isEmpty()) {
            return number;
        }
        return MessageFormatter.arrayFormat((String)"\u201c{}\u201d {}", (Object[])new Object[]{name, number}).getMessage();
    }
}

