/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.websocket;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.SingleSubject;
import java.io.IOException;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Pair;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.push.TrustStore;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.util.Tls12SocketFactory;
import org.whispersystems.signalservice.api.util.TlsProxySocketFactory;
import org.whispersystems.signalservice.api.websocket.HealthMonitor;
import org.whispersystems.signalservice.api.websocket.WebSocketConnectionState;
import org.whispersystems.signalservice.internal.configuration.SignalProxy;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.configuration.SignalServiceUrl;
import org.whispersystems.signalservice.internal.util.BlacklistingTrustManager;
import org.whispersystems.signalservice.internal.util.Util;
import org.whispersystems.signalservice.internal.websocket.WebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.WebSocketMessage;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebSocketResponseMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

public class OkHttpWebSocketConnection
extends WebSocketListener
implements WebSocketConnection {
    private static final String TAG = OkHttpWebSocketConnection.class.getSimpleName();
    public static final int KEEPALIVE_FREQUENCY_SECONDS = 30;
    private final LinkedList<WebSocketRequestMessage> incomingRequests = new LinkedList();
    private final Map<Long, OutgoingRequest> outgoingRequests = new HashMap<Long, OutgoingRequest>();
    private final Set<Long> keepAlives = new HashSet<Long>();
    private final String name;
    private final TrustStore trustStore;
    private final Optional<CredentialsProvider> credentialsProvider;
    private final String signalAgent;
    private final HealthMonitor healthMonitor;
    private final List<Interceptor> interceptors;
    private final Optional<Dns> dns;
    private final Optional<SignalProxy> signalProxy;
    private final BehaviorSubject<WebSocketConnectionState> webSocketState;
    private final boolean allowStories;
    private final SignalServiceUrl[] serviceUrls;
    private final String extraPathUri;
    private final SecureRandom random;
    private OkHttpClient okHttpClient;
    private WebSocket client;

    public OkHttpWebSocketConnection(String name, SignalServiceConfiguration serviceConfiguration, Optional<CredentialsProvider> credentialsProvider, String signalAgent, HealthMonitor healthMonitor, boolean allowStories) {
        this(name, serviceConfiguration, credentialsProvider, signalAgent, healthMonitor, "", allowStories);
    }

    public OkHttpWebSocketConnection(String name, SignalServiceConfiguration serviceConfiguration, Optional<CredentialsProvider> credentialsProvider, String signalAgent, HealthMonitor healthMonitor, String extraPathUri, boolean allowStories) {
        this.name = "[" + name + ":" + System.identityHashCode(this) + "]";
        this.trustStore = serviceConfiguration.getSignalServiceUrls()[0].getTrustStore();
        this.credentialsProvider = credentialsProvider;
        this.signalAgent = signalAgent;
        this.interceptors = serviceConfiguration.getNetworkInterceptors();
        this.dns = serviceConfiguration.getDns();
        this.signalProxy = serviceConfiguration.getSignalProxy();
        this.healthMonitor = healthMonitor;
        this.webSocketState = BehaviorSubject.createDefault((Object)((Object)WebSocketConnectionState.DISCONNECTED));
        this.allowStories = allowStories;
        this.serviceUrls = serviceConfiguration.getSignalServiceUrls();
        this.extraPathUri = extraPathUri;
        this.random = new SecureRandom();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private Pair<SignalServiceUrl, String> getConnectionInfo() {
        SignalServiceUrl serviceUrl = this.serviceUrls[this.random.nextInt(this.serviceUrls.length)];
        String uri = serviceUrl.getUrl().replace("https://", "wss://").replace("http://", "ws://");
        return new Pair((Object)serviceUrl, (Object)(uri + "/v1/websocket/" + this.extraPathUri));
    }

    @Override
    public synchronized Observable<WebSocketConnectionState> connect() {
        this.log("connect()");
        if (this.client == null) {
            Pair<SignalServiceUrl, String> connectionInfo = this.getConnectionInfo();
            SignalServiceUrl serviceUrl = (SignalServiceUrl)connectionInfo.getFirst();
            String wsUri = (String)connectionInfo.getSecond();
            Pair<SSLSocketFactory, X509TrustManager> socketFactory = this.createTlsSocketFactory(this.trustStore);
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory((SSLSocketFactory)socketFactory.getFirst()), (X509TrustManager)socketFactory.getSecond()).connectionSpecs(serviceUrl.getConnectionSpecs().orElse(Util.immutableList(ConnectionSpec.RESTRICTED_TLS))).readTimeout(40L, TimeUnit.SECONDS).dns(this.dns.orElse(Dns.SYSTEM)).connectTimeout(40L, TimeUnit.SECONDS);
            for (Interceptor interceptor : this.interceptors) {
                clientBuilder.addInterceptor(interceptor);
            }
            if (this.signalProxy.isPresent()) {
                clientBuilder.socketFactory((SocketFactory)new TlsProxySocketFactory(this.signalProxy.get().getHost(), this.signalProxy.get().getPort(), this.dns));
            }
            this.okHttpClient = clientBuilder.build();
            Request.Builder requestBuilder = new Request.Builder().url(wsUri);
            if (this.signalAgent != null) {
                requestBuilder.addHeader("X-Signal-Agent", this.signalAgent);
            }
            if (this.credentialsProvider.isPresent()) {
                if (this.credentialsProvider.get().getUsername() != null && this.credentialsProvider.get().getPassword() != null) {
                    requestBuilder.addHeader("Authorization", Credentials.basic((String)this.credentialsProvider.get().getUsername(), (String)this.credentialsProvider.get().getPassword()));
                } else {
                    Log.w((String)TAG, (String)"CredentialsProvider was present, but username or password was missing!");
                }
            }
            requestBuilder.addHeader("X-Signal-Receive-Stories", this.allowStories ? "true" : "false");
            if (serviceUrl.getHostHeader().isPresent()) {
                requestBuilder.addHeader("Host", serviceUrl.getHostHeader().get());
                Log.w((String)TAG, (String)("Using alternate host: " + serviceUrl.getHostHeader().get()));
            }
            this.webSocketState.onNext((Object)WebSocketConnectionState.CONNECTING);
            this.client = this.okHttpClient.newWebSocket(requestBuilder.build(), (WebSocketListener)this);
        }
        return this.webSocketState;
    }

    @Override
    public synchronized boolean isDead() {
        return this.client == null;
    }

    @Override
    public synchronized void disconnect() {
        this.log("disconnect()");
        if (this.client != null) {
            this.client.close(1000, "OK");
            this.client = null;
            this.webSocketState.onNext((Object)WebSocketConnectionState.DISCONNECTING);
            this.okHttpClient.dispatcher().executorService().shutdown();
        }
        this.notifyAll();
    }

    @Override
    public synchronized Optional<WebSocketRequestMessage> readRequestIfAvailable() {
        if (this.incomingRequests.size() > 0) {
            return Optional.of(this.incomingRequests.removeFirst());
        }
        return Optional.empty();
    }

    @Override
    public synchronized WebSocketRequestMessage readRequest(long timeoutMillis) throws TimeoutException, IOException {
        if (this.client == null) {
            throw new IOException("Connection closed!");
        }
        long startTime = System.currentTimeMillis();
        while (this.client != null && this.incomingRequests.isEmpty() && this.elapsedTime(startTime) < timeoutMillis) {
            Util.wait(this, Math.max(1L, timeoutMillis - this.elapsedTime(startTime)));
        }
        if (this.incomingRequests.isEmpty() && this.client == null) {
            throw new IOException("Connection closed!");
        }
        if (this.incomingRequests.isEmpty()) {
            throw new TimeoutException("Timeout exceeded");
        }
        return this.incomingRequests.removeFirst();
    }

    @Override
    public synchronized Single<WebsocketResponse> sendRequest(@NotNull WebSocketRequestMessage request2, long timeoutSeconds) throws IOException {
        if (this.client == null) {
            throw new IOException("No connection!");
        }
        WebSocketMessage message = new WebSocketMessage.Builder().type(WebSocketMessage.Type.REQUEST).request(request2).build();
        SingleSubject single = SingleSubject.create();
        this.outgoingRequests.put(request2.id, new OutgoingRequest((SingleSubject<WebsocketResponse>)single));
        if (!this.client.send(ByteString.of((byte[])message.encode()))) {
            throw new IOException("Write failed!");
        }
        return single.subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).timeout(timeoutSeconds, TimeUnit.SECONDS, Schedulers.io());
    }

    @Override
    public synchronized void sendResponse(WebSocketResponseMessage response) throws IOException {
        if (this.client == null) {
            throw new IOException("Connection closed!");
        }
        WebSocketMessage message = new WebSocketMessage.Builder().type(WebSocketMessage.Type.RESPONSE).response(response).build();
        if (!this.client.send(ByteString.of((byte[])message.encode()))) {
            throw new IOException("Write failed!");
        }
    }

    @Override
    public synchronized void sendKeepAlive() throws IOException {
        if (this.client != null) {
            this.log("Sending keep alive...");
            long id = System.currentTimeMillis();
            byte[] message = new WebSocketMessage.Builder().type(WebSocketMessage.Type.REQUEST).request(new WebSocketRequestMessage.Builder().id(id).path("/v1/keepalive").verb("GET").build()).build().encode();
            this.keepAlives.add(id);
            if (!this.client.send(ByteString.of((byte[])message))) {
                throw new IOException("Write failed!");
            }
        }
    }

    public synchronized void onOpen(WebSocket webSocket, Response response) {
        if (this.client != null) {
            this.log("onOpen() connected");
            this.webSocketState.onNext((Object)WebSocketConnectionState.CONNECTED);
        }
    }

    public synchronized void onMessage(WebSocket webSocket, ByteString payload) {
        try {
            WebSocketMessage message = (WebSocketMessage)((Object)WebSocketMessage.ADAPTER.decode(payload.toByteArray()));
            if (message.type == WebSocketMessage.Type.REQUEST) {
                this.incomingRequests.add(message.request);
            } else if (message.type == WebSocketMessage.Type.RESPONSE) {
                OutgoingRequest listener = this.outgoingRequests.remove(message.response.id);
                if (listener != null) {
                    listener.onSuccess(new WebsocketResponse((int)message.response.status, message.response.body == null ? "" : new String(message.response.body.toByteArray()), message.response.headers, !this.credentialsProvider.isPresent()));
                    if (message.response.status >= 400) {
                        this.healthMonitor.onMessageError(message.response.status, this.credentialsProvider.isPresent());
                    }
                } else if (this.keepAlives.remove(message.response.id)) {
                    this.healthMonitor.onKeepAliveResponse(message.response.id, this.credentialsProvider.isPresent());
                }
            }
            this.notifyAll();
        }
        catch (IOException e) {
            this.warn(e);
        }
    }

    public synchronized void onClosed(WebSocket webSocket, int code, String reason) {
        this.log("onClose(" + code + ")");
        this.webSocketState.onNext((Object)WebSocketConnectionState.DISCONNECTED);
        this.cleanupAfterShutdown(code);
        this.notifyAll();
    }

    public synchronized void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.warn("onFailure()", t);
        if (response != null && (response.code() == 401 || response.code() == 403)) {
            this.webSocketState.onNext((Object)WebSocketConnectionState.AUTHENTICATION_FAILED);
        } else {
            this.webSocketState.onNext((Object)WebSocketConnectionState.FAILED);
        }
        this.cleanupAfterShutdown(response != null ? response.code() : 1000);
        if (this.okHttpClient != null) {
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient = null;
        }
        this.notifyAll();
    }

    private void cleanupAfterShutdown(int code) {
        Iterator<Map.Entry<Long, OutgoingRequest>> iterator = this.outgoingRequests.entrySet().iterator();
        IOException exception = code == 403 || code == 4401 ? new NonSuccessfulResponseCodeException(code) : new SocketException("Closed unexpectedly");
        while (iterator.hasNext()) {
            Map.Entry<Long, OutgoingRequest> entry = iterator.next();
            entry.getValue().onError(exception);
            iterator.remove();
        }
        if (this.client != null) {
            this.log("Client not null when closed");
            this.client.close(1000, "OK");
            this.client = null;
        }
    }

    public void onMessage(WebSocket webSocket, String text) {
        Log.d((String)TAG, (String)"onMessage(text)");
    }

    public synchronized void onClosing(WebSocket webSocket, int code, String reason) {
        this.log("onClosing(" + code + ")");
        this.webSocketState.onNext((Object)WebSocketConnectionState.DISCONNECTING);
        webSocket.close(1000, "OK");
    }

    private long elapsedTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    private Pair<SSLSocketFactory, X509TrustManager> createTlsSocketFactory(TrustStore trustStore) {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = BlacklistingTrustManager.createFor(trustStore);
            context.init(null, trustManagers, null);
            return new Pair((Object)context.getSocketFactory(), (Object)((X509TrustManager)trustManagers[0]));
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void log(String message) {
        Log.i((String)TAG, (String)(this.name + " " + message));
    }

    private void warn(String message) {
        Log.w((String)TAG, (String)(this.name + " " + message));
    }

    private void warn(Throwable e) {
        Log.w((String)TAG, (String)this.name, (Throwable)e);
    }

    private void warn(String message, Throwable e) {
        Log.w((String)TAG, (String)(this.name + " " + message), (Throwable)e);
    }

    private static class OutgoingRequest {
        private final SingleSubject<WebsocketResponse> responseSingle;

        private OutgoingRequest(SingleSubject<WebsocketResponse> future) {
            this.responseSingle = future;
        }

        public void onSuccess(WebsocketResponse response) {
            this.responseSingle.onSuccess((Object)response);
        }

        public void onError(Throwable throwable) {
            this.responseSingle.onError(throwable);
        }
    }
}

