/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.websocket;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.OptionalExtensionsKt;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.net.Network;
import org.whispersystems.signalservice.internal.configuration.HttpProxy;
import org.whispersystems.signalservice.internal.configuration.SignalProxy;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"TAG", "", "applyConfiguration", "", "Lorg/signal/libsignal/net/Network;", "config", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;", "signal-service-java"})
@JvmName(name="LibSignalNetworkExtensions")
public final class LibSignalNetworkExtensions {
    @NotNull
    private static final String TAG = "LibSignalNetworkExtensions";

    public static final void applyConfiguration(@NotNull Network $this$applyConfiguration, @NotNull SignalServiceConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)$this$applyConfiguration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SignalProxy signalProxy = (SignalProxy)OptionalExtensionsKt.orNull(config.getSignalProxy());
        HttpProxy systemHttpProxy = (HttpProxy)OptionalExtensionsKt.orNull(config.getSystemHttpProxy());
        if (signalProxy != null) {
            try {
                $this$applyConfiguration.setProxy(signalProxy.getHost(), signalProxy.getPort());
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Invalid proxy configuration set! Failing connections until changed.");
                $this$applyConfiguration.setInvalidProxy();
            }
        } else if (systemHttpProxy != null) {
            try {
                $this$applyConfiguration.setProxy("http", systemHttpProxy.getHost(), Integer.valueOf(systemHttpProxy.getPort()), "", "");
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Failed to set system HTTP proxy, ignoring and continuing...");
            }
        }
        $this$applyConfiguration.setCensorshipCircumventionEnabled(config.getCensored());
    }
}

