/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.websocket;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.SingleSubject;
import java.io.IOException;
import java.net.SocketException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.net.AppExpiredException;
import org.signal.libsignal.net.AuthenticatedChatConnection;
import org.signal.libsignal.net.ChatConnection;
import org.signal.libsignal.net.ChatConnectionListener;
import org.signal.libsignal.net.ChatServiceException;
import org.signal.libsignal.net.ConnectionInvalidatedException;
import org.signal.libsignal.net.DeviceDeregisteredException;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.UnauthenticatedChatConnection;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.websocket.HealthMonitor;
import org.whispersystems.signalservice.api.websocket.WebSocketConnectionState;
import org.whispersystems.signalservice.internal.util.CompletableFutureExtensionsKt;
import org.whispersystems.signalservice.internal.websocket.LibSignalResponseExtensionKt;
import org.whispersystems.signalservice.internal.websocket.WebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebSocketResponseMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 V2\u00020\u0001:\u0003UVWB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u00103\u001a\u000204H\u0002J&\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00152\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0002J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020*0<H\u0016J\u0010\u0010=\u001a\u0002042\u0006\u0010>\u001a\u00020 H\u0002J\u0010\u0010?\u001a\u0002042\u0006\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020\tH\u0016J\b\u0010C\u001a\u000204H\u0016J\u001e\u0010D\u001a\b\u0012\u0004\u0012\u00020:0E2\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0015H\u0016J\b\u0010F\u001a\u000204H\u0016J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00100HH\u0016J\u0010\u0010I\u001a\u00020\u00102\u0006\u0010J\u001a\u00020\u0015H\u0016J\u0010\u0010K\u001a\u0002042\u0006\u0010L\u001a\u00020MH\u0016J(\u0010N\u001a\u0002HO\"\u0004\b\u0000\u0010O2\u0012\u0010P\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002HO0QH\u0096@\u00a2\u0006\u0002\u0010RR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\f\u0012\u0006\b\u0001\u0012\u00020 \u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R!\u0010(\u001a\u0012\u0012\t\u0012\u00070*\u00a2\u0006\u0002\b+0)\u00a2\u0006\u0002\b,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0016\u0010/\u001a\u000700\u00a2\u0006\u0002\b,\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0012\u0010S\u001a\u00060TR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lorg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection;", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketConnection;", "name", "", "network", "Lorg/signal/libsignal/net/Network;", "credentialsProvider", "Lorg/whispersystems/signalservice/api/util/CredentialsProvider;", "receiveStories", "", "healthMonitor", "Lorg/whispersystems/signalservice/api/websocket/HealthMonitor;", "<init>", "(Ljava/lang/String;Lorg/signal/libsignal/net/Network;Lorg/whispersystems/signalservice/api/util/CredentialsProvider;ZLorg/whispersystems/signalservice/api/websocket/HealthMonitor;)V", "incomingRequestQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "nextIncomingMessageInternalPseudoId", "Ljava/util/concurrent/atomic/AtomicLong;", "ackSenderForInternalPseudoId", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/signal/libsignal/net/ChatConnectionListener$ServerMessageAck;", "getAckSenderForInternalPseudoId", "()Ljava/util/concurrent/ConcurrentHashMap;", "CHAT_SERVICE_LOCK", "Ljava/util/concurrent/locks/ReentrantLock;", "stateChangedOrMessageReceivedCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/locks/Condition;", "chatConnection", "Lorg/signal/libsignal/net/ChatConnection;", "chatConnectionFuture", "Lorg/signal/libsignal/internal/CompletableFuture;", "pendingCallbacks", "", "Lorg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$PendingAction;", "getName", "()Ljava/lang/String;", "state", "Lio/reactivex/rxjava3/subjects/BehaviorSubject;", "Lorg/whispersystems/signalservice/api/websocket/WebSocketConnectionState;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lio/reactivex/rxjava3/annotations/NonNull;", "getState", "()Lio/reactivex/rxjava3/subjects/BehaviorSubject;", "stateMonitor", "Lio/reactivex/rxjava3/disposables/Disposable;", "getStateMonitor", "()Lio/reactivex/rxjava3/disposables/Disposable;", "cleanup", "", "sendRequestInternal", "request", "timeoutSeconds", "single", "Lio/reactivex/rxjava3/subjects/SingleSubject;", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "connect", "Lio/reactivex/rxjava3/core/Observable;", "handleConnectionSuccess", "connection", "handleConnectionFailure", "throwable", "", "isDead", "disconnect", "sendRequest", "Lio/reactivex/rxjava3/core/Single;", "sendKeepAlive", "readRequestIfAvailable", "Ljava/util/Optional;", "readRequest", "timeoutMillis", "sendResponse", "response", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketResponseMessage;", "runWithChatConnection", "T", "callback", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listener", "Lorg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$LibSignalChatListener;", "PendingAction", "Companion", "LibSignalChatListener", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nLibSignalChatConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibSignalChatConnection.kt\norg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,673:1\n1869#2,2:674\n1869#2:676\n1870#2:678\n1869#2,2:679\n1#3:677\n351#4,11:681\n*S KotlinDebug\n*F\n+ 1 LibSignalChatConnection.kt\norg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection\n*L\n172#1:674,2\n257#1:676\n257#1:678\n311#1:679,2\n559#1:681,11\n*E\n"})
public final class LibSignalChatConnection
implements WebSocketConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Network network;
    @Nullable
    private final CredentialsProvider credentialsProvider;
    private final boolean receiveStories;
    @NotNull
    private final HealthMonitor healthMonitor;
    @NotNull
    private final LinkedBlockingQueue<WebSocketRequestMessage> incomingRequestQueue;
    @NotNull
    private final AtomicLong nextIncomingMessageInternalPseudoId;
    @NotNull
    private final ConcurrentHashMap<Long, ChatConnectionListener.ServerMessageAck> ackSenderForInternalPseudoId;
    @NotNull
    private final ReentrantLock CHAT_SERVICE_LOCK;
    private final Condition stateChangedOrMessageReceivedCondition;
    @Nullable
    private ChatConnection chatConnection;
    @Nullable
    private CompletableFuture<? extends ChatConnection> chatConnectionFuture;
    @NotNull
    private final List<PendingAction> pendingCallbacks;
    @NotNull
    private final String name;
    @NotNull
    private final BehaviorSubject<WebSocketConnectionState> state;
    @NotNull
    private final Disposable stateMonitor;
    @NotNull
    private final LibSignalChatListener listener;
    @NotNull
    public static final String SERVICE_ENVELOPE_REQUEST_VERB = "PUT";
    @NotNull
    public static final String SERVICE_ENVELOPE_REQUEST_PATH = "/api/v1/message";
    @NotNull
    public static final String SOCKET_EMPTY_REQUEST_VERB = "PUT";
    @NotNull
    public static final String SOCKET_EMPTY_REQUEST_PATH = "/api/v1/queue/empty";
    @NotNull
    public static final String SIGNAL_SERVICE_ENVELOPE_TIMESTAMP_HEADER_KEY = "X-Signal-Timestamp";
    @NotNull
    private static final String TAG = Log.tag(LibSignalChatConnection.class);
    @NotNull
    private static final ChatConnection.Request KEEP_ALIVE_REQUEST = new ChatConnection.Request("GET", "/v1/keepalive", MapsKt.emptyMap(), new byte[0], (int)Duration.getInWholeMilliseconds-impl((long)WebSocketConnection.Companion.getDEFAULT_SEND_TIMEOUT-UwyO8pc()));

    public LibSignalChatConnection(@NotNull String name, @NotNull Network network, @Nullable CredentialsProvider credentialsProvider, boolean receiveStories, @NotNull HealthMonitor healthMonitor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)healthMonitor, (String)"healthMonitor");
        this.network = network;
        this.credentialsProvider = credentialsProvider;
        this.receiveStories = receiveStories;
        this.healthMonitor = healthMonitor;
        this.incomingRequestQueue = new LinkedBlockingQueue();
        this.nextIncomingMessageInternalPseudoId = new AtomicLong(1L);
        this.ackSenderForInternalPseudoId = new ConcurrentHashMap();
        this.CHAT_SERVICE_LOCK = new ReentrantLock();
        this.stateChangedOrMessageReceivedCondition = this.CHAT_SERVICE_LOCK.newCondition();
        this.pendingCallbacks = new ArrayList();
        this.name = "[" + name + ":" + System.identityHashCode(this) + "]";
        BehaviorSubject behaviorSubject = BehaviorSubject.createDefault((Object)((Object)WebSocketConnectionState.DISCONNECTED));
        Intrinsics.checkNotNullExpressionValue((Object)behaviorSubject, (String)"createDefault(...)");
        this.state = behaviorSubject;
        Disposable disposable = this.state.skip(1L).subscribe(new Consumer(this){
            final /* synthetic */ LibSignalChatConnection this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void accept(WebSocketConnectionState nextState) {
                Lock lock = LibSignalChatConnection.access$getCHAT_SERVICE_LOCK$p(this.this$0);
                LibSignalChatConnection libSignalChatConnection = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    if (nextState == WebSocketConnectionState.DISCONNECTED) {
                        LibSignalChatConnection.access$cleanup(libSignalChatConnection);
                    }
                    LibSignalChatConnection.access$getStateChangedOrMessageReceivedCondition$p(libSignalChatConnection).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        this.stateMonitor = disposable;
        if (this.credentialsProvider != null) {
            CharSequence charSequence = this.credentialsProvider.getUsername();
            if (!(!(charSequence == null || charSequence.length() == 0))) {
                throw new IllegalStateException("Check failed.");
            }
            charSequence = this.credentialsProvider.getPassword();
            if (!(!(charSequence == null || charSequence.length() == 0))) {
                throw new IllegalStateException("Check failed.");
            }
        }
        this.listener = new LibSignalChatListener();
    }

    @NotNull
    public final ConcurrentHashMap<Long, ChatConnectionListener.ServerMessageAck> getAckSenderForInternalPseudoId() {
        return this.ackSenderForInternalPseudoId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final BehaviorSubject<WebSocketConnectionState> getState() {
        return this.state;
    }

    @NotNull
    public final Disposable getStateMonitor() {
        return this.stateMonitor;
    }

    private final void cleanup() {
        Log.i((String)TAG, (String)(this.getName() + " [cleanup]"));
        this.incomingRequestQueue.clear();
        this.ackSenderForInternalPseudoId.clear();
        if (!((Collection)this.pendingCallbacks).isEmpty()) {
            Log.w((String)TAG, (String)(this.getName() + " [cleanup] " + this.pendingCallbacks.size() + " pendingCallbacks during cleanup! This is probably a bug."));
            Iterable $this$forEach$iv = this.pendingCallbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PendingAction pending = (PendingAction)element$iv;
                boolean bl = false;
                pending.getOnFailure().invoke((Object)new SocketException("Connection terminated unexpectedly"));
            }
            this.pendingCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendRequestInternal(WebSocketRequestMessage request2, long timeoutSeconds, SingleSubject<WebsocketResponse> single) {
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl = false;
            if (!(this.state.getValue() == WebSocketConnectionState.CONNECTED)) {
                throw new IllegalStateException("Check failed.");
            }
            ChatConnection.Request internalRequest = LibSignalChatConnection.Companion.toLibSignalRequest-HG0u8IE(request2, DurationKt.toDuration((long)timeoutSeconds, (DurationUnit)DurationUnit.SECONDS));
            ChatConnection chatConnection = this.chatConnection;
            Intrinsics.checkNotNull((Object)chatConnection);
            CompletableFuture completableFuture = chatConnection.send(internalRequest);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"send(...)");
            CompletableFuture completableFuture2 = CompletableFutureExtensionsKt.whenComplete(completableFuture, arg_0 -> LibSignalChatConnection.sendRequestInternal$lambda$3$lambda$1(this, single, arg_0), (Function1<? super Throwable, Unit>)((Function1)arg_0 -> LibSignalChatConnection.sendRequestInternal$lambda$3$lambda$2(this, single, arg_0)));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Observable<WebSocketConnectionState> connect() {
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.isDead()) {
                Observable observable = (Observable)this.state;
                return observable;
            }
            Log.i((String)TAG, (String)(this.getName() + " Connecting..."));
            this.chatConnectionFuture = this.credentialsProvider == null ? this.network.connectUnauthChat((ChatConnectionListener)this.listener) : this.network.connectAuthChat(this.credentialsProvider.getUsername(), this.credentialsProvider.getPassword(), this.receiveStories, (ChatConnectionListener)this.listener);
            this.state.onNext((Object)WebSocketConnectionState.CONNECTING);
            CompletableFuture<? extends ChatConnection> completableFuture = this.chatConnectionFuture;
            Intrinsics.checkNotNull(completableFuture);
            CompletableFutureExtensionsKt.whenComplete(completableFuture, (Function1)new Function1(this){
                final /* synthetic */ LibSignalChatConnection this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void invoke(ChatConnection connection) {
                    ChatConnection chatConnection = connection;
                    Intrinsics.checkNotNull((Object)chatConnection);
                    LibSignalChatConnection.access$handleConnectionSuccess(this.this$0, chatConnection);
                }
            }, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> LibSignalChatConnection.connect$lambda$5$lambda$4(this, arg_0)));
            Observable observable = (Observable)this.state;
            return observable;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleConnectionSuccess(ChatConnection connection) {
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl = false;
            WebSocketConnectionState webSocketConnectionState = (WebSocketConnectionState)((Object)this.state.getValue());
            if ((webSocketConnectionState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[webSocketConnectionState.ordinal()]) == 1) {
                ChatConnection chatConnection = this.chatConnection = connection;
                if (chatConnection != null) {
                    chatConnection.start();
                }
                Log.i((String)TAG, (String)(this.getName() + " Connected"));
                this.state.onNext((Object)WebSocketConnectionState.CONNECTED);
                Iterable $this$forEach$iv = this.pendingCallbacks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    PendingAction pending = (PendingAction)element$iv;
                    boolean bl2 = false;
                    Object object2 = this;
                    try {
                        LibSignalChatConnection $this$handleConnectionSuccess_u24lambda_u249_u24lambda_u248_u24lambda_u246 = object2;
                        boolean bl3 = false;
                        pending.getOnConnectionSuccess().invoke((Object)connection);
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl3) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                    }
                    object2 = object;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable == null) continue;
                    Object e = object = throwable;
                    boolean bl4 = false;
                    Log.w((String)TAG, (String)(this.getName() + " [handleConnectionSuccess] Failed to execute pending action"), (Throwable)e);
                    pending.getOnFailure().invoke(e);
                }
                this.pendingCallbacks.clear();
            } else {
                Log.i((String)TAG, (String)(this.getName() + " Dropped successful connection because we are now " + this.state.getValue()));
                this.disconnect();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleConnectionFailure(Throwable throwable) {
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl = false;
            if (throwable instanceof CancellationException) {
                if (!(this.state.getValue() == WebSocketConnectionState.DISCONNECTED)) {
                    throw new IllegalStateException("Check failed.");
                }
                Log.i((String)TAG, (String)(this.getName() + " [connect] cancelled"));
                return;
            }
            Log.w((String)TAG, (String)(this.getName() + " [connect] Failure:"), (Throwable)throwable);
            this.chatConnection = null;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof DeviceDeregisteredException) {
                this.state.onNext((Object)WebSocketConnectionState.AUTHENTICATION_FAILED);
            } else if (throwable2 instanceof AppExpiredException) {
                this.state.onNext((Object)WebSocketConnectionState.REMOTE_DEPRECATED);
            } else {
                Log.w((String)TAG, (String)"Unknown connection failure reason", (Throwable)throwable);
                this.state.onNext((Object)WebSocketConnectionState.FAILED);
            }
            IOException downstreamThrowable = throwable instanceof DeviceDeregisteredException ? (IOException)new NonSuccessfulResponseCodeException(403) : (IOException)new SocketException("Closed unexpectedly");
            Iterable $this$forEach$iv = this.pendingCallbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PendingAction pending = (PendingAction)element$iv;
                boolean bl2 = false;
                pending.getOnFailure().invoke((Object)downstreamThrowable);
            }
            this.pendingCallbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDead() {
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl = false;
            WebSocketConnectionState webSocketConnectionState = (WebSocketConnectionState)((Object)this.state.getValue());
            boolean bl2 = switch (webSocketConnectionState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[webSocketConnectionState.ordinal()]) {
                case 2, 3, 4, 5, 6 -> true;
                case 1, 7 -> false;
                case -1 -> throw new IllegalStateException("LibSignalChatConnection.state can never be null");
                default -> throw new NoWhenBranchMatchedException();
            };
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl = false;
            if (this.isDead()) {
                return;
            }
            if (this.state.getValue() == WebSocketConnectionState.CONNECTING) {
                Log.i((String)TAG, (String)(this.getName() + " Cancelling connection attempt..."));
                CompletableFuture<? extends ChatConnection> completableFuture = this.chatConnectionFuture;
                Intrinsics.checkNotNull(completableFuture);
                completableFuture.cancel(true);
                this.state.onNext((Object)WebSocketConnectionState.DISCONNECTED);
                return;
            }
            Log.i((String)TAG, (String)(this.getName() + " Disconnecting..."));
            this.state.onNext((Object)WebSocketConnectionState.DISCONNECTING);
            ChatConnection chatConnection = this.chatConnection;
            Intrinsics.checkNotNull((Object)chatConnection);
            CompletableFuture completableFuture = chatConnection.disconnect();
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"disconnect(...)");
            CompletableFutureExtensionsKt.whenComplete(completableFuture, LibSignalChatConnection::disconnect$lambda$15$lambda$13, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> LibSignalChatConnection.disconnect$lambda$15$lambda$14(this, arg_0)));
            this.chatConnection = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Single<WebsocketResponse> sendRequest(@NotNull WebSocketRequestMessage request2, long timeoutSeconds) {
        Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl = false;
            if (this.isDead()) {
                throw new IOException(this.getName() + " is closed!");
            }
            SingleSubject singleSubject = SingleSubject.create();
            Intrinsics.checkNotNullExpressionValue((Object)singleSubject, (String)"create(...)");
            SingleSubject single = singleSubject;
            WebSocketConnectionState webSocketConnectionState = (WebSocketConnectionState)((Object)this.state.getValue());
            Single single2 = (switch (webSocketConnectionState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[webSocketConnectionState.ordinal()]) {
                case 1 -> {
                    Log.i((String)TAG, (String)"[sendRequest] Enqueuing request send for after connection");
                    this.pendingCallbacks.add(new PendingAction((Function1<? super ChatConnection, Unit>)((Function1)arg_0 -> LibSignalChatConnection.sendRequest$lambda$18$lambda$16(this, request2, timeoutSeconds, single, arg_0)), (Function1<? super Throwable, Unit>)((Function1)arg_0 -> LibSignalChatConnection.sendRequest$lambda$18$lambda$17(single, arg_0))));
                    yield single;
                }
                case 7 -> {
                    this.sendRequestInternal(request2, timeoutSeconds, (SingleSubject<WebsocketResponse>)single);
                    yield single;
                }
                default -> throw new IllegalStateException("LibSignalChatConnection.state was neither dead, CONNECTING, or CONNECTED.");
            }).subscribeOn(Schedulers.io()).observeOn(Schedulers.io());
            Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"observeOn(...)");
            Single single3 = single2;
            return single3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendKeepAlive() {
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl = false;
            if (this.isDead()) {
                return;
            }
            if (this.state.getValue() == WebSocketConnectionState.CONNECTING) {
                Log.i((String)TAG, (String)(this.getName() + " Buffering keep alive to send after connection establishment"));
                CompletableFuture<? extends ChatConnection> completableFuture = this.chatConnectionFuture;
                Intrinsics.checkNotNull(completableFuture);
                CompletableFutureExtensionsKt.whenComplete(completableFuture, (Function1)new Function1(this){
                    final /* synthetic */ LibSignalChatConnection this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void invoke(ChatConnection it) {
                        Log.i((String)LibSignalChatConnection.access$getTAG$cp(), (String)(this.this$0.getName() + " Sending buffered keep alive"));
                        this.this$0.sendKeepAlive();
                    }
                }, (Function1<? super Throwable, Unit>)((Function1)LibSignalChatConnection::sendKeepAlive$lambda$22$lambda$19));
                return;
            }
            Log.i((String)TAG, (String)(this.getName() + " Sending keep alive..."));
            ChatConnection chatConnection = this.chatConnection;
            Intrinsics.checkNotNull((Object)chatConnection);
            CompletableFuture completableFuture = chatConnection.send(KEEP_ALIVE_REQUEST);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"send(...)");
            CompletableFuture completableFuture2 = CompletableFutureExtensionsKt.whenComplete(completableFuture, arg_0 -> LibSignalChatConnection.sendKeepAlive$lambda$22$lambda$20(this, arg_0), (Function1<? super Throwable, Unit>)((Function1)arg_0 -> LibSignalChatConnection.sendKeepAlive$lambda$22$lambda$21(this, arg_0)));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public Optional<WebSocketRequestMessage> readRequestIfAvailable() {
        WebSocketRequestMessage incomingMessage = this.incomingRequestQueue.poll();
        Optional<WebSocketRequestMessage> optional = Optional.ofNullable(incomingMessage);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public WebSocketRequestMessage readRequest(long timeoutMillis) {
        if (timeoutMillis <= 0L) {
            throw new TimeoutException("Invalid timeoutMillis");
        }
        long startTime = System.currentTimeMillis();
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl = false;
            if (this.isDead()) {
                throw new IOException("Connection closed!");
            }
            long remainingTimeoutMillis = timeoutMillis;
            while (LibSignalChatConnection.readRequest$lambda$23$couldGetRequest(this) && this.incomingRequestQueue.isEmpty()) {
                if (remainingTimeoutMillis <= 0L) {
                    throw new TimeoutException("Timeout exceeded after " + timeoutMillis + " ms");
                }
                try {
                    this.stateChangedOrMessageReceivedCondition.await(remainingTimeoutMillis, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                long elapsedTimeMillis = System.currentTimeMillis() - startTime;
                remainingTimeoutMillis = timeoutMillis - elapsedTimeMillis;
            }
            if (!this.incomingRequestQueue.isEmpty()) {
                WebSocketRequestMessage webSocketRequestMessage = this.incomingRequestQueue.poll();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)webSocketRequestMessage), (String)"poll(...)");
                WebSocketRequestMessage webSocketRequestMessage2 = webSocketRequestMessage;
                return webSocketRequestMessage2;
            }
            if (!LibSignalChatConnection.readRequest$lambda$23$couldGetRequest(this)) {
                throw new IOException("Connection closed!");
            }
            throw new TimeoutException("Incoming request queue was empty!");
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void sendResponse(@NotNull WebSocketResponseMessage response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)response), (String)"response");
        Integer n = response.status;
        int n2 = 200;
        if (n != null && n == n2 && StringsKt.equals$default((String)response.message, (String)"OK", (boolean)false, (int)2, null)) {
            ChatConnectionListener.ServerMessageAck serverMessageAck = (ChatConnectionListener.ServerMessageAck)((Map)this.ackSenderForInternalPseudoId).get(response.id);
            if (serverMessageAck != null) {
                serverMessageAck.send();
            } else {
                Log.w((String)TAG, (String)(this.getName() + " [sendResponse] Silently dropped response without available ackSend {id: " + response.id + "}"));
            }
            Map map = this.ackSenderForInternalPseudoId;
            Long l = response.id;
            TypeIntrinsics.asMutableMap((Object)map).remove(l);
            Log.d((String)TAG, (String)(this.getName() + " [sendResponse] sent ack [" + response.id + "]"));
        } else {
            Log.w((String)TAG, (String)(this.getName() + " [sendResponse] Silently dropped unsupported response {status: " + response.status + ", id: " + response.id + "}"));
            Map map = this.ackSenderForInternalPseudoId;
            Long l = response.id;
            TypeIntrinsics.asMutableMap((Object)map).remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> Object runWithChatConnection(@NotNull Function1<? super ChatConnection, ? extends T> callback, @NotNull Continuation<? super T> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super T> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        Lock lock = this.CHAT_SERVICE_LOCK;
        lock.lock();
        try {
            boolean bl3 = false;
            WebSocketConnectionState webSocketConnectionState = (WebSocketConnectionState)((Object)this.getState().getValue());
            switch (webSocketConnectionState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[webSocketConnectionState.ordinal()]) {
                case 7: {
                    try {
                        ChatConnection chatConnection = this.chatConnection;
                        Intrinsics.checkNotNull((Object)chatConnection);
                        Object result2 = callback.invoke((Object)chatConnection);
                        ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)result2));
                    }
                    catch (Exception e) {
                        ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
                    }
                    break;
                }
                case 1: {
                    PendingAction action2 = new PendingAction((Function1<? super ChatConnection, Unit>)((Function1)new Function1<ChatConnection, Unit>(this, callback, continuation){
                        final /* synthetic */ LibSignalChatConnection this$0;
                        final /* synthetic */ Function1<ChatConnection, T> $callback;
                        final /* synthetic */ CancellableContinuation<T> $continuation;
                        {
                            this.this$0 = $receiver;
                            this.$callback = $callback;
                            this.$continuation = $continuation;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke(ChatConnection connection) {
                            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                            Lock lock = LibSignalChatConnection.access$getCHAT_SERVICE_LOCK$p(this.this$0);
                            Function1<ChatConnection, T> function1 = this.$callback;
                            CancellableContinuation<T> cancellableContinuation = this.$continuation;
                            lock.lock();
                            try {
                                block5: {
                                    boolean bl = false;
                                    try {
                                        Object result2 = function1.invoke((Object)connection);
                                        Object object = CancellableContinuation.DefaultImpls.tryResume$default(cancellableContinuation, (Object)result2, null, (int)2, null);
                                        if (object == null) break block5;
                                        Object p0 = object;
                                        boolean bl2 = false;
                                        cancellableContinuation.completeResume(p0);
                                    }
                                    catch (Throwable e) {
                                        Object object = cancellableContinuation.tryResumeWithException(e);
                                        if (object == null) break block5;
                                        Object p0 = object;
                                        boolean bl3 = false;
                                        cancellableContinuation.completeResume(p0);
                                    }
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                    }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(continuation){
                        final /* synthetic */ CancellableContinuation<T> $continuation;
                        {
                            this.$continuation = $continuation;
                        }

                        public final void invoke(Throwable error) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                                Object object = this.$continuation.tryResumeWithException(error);
                                if (object == null) break block0;
                                Object object2 = object;
                                CancellableContinuation<T> cancellableContinuation = this.$continuation;
                                Object p0 = object2;
                                boolean bl = false;
                                cancellableContinuation.completeResume(p0);
                            }
                        }
                    }));
                    this.pendingCallbacks.add(action2);
                    continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(this, action2){
                        final /* synthetic */ LibSignalChatConnection this$0;
                        final /* synthetic */ PendingAction $action;
                        {
                            this.this$0 = $receiver;
                            this.$action = $action;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke(Throwable it) {
                            Lock lock = LibSignalChatConnection.access$getCHAT_SERVICE_LOCK$p(this.this$0);
                            LibSignalChatConnection libSignalChatConnection = this.this$0;
                            PendingAction pendingAction = this.$action;
                            lock.lock();
                            try {
                                boolean bl = false;
                                Function1 function1 = (Function1)new Function1<PendingAction, Boolean>(pendingAction){
                                    final /* synthetic */ PendingAction $action;
                                    {
                                        this.$action = $action;
                                    }

                                    public final Boolean invoke(PendingAction it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        return it == this.$action;
                                    }
                                };
                                LibSignalChatConnection.access$getPendingCallbacks$p(libSignalChatConnection).removeIf(new Predicate(function1){
                                    private final /* synthetic */ Function1 function;
                                    {
                                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                                        this.function = function;
                                    }

                                    public final /* synthetic */ boolean test(Object p0) {
                                        return (Boolean)this.function.invoke(p0);
                                    }
                                });
                                Unit unit = Unit.INSTANCE;
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                    });
                    break;
                }
                default: {
                    ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IOException("WebSocket is not connected (state: " + this.getState().getValue() + ")"))));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private static final Unit sendRequestInternal$lambda$3$lambda$1(LibSignalChatConnection this$0, SingleSubject $single, ChatConnection.Response response) {
        String string = this$0.getName();
        ChatConnection.Response response2 = response;
        Intrinsics.checkNotNull((Object)response2);
        Log.d((String)TAG, (String)(string + " [sendRequest] Success: " + response2.status()));
        int n = response.status();
        boolean bl = 400 <= n ? n < 600 : false;
        if (bl) {
            this$0.healthMonitor.onMessageError(response.status(), this$0.chatConnection instanceof AuthenticatedChatConnection);
        }
        $single.onSuccess((Object)LibSignalResponseExtensionKt.toWebsocketResponse(response, this$0.chatConnection instanceof UnauthenticatedChatConnection));
        return Unit.INSTANCE;
    }

    private static final Unit sendRequestInternal$lambda$3$lambda$2(LibSignalChatConnection this$0, SingleSubject $single, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Log.w((String)TAG, (String)(this$0.getName() + " [sendRequest] Failure:"), (Throwable)throwable);
        IOException downstreamThrowable = throwable instanceof ConnectionInvalidatedException ? (IOException)new NonSuccessfulResponseCodeException(4401) : (IOException)new SocketException("Failed to get response for request");
        $single.onError((Throwable)downstreamThrowable);
        return Unit.INSTANCE;
    }

    private static final Unit connect$lambda$5$lambda$4(LibSignalChatConnection this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this$0.handleConnectionFailure(throwable);
        return Unit.INSTANCE;
    }

    private static final Unit disconnect$lambda$15$lambda$13(Void it) {
        return Unit.INSTANCE;
    }

    private static final Unit disconnect$lambda$15$lambda$14(LibSignalChatConnection this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Log.w((String)TAG, (String)(this$0.getName() + " Disconnect failed"), (Throwable)throwable);
        this$0.state.onNext((Object)WebSocketConnectionState.DISCONNECTED);
        return Unit.INSTANCE;
    }

    private static final Unit sendRequest$lambda$18$lambda$16(LibSignalChatConnection this$0, WebSocketRequestMessage $request, long $timeoutSeconds, SingleSubject $single, ChatConnection chatConnection) {
        Intrinsics.checkNotNullParameter((Object)chatConnection, (String)"<unused var>");
        this$0.sendRequestInternal($request, $timeoutSeconds, (SingleSubject<WebsocketResponse>)$single);
        return Unit.INSTANCE;
    }

    private static final Unit sendRequest$lambda$18$lambda$17(SingleSubject $single, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        $single.onError(error);
        return Unit.INSTANCE;
    }

    private static final Unit sendKeepAlive$lambda$22$lambda$19(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit sendKeepAlive$lambda$22$lambda$20(LibSignalChatConnection this$0, ChatConnection.Response response) {
        Log.d((String)TAG, (String)(this$0.getName() + " [sendKeepAlive] Success"));
        ChatConnection.Response response2 = response;
        Intrinsics.checkNotNull((Object)response2);
        int n = response2.status();
        boolean bl = 200 <= n ? n < 300 : false;
        if (bl) {
            this$0.healthMonitor.onKeepAliveResponse(Instant.now().toEpochMilli(), this$0.chatConnection instanceof AuthenticatedChatConnection);
        } else {
            boolean bl2 = 400 <= n ? n < 600 : false;
            if (bl2) {
                this$0.healthMonitor.onMessageError(response.status(), this$0.chatConnection instanceof AuthenticatedChatConnection);
            } else {
                Log.w((String)TAG, (String)(this$0.getName() + " [sendKeepAlive] Unsupported keep alive response status: " + response.status()));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendKeepAlive$lambda$22$lambda$21(LibSignalChatConnection this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Log.w((String)TAG, (String)(this$0.getName() + " [sendKeepAlive] Failure:"), (Throwable)throwable);
        this$0.state.onNext((Object)WebSocketConnectionState.DISCONNECTED);
        return Unit.INSTANCE;
    }

    private static final boolean readRequest$lambda$23$couldGetRequest(LibSignalChatConnection this$0) {
        return this$0.state.getValue() == WebSocketConnectionState.CONNECTED || this$0.state.getValue() == WebSocketConnectionState.CONNECTING;
    }

    public static final /* synthetic */ void access$handleConnectionSuccess(LibSignalChatConnection $this, ChatConnection connection) {
        $this.handleConnectionSuccess(connection);
    }

    public static final /* synthetic */ void access$cleanup(LibSignalChatConnection $this) {
        $this.cleanup();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\r\u001a\u00020\f*\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$Companion;", "", "<init>", "()V", "SERVICE_ENVELOPE_REQUEST_VERB", "", "SERVICE_ENVELOPE_REQUEST_PATH", "SOCKET_EMPTY_REQUEST_VERB", "SOCKET_EMPTY_REQUEST_PATH", "SIGNAL_SERVICE_ENVELOPE_TIMESTAMP_HEADER_KEY", "TAG", "KEEP_ALIVE_REQUEST", "Lorg/signal/libsignal/net/ChatConnection$Request;", "toLibSignalRequest", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "timeout", "Lkotlin/time/Duration;", "toLibSignalRequest-HG0u8IE", "(Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;J)Lorg/signal/libsignal/net/ChatConnection$Request;", "signal-service-java"})
    @SourceDebugExtension(value={"SMAP\nLibSignalChatConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibSignalChatConnection.kt\norg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,673:1\n1193#2,2:674\n1267#2,4:676\n*S KotlinDebug\n*F\n+ 1 LibSignalChatConnection.kt\norg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$Companion\n*L\n129#1:674,2\n129#1:676,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final ChatConnection.Request toLibSignalRequest-HG0u8IE(WebSocketRequestMessage $this$toLibSignalRequest_u2dHG0u8IE, long timeout) {
            Object object;
            Map map;
            String string;
            String string2;
            block12: {
                block11: {
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    String string3;
                    String string4;
                    block10: {
                        block9: {
                            string4 = $this$toLibSignalRequest_u2dHG0u8IE.verb;
                            if (string4 == null) break block9;
                            String string5 = string4.toUpperCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                            string4 = string5;
                            if (string5 != null) break block10;
                        }
                        string4 = "GET";
                    }
                    if ((string3 = $this$toLibSignalRequest_u2dHG0u8IE.path) == null) {
                        string3 = "";
                    }
                    Iterable iterable = $this$toLibSignalRequest_u2dHG0u8IE.headers;
                    string2 = string3;
                    string = string4;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    void var7_8 = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map2 = destination$iv$iv;
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        char[] cArray = new char[]{':'};
                        List parts = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)2, (int)2, null);
                        if (parts.size() != 2) {
                            throw new IllegalArgumentException("Headers must contain at least one colon");
                        }
                        Pair pair = TuplesKt.to(parts.get(0), parts.get(1));
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                    map = destination$iv$iv;
                    object = $this$toLibSignalRequest_u2dHG0u8IE.body;
                    if (object == null) break block11;
                    byte[] byArray = object.toByteArray();
                    object = byArray;
                    if (byArray != null) break block12;
                }
                object = new byte[0];
            }
            int n = (int)Duration.getInWholeMilliseconds-impl((long)timeout);
            Object object2 = object;
            Map map3 = map;
            String string6 = string2;
            String string7 = string;
            return new ChatConnection.Request(string7, string6, map3, (byte[])object2, n);
        }

        static /* synthetic */ ChatConnection.Request toLibSignalRequest-HG0u8IE$default(Companion companion, WebSocketRequestMessage webSocketRequestMessage, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = WebSocketConnection.Companion.getDEFAULT_SEND_TIMEOUT-UwyO8pc();
            }
            return companion.toLibSignalRequest-HG0u8IE(webSocketRequestMessage, l);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J%\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$LibSignalChatListener;", "Lorg/signal/libsignal/net/ChatConnectionListener;", "<init>", "(Lorg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/ExecutorService;", "onIncomingMessage", "", "chat", "Lorg/signal/libsignal/net/ChatConnection;", "envelope", "", "serverDeliveryTimestamp", "", "sendAck", "Lorg/signal/libsignal/net/ChatConnectionListener$ServerMessageAck;", "onConnectionInterrupted", "disconnectReason", "Lorg/signal/libsignal/net/ChatServiceException;", "onQueueEmpty", "onReceivedAlerts", "alerts", "", "", "(Lorg/signal/libsignal/net/ChatConnection;[Ljava/lang/String;)V", "signal-service-java"})
    private final class LibSignalChatListener
    implements ChatConnectionListener {
        private final ExecutorService executor = Executors.newSingleThreadExecutor();

        public void onIncomingMessage(@NotNull ChatConnection chat, @NotNull byte[] envelope, long serverDeliveryTimestamp, @Nullable ChatConnectionListener.ServerMessageAck sendAck) {
            Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
            Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
            long internalPseudoId = LibSignalChatConnection.this.nextIncomingMessageInternalPseudoId.getAndIncrement();
            WebSocketRequestMessage incomingWebSocketRequest = new WebSocketRequestMessage("PUT", LibSignalChatConnection.SERVICE_ENVELOPE_REQUEST_PATH, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])envelope, (int)0, (int)0, (int)3, null), CollectionsKt.listOf((Object)("X-Signal-Timestamp: " + serverDeliveryTimestamp)), internalPseudoId, null, 32, null);
            if (sendAck != null) {
                Long l = internalPseudoId;
                ((Map)LibSignalChatConnection.this.getAckSenderForInternalPseudoId()).put(l, sendAck);
            }
            LibSignalChatConnection.this.incomingRequestQueue.put(incomingWebSocketRequest);
            this.executor.submit(() -> LibSignalChatListener.onIncomingMessage$lambda$1(LibSignalChatConnection.this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectionInterrupted(@NotNull ChatConnection chat, @Nullable ChatServiceException disconnectReason) {
            Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
            Lock lock = LibSignalChatConnection.this.CHAT_SERVICE_LOCK;
            LibSignalChatConnection libSignalChatConnection = LibSignalChatConnection.this;
            lock.lock();
            try {
                boolean bl = false;
                if (disconnectReason == null) {
                    Log.i((String)TAG, (String)(libSignalChatConnection.getName() + " disconnected"));
                } else {
                    Log.i((String)TAG, (String)(libSignalChatConnection.getName() + " connection unexpectedly closed"), (Throwable)((Throwable)disconnectReason));
                }
                libSignalChatConnection.chatConnection = null;
                libSignalChatConnection.getState().onNext((Object)WebSocketConnectionState.DISCONNECTED);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        public void onQueueEmpty(@NotNull ChatConnection chat) {
            Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
            Log.i((String)TAG, (String)(LibSignalChatConnection.this.getName() + " queue empty"));
            long internalPseudoId = LibSignalChatConnection.this.nextIncomingMessageInternalPseudoId.getAndIncrement();
            WebSocketRequestMessage queueEmptyRequest = new WebSocketRequestMessage("PUT", LibSignalChatConnection.SOCKET_EMPTY_REQUEST_PATH, ByteString.EMPTY, CollectionsKt.emptyList(), internalPseudoId, null, 32, null);
            LibSignalChatConnection.this.incomingRequestQueue.put(queueEmptyRequest);
            this.executor.submit(() -> LibSignalChatListener.onQueueEmpty$lambda$4(LibSignalChatConnection.this));
        }

        public void onReceivedAlerts(@NotNull ChatConnection chat, @NotNull String[] alerts) {
            Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
            Intrinsics.checkNotNullParameter((Object)alerts, (String)"alerts");
            if (!(alerts.length == 0)) {
                Log.i((String)TAG, (String)(LibSignalChatConnection.this.getName() + " Received " + alerts.length + " alerts from the server"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void onIncomingMessage$lambda$1(LibSignalChatConnection this$0) {
            Lock lock = this$0.CHAT_SERVICE_LOCK;
            lock.lock();
            try {
                boolean bl = false;
                this$0.stateChangedOrMessageReceivedCondition.signalAll();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void onQueueEmpty$lambda$4(LibSignalChatConnection this$0) {
            Lock lock = this$0.CHAT_SERVICE_LOCK;
            lock.lock();
            try {
                boolean bl = false;
                this$0.stateChangedOrMessageReceivedCondition.signalAll();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J5\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/whispersystems/signalservice/internal/websocket/LibSignalChatConnection$PendingAction;", "", "onConnectionSuccess", "Lkotlin/Function1;", "Lorg/signal/libsignal/net/ChatConnection;", "", "onFailure", "", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getOnConnectionSuccess", "()Lkotlin/jvm/functions/Function1;", "getOnFailure", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "signal-service-java"})
    private static final class PendingAction {
        @NotNull
        private final Function1<ChatConnection, Unit> onConnectionSuccess;
        @NotNull
        private final Function1<Throwable, Unit> onFailure;

        public PendingAction(@NotNull Function1<? super ChatConnection, Unit> onConnectionSuccess, @NotNull Function1<? super Throwable, Unit> onFailure2) {
            Intrinsics.checkNotNullParameter(onConnectionSuccess, (String)"onConnectionSuccess");
            Intrinsics.checkNotNullParameter(onFailure2, (String)"onFailure");
            this.onConnectionSuccess = onConnectionSuccess;
            this.onFailure = onFailure2;
        }

        @NotNull
        public final Function1<ChatConnection, Unit> getOnConnectionSuccess() {
            return this.onConnectionSuccess;
        }

        @NotNull
        public final Function1<Throwable, Unit> getOnFailure() {
            return this.onFailure;
        }

        @NotNull
        public final Function1<ChatConnection, Unit> component1() {
            return this.onConnectionSuccess;
        }

        @NotNull
        public final Function1<Throwable, Unit> component2() {
            return this.onFailure;
        }

        @NotNull
        public final PendingAction copy(@NotNull Function1<? super ChatConnection, Unit> onConnectionSuccess, @NotNull Function1<? super Throwable, Unit> onFailure2) {
            Intrinsics.checkNotNullParameter(onConnectionSuccess, (String)"onConnectionSuccess");
            Intrinsics.checkNotNullParameter(onFailure2, (String)"onFailure");
            return new PendingAction(onConnectionSuccess, onFailure2);
        }

        public static /* synthetic */ PendingAction copy$default(PendingAction pendingAction, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = pendingAction.onConnectionSuccess;
            }
            if ((n & 2) != 0) {
                function12 = pendingAction.onFailure;
            }
            return pendingAction.copy(function1, function12);
        }

        @NotNull
        public String toString() {
            return "PendingAction(onConnectionSuccess=" + this.onConnectionSuccess + ", onFailure=" + this.onFailure + ")";
        }

        public int hashCode() {
            int result2 = this.onConnectionSuccess.hashCode();
            result2 = result2 * 31 + this.onFailure.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PendingAction)) {
                return false;
            }
            PendingAction pendingAction = (PendingAction)other;
            if (!Intrinsics.areEqual(this.onConnectionSuccess, pendingAction.onConnectionSuccess)) {
                return false;
            }
            return Intrinsics.areEqual(this.onFailure, pendingAction.onFailure);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WebSocketConnectionState.values().length];
            try {
                nArray[WebSocketConnectionState.CONNECTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSocketConnectionState.DISCONNECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSocketConnectionState.DISCONNECTING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSocketConnectionState.FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSocketConnectionState.AUTHENTICATION_FAILED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSocketConnectionState.REMOTE_DEPRECATED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSocketConnectionState.CONNECTED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

