/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.serialize;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.core.models.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.serialize.protos.AddressProto;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007\u00a8\u0006\n"}, d2={"Lorg/whispersystems/signalservice/internal/serialize/SignalServiceAddressProtobufSerializer;", "", "<init>", "()V", "toProtobuf", "Lorg/whispersystems/signalservice/internal/serialize/protos/AddressProto;", "signalServiceAddress", "Lorg/whispersystems/signalservice/api/push/SignalServiceAddress;", "fromProtobuf", "addressProto", "signal-service-java"})
public final class SignalServiceAddressProtobufSerializer {
    @NotNull
    public static final SignalServiceAddressProtobufSerializer INSTANCE = new SignalServiceAddressProtobufSerializer();

    private SignalServiceAddressProtobufSerializer() {
    }

    @JvmStatic
    @NotNull
    public static final AddressProto toProtobuf(@NotNull SignalServiceAddress signalServiceAddress) {
        Intrinsics.checkNotNullParameter((Object)signalServiceAddress, (String)"signalServiceAddress");
        AddressProto.Builder builder = new AddressProto.Builder();
        builder.uuid(signalServiceAddress.getServiceId().toByteString());
        if (signalServiceAddress.getNumber().isPresent()) {
            builder.e164(signalServiceAddress.getNumber().get());
        }
        return builder.build();
    }

    @JvmStatic
    @NotNull
    public static final SignalServiceAddress fromProtobuf(@NotNull AddressProto addressProto) {
        Intrinsics.checkNotNullParameter((Object)((Object)addressProto), (String)"addressProto");
        if (addressProto.uuid == null) {
            throw new IllegalArgumentException("Missing ServiceId!");
        }
        ServiceId serviceId = ServiceId.Companion.parseOrThrow(addressProto.uuid.toByteArray());
        Optional<String> optional = Optional.ofNullable(addressProto.e164);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        Optional<String> number = optional;
        return new SignalServiceAddress(serviceId, number);
    }
}

