/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.push;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.wire.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Pair;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http2.StreamResetException;
import org.signal.core.util.Base64;
import org.signal.core.util.Hex;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.storageservice.storage.protos.groups.AvatarUploadAttributes;
import org.signal.storageservice.storage.protos.groups.ExternalGroupCredential;
import org.signal.storageservice.storage.protos.groups.Group;
import org.signal.storageservice.storage.protos.groups.GroupChange;
import org.signal.storageservice.storage.protos.groups.GroupChangeResponse;
import org.signal.storageservice.storage.protos.groups.GroupChanges;
import org.signal.storageservice.storage.protos.groups.GroupJoinInfo;
import org.signal.storageservice.storage.protos.groups.GroupResponse;
import org.signal.storageservice.storage.protos.groups.Member;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.account.AccountAttributes;
import org.whispersystems.signalservice.api.account.PreKeyCollection;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherStreamUtil;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2AuthorizationString;
import org.whispersystems.signalservice.api.messages.AttachmentTransferProgress;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentRemoteId;
import org.whispersystems.signalservice.api.messages.calls.CallingResponse;
import org.whispersystems.signalservice.api.messages.multidevice.RegisterAsSecondaryDeviceResponse;
import org.whispersystems.signalservice.api.push.SignedPreKeyEntity;
import org.whispersystems.signalservice.api.push.exceptions.AlreadyVerifiedException;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.ChallengeRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.ConflictException;
import org.whispersystems.signalservice.api.push.exceptions.ContactManifestMismatchException;
import org.whispersystems.signalservice.api.push.exceptions.DeprecatedVersionException;
import org.whispersystems.signalservice.api.push.exceptions.ExpectationFailedException;
import org.whispersystems.signalservice.api.push.exceptions.ExternalServiceFailureException;
import org.whispersystems.signalservice.api.push.exceptions.HttpConflictException;
import org.whispersystems.signalservice.api.push.exceptions.IncorrectRegistrationRecoveryPasswordException;
import org.whispersystems.signalservice.api.push.exceptions.InvalidRegistrationSessionIdException;
import org.whispersystems.signalservice.api.push.exceptions.InvalidTransportModeException;
import org.whispersystems.signalservice.api.push.exceptions.MalformedRequestException;
import org.whispersystems.signalservice.api.push.exceptions.MalformedResponseException;
import org.whispersystems.signalservice.api.push.exceptions.MissingConfigurationException;
import org.whispersystems.signalservice.api.push.exceptions.MustRequestNewCodeException;
import org.whispersystems.signalservice.api.push.exceptions.NoContentException;
import org.whispersystems.signalservice.api.push.exceptions.NoSuchSessionException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResumableUploadResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.NotFoundException;
import org.whispersystems.signalservice.api.push.exceptions.ProofRequiredException;
import org.whispersystems.signalservice.api.push.exceptions.PushNetworkException;
import org.whispersystems.signalservice.api.push.exceptions.RangeException;
import org.whispersystems.signalservice.api.push.exceptions.RateLimitException;
import org.whispersystems.signalservice.api.push.exceptions.RequestVerificationCodeRateLimitException;
import org.whispersystems.signalservice.api.push.exceptions.ResumeLocationInvalidException;
import org.whispersystems.signalservice.api.push.exceptions.ServerRejectedException;
import org.whispersystems.signalservice.api.push.exceptions.SubmitVerificationCodeRateLimitException;
import org.whispersystems.signalservice.api.push.exceptions.TokenNotAcceptedException;
import org.whispersystems.signalservice.api.push.exceptions.UnregisteredUserException;
import org.whispersystems.signalservice.api.registration.RestoreMethodBody;
import org.whispersystems.signalservice.api.remoteconfig.RemoteConfigResponse;
import org.whispersystems.signalservice.api.svr.Svr3Credentials;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.util.Tls12SocketFactory;
import org.whispersystems.signalservice.api.util.TlsProxySocketFactory;
import org.whispersystems.signalservice.internal.configuration.SignalCdnUrl;
import org.whispersystems.signalservice.internal.configuration.SignalProxy;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.configuration.SignalUrl;
import org.whispersystems.signalservice.internal.crypto.AttachmentDigest;
import org.whispersystems.signalservice.internal.push.AttachmentUploadForm;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.BackupAuthCheckRequest;
import org.whispersystems.signalservice.internal.push.BackupV2AuthCheckResponse;
import org.whispersystems.signalservice.internal.push.BackupV3AuthCheckResponse;
import org.whispersystems.signalservice.internal.push.ContentRange;
import org.whispersystems.signalservice.internal.push.DeviceId;
import org.whispersystems.signalservice.internal.push.DeviceLimit;
import org.whispersystems.signalservice.internal.push.DeviceLimitExceededException;
import org.whispersystems.signalservice.internal.push.GcmRegistrationId;
import org.whispersystems.signalservice.internal.push.GroupPatchResponse;
import org.whispersystems.signalservice.internal.push.KyberPreKeyEntity;
import org.whispersystems.signalservice.internal.push.LinkDeviceRequest;
import org.whispersystems.signalservice.internal.push.LockedException;
import org.whispersystems.signalservice.internal.push.MismatchedDevices;
import org.whispersystems.signalservice.internal.push.NowhereBufferedSink;
import org.whispersystems.signalservice.internal.push.OutgoingPushMessageList;
import org.whispersystems.signalservice.internal.push.ProfileAvatarData;
import org.whispersystems.signalservice.internal.push.ProfileAvatarUploadAttributes;
import org.whispersystems.signalservice.internal.push.ProofRequiredResponse;
import org.whispersystems.signalservice.internal.push.PushAttachmentData;
import org.whispersystems.signalservice.internal.push.RegisterAsSecondaryDeviceRequest;
import org.whispersystems.signalservice.internal.push.RegistrationSessionMetadataJson;
import org.whispersystems.signalservice.internal.push.RegistrationSessionMetadataResponse;
import org.whispersystems.signalservice.internal.push.RegistrationSessionRequestBody;
import org.whispersystems.signalservice.internal.push.SendGroupMessageResponse;
import org.whispersystems.signalservice.internal.push.SendMessageResponse;
import org.whispersystems.signalservice.internal.push.StaleDevices;
import org.whispersystems.signalservice.internal.push.StickerUploadAttributes;
import org.whispersystems.signalservice.internal.push.StickerUploadAttributesResponse;
import org.whispersystems.signalservice.internal.push.UpdateVerificationSessionRequestBody;
import org.whispersystems.signalservice.internal.push.VerificationCodeFailureResponseBody;
import org.whispersystems.signalservice.internal.push.VerificationSessionMetadataRequestBody;
import org.whispersystems.signalservice.internal.push.VerifyAccountResponse;
import org.whispersystems.signalservice.internal.push.exceptions.ForbiddenException;
import org.whispersystems.signalservice.internal.push.exceptions.GroupExistsException;
import org.whispersystems.signalservice.internal.push.exceptions.GroupNotFoundException;
import org.whispersystems.signalservice.internal.push.exceptions.GroupPatchNotAcceptedException;
import org.whispersystems.signalservice.internal.push.exceptions.MismatchedDevicesException;
import org.whispersystems.signalservice.internal.push.exceptions.MissingCapabilitiesException;
import org.whispersystems.signalservice.internal.push.exceptions.NotInGroupException;
import org.whispersystems.signalservice.internal.push.exceptions.StaleDevicesException;
import org.whispersystems.signalservice.internal.push.http.CancelationSignal;
import org.whispersystems.signalservice.internal.push.http.DigestingRequestBody;
import org.whispersystems.signalservice.internal.push.http.NoCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.OutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;
import org.whispersystems.signalservice.internal.push.http.StickerCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.storage.protos.ReadOperation;
import org.whispersystems.signalservice.internal.storage.protos.StorageItems;
import org.whispersystems.signalservice.internal.storage.protos.StorageManifest;
import org.whispersystems.signalservice.internal.storage.protos.WriteOperation;
import org.whispersystems.signalservice.internal.util.BlacklistingTrustManager;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.util.Util;

public class PushServiceSocket
implements Closeable {
    private static final String TAG = PushServiceSocket.class.getSimpleName();
    private static final String SET_RESTORE_METHOD_PATH = "/v1/devices/restore_account/%s";
    private static final String DEVICE_LINK_PATH = "/v1/devices/link";
    private static final String GROUP_MESSAGE_PATH = "/v1/messages/multi_recipient?ts=%s&online=%s&urgent=%s&story=%s";
    private static final String STICKER_UPLOAD_PATH = "/v1/sticker/pack/form/%d";
    private static final String ATTACHMENT_KEY_DOWNLOAD_PATH = "attachments/%s";
    private static final String ATTACHMENT_ID_DOWNLOAD_PATH = "attachments/%d";
    private static final String AVATAR_UPLOAD_PATH = "";
    private static final String STICKER_MANIFEST_PATH = "stickers/%s/manifest.proto";
    private static final String STICKER_PATH = "stickers/%s/full/%d";
    private static final String GROUPSV2_GROUP = "/v2/groups/";
    private static final String GROUPSV2_GROUP_PASSWORD = "/v2/groups/?inviteLinkPassword=%s";
    private static final String GROUPSV2_GROUP_CHANGES = "/v2/groups/logs/%s?maxSupportedChangeEpoch=%d&includeFirstState=%s&includeLastState=false";
    private static final String GROUPSV2_AVATAR_REQUEST = "/v2/groups/avatar/form";
    private static final String GROUPSV2_GROUP_JOIN = "/v2/groups/join/%s";
    private static final String GROUPSV2_TOKEN = "/v2/groups/token";
    private static final String GROUPSV2_JOINED_AT = "/v2/groups/joined_at_version";
    private static final String VERIFICATION_SESSION_PATH = "/v1/verification/session";
    private static final String VERIFICATION_CODE_PATH = "/v1/verification/session/%s/code";
    private static final String REMOTE_CONFIG = "/v2/config";
    private static final String REGISTRATION_PATH = "/v1/registration";
    private static final String BACKUP_AUTH_CHECK_V2 = "/v2/svr/auth/check";
    private static final String BACKUP_AUTH_CHECK_V3 = "/v3/backup/auth/check";
    private static final String ARCHIVE_MEDIA_DOWNLOAD_PATH = "backups/%s/%s";
    private static final Map<String, String> NO_HEADERS = Collections.emptyMap();
    private static final ResponseCodeHandler NO_HANDLER = new EmptyResponseCodeHandler();
    private static final ResponseCodeHandler UNOPINIONATED_HANDLER = new UnopinionatedResponseCodeHandler();
    private static final ResponseCodeHandler UNOPINIONATED_BINARY_ERROR_HANDLER = new UnopinionatedBinaryErrorResponseCodeHandler();
    public static final long CDN2_RESUMABLE_LINK_LIFETIME_MILLIS = TimeUnit.DAYS.toMillis(7L);
    private static final int MAX_FOLLOW_UPS = 20;
    private long soTimeoutMillis = TimeUnit.SECONDS.toMillis(30L);
    private final Set<Call> connections = new HashSet<Call>();
    private final ServiceConnectionHolder[] serviceClients;
    private final Map<Integer, ConnectionHolder[]> cdnClientsMap;
    private final ConnectionHolder[] storageClients;
    private final SignalServiceConfiguration configuration;
    private final CredentialsProvider credentialsProvider;
    private final String signalAgent;
    private final SecureRandom random;
    private final boolean automaticNetworkRetry;
    private static final ResponseCodeHandler NEW_DEVICE_PUT_RESPONSE_HANDLER = (responseCode, body, header) -> {
        if (responseCode == 409) {
            throw new MissingCapabilitiesException();
        }
    };
    private static final ResponseCodeHandler GROUPS_V2_PUT_RESPONSE_HANDLER = (responseCode, body, getHeader) -> {
        if (getHeader.apply("X-Signal-Timestamp") == null) {
            throw new NonSuccessfulResponseCodeException(500, "Missing timestamp header");
        }
        if (responseCode == 409) {
            throw new GroupExistsException();
        }
    };
    private static final ResponseCodeHandler GROUPS_V2_GET_CURRENT_HANDLER = (responseCode, body, getHeader) -> {
        if (getHeader.apply("X-Signal-Timestamp") == null) {
            throw new NonSuccessfulResponseCodeException(500, "Missing timestamp header");
        }
        switch (responseCode) {
            case 403: {
                throw new NotInGroupException();
            }
            case 404: {
                throw new GroupNotFoundException();
            }
        }
    };
    private static final ResponseCodeHandler GROUPS_V2_PATCH_RESPONSE_HANDLER = (responseCode, body, getHeader) -> {
        if (getHeader.apply("X-Signal-Timestamp") == null) {
            throw new NonSuccessfulResponseCodeException(500, "Missing timestamp header");
        }
        if (responseCode == 400) {
            String message = null;
            try {
                message = JsonUtil.fromJson(body.string(), GroupPatchResponse.class).getMessage();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Unable to parse group patch error", (Throwable)e);
            }
            throw message != null ? new GroupPatchNotAcceptedException(message) : new GroupPatchNotAcceptedException();
        }
    };
    private static final ResponseCodeHandler GROUPS_V2_GET_JOIN_INFO_HANDLER = (responseCode, body, getHeader) -> {
        if (getHeader.apply("X-Signal-Timestamp") == null) {
            throw new NonSuccessfulResponseCodeException(500, "Missing timestamp header");
        }
        if (responseCode == 403) {
            throw new ForbiddenException(Optional.ofNullable((String)getHeader.apply("X-Signal-Forbidden-Reason")));
        }
    };

    public PushServiceSocket(SignalServiceConfiguration configuration, CredentialsProvider credentialsProvider, String signalAgent, boolean automaticNetworkRetry) {
        this.configuration = configuration;
        this.credentialsProvider = credentialsProvider;
        this.signalAgent = signalAgent;
        this.automaticNetworkRetry = automaticNetworkRetry;
        this.serviceClients = this.createServiceConnectionHolders(configuration.getSignalServiceUrls(), configuration.getNetworkInterceptors(), configuration.getDns(), configuration.getSignalProxy());
        this.cdnClientsMap = PushServiceSocket.createCdnClientsMap(configuration.getSignalCdnUrlMap(), configuration.getNetworkInterceptors(), configuration.getDns(), configuration.getSignalProxy());
        this.storageClients = PushServiceSocket.createConnectionHolders(configuration.getSignalStorageUrls(), configuration.getNetworkInterceptors(), configuration.getDns(), configuration.getSignalProxy());
        this.random = new SecureRandom();
    }

    public SignalServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public int finishNewDeviceRegistration(String provisioningCode, AccountAttributes accountAttributes, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys) throws IOException {
        LinkDeviceRequest linkDeviceRequest;
        try {
            SignedPreKeyEntity aciSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(aciPreKeys.getSignedPreKey()).getId(), aciPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), aciPreKeys.getSignedPreKey().getSignature());
            SignedPreKeyEntity pniSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(pniPreKeys.getSignedPreKey()).getId(), pniPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), pniPreKeys.getSignedPreKey().getSignature());
            KyberPreKeyEntity aciLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(aciPreKeys.getLastResortKyberPreKey()).getId(), aciPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), aciPreKeys.getLastResortKyberPreKey().getSignature());
            KyberPreKeyEntity pniLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(pniPreKeys.getLastResortKyberPreKey()).getId(), pniPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), pniPreKeys.getLastResortKyberPreKey().getSignature());
            linkDeviceRequest = new LinkDeviceRequest(provisioningCode, accountAttributes, aciSignedPreKey, pniSignedPreKey, aciLastResortKyberPreKey, pniLastResortKyberPreKey);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError("unexpected invalid key", e);
        }
        String json = JsonUtil.toJson(linkDeviceRequest);
        String responseText = this.makeServiceRequest(DEVICE_LINK_PATH, "PUT", json, NO_HEADERS, NEW_DEVICE_PUT_RESPONSE_HANDLER, null);
        DeviceId response = JsonUtil.fromJson(responseText, DeviceId.class);
        return response.getDeviceId();
    }

    public RegistrationSessionMetadataResponse createVerificationSession(@Nullable String pushToken, @Nullable String mcc, @Nullable String mnc) throws IOException {
        String jsonBody = JsonUtil.toJson(new VerificationSessionMetadataRequestBody(this.credentialsProvider.getE164(), pushToken, mcc, mnc));
        try (Response response = this.makeServiceRequest(VERIFICATION_SESSION_PATH, "POST", PushServiceSocket.jsonRequestBody(jsonBody), NO_HEADERS, new RegistrationSessionResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public RegistrationSessionMetadataResponse getSessionStatus(String sessionId) throws IOException {
        String path = "/v1/verification/session/" + sessionId;
        try (Response response = this.makeServiceRequest(path, "GET", PushServiceSocket.jsonRequestBody(null), NO_HEADERS, new RegistrationSessionResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public RegistrationSessionMetadataResponse patchVerificationSession(String sessionId, @Nullable String pushToken, @Nullable String mcc, @Nullable String mnc, @Nullable String captchaToken, @Nullable String pushChallengeToken) throws IOException {
        String path = "/v1/verification/session/" + sessionId;
        UpdateVerificationSessionRequestBody requestBody = new UpdateVerificationSessionRequestBody(captchaToken, pushToken, pushChallengeToken, mcc, mnc);
        try (Response response = this.makeServiceRequest(path, "PATCH", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(requestBody)), NO_HEADERS, new PatchRegistrationSessionResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public RegistrationSessionMetadataResponse requestVerificationCode(String sessionId, Locale locale, boolean androidSmsRetriever, VerificationCodeTransport transport) throws IOException {
        String path = String.format(VERIFICATION_CODE_PATH, sessionId);
        Map<String, String> headers = locale != null ? Collections.singletonMap("Accept-Language", locale.getLanguage() + "-" + locale.getCountry()) : NO_HEADERS;
        HashMap<String, String> body = new HashMap<String, String>();
        switch (transport.ordinal()) {
            case 0: {
                body.put("transport", "sms");
                break;
            }
            case 1: {
                body.put("transport", "voice");
            }
        }
        body.put("client", androidSmsRetriever ? "android-2021-03" : "android");
        try (Response response = this.makeServiceRequest(path, "POST", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(body)), headers, new RequestVerificationCodeResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public RegistrationSessionMetadataResponse submitVerificationCode(String sessionId, String verificationCode) throws IOException {
        String path = String.format(VERIFICATION_CODE_PATH, sessionId);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("code", verificationCode);
        try (Response response = this.makeServiceRequest(path, "PUT", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(body)), NO_HEADERS, new SubmitVerificationCodeResponseHandler(), SealedSenderAccess.NONE, false);){
            RegistrationSessionMetadataResponse registrationSessionMetadataResponse = PushServiceSocket.parseSessionMetadataResponse(response);
            return registrationSessionMetadataResponse;
        }
    }

    public VerifyAccountResponse submitRegistrationRequest(@Nullable String sessionId, @Nullable String recoveryPassword, AccountAttributes attributes, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys, @Nullable String fcmToken, boolean skipDeviceTransfer) throws IOException {
        RegistrationSessionRequestBody body;
        String path = REGISTRATION_PATH;
        if (sessionId == null && recoveryPassword == null) {
            throw new IllegalArgumentException("Neither Session ID nor Recovery Password provided.");
        }
        if (sessionId != null && recoveryPassword != null) {
            throw new IllegalArgumentException("You must supply one and only one of either: Session ID, or Recovery Password.");
        }
        GcmRegistrationId gcmRegistrationId = attributes.getFetchesMessages() ? null : new GcmRegistrationId(fcmToken, true);
        try {
            SignedPreKeyEntity aciSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(aciPreKeys.getSignedPreKey()).getId(), aciPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), aciPreKeys.getSignedPreKey().getSignature());
            SignedPreKeyEntity pniSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(pniPreKeys.getSignedPreKey()).getId(), pniPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), pniPreKeys.getSignedPreKey().getSignature());
            KyberPreKeyEntity aciLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(aciPreKeys.getLastResortKyberPreKey()).getId(), aciPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), aciPreKeys.getLastResortKyberPreKey().getSignature());
            KyberPreKeyEntity pniLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(pniPreKeys.getLastResortKyberPreKey()).getId(), pniPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), pniPreKeys.getLastResortKyberPreKey().getSignature());
            body = new RegistrationSessionRequestBody(sessionId, recoveryPassword, attributes, Base64.encodeWithoutPadding((byte[])aciPreKeys.getIdentityKey().serialize()), Base64.encodeWithoutPadding((byte[])pniPreKeys.getIdentityKey().serialize()), aciSignedPreKey, pniSignedPreKey, aciLastResortKyberPreKey, pniLastResortKyberPreKey, gcmRegistrationId, skipDeviceTransfer, true);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError("unexpected invalid key", e);
        }
        String response = this.makeServiceRequest(path, "POST", JsonUtil.toJson(body), NO_HEADERS, new RegistrationSessionResponseHandler(), SealedSenderAccess.NONE);
        return JsonUtil.fromJson(response, VerifyAccountResponse.class);
    }

    public Response createVerificationSessionV2(@Nonnull String e164, @Nullable String pushToken, @Nullable String mcc, @Nullable String mnc) throws IOException {
        String jsonBody = JsonUtil.toJson(new VerificationSessionMetadataRequestBody(e164, pushToken, mcc, mnc));
        return this.makeServiceRequestWithoutValidation(VERIFICATION_SESSION_PATH, "POST", PushServiceSocket.jsonRequestBody(jsonBody), NO_HEADERS, SealedSenderAccess.NONE, false);
    }

    public Response getSessionStatusV2(String sessionId) throws IOException {
        String path = "/v1/verification/session/" + sessionId;
        return this.makeServiceRequestWithoutValidation(path, "GET", PushServiceSocket.jsonRequestBody(null), NO_HEADERS, SealedSenderAccess.NONE, false);
    }

    public Response patchVerificationSessionV2(String sessionId, @Nullable String pushToken, @Nullable String mcc, @Nullable String mnc, @Nullable String captchaToken, @Nullable String pushChallengeToken) throws IOException {
        String path = "/v1/verification/session/" + sessionId;
        UpdateVerificationSessionRequestBody requestBody = new UpdateVerificationSessionRequestBody(captchaToken, pushToken, pushChallengeToken, mcc, mnc);
        return this.makeServiceRequestWithoutValidation(path, "PATCH", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(requestBody)), NO_HEADERS, SealedSenderAccess.NONE, false);
    }

    public Response requestVerificationCodeV2(String sessionId, Locale locale, boolean androidSmsRetriever, VerificationCodeTransport transport) throws IOException {
        String path = String.format(VERIFICATION_CODE_PATH, sessionId);
        Map<String, String> headers = locale != null ? Collections.singletonMap("Accept-Language", locale.getLanguage() + "-" + locale.getCountry()) : NO_HEADERS;
        HashMap<String, String> body = new HashMap<String, String>();
        switch (transport.ordinal()) {
            case 0: {
                body.put("transport", "sms");
                break;
            }
            case 1: {
                body.put("transport", "voice");
            }
        }
        body.put("client", androidSmsRetriever ? "android-2021-03" : "android");
        return this.makeServiceRequestWithoutValidation(path, "POST", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(body)), headers, SealedSenderAccess.NONE, false);
    }

    public Response submitVerificationCodeV2(String sessionId, String verificationCode) throws IOException {
        String path = String.format(VERIFICATION_CODE_PATH, sessionId);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("code", verificationCode);
        return this.makeServiceRequestWithoutValidation(path, "PUT", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(body)), NO_HEADERS, SealedSenderAccess.NONE, false);
    }

    public Response submitRegistrationRequestV2(@Nullable String sessionId, @Nullable String recoveryPassword, AccountAttributes attributes, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys, @Nullable String fcmToken, boolean skipDeviceTransfer) throws IOException {
        RegistrationSessionRequestBody body;
        String path = REGISTRATION_PATH;
        if (sessionId == null && recoveryPassword == null) {
            throw new IllegalArgumentException("Neither Session ID nor Recovery Password provided.");
        }
        if (sessionId != null && recoveryPassword != null) {
            throw new IllegalArgumentException("You must supply one and only one of either: Session ID, or Recovery Password.");
        }
        GcmRegistrationId gcmRegistrationId = attributes.getFetchesMessages() ? null : new GcmRegistrationId(fcmToken, true);
        try {
            SignedPreKeyEntity aciSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(aciPreKeys.getSignedPreKey()).getId(), aciPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), aciPreKeys.getSignedPreKey().getSignature());
            SignedPreKeyEntity pniSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(pniPreKeys.getSignedPreKey()).getId(), pniPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), pniPreKeys.getSignedPreKey().getSignature());
            KyberPreKeyEntity aciLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(aciPreKeys.getLastResortKyberPreKey()).getId(), aciPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), aciPreKeys.getLastResortKyberPreKey().getSignature());
            KyberPreKeyEntity pniLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(pniPreKeys.getLastResortKyberPreKey()).getId(), pniPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), pniPreKeys.getLastResortKyberPreKey().getSignature());
            body = new RegistrationSessionRequestBody(sessionId, recoveryPassword, attributes, Base64.encodeWithoutPadding((byte[])aciPreKeys.getIdentityKey().serialize()), Base64.encodeWithoutPadding((byte[])pniPreKeys.getIdentityKey().serialize()), aciSignedPreKey, pniSignedPreKey, aciLastResortKyberPreKey, pniLastResortKyberPreKey, gcmRegistrationId, skipDeviceTransfer, true);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError("unexpected invalid key", e);
        }
        return this.makeServiceRequestWithoutValidation(path, "POST", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(body)), NO_HEADERS, SealedSenderAccess.NONE, false);
    }

    public Response submitRegistrationRequestV2(@Nonnull String e164, @Nonnull String password, @Nullable String sessionId, @Nullable String recoveryPassword, AccountAttributes attributes, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys, @Nullable String fcmToken, boolean skipDeviceTransfer) throws IOException {
        RegistrationSessionRequestBody body;
        String path = REGISTRATION_PATH;
        if (sessionId == null && recoveryPassword == null) {
            throw new IllegalArgumentException("Neither Session ID nor Recovery Password provided.");
        }
        if (sessionId != null && recoveryPassword != null) {
            throw new IllegalArgumentException("You must supply one and only one of either: Session ID, or Recovery Password.");
        }
        GcmRegistrationId gcmRegistrationId = attributes.getFetchesMessages() ? null : new GcmRegistrationId(fcmToken, true);
        try {
            SignedPreKeyEntity aciSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(aciPreKeys.getSignedPreKey()).getId(), aciPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), aciPreKeys.getSignedPreKey().getSignature());
            SignedPreKeyEntity pniSignedPreKey = new SignedPreKeyEntity(Objects.requireNonNull(pniPreKeys.getSignedPreKey()).getId(), pniPreKeys.getSignedPreKey().getKeyPair().getPublicKey(), pniPreKeys.getSignedPreKey().getSignature());
            KyberPreKeyEntity aciLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(aciPreKeys.getLastResortKyberPreKey()).getId(), aciPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), aciPreKeys.getLastResortKyberPreKey().getSignature());
            KyberPreKeyEntity pniLastResortKyberPreKey = new KyberPreKeyEntity(Objects.requireNonNull(pniPreKeys.getLastResortKyberPreKey()).getId(), pniPreKeys.getLastResortKyberPreKey().getKeyPair().getPublicKey(), pniPreKeys.getLastResortKyberPreKey().getSignature());
            body = new RegistrationSessionRequestBody(sessionId, recoveryPassword, attributes, Base64.encodeWithoutPadding((byte[])aciPreKeys.getIdentityKey().serialize()), Base64.encodeWithoutPadding((byte[])pniPreKeys.getIdentityKey().serialize()), aciSignedPreKey, pniSignedPreKey, aciLastResortKyberPreKey, pniLastResortKyberPreKey, gcmRegistrationId, skipDeviceTransfer, true);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError("unexpected invalid key", e);
        }
        String authHeader = "Basic " + Base64.encodeWithPadding((byte[])(e164 + ":" + password).getBytes("UTF-8"));
        Map<String, CallSite> headers = Collections.singletonMap("Authorization", authHeader);
        return this.makeServiceRequestWithoutValidation(path, "POST", PushServiceSocket.jsonRequestBody(JsonUtil.toJson(body)), headers, SealedSenderAccess.NONE, false);
    }

    public void setRestoreMethodChosen(@Nonnull String token, @Nonnull RestoreMethodBody request2) throws IOException {
        String body = JsonUtil.toJson(request2);
        this.makeServiceRequest(String.format(Locale.US, SET_RESTORE_METHOD_PATH, PushServiceSocket.urlEncode(token)), "PUT", body, NO_HEADERS, UNOPINIONATED_HANDLER, SealedSenderAccess.NONE);
    }

    public void requestPushChallenge(String sessionId, String gcmRegistrationId) throws IOException {
        this.patchVerificationSession(sessionId, gcmRegistrationId, null, null, null, null);
    }

    public RegisterAsSecondaryDeviceResponse registerAsSecondaryDevice(RegisterAsSecondaryDeviceRequest request2) throws IOException {
        String responseText = this.makeServiceRequest(DEVICE_LINK_PATH, "PUT", JsonUtil.toJson(request2));
        return JsonUtil.fromJson(responseText, RegisterAsSecondaryDeviceResponse.class);
    }

    /*
     * Exception decompiling
     */
    public SendGroupMessageResponse sendGroupMessage(byte[] body, @Nonnull SealedSenderAccess sealedSenderAccess, long timestamp, boolean online, boolean urgent, boolean story) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SendMessageResponse sendMessage(OutgoingPushMessageList bundle, @Nullable SealedSenderAccess sealedSenderAccess, boolean story) throws IOException {
        try {
            String responseText = this.makeServiceRequest(String.format("/v1/messages/%s?story=%s", bundle.getDestination(), story ? "true" : "false"), "PUT", JsonUtil.toJson(bundle), NO_HEADERS, NO_HANDLER, sealedSenderAccess);
            SendMessageResponse response = JsonUtil.fromJson(responseText, SendMessageResponse.class);
            response.setSentUnidentfied(sealedSenderAccess != null);
            return response;
        }
        catch (NotFoundException nfe) {
            throw new UnregisteredUserException(bundle.getDestination(), nfe);
        }
    }

    public void retrieveBackup(int cdnNumber, Map<String, String> headers, String cdnPath, File destination, long maxSizeBytes, SignalServiceAttachment.ProgressListener listener) throws MissingConfigurationException, IOException {
        this.downloadFromCdn(destination, cdnNumber, headers, cdnPath, maxSizeBytes, listener);
    }

    public byte[] retrieveBackupForwardSecrecyMetadataBytes(int cdnNumber, Map<String, String> headers, String cdnPath, int maxSizeBytes) throws MissingConfigurationException, IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.downloadFromCdn(outputStream, 0L, cdnNumber, headers, cdnPath, maxSizeBytes, null);
        return outputStream.toByteArray();
    }

    public void retrieveAttachment(int cdnNumber, Map<String, String> headers, SignalServiceAttachmentRemoteId remoteId, File destination, long maxSizeBytes, SignalServiceAttachment.ProgressListener listener) throws IOException, MissingConfigurationException {
        String path;
        if (remoteId instanceof SignalServiceAttachmentRemoteId.V2) {
            path = String.format(Locale.US, ATTACHMENT_ID_DOWNLOAD_PATH, ((SignalServiceAttachmentRemoteId.V2)remoteId).getCdnId());
        } else if (remoteId instanceof SignalServiceAttachmentRemoteId.V4) {
            String urlEncodedKey = PushServiceSocket.urlEncode(((SignalServiceAttachmentRemoteId.V4)remoteId).getCdnKey());
            path = String.format(Locale.US, ATTACHMENT_KEY_DOWNLOAD_PATH, urlEncodedKey);
        } else if (remoteId instanceof SignalServiceAttachmentRemoteId.Backup) {
            SignalServiceAttachmentRemoteId.Backup backupCdnRemoteId = (SignalServiceAttachmentRemoteId.Backup)remoteId;
            path = String.format(Locale.US, ARCHIVE_MEDIA_DOWNLOAD_PATH, backupCdnRemoteId.getMediaCdnPath(), backupCdnRemoteId.getMediaId());
        } else {
            throw new IllegalArgumentException("Invalid cdnPath type: " + remoteId.getClass().getSimpleName());
        }
        this.downloadFromCdn(destination, cdnNumber, headers, path, maxSizeBytes, listener);
    }

    public byte[] retrieveSticker(byte[] packId, int stickerId) throws NonSuccessfulResponseCodeException, PushNetworkException {
        String hexPackId = Hex.toStringCondensed((byte[])packId);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.downloadFromCdn(output, 0L, 0, Collections.emptyMap(), String.format(Locale.US, STICKER_PATH, hexPackId, stickerId), 0x100000L, null);
        }
        catch (MissingConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        return output.toByteArray();
    }

    public byte[] retrieveStickerManifest(byte[] packId) throws NonSuccessfulResponseCodeException, PushNetworkException {
        String hexPackId = Hex.toStringCondensed((byte[])packId);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.downloadFromCdn(output, 0L, 0, Collections.emptyMap(), String.format(STICKER_MANIFEST_PATH, hexPackId), 0x100000L, null);
        }
        catch (MissingConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        return output.toByteArray();
    }

    public void retrieveProfileAvatar(String path, File destination, long maxSizeBytes) throws IOException {
        try {
            this.downloadFromCdn(destination, 0, Collections.emptyMap(), path, maxSizeBytes, null);
        }
        catch (MissingConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public NetworkResult<String> uploadProfileAvatar(ProfileAvatarUploadAttributes formAttributes, ProfileAvatarData profileAvatar) {
        return NetworkResult.fromFetch(() -> {
            this.uploadToCdn0(AVATAR_UPLOAD_PATH, formAttributes.getAcl(), formAttributes.getKey(), formAttributes.getPolicy(), formAttributes.getAlgorithm(), formAttributes.getCredential(), formAttributes.getDate(), formAttributes.getSignature(), profileAvatar.getData(), profileAvatar.getContentType(), profileAvatar.getDataLength(), false, profileAvatar.getOutputStreamFactory(), null, null);
            return formAttributes.getKey();
        });
    }

    public BackupV2AuthCheckResponse checkSvr2AuthCredentials(@Nullable String number, @Nonnull List<String> passwords) throws IOException {
        String response = this.makeServiceRequest(BACKUP_AUTH_CHECK_V2, "POST", JsonUtil.toJson(new BackupAuthCheckRequest(number, passwords)), NO_HEADERS, UNOPINIONATED_HANDLER, SealedSenderAccess.NONE);
        return JsonUtil.fromJson(response, BackupV2AuthCheckResponse.class);
    }

    public BackupV3AuthCheckResponse checkSvr3AuthCredentials(@Nullable String number, @Nonnull List<String> passwords) throws IOException {
        String response = this.makeServiceRequest(BACKUP_AUTH_CHECK_V3, "POST", JsonUtil.toJson(new BackupAuthCheckRequest(number, passwords)), NO_HEADERS, UNOPINIONATED_HANDLER, SealedSenderAccess.NONE);
        return JsonUtil.fromJson(response, BackupV3AuthCheckResponse.class);
    }

    public StorageManifest getStorageManifest(String authToken) throws IOException {
        try (Response response = this.makeStorageRequest(authToken, "/v1/storage/manifest", "GET", null, NO_HANDLER);){
            StorageManifest storageManifest = (StorageManifest)((Object)StorageManifest.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return storageManifest;
        }
    }

    public StorageManifest getStorageManifestIfDifferentVersion(String authToken, long version) throws IOException {
        try (Response response = this.makeStorageRequest(authToken, "/v1/storage/manifest/version/" + version, "GET", null, NO_HANDLER);){
            StorageManifest storageManifest = (StorageManifest)((Object)StorageManifest.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return storageManifest;
        }
    }

    public StorageItems readStorageItems(String authToken, ReadOperation operation) throws IOException {
        try (Response response = this.makeStorageRequest(authToken, "/v1/storage/read", "PUT", PushServiceSocket.protobufRequestBody(operation), NO_HANDLER);){
            StorageItems storageItems = (StorageItems)((Object)StorageItems.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return storageItems;
        }
    }

    public void writeStorageItems(String authToken, WriteOperation writeOperation) throws IOException {
        this.makeStorageRequest(authToken, "/v1/storage", "PUT", PushServiceSocket.protobufRequestBody(writeOperation), UNOPINIONATED_BINARY_ERROR_HANDLER);
    }

    public void pingStorageService() throws IOException {
        Response response = this.makeStorageRequest(null, "/ping", "GET", null, NO_HANDLER);
        if (response != null) {
            response.close();
        }
    }

    public RemoteConfigResponse getRemoteConfig() throws IOException {
        try (Response response = this.makeServiceRequest(REMOTE_CONFIG, "GET", PushServiceSocket.jsonRequestBody(null), NO_HEADERS, NO_HANDLER, SealedSenderAccess.NONE, false);){
            RemoteConfigResponse remoteConfigResponse = JsonUtil.fromJson(PushServiceSocket.readBodyString(response), RemoteConfigResponse.class);
            remoteConfigResponse.setServerEpochTime(response.headers().get("X-Signal-Timestamp") != null ? Long.parseLong(response.headers().get("X-Signal-Timestamp")) : System.currentTimeMillis());
            RemoteConfigResponse remoteConfigResponse2 = remoteConfigResponse;
            return remoteConfigResponse2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelInFlightRequests() {
        Set<Call> set = this.connections;
        synchronized (set) {
            Log.w((String)TAG, (String)("Canceling: " + this.connections.size()));
            for (Call connection : this.connections) {
                Log.w((String)TAG, (String)("Canceling: " + String.valueOf(connection)));
                connection.cancel();
            }
        }
    }

    public StickerUploadAttributesResponse getStickerUploadAttributes(int stickerCount) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        String response = this.makeServiceRequest(String.format(Locale.ROOT, STICKER_UPLOAD_PATH, stickerCount), "GET", null);
        try {
            return JsonUtil.fromJson(response, StickerUploadAttributesResponse.class);
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
            throw new MalformedResponseException("Unable to parse entity", e);
        }
    }

    public AttachmentDigest uploadGroupV2Avatar(byte[] avatarCipherText, AvatarUploadAttributes uploadAttributes) throws IOException {
        return this.uploadToCdn0(AVATAR_UPLOAD_PATH, uploadAttributes.acl, uploadAttributes.key, uploadAttributes.policy, uploadAttributes.algorithm, uploadAttributes.credential, uploadAttributes.date, uploadAttributes.signature, new ByteArrayInputStream(avatarCipherText), "application/octet-stream", avatarCipherText.length, false, new NoCipherOutputStreamFactory(), null, null);
    }

    public ResumableUploadSpec getResumableUploadSpec(AttachmentUploadForm uploadForm) throws IOException {
        return new ResumableUploadSpec(Util.getSecretBytes(64), Util.getSecretBytes(16), uploadForm.key, uploadForm.cdn, this.getResumableUploadUrl(uploadForm), System.currentTimeMillis() + CDN2_RESUMABLE_LINK_LIFETIME_MILLIS, uploadForm.headers);
    }

    public AttachmentDigest uploadAttachment(PushAttachmentData attachment) throws IOException {
        if (attachment.getResumableUploadSpec().getExpirationTimestamp() < System.currentTimeMillis()) {
            throw new ResumeLocationInvalidException();
        }
        if (attachment.getResumableUploadSpec().getCdnNumber() == 2) {
            return this.uploadToCdn2(attachment.getResumableUploadSpec().getResumeLocation(), attachment.getData(), "application/octet-stream", attachment.getDataSize(), attachment.getIncremental(), attachment.getOutputStreamFactory(), attachment.getListener(), attachment.getCancelationSignal());
        }
        return this.uploadToCdn3(attachment.getResumableUploadSpec().getResumeLocation(), attachment.getData(), "application/offset+octet-stream", attachment.getDataSize(), attachment.getIncremental(), attachment.getOutputStreamFactory(), attachment.getListener(), attachment.getCancelationSignal(), attachment.getResumableUploadSpec().getHeaders());
    }

    public void uploadStickerContent(InputStream content, long length, byte[] expandedPackKey, StickerUploadAttributes uploadAttributes) throws NonSuccessfulResponseCodeException, PushNetworkException {
        this.uploadToCdn0(AVATAR_UPLOAD_PATH, uploadAttributes.getAcl(), uploadAttributes.getKey(), uploadAttributes.getPolicy(), uploadAttributes.getAlgorithm(), uploadAttributes.getCredential(), uploadAttributes.getDate(), uploadAttributes.getSignature(), content, "application/octet-stream", AttachmentCipherStreamUtil.getCiphertextLength(length), false, new StickerCipherOutputStreamFactory(expandedPackKey), null, null);
    }

    private void downloadFromCdn(File destination, int cdnNumber, Map<String, String> headers, String path, long maxSizeBytes, SignalServiceAttachment.ProgressListener listener) throws IOException, MissingConfigurationException {
        try (FileOutputStream outputStream = new FileOutputStream(destination, true);){
            this.downloadFromCdn(outputStream, destination.length(), cdnNumber, headers, path, maxSizeBytes, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFromCdn(OutputStream outputStream, long offset, int cdnNumber, Map<String, String> headers, String path, long maxSizeBytes, SignalServiceAttachment.ProgressListener listener) throws PushNetworkException, NonSuccessfulResponseCodeException, MissingConfigurationException {
        block31: {
            ConnectionHolder[] cdnNumberClients = this.cdnClientsMap.get(cdnNumber);
            if (cdnNumberClients == null) {
                throw new MissingConfigurationException("Attempted to download from unsupported CDN number: " + cdnNumber + ", Our configuration supports: " + String.valueOf(this.cdnClientsMap.keySet()));
            }
            ConnectionHolder connectionHolder = this.getRandom(cdnNumberClients, this.random);
            OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
            Request.Builder request2 = new Request.Builder().url(connectionHolder.getUrl() + "/" + path).get();
            if (connectionHolder.getHostHeader().isPresent()) {
                request2.addHeader("Host", connectionHolder.getHostHeader().get());
            }
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request2.addHeader(entry.getKey(), entry.getValue());
            }
            if (offset > 0L) {
                Log.i((String)TAG, (String)("Starting download from CDN with offset " + offset));
                request2.addHeader("Range", "bytes=" + offset + "-");
            }
            Call call = okHttpClient.newCall(request2.build());
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.add(call);
            }
            try (Response response = call.execute();){
                if (response.isSuccessful()) {
                    ResponseBody body = response.body();
                    if (body == null) {
                        throw new PushNetworkException("No response body!");
                    }
                    if (body.contentLength() > maxSizeBytes) {
                        throw new PushNetworkException("Response exceeds max size!");
                    }
                    InputStream in = body.byteStream();
                    byte[] buffer = new byte[32768];
                    int read = 0;
                    long totalRead = offset;
                    while ((read = in.read(buffer, 0, buffer.length)) != -1) {
                        outputStream.write(buffer, 0, read);
                        if ((totalRead += (long)read) > maxSizeBytes) {
                            throw new PushNetworkException("Response exceeded max size!");
                        }
                        if (listener == null) continue;
                        listener.onAttachmentProgress(new AttachmentTransferProgress(body.contentLength() + offset, totalRead));
                        if (!listener.shouldCancel()) continue;
                        call.cancel();
                        throw new PushNetworkException("Canceled by listener check.");
                    }
                    break block31;
                }
                if (response.code() == 416) {
                    throw new RangeException(offset);
                }
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException iOException) {
                throw iOException;
            }
            catch (IOException iOException) {
                throw new PushNetworkException(iOException);
            }
            finally {
                Set<Call> set2 = this.connections;
                synchronized (set2) {
                    this.connections.remove(call);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Nonnull
    public ZonedDateTime getCdnLastModifiedTime(int cdnNumber, Map<String, String> headers, String path) throws MissingConfigurationException, PushNetworkException, NonSuccessfulResponseCodeException, MalformedResponseException {
        Object header2;
        ConnectionHolder[] cdnNumberClients = this.cdnClientsMap.get(cdnNumber);
        if (cdnNumberClients == null) {
            throw new MissingConfigurationException("Attempted to download from unsupported CDN number: " + cdnNumber + ", Our configuration supports: " + String.valueOf(this.cdnClientsMap.keySet()));
        }
        ConnectionHolder connectionHolder = this.getRandom(cdnNumberClients, this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        Request.Builder request2 = new Request.Builder().url(connectionHolder.getUrl() + "/" + path).head();
        if (connectionHolder.getHostHeader().isPresent()) {
            request2.addHeader("Host", connectionHolder.getHostHeader().get());
        }
        for (Object header2 : headers.entrySet()) {
            request2.addHeader(header2.getKey(), header2.getValue());
        }
        Call call = okHttpClient.newCall(request2.build());
        header2 = this.connections;
        synchronized (header2) {
            this.connections.add(call);
        }
        try {
            Response response;
            block26: {
                ZonedDateTime zonedDateTime;
                block27: {
                    response = call.execute();
                    if (!response.isSuccessful()) break block26;
                    String lastModified = response.header("Last-Modified");
                    if (lastModified == null) {
                        throw new MalformedResponseException("No Last-Modified header in response");
                    }
                    zonedDateTime = ZonedDateTime.parse(lastModified, DateTimeFormatter.RFC_1123_DATE_TIME);
                    if (response == null) break block27;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    response.close();
                }
                return zonedDateTime;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
        }
        finally {
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.remove(call);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private AttachmentDigest uploadToCdn0(String path, String acl, String key, String policy, String algorithm, String credential, String date, String signature, InputStream data, String contentType, long length, boolean incremental, OutputStreamFactory outputStreamFactory, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal) throws PushNetworkException, NonSuccessfulResponseCodeException {
        ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(0), this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        DigestingRequestBody file = new DigestingRequestBody(data, outputStreamFactory, contentType, length, incremental, progressListener, cancelationSignal, 0L);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("acl", acl).addFormDataPart("key", key).addFormDataPart("policy", policy).addFormDataPart("Content-Type", contentType).addFormDataPart("x-amz-algorithm", algorithm).addFormDataPart("x-amz-credential", credential).addFormDataPart("x-amz-date", date).addFormDataPart("x-amz-signature", signature).addFormDataPart("file", "file", (RequestBody)file).build();
        Request.Builder request2 = new Request.Builder().url(connectionHolder.getUrl() + "/" + path).post((RequestBody)requestBody);
        if (connectionHolder.getHostHeader().isPresent()) {
            request2.addHeader("Host", connectionHolder.getHostHeader().get());
        }
        Call call = okHttpClient.newCall(request2.build());
        Set<Call> set = this.connections;
        synchronized (set) {
            this.connections.add(call);
        }
        try {
            Response response;
            block23: {
                AttachmentDigest attachmentDigest;
                block24: {
                    response = call.execute();
                    if (!response.isSuccessful()) break block23;
                    attachmentDigest = file.getAttachmentDigest();
                    if (response == null) break block24;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    response.close();
                }
                return attachmentDigest;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
        }
        finally {
            Set<Call> set2 = this.connections;
            synchronized (set2) {
                this.connections.remove(call);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getResumableUploadUrl(AttachmentUploadForm uploadForm) throws IOException {
        Map.Entry<String, String> header2222;
        ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(uploadForm.cdn), this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        Request.Builder request2 = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, uploadForm.signedUploadLocation)).post(RequestBody.create(null, (String)AVATAR_UPLOAD_PATH));
        for (Map.Entry<String, String> header2222 : uploadForm.headers.entrySet()) {
            if (header2222.getKey().equalsIgnoreCase("host")) continue;
            request2.header(header2222.getKey(), header2222.getValue());
        }
        if (connectionHolder.getHostHeader().isPresent()) {
            request2.header("host", connectionHolder.getHostHeader().get());
        }
        request2.addHeader("Content-Length", "0");
        if (uploadForm.cdn == 2) {
            request2.addHeader("Content-Type", "application/octet-stream");
        } else if (uploadForm.cdn == 3) {
            request2.addHeader("Upload-Defer-Length", "1").addHeader("Tus-Resumable", "1.0.0");
        } else {
            throw new AssertionError((Object)("Unknown CDN version: " + uploadForm.cdn));
        }
        Call call = okHttpClient.newCall(request2.build());
        header2222 = this.connections;
        synchronized (header2222) {
            this.connections.add(call);
        }
        try {
            Response response;
            block28: {
                String string;
                block29: {
                    response = call.execute();
                    if (!response.isSuccessful()) break block28;
                    string = response.header("location");
                    if (response == null) break block29;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    response.close();
                }
                return string;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
        }
        finally {
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.remove(call);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private AttachmentDigest uploadToCdn2(String resumableUrl, InputStream data, String contentType, long length, boolean incremental, OutputStreamFactory outputStreamFactory, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal) throws IOException {
        ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(2), this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        ResumeInfo resumeInfo = this.getResumeInfoCdn2(resumableUrl, length);
        DigestingRequestBody file = new DigestingRequestBody(data, outputStreamFactory, contentType, length, incremental, progressListener, cancelationSignal, resumeInfo.contentStart);
        if (resumeInfo.contentStart == length) {
            Log.w((String)TAG, (String)"Resume start point == content length");
            try (NowhereBufferedSink buffer = new NowhereBufferedSink();){
                file.writeTo(buffer);
            }
            return file.getAttachmentDigest();
        }
        Request.Builder request2 = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, resumableUrl)).put((RequestBody)file).addHeader("Content-Range", resumeInfo.contentRange);
        if (connectionHolder.getHostHeader().isPresent()) {
            request2.header("host", connectionHolder.getHostHeader().get());
        }
        Call call = okHttpClient.newCall(request2.build());
        Set<Call> set = this.connections;
        synchronized (set) {
            this.connections.add(call);
        }
        try {
            Response response;
            block31: {
                AttachmentDigest attachmentDigest;
                block32: {
                    response = call.execute();
                    if (!response.isSuccessful()) break block31;
                    attachmentDigest = file.getAttachmentDigest();
                    if (response == null) break block32;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    response.close();
                }
                return attachmentDigest;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                if (e instanceof StreamResetException) {
                    throw e;
                }
                throw new PushNetworkException(e);
            }
        }
        finally {
            Set<Call> set2 = this.connections;
            synchronized (set2) {
                this.connections.remove(call);
            }
        }
    }

    public void uploadBackupFile(AttachmentUploadForm uploadForm, String resumableUploadUrl, InputStream data, long dataLength) throws IOException {
        this.uploadBackupFile(uploadForm, resumableUploadUrl, data, dataLength, null);
    }

    public void uploadBackupFile(AttachmentUploadForm uploadForm, String resumableUploadUrl, InputStream data, long dataLength, SignalServiceAttachment.ProgressListener progressListener) throws IOException {
        if (uploadForm.cdn == 2) {
            this.uploadToCdn2(resumableUploadUrl, data, "application/octet-stream", dataLength, false, new NoCipherOutputStreamFactory(), progressListener, null);
        } else {
            this.uploadToCdn3(resumableUploadUrl, data, "application/octet-stream", dataLength, false, new NoCipherOutputStreamFactory(), progressListener, null, uploadForm.headers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private AttachmentDigest uploadToCdn3(String resumableUrl, InputStream data, String contentType, long length, boolean incremental, OutputStreamFactory outputStreamFactory, SignalServiceAttachment.ProgressListener progressListener, CancelationSignal cancelationSignal, Map<String, String> headers) throws IOException {
        Object entry2;
        ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(3), this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        ResumeInfo resumeInfo = this.getResumeInfoCdn3(resumableUrl, headers);
        DigestingRequestBody file = new DigestingRequestBody(data, outputStreamFactory, contentType, length, incremental, progressListener, cancelationSignal, resumeInfo.contentStart);
        if (resumeInfo.contentStart == length) {
            Log.w((String)TAG, (String)"Resume start point == content length");
            try (NowhereBufferedSink buffer = new NowhereBufferedSink();){
                file.writeTo(buffer);
            }
            return file.getAttachmentDigest();
        }
        if (resumeInfo.contentStart != 0L) {
            Log.w((String)TAG, (String)"Resuming previous attachment upload");
        }
        Request.Builder request2 = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, resumableUrl)).patch((RequestBody)file).addHeader("Upload-Offset", String.valueOf(resumeInfo.contentStart)).addHeader("Upload-Length", String.valueOf(length)).addHeader("Tus-Resumable", "1.0.0");
        for (Object entry2 : headers.entrySet()) {
            request2.addHeader(entry2.getKey(), entry2.getValue());
        }
        if (connectionHolder.getHostHeader().isPresent()) {
            request2.header("host", connectionHolder.getHostHeader().get());
        }
        Call call = okHttpClient.newCall(request2.build());
        entry2 = this.connections;
        synchronized (entry2) {
            this.connections.add(call);
        }
        try {
            Response response;
            block33: {
                AttachmentDigest attachmentDigest;
                block34: {
                    response = call.execute();
                    if (!response.isSuccessful()) break block33;
                    attachmentDigest = file.getAttachmentDigest();
                    if (response == null) break block34;
                    {
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    response.close();
                }
                return attachmentDigest;
            }
            try {
                throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response), response.body().string());
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                if (e instanceof StreamResetException) {
                    throw e;
                }
                throw new PushNetworkException(e);
            }
        }
        finally {
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.remove(call);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResumeInfo getResumeInfoCdn2(String resumableUrl, long contentLength) throws IOException {
        String contentRange;
        long offset;
        block25: {
            ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(2), this.random);
            OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
            Request.Builder request2 = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, resumableUrl)).put(RequestBody.create(null, (String)AVATAR_UPLOAD_PATH)).addHeader("Content-Range", String.format(Locale.US, "bytes */%d", contentLength));
            if (connectionHolder.getHostHeader().isPresent()) {
                request2.header("host", connectionHolder.getHostHeader().get());
            }
            Call call = okHttpClient.newCall(request2.build());
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.add(call);
            }
            try (Object response = call.execute();){
                if (response.isSuccessful()) {
                    offset = contentLength;
                    contentRange = null;
                    break block25;
                }
                if (response.code() == 308) {
                    String rangeCompleted = response.header("Range");
                    offset = rangeCompleted == null ? 0L : Long.parseLong(rangeCompleted.split("-")[1]) + 1L;
                    contentRange = String.format(Locale.US, "bytes %d-%d/%d", offset, contentLength - 1L, contentLength);
                    break block25;
                }
                if (response.code() == 404) {
                    throw new ResumeLocationInvalidException();
                }
                throw new NonSuccessfulResumableUploadResponseCodeException(response.code(), "Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException e) {
                throw e;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
            finally {
                Set<Call> set2 = this.connections;
                synchronized (set2) {
                    this.connections.remove(call);
                }
            }
        }
        return new ResumeInfo(contentRange, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResumeInfo getResumeInfoCdn3(String resumableUrl, Map<String, String> headers) throws IOException {
        long offset;
        block24: {
            ConnectionHolder connectionHolder = this.getRandom(this.cdnClientsMap.get(3), this.random);
            OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
            Request.Builder request2 = new Request.Builder().url(PushServiceSocket.buildConfiguredUrl(connectionHolder, resumableUrl)).head().addHeader("Tus-Resumable", "1.0.0");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request2.addHeader(entry.getKey(), entry.getValue());
            }
            if (connectionHolder.getHostHeader().isPresent()) {
                request2.header("host", connectionHolder.getHostHeader().get());
            }
            Call call = okHttpClient.newCall(request2.build());
            Set<Call> set = this.connections;
            synchronized (set) {
                this.connections.add(call);
            }
            try (Response response = call.execute();){
                if (response.isSuccessful()) {
                    offset = Long.parseLong(Objects.requireNonNull(response.header("Upload-Offset")));
                    break block24;
                }
                throw new ResumeLocationInvalidException("Response: " + String.valueOf(response));
            }
            catch (NonSuccessfulResponseCodeException | PushNetworkException iOException) {
                throw iOException;
            }
            catch (IOException iOException) {
                throw new PushNetworkException(iOException);
            }
            finally {
                Set<Call> set2 = this.connections;
                synchronized (set2) {
                    this.connections.remove(call);
                }
            }
        }
        return new ResumeInfo(null, offset);
    }

    private static HttpUrl buildConfiguredUrl(ConnectionHolder connectionHolder, String url) throws IOException {
        HttpUrl resumableHttpUrl;
        HttpUrl endpointUrl = HttpUrl.get((String)connectionHolder.url);
        try {
            resumableHttpUrl = HttpUrl.get((String)url);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Malformed URL!", e);
        }
        return new HttpUrl.Builder().scheme(endpointUrl.scheme()).host(endpointUrl.host()).port(endpointUrl.port()).encodedPath(endpointUrl.encodedPath()).addEncodedPathSegments(resumableHttpUrl.encodedPath().substring(1)).encodedQuery(resumableHttpUrl.encodedQuery()).encodedFragment(resumableHttpUrl.encodedFragment()).build();
    }

    private String makeServiceRequest(String urlFragment, String method, String jsonBody) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        return this.makeServiceRequest(urlFragment, method, jsonBody, NO_HEADERS, NO_HANDLER, SealedSenderAccess.NONE);
    }

    private String makeServiceRequest(String urlFragment, String method, String jsonBody, Map<String, String> headers, ResponseCodeHandler responseCodeHandler, @Nullable SealedSenderAccess sealedSenderAccess) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        try (Response response = this.makeServiceRequest(urlFragment, method, PushServiceSocket.jsonRequestBody(jsonBody), headers, responseCodeHandler, sealedSenderAccess, false);){
            String string = PushServiceSocket.readBodyString(response);
            return string;
        }
    }

    private static RequestBody jsonRequestBody(String jsonBody) {
        return jsonBody != null ? RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonBody) : null;
    }

    private static RequestBody protobufRequestBody(Message<?, ?> protobufBody) {
        return protobufBody != null ? RequestBody.create((MediaType)MediaType.parse((String)"application/x-protobuf"), (byte[])protobufBody.encode()) : null;
    }

    private Response makeServiceRequest(String urlFragment, String method, RequestBody body, Map<String, String> headers, ResponseCodeHandler responseCodeHandler, @Nullable SealedSenderAccess sealedSenderAccess, boolean doNotAddAuthenticationOrUnidentifiedAccessKey) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        Response response = null;
        try {
            response = this.getServiceConnection(urlFragment, method, body, headers, sealedSenderAccess, doNotAddAuthenticationOrUnidentifiedAccessKey);
            responseCodeHandler.handle(response.code(), response.body(), arg_0 -> ((Response)response).header(arg_0));
            return this.validateServiceResponse(response);
        }
        catch (Exception e) {
            if (response != null && response.body() != null) {
                response.body().close();
            }
            throw e;
        }
    }

    private Response makeServiceRequestWithoutValidation(String urlFragment, String method, RequestBody body, Map<String, String> headers, @Nullable SealedSenderAccess sealedSenderAccess, boolean doNotAddAuthenticationOrUnidentifiedAccessKey) throws PushNetworkException {
        Response response = null;
        try {
            response = this.getServiceConnection(urlFragment, method, body, headers, sealedSenderAccess, doNotAddAuthenticationOrUnidentifiedAccessKey);
            return response;
        }
        catch (Exception e) {
            if (response != null && response.body() != null) {
                response.body().close();
            }
            throw e;
        }
    }

    private Response validateServiceResponse(Response response) throws NonSuccessfulResponseCodeException, PushNetworkException, MalformedResponseException {
        int responseCode = response.code();
        String responseMessage = response.message();
        switch (responseCode) {
            case 413: 
            case 429: {
                long retryAfterLong = Util.parseLong(response.header("Retry-After"), -1L);
                Optional<Long> retryAfter = retryAfterLong != -1L ? Optional.of(TimeUnit.SECONDS.toMillis(retryAfterLong)) : Optional.empty();
                throw new RateLimitException(responseCode, "Rate limit exceeded: " + responseCode, retryAfter);
            }
            case 401: 
            case 403: {
                throw new AuthorizationFailedException(responseCode, "Authorization failed!");
            }
            case 404: {
                throw new NotFoundException("Not found");
            }
            case 409: {
                MismatchedDevices mismatchedDevices = PushServiceSocket.readResponseJson(response, MismatchedDevices.class);
                throw new MismatchedDevicesException(mismatchedDevices);
            }
            case 410: {
                StaleDevices staleDevices = PushServiceSocket.readResponseJson(response, StaleDevices.class);
                throw new StaleDevicesException(staleDevices);
            }
            case 411: {
                DeviceLimit deviceLimit = PushServiceSocket.readResponseJson(response, DeviceLimit.class);
                throw new DeviceLimitExceededException(deviceLimit);
            }
            case 417: {
                throw new ExpectationFailedException();
            }
            case 423: {
                RegistrationLockFailure accountLockFailure = PushServiceSocket.readResponseJson(response, RegistrationLockFailure.class);
                throw new LockedException(accountLockFailure.length, accountLockFailure.timeRemaining, accountLockFailure.svr2Credentials, accountLockFailure.svr3Credentials);
            }
            case 428: {
                ProofRequiredResponse proofRequiredResponse = PushServiceSocket.readResponseJson(response, ProofRequiredResponse.class);
                String retryAfterRaw = response.header("Retry-After");
                long retryAfter = Util.parseInt(retryAfterRaw, -1);
                throw new ProofRequiredException(proofRequiredResponse, retryAfter);
            }
            case 499: {
                throw new DeprecatedVersionException();
            }
            case 508: {
                throw new ServerRejectedException();
            }
        }
        if (responseCode != 200 && responseCode != 202 && responseCode != 204 && responseCode != 207) {
            throw new NonSuccessfulResponseCodeException(responseCode, "Bad response: " + responseCode + " " + responseMessage + ": " + (response.body() == null ? AVATAR_UPLOAD_PATH : PushServiceSocket.readBodyString(response.body())));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getServiceConnection(String urlFragment, String method, RequestBody body, Map<String, String> headers, @Nullable SealedSenderAccess sealedSenderAccess, boolean doNotAddAuthenticationOrUnidentifiedAccessKey) throws PushNetworkException {
        Set<Call> set;
        OkHttpClient okHttpClient = this.buildOkHttpClient(sealedSenderAccess != null);
        Call call = okHttpClient.newCall(this.buildServiceRequest(urlFragment, method, body, headers, sealedSenderAccess, doNotAddAuthenticationOrUnidentifiedAccessKey));
        Response response = this.connections;
        synchronized (response) {
            this.connections.add(call);
        }
        try {
            response = call.execute();
            set = this.connections;
        }
        catch (Throwable throwable) {
            try {
                Set<Call> set2 = this.connections;
                synchronized (set2) {
                    this.connections.remove(call);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PushNetworkException(e);
            }
        }
        synchronized (set) {
            this.connections.remove(call);
        }
        return response;
    }

    private OkHttpClient buildOkHttpClient(boolean unidentified) {
        ServiceConnectionHolder connectionHolder = (ServiceConnectionHolder)this.getRandom(this.serviceClients, this.random);
        OkHttpClient baseClient = unidentified ? connectionHolder.getUnidentifiedClient() : connectionHolder.getClient();
        return baseClient.newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).retryOnConnectionFailure(this.automaticNetworkRetry).build();
    }

    private Request buildServiceRequest(String urlFragment, String method, RequestBody body, Map<String, String> headers, @Nullable SealedSenderAccess sealedSenderAccess, boolean doNotAddAuthenticationOrUnidentifiedAccessKey) {
        ServiceConnectionHolder connectionHolder = (ServiceConnectionHolder)this.getRandom(this.serviceClients, this.random);
        Request.Builder request2 = new Request.Builder();
        request2.url(String.format("%s%s", connectionHolder.getUrl(), urlFragment));
        request2.method(method, body);
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request2.addHeader(header.getKey(), header.getValue());
        }
        if (!headers.containsKey("Authorization") && !doNotAddAuthenticationOrUnidentifiedAccessKey) {
            if (sealedSenderAccess != null) {
                request2.addHeader(sealedSenderAccess.getHeaderName(), sealedSenderAccess.getHeaderValue());
            } else if (this.credentialsProvider.getPassword() != null) {
                request2.addHeader("Authorization", this.getAuthorizationHeader(this.credentialsProvider));
            }
        }
        if (this.signalAgent != null) {
            request2.addHeader("X-Signal-Agent", this.signalAgent);
        }
        if (connectionHolder.getHostHeader().isPresent()) {
            request2.addHeader("Host", connectionHolder.getHostHeader().get());
        }
        return request2.build();
    }

    private Response makeStorageRequest(String authorization, String path, String method, RequestBody body, ResponseCodeHandler responseCodeHandler) throws PushNetworkException, NonSuccessfulResponseCodeException {
        return this.makeStorageRequest(authorization, path, method, body, NO_HEADERS, responseCodeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response makeStorageRequest(String authorization, String path, String method, RequestBody body, Map<String, String> headers, ResponseCodeHandler responseCodeHandler) throws PushNetworkException, NonSuccessfulResponseCodeException {
        Response response;
        ConnectionHolder connectionHolder = this.getRandom(this.storageClients, this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        Request.Builder request2 = new Request.Builder().url(connectionHolder.getUrl() + path);
        request2.method(method, body);
        if (connectionHolder.getHostHeader().isPresent()) {
            request2.addHeader("Host", connectionHolder.getHostHeader().get());
        }
        if (authorization != null) {
            request2.addHeader("Authorization", authorization);
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request2.addHeader(entry.getKey(), entry.getValue());
        }
        Call call = okHttpClient.newCall(request2.build());
        Set<Call> set = this.connections;
        synchronized (set) {
            this.connections.add(call);
        }
        try {
            response = call.execute();
            if (response.isSuccessful() && response.code() != 204) {
                Response response2 = response;
                return response2;
            }
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
        finally {
            Set<Call> set2 = this.connections;
            synchronized (set2) {
                this.connections.remove(call);
            }
        }
        ResponseBody responseBody = response.body();
        try {
            responseCodeHandler.handle(response.code(), responseBody, arg_0 -> ((Response)response).header(arg_0));
            switch (response.code()) {
                case 204: {
                    throw new NoContentException("No content!");
                }
                case 401: 
                case 403: {
                    throw new AuthorizationFailedException(response.code(), "Authorization failed!");
                }
                case 404: {
                    throw new NotFoundException("Not found");
                }
                case 409: {
                    if (responseBody != null) {
                        throw new ContactManifestMismatchException(PushServiceSocket.readBodyBytes(responseBody));
                    }
                    throw new ConflictException();
                }
                case 429: {
                    throw new RateLimitException(response.code(), "Rate limit exceeded: " + response.code());
                }
                case 499: {
                    throw new DeprecatedVersionException();
                }
            }
            throw new NonSuccessfulResponseCodeException(response.code(), "Response: " + String.valueOf(response));
        }
        catch (Throwable throwable) {
            if (responseBody != null) {
                try {
                    responseBody.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CallingResponse makeCallingRequest(long requestId, String url, String httpMethod, List<Pair<String, String>> headers, byte[] body) {
        ConnectionHolder connectionHolder = this.getRandom(this.serviceClients, this.random);
        OkHttpClient okHttpClient = connectionHolder.getClient().newBuilder().followRedirects(false).connectTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS).build();
        RequestBody requestBody = body != null ? RequestBody.create(null, (byte[])body) : null;
        Request.Builder builder = new Request.Builder().url(url).method(httpMethod, requestBody);
        if (headers != null) {
            for (Pair<String, String> header : headers) {
                builder.addHeader((String)header.getFirst(), (String)header.getSecond());
            }
        }
        Request request2 = builder.build();
        int i = 0;
        while (true) {
            if (i >= 20) {
                Log.w((String)TAG, (String)"Calling request max redirects exceeded");
                return new CallingResponse.Error(requestId, new IOException("Redirect limit exceeded"));
            }
            try (Response response = okHttpClient.newCall(request2).execute();){
                HttpUrl newUrl;
                int responseStatus = response.code();
                if (responseStatus != 307) {
                    CallingResponse.Success success = new CallingResponse.Success(requestId, responseStatus, response.body() != null ? response.body().bytes() : new byte[]{});
                    return success;
                }
                String location = response.header("Location");
                HttpUrl httpUrl = newUrl = location != null ? request2.url().resolve(location) : null;
                if (newUrl == null) {
                    CallingResponse.Error error = new CallingResponse.Error(requestId, new IOException("Received redirect without a valid Location header"));
                    return error;
                }
                request2 = request2.newBuilder().url(newUrl).build();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Exception during ringrtc http call.", (Throwable)e);
                return new CallingResponse.Error(requestId, e);
            }
            ++i;
        }
    }

    private ServiceConnectionHolder[] createServiceConnectionHolders(SignalUrl[] urls, List<Interceptor> interceptors, Optional<Dns> dns, Optional<SignalProxy> proxy) {
        LinkedList<ServiceConnectionHolder> serviceConnectionHolders = new LinkedList<ServiceConnectionHolder>();
        for (SignalUrl url : urls) {
            serviceConnectionHolders.add(new ServiceConnectionHolder(PushServiceSocket.createConnectionClient(url, interceptors, dns, proxy), PushServiceSocket.createConnectionClient(url, interceptors, dns, proxy), url.getUrl(), url.getHostHeader()));
        }
        return serviceConnectionHolders.toArray(new ServiceConnectionHolder[0]);
    }

    private static Map<Integer, ConnectionHolder[]> createCdnClientsMap(Map<Integer, SignalCdnUrl[]> signalCdnUrlMap, List<Interceptor> interceptors, Optional<Dns> dns, Optional<SignalProxy> proxy) {
        PushServiceSocket.validateConfiguration(signalCdnUrlMap);
        HashMap<Integer, ConnectionHolder[]> result2 = new HashMap<Integer, ConnectionHolder[]>();
        for (Map.Entry<Integer, SignalCdnUrl[]> entry : signalCdnUrlMap.entrySet()) {
            result2.put(entry.getKey(), PushServiceSocket.createConnectionHolders(entry.getValue(), interceptors, dns, proxy));
        }
        return Collections.unmodifiableMap(result2);
    }

    private static void validateConfiguration(Map<Integer, SignalCdnUrl[]> signalCdnUrlMap) {
        if (!signalCdnUrlMap.containsKey(0) || !signalCdnUrlMap.containsKey(2)) {
            throw new AssertionError((Object)"Configuration used to create PushServiceSocket must support CDN 0 and CDN 2");
        }
    }

    private static ConnectionHolder[] createConnectionHolders(SignalUrl[] urls, List<Interceptor> interceptors, Optional<Dns> dns, Optional<SignalProxy> proxy) {
        LinkedList<ConnectionHolder> connectionHolders = new LinkedList<ConnectionHolder>();
        for (SignalUrl url : urls) {
            connectionHolders.add(new ConnectionHolder(PushServiceSocket.createConnectionClient(url, interceptors, dns, proxy), url.getUrl(), url.getHostHeader()));
        }
        return connectionHolders.toArray(new ConnectionHolder[0]);
    }

    private static OkHttpClient createConnectionClient(SignalUrl url, List<Interceptor> interceptors, Optional<Dns> dns, Optional<SignalProxy> proxy) {
        try {
            TrustManager[] trustManagers = BlacklistingTrustManager.createFor(url.getTrustStore());
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, trustManagers, null);
            OkHttpClient.Builder builder = new OkHttpClient.Builder().sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(context.getSocketFactory()), (X509TrustManager)trustManagers[0]).connectionSpecs(url.getConnectionSpecs().orElse(Util.immutableList(ConnectionSpec.RESTRICTED_TLS))).dns(dns.orElse(Dns.SYSTEM));
            if (proxy.isPresent()) {
                builder.socketFactory((SocketFactory)new TlsProxySocketFactory(proxy.get().getHost(), proxy.get().getPort(), dns));
            }
            builder.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(context.getSocketFactory()), (X509TrustManager)trustManagers[0]).connectionSpecs(url.getConnectionSpecs().orElse(Util.immutableList(ConnectionSpec.RESTRICTED_TLS))).build();
            builder.connectionPool(new ConnectionPool(5, 45L, TimeUnit.SECONDS));
            for (Interceptor interceptor : interceptors) {
                builder.addInterceptor(interceptor);
            }
            return builder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String getAuthorizationHeader(CredentialsProvider credentialsProvider) {
        try {
            Object identifier;
            Object object = identifier = credentialsProvider.getAci() != null ? credentialsProvider.getAci().toString() : credentialsProvider.getE164();
            if (credentialsProvider.getDeviceId() != 1) {
                identifier = (String)identifier + "." + credentialsProvider.getDeviceId();
            }
            return "Basic " + Base64.encodeWithPadding((byte[])((String)identifier + ":" + credentialsProvider.getPassword()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ConnectionHolder getRandom(ConnectionHolder[] connections, SecureRandom random) {
        return connections[random.nextInt(connections.length)];
    }

    private static byte[] readBodyBytes(Response response) throws PushNetworkException, MalformedResponseException {
        if (response.body() == null) {
            throw new MalformedResponseException("No body!");
        }
        try {
            return response.body().bytes();
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
    }

    private static byte[] readBodyBytes(@Nonnull ResponseBody responseBody) throws PushNetworkException {
        try {
            return responseBody.bytes();
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
    }

    static String readBodyString(Response response) throws PushNetworkException, MalformedResponseException {
        return PushServiceSocket.readBodyString(response.body());
    }

    private static String readBodyString(ResponseBody body) throws PushNetworkException, MalformedResponseException {
        if (body == null) {
            throw new MalformedResponseException("No body!");
        }
        return PushServiceSocket.readBodyStringNonNull(body);
    }

    private static String readBodyStringNonNull(ResponseBody body) throws PushNetworkException {
        try {
            return body.string();
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
    }

    private static <T> T readBodyJson(ResponseBody body, Class<T> clazz) throws PushNetworkException, MalformedResponseException {
        String json = PushServiceSocket.readBodyString(body);
        try {
            return JsonUtil.fromJson(json, clazz);
        }
        catch (JsonProcessingException e) {
            Log.w((String)TAG, (Throwable)e);
            throw new MalformedResponseException("Unable to parse entity", (IOException)((Object)e));
        }
        catch (IOException e) {
            throw new PushNetworkException(e);
        }
    }

    private static <T> T readResponseJson(Response response, Class<T> clazz) throws PushNetworkException, MalformedResponseException {
        return PushServiceSocket.readBodyJson(response.body(), clazz);
    }

    @Override
    public void close() {
        for (ServiceConnectionHolder holder : this.serviceClients) {
            holder.getClient().dispatcher().executorService().shutdown();
        }
        Iterator<ConnectionHolder[]> iterator = this.cdnClientsMap.values().iterator();
        while (iterator.hasNext()) {
            ConnectionHolder[] holders;
            for (ConnectionHolder holder : holders = (ConnectionHolder[])iterator.next()) {
                holder.getClient().dispatcher().executorService().shutdown();
            }
        }
        for (ConnectionHolder holder : this.storageClients) {
            holder.getClient().dispatcher().executorService().shutdown();
        }
    }

    public GroupResponse putNewGroupsV2Group(Group group, GroupsV2AuthorizationString authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        try (Response response = this.makeStorageRequest(authorization.toString(), GROUPSV2_GROUP, "PUT", PushServiceSocket.protobufRequestBody(group), GROUPS_V2_PUT_RESPONSE_HANDLER);){
            GroupResponse groupResponse = (GroupResponse)((Object)GroupResponse.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return groupResponse;
        }
    }

    public GroupResponse getGroupsV2Group(GroupsV2AuthorizationString authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        try (Response response = this.makeStorageRequest(authorization.toString(), GROUPSV2_GROUP, "GET", null, GROUPS_V2_GET_CURRENT_HANDLER);){
            GroupResponse groupResponse = (GroupResponse)((Object)GroupResponse.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return groupResponse;
        }
    }

    public AvatarUploadAttributes getGroupsV2AvatarUploadForm(String authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        try (Response response = this.makeStorageRequest(authorization, GROUPSV2_AVATAR_REQUEST, "GET", null, NO_HANDLER);){
            AvatarUploadAttributes avatarUploadAttributes = (AvatarUploadAttributes)((Object)AvatarUploadAttributes.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return avatarUploadAttributes;
        }
    }

    public GroupChangeResponse patchGroupsV2Group(GroupChange.Actions groupChange, String authorization, Optional<byte[]> groupLinkPassword) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        String path = groupLinkPassword.isPresent() ? String.format(GROUPSV2_GROUP_PASSWORD, Base64.encodeUrlSafeWithoutPadding((byte[])groupLinkPassword.get())) : GROUPSV2_GROUP;
        try (Response response = this.makeStorageRequest(authorization, path, "PATCH", PushServiceSocket.protobufRequestBody(groupChange), GROUPS_V2_PATCH_RESPONSE_HANDLER);){
            GroupChangeResponse groupChangeResponse = (GroupChangeResponse)((Object)GroupChangeResponse.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return groupChangeResponse;
        }
    }

    public GroupHistory getGroupHistory(int fromVersion, GroupsV2AuthorizationString authorization, int highestKnownEpoch, boolean includeFirstState, long sendEndorsementsExpirationMs) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Cached-Send-Endorsements", Long.toString(TimeUnit.MILLISECONDS.toSeconds(sendEndorsementsExpirationMs)));
        try (Response response = this.makeStorageRequest(authorization.toString(), String.format(Locale.US, GROUPSV2_GROUP_CHANGES, fromVersion, highestKnownEpoch, includeFirstState), "GET", null, headers, GROUPS_V2_GET_CURRENT_HANDLER);){
            if (response.body() == null) {
                throw new PushNetworkException("No body!");
            }
            GroupChanges groupChanges = (GroupChanges)((Object)GroupChanges.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            if (response.code() == 206) {
                String contentRangeHeader = response.header("Content-Range");
                Optional<ContentRange> contentRange = ContentRange.parse(contentRangeHeader);
                if (contentRange.isPresent()) {
                    Log.i((String)TAG, (String)("Additional logs for group: " + contentRangeHeader));
                    GroupHistory groupHistory = new GroupHistory(groupChanges, contentRange);
                    return groupHistory;
                }
                Log.w((String)TAG, (String)("Unable to parse Content-Range header: " + contentRangeHeader));
                throw new MalformedResponseException("Unable to parse content range header on 206");
            }
            GroupHistory groupHistory = new GroupHistory(groupChanges, Optional.empty());
            return groupHistory;
        }
    }

    public int getGroupJoinedAtRevision(GroupsV2AuthorizationString authorization) throws IOException {
        try (Response response = this.makeStorageRequest(authorization.toString(), GROUPSV2_JOINED_AT, "GET", null, GROUPS_V2_GET_CURRENT_HANDLER);){
            int n = ((Member)((Object)Member.ADAPTER.decode((byte[])PushServiceSocket.readBodyBytes((Response)response)))).joinedAtVersion;
            return n;
        }
    }

    public GroupJoinInfo getGroupJoinInfo(Optional<byte[]> groupLinkPassword, GroupsV2AuthorizationString authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        String passwordParam = groupLinkPassword.map(Base64::encodeUrlSafeWithoutPadding).orElse(AVATAR_UPLOAD_PATH);
        try (Response response = this.makeStorageRequest(authorization.toString(), String.format(GROUPSV2_GROUP_JOIN, passwordParam), "GET", null, GROUPS_V2_GET_JOIN_INFO_HANDLER);){
            GroupJoinInfo groupJoinInfo = (GroupJoinInfo)((Object)GroupJoinInfo.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return groupJoinInfo;
        }
    }

    public ExternalGroupCredential getExternalGroupCredential(GroupsV2AuthorizationString authorization) throws NonSuccessfulResponseCodeException, PushNetworkException, IOException, MalformedResponseException {
        try (Response response = this.makeStorageRequest(authorization.toString(), GROUPSV2_TOKEN, "GET", null, NO_HANDLER);){
            ExternalGroupCredential externalGroupCredential = (ExternalGroupCredential)((Object)ExternalGroupCredential.ADAPTER.decode(PushServiceSocket.readBodyBytes(response)));
            return externalGroupCredential;
        }
    }

    private static RegistrationSessionMetadataResponse parseSessionMetadataResponse(Response response) throws IOException {
        return PushServiceSocket.parseSessionMetadataResponse(response.body(), arg_0 -> ((Response)response).header(arg_0));
    }

    private static RegistrationSessionMetadataResponse parseSessionMetadataResponse(ResponseBody body, Function<String, String> getHeader) throws IOException {
        long retryAfterLong = Util.parseLong(getHeader.apply("Retry-After"), -1L);
        Long retryAfterMs = retryAfterLong != -1L ? Long.valueOf(TimeUnit.SECONDS.toMillis(retryAfterLong)) : null;
        RegistrationSessionMetadataJson responseBody = JsonUtil.fromJson(body.string(), RegistrationSessionMetadataJson.class);
        return new RegistrationSessionMetadataResponse(responseBody, System.currentTimeMillis(), retryAfterMs);
    }

    @Nonnull
    private static String urlEncode(@Nonnull String data) throws IOException {
        return URLEncoder.encode(data, StandardCharsets.UTF_8.name());
    }

    private static class ServiceConnectionHolder
    extends ConnectionHolder {
        private final OkHttpClient unidentifiedClient;

        private ServiceConnectionHolder(OkHttpClient identifiedClient, OkHttpClient unidentifiedClient, String url, Optional<String> hostHeader) {
            super(identifiedClient, url, hostHeader);
            this.unidentifiedClient = unidentifiedClient;
        }

        OkHttpClient getUnidentifiedClient() {
            return this.unidentifiedClient;
        }
    }

    private static class ConnectionHolder {
        private final OkHttpClient client;
        private final String url;
        private final Optional<String> hostHeader;

        private ConnectionHolder(OkHttpClient client, String url, Optional<String> hostHeader) {
            this.client = client;
            this.url = url;
            this.hostHeader = hostHeader;
        }

        OkHttpClient getClient() {
            return this.client;
        }

        public String getUrl() {
            return this.url;
        }

        Optional<String> getHostHeader() {
            return this.hostHeader;
        }
    }

    private static interface ResponseCodeHandler {
        public void handle(int var1, ResponseBody var2, Function<String, String> var3) throws NonSuccessfulResponseCodeException, PushNetworkException;
    }

    private static class RegistrationSessionResponseHandler
    implements ResponseCodeHandler {
        private RegistrationSessionResponseHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body, Function<String, String> getHeader) throws NonSuccessfulResponseCodeException, PushNetworkException {
            if (responseCode == 400) {
                throw new InvalidRegistrationSessionIdException();
            }
            if (responseCode == 403) {
                throw new IncorrectRegistrationRecoveryPasswordException();
            }
            if (responseCode == 404) {
                throw new NoSuchSessionException();
            }
            if (responseCode == 409) {
                RegistrationSessionMetadataResponse response;
                try {
                    response = PushServiceSocket.parseSessionMetadataResponse(body, getHeader);
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                    throw new NonSuccessfulResponseCodeException(409);
                }
                if (response.getMetadata().getVerified()) {
                    throw new AlreadyVerifiedException();
                }
                if (response.getMetadata().pushChallengedRequired() || response.getMetadata().captchaRequired()) {
                    throw new ChallengeRequiredException(response);
                }
                Log.i((String)TAG, (String)("Received 409 in reg session handler that is not verified, with required information: " + String.join((CharSequence)", ", response.getMetadata().getRequestedInformation())));
                throw new HttpConflictException();
            }
            if (responseCode == 502) {
                VerificationCodeFailureResponseBody response;
                try {
                    response = JsonUtil.fromJson(body.string(), VerificationCodeFailureResponseBody.class);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                    throw new NonSuccessfulResponseCodeException(responseCode);
                }
                throw new ExternalServiceFailureException(response.getPermanentFailure(), response.getReason());
            }
        }
    }

    private static class PatchRegistrationSessionResponseHandler
    implements ResponseCodeHandler {
        private PatchRegistrationSessionResponseHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body, Function<String, String> getHeader) throws NonSuccessfulResponseCodeException, PushNetworkException {
            switch (responseCode) {
                case 403: {
                    throw new TokenNotAcceptedException();
                }
                case 404: {
                    throw new NoSuchSessionException();
                }
                case 409: {
                    RegistrationSessionMetadataResponse response;
                    try {
                        response = PushServiceSocket.parseSessionMetadataResponse(body, getHeader);
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                        throw new NonSuccessfulResponseCodeException(409);
                    }
                    if (response.getMetadata().getVerified()) {
                        throw new AlreadyVerifiedException();
                    }
                    if (response.getMetadata().pushChallengedRequired() || response.getMetadata().captchaRequired()) {
                        throw new ChallengeRequiredException(response);
                    }
                    Log.i((String)TAG, (String)("Received 409 for patching reg session that is not verified, with required information: " + String.join((CharSequence)", ", response.getMetadata().getRequestedInformation())));
                    throw new HttpConflictException();
                }
            }
        }
    }

    public static enum VerificationCodeTransport {
        SMS,
        VOICE;

    }

    private static class RequestVerificationCodeResponseHandler
    implements ResponseCodeHandler {
        private RequestVerificationCodeResponseHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body, Function<String, String> getHeader) throws NonSuccessfulResponseCodeException {
            if (responseCode == 400) {
                throw new MalformedRequestException();
            }
            if (responseCode == 403) {
                throw new IncorrectRegistrationRecoveryPasswordException();
            }
            if (responseCode == 404) {
                throw new NoSuchSessionException();
            }
            if (responseCode == 409) {
                RegistrationSessionMetadataResponse response;
                try {
                    response = PushServiceSocket.parseSessionMetadataResponse(body, getHeader);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                    throw new NonSuccessfulResponseCodeException(409);
                }
                if (response.getMetadata().getVerified()) {
                    throw new AlreadyVerifiedException();
                }
                if (response.getMetadata().pushChallengedRequired() || response.getMetadata().captchaRequired()) {
                    throw new ChallengeRequiredException(response);
                }
                Log.i((String)TAG, (String)("Received 409 in for reg code request that is not verified, with required information: " + String.join((CharSequence)", ", response.getMetadata().getRequestedInformation())));
                throw new HttpConflictException();
            }
            if (responseCode == 418) {
                throw new InvalidTransportModeException();
            }
            if (responseCode == 429) {
                RegistrationSessionMetadataResponse response;
                try {
                    response = PushServiceSocket.parseSessionMetadataResponse(body, getHeader);
                }
                catch (IOException e) {
                    Log.w((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                    throw new NonSuccessfulResponseCodeException(429);
                }
                throw new RequestVerificationCodeRateLimitException(response);
            }
            if (responseCode == 440) {
                VerificationCodeFailureResponseBody response;
                try {
                    response = JsonUtil.fromJson(body.string(), VerificationCodeFailureResponseBody.class);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                    throw new NonSuccessfulResponseCodeException(responseCode);
                }
                throw new ExternalServiceFailureException(response.getPermanentFailure(), response.getReason());
            }
        }
    }

    private static class SubmitVerificationCodeResponseHandler
    implements ResponseCodeHandler {
        private SubmitVerificationCodeResponseHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body, Function<String, String> getHeader) throws NonSuccessfulResponseCodeException, PushNetworkException {
            switch (responseCode) {
                case 400: {
                    throw new InvalidTransportModeException();
                }
                case 404: {
                    throw new NoSuchSessionException();
                }
                case 409: {
                    RegistrationSessionMetadataJson sessionMetadata;
                    try {
                        sessionMetadata = JsonUtil.fromJson(body.string(), RegistrationSessionMetadataJson.class);
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                        throw new NonSuccessfulResponseCodeException(409);
                    }
                    if (sessionMetadata.getVerified()) {
                        throw new AlreadyVerifiedException();
                    }
                    if (sessionMetadata.getNextVerificationAttempt() == null) {
                        throw new MustRequestNewCodeException();
                    }
                    Log.i((String)TAG, (String)("Received 409 for reg code submission that is not verified, with required information: " + String.join((CharSequence)", ", sessionMetadata.getRequestedInformation())));
                    throw new HttpConflictException();
                }
                case 429: {
                    RegistrationSessionMetadataResponse response;
                    try {
                        response = PushServiceSocket.parseSessionMetadataResponse(body, getHeader);
                    }
                    catch (IOException e) {
                        Log.w((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                        throw new NonSuccessfulResponseCodeException(429);
                    }
                    throw new SubmitVerificationCodeRateLimitException(response);
                }
                case 440: {
                    VerificationCodeFailureResponseBody codeFailureResponse;
                    try {
                        codeFailureResponse = JsonUtil.fromJson(body.string(), VerificationCodeFailureResponseBody.class);
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"Unable to read response body.", (Throwable)e);
                        throw new NonSuccessfulResponseCodeException(responseCode);
                    }
                    throw new ExternalServiceFailureException(codeFailureResponse.getPermanentFailure(), codeFailureResponse.getReason());
                }
            }
        }
    }

    private final class ResumeInfo {
        private final String contentRange;
        private final long contentStart;

        private ResumeInfo(String contentRange, long offset) {
            this.contentRange = contentRange;
            this.contentStart = offset;
        }
    }

    public static class RegistrationLockFailure {
        @JsonProperty
        public int length;
        @JsonProperty
        public long timeRemaining;
        @JsonProperty(value="backupCredentials")
        public AuthCredentials svr1Credentials;
        @JsonProperty
        public AuthCredentials svr2Credentials;
        @JsonProperty
        public Svr3Credentials svr3Credentials;
    }

    public static final class GroupHistory {
        private final GroupChanges groupChanges;
        private final Optional<ContentRange> contentRange;

        public GroupHistory(GroupChanges groupChanges, Optional<ContentRange> contentRange) {
            this.groupChanges = groupChanges;
            this.contentRange = contentRange;
        }

        public GroupChanges getGroupChanges() {
            return this.groupChanges;
        }

        public boolean hasMore() {
            return this.contentRange.isPresent();
        }

        public int getNextPageStartGroupRevision() {
            return this.contentRange.get().getRangeEnd() + 1;
        }
    }

    private static class EmptyResponseCodeHandler
    implements ResponseCodeHandler {
        private EmptyResponseCodeHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body, Function<String, String> getHeader) {
        }
    }

    private static class UnopinionatedResponseCodeHandler
    implements ResponseCodeHandler {
        private UnopinionatedResponseCodeHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body, Function<String, String> getHeader) throws NonSuccessfulResponseCodeException, PushNetworkException {
            if (responseCode < 200 || responseCode > 299) {
                String bodyString = null;
                if (body != null) {
                    try {
                        bodyString = PushServiceSocket.readBodyString(body);
                    }
                    catch (MalformedResponseException e) {
                        Log.w((String)TAG, (String)"Failed to read body string", (Throwable)e);
                    }
                }
                throw new NonSuccessfulResponseCodeException(responseCode, "Response: " + responseCode, bodyString);
            }
        }
    }

    private static class UnopinionatedBinaryErrorResponseCodeHandler
    implements ResponseCodeHandler {
        private UnopinionatedBinaryErrorResponseCodeHandler() {
        }

        @Override
        public void handle(int responseCode, ResponseBody body, Function<String, String> getHeader) throws NonSuccessfulResponseCodeException, PushNetworkException {
            if (responseCode < 200 || responseCode > 299) {
                byte[] bodyBytes = null;
                if (body != null) {
                    bodyBytes = PushServiceSocket.readBodyBytes(body);
                }
                throw new NonSuccessfulResponseCodeException(responseCode, "Response: " + responseCode, bodyBytes);
            }
        }
    }

    public static class RegistrationLockV2 {
        @JsonProperty
        private String registrationLock;

        public RegistrationLockV2() {
        }

        public RegistrationLockV2(String registrationLock) {
            this.registrationLock = registrationLock;
        }
    }
}

