/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal;

import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.push.exceptions.PushNetworkException;
import org.whispersystems.signalservice.api.util.Preconditions;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

public final class ServiceResponse<Result> {
    private final int status;
    private final Optional<String> body;
    private final Optional<Result> result;
    private final Optional<Throwable> applicationError;
    private final Optional<Throwable> executionError;

    private ServiceResponse(Result result2, WebsocketResponse response) {
        this(response.getStatus(), response.getBody(), result2, null, null);
    }

    private ServiceResponse(Throwable applicationError, WebsocketResponse response) {
        this(response.getStatus(), response.getBody(), null, applicationError, null);
    }

    public ServiceResponse(int status, String body, Result result2, Throwable applicationError, Throwable executionError) {
        if (result2 != null) {
            Preconditions.checkArgument(applicationError == null && executionError == null);
        } else {
            Preconditions.checkArgument(applicationError != null || executionError != null);
        }
        this.status = status;
        this.body = Optional.ofNullable(body);
        this.result = Optional.ofNullable(result2);
        this.applicationError = Optional.ofNullable(applicationError);
        this.executionError = Optional.ofNullable(executionError);
    }

    public int getStatus() {
        return this.status;
    }

    public Optional<String> getBody() {
        return this.body;
    }

    public Optional<Result> getResult() {
        return this.result;
    }

    public Optional<Throwable> getApplicationError() {
        return this.applicationError;
    }

    public Optional<Throwable> getExecutionError() {
        return this.executionError;
    }

    public Single<Result> flattenResult() {
        if (this.result.isPresent()) {
            return Single.just(this.result.get());
        }
        if (this.applicationError.isPresent()) {
            return Single.error((Throwable)this.applicationError.get());
        }
        if (this.executionError.isPresent()) {
            return Single.error((Throwable)this.executionError.get());
        }
        return Single.error((Throwable)((Object)new AssertionError((Object)"Should never get here.")));
    }

    public NetworkResult<Result> toNetworkResult() {
        if (this.result.isPresent()) {
            return new NetworkResult.Success<Result>(this.result.get());
        }
        if (this.applicationError.isPresent()) {
            return new NetworkResult.ApplicationError(this.applicationError.get());
        }
        if (this.executionError.isPresent()) {
            Throwable error = this.executionError.get();
            if (error instanceof NonSuccessfulResponseCodeException) {
                return new NetworkResult.StatusCodeError((NonSuccessfulResponseCodeException)error);
            }
            if (error instanceof IOException) {
                return new NetworkResult.NetworkError((IOException)error);
            }
            return new NetworkResult.ApplicationError(error);
        }
        throw new AssertionError((Object)"Should never get here");
    }

    public Result getResultOrThrow() throws Throwable {
        if (this.result.isPresent()) {
            return this.result.get();
        }
        if (this.applicationError.isPresent()) {
            throw this.applicationError.get();
        }
        if (this.executionError.isPresent()) {
            throw this.executionError.get();
        }
        throw new AssertionError((Object)"Should never get here");
    }

    public static <T> ServiceResponse<T> forResult(T result2, WebsocketResponse response) {
        return new ServiceResponse<T>(result2, response);
    }

    public static <T> ServiceResponse<T> forResult(T result2, int status, String body) {
        return new ServiceResponse<T>(status, body, result2, null, null);
    }

    public static <T> ServiceResponse<T> forApplicationError(Throwable throwable, WebsocketResponse response) {
        return new ServiceResponse(throwable, response);
    }

    public static <T> ServiceResponse<T> forApplicationError(Throwable throwable, int status, String body) {
        return new ServiceResponse<Object>(status, body, null, throwable, null);
    }

    public static <T> ServiceResponse<T> forExecutionError(Throwable throwable) {
        return new ServiceResponse<Object>(0, null, null, null, throwable);
    }

    public static <T> ServiceResponse<T> forUnknownError(Throwable throwable) {
        if (throwable instanceof ExecutionException) {
            return ServiceResponse.forUnknownError(throwable.getCause());
        }
        if (throwable instanceof NonSuccessfulResponseCodeException) {
            return ServiceResponse.forApplicationError(throwable, ((NonSuccessfulResponseCodeException)throwable).code, null);
        }
        if (throwable instanceof PushNetworkException && throwable.getCause() != null) {
            return ServiceResponse.forUnknownError(throwable.getCause());
        }
        return ServiceResponse.forExecutionError(throwable);
    }

    public static <T, I> ServiceResponse<T> coerceError(ServiceResponse<I> response) {
        if (response.applicationError.isPresent()) {
            return ServiceResponse.forApplicationError(response.applicationError.get(), response.status, response.body.orElse(null));
        }
        return ServiceResponse.forExecutionError(response.executionError.orElse(null));
    }
}

