/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.websocket;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.kotlin.DisposableKt;
import io.reactivex.rxjava3.kotlin.SubscribersKt;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.OptionalExtensionsKt;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.net.BadRequestError;
import org.signal.libsignal.net.ChatConnection;
import org.signal.libsignal.net.RequestResult;
import org.signal.libsignal.net.UnauthenticatedChatConnection;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.messages.EnvelopeResponse;
import org.whispersystems.signalservice.api.util.SleepTimer;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.api.websocket.SignalWebSocketKt;
import org.whispersystems.signalservice.api.websocket.WebSocketConnectionState;
import org.whispersystems.signalservice.api.websocket.WebSocketFactory;
import org.whispersystems.signalservice.api.websocket.WebSocketUnavailableException;
import org.whispersystems.signalservice.internal.push.Envelope;
import org.whispersystems.signalservice.internal.websocket.WebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebSocketResponseMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 O2\u00020\u0001:\u0005OPQRSB)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010-\u001a\u00020\"J\u0006\u0010.\u001a\u00020\"J\u0006\u0010/\u001a\u00020\"J\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\u0012J\u000e\u00104\u001a\u00020\"2\u0006\u00103\u001a\u00020\u0012J\u0018\u00105\u001a\u00020\"2\u0010\u00106\u001a\f\u0012\u0004\u0012\u00020\"0!j\u0002`#J\u0014\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u00107\u001a\u00020:J#\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u00107\u001a\u00020:2\u0006\u0010;\u001a\u00020\t\u00a2\u0006\u0004\b<\u0010=J\u000e\u0010>\u001a\u00020\"2\u0006\u0010?\u001a\u00020@J(\u0010A\u001a\u0002HB\"\u0004\b\u0000\u0010B2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u0002HB0DH\u0086@\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u00020\u0010H\u0004J\b\u0010H\u001a\u00020\"H\u0002J\u0006\u0010I\u001a\u00020\"J\u000e\u0010J\u001a\u000201*\u0004\u0018\u00010\u0010H\u0002J\f\u0010K\u001a\u000201*\u00020:H\u0004J\f\u0010L\u001a\u000201*\u00020:H\u0004J\f\u0010M\u001a\u00020N*\u00020:H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\"0!j\u0002`#0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0018\u00010%R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u0082\u0001\u0002TU\u00a8\u0006V"}, d2={"Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket;", "", "connectionFactory", "Lorg/whispersystems/signalservice/api/websocket/WebSocketFactory;", "canConnect", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$CanConnect;", "sleepTimer", "Lorg/whispersystems/signalservice/api/util/SleepTimer;", "disconnectTimeout", "Lkotlin/time/Duration;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/WebSocketFactory;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$CanConnect;Lorg/whispersystems/signalservice/api/util/SleepTimer;J)V", "getSleepTimer", "()Lorg/whispersystems/signalservice/api/util/SleepTimer;", "J", "connection", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketConnection;", "connectionName", "", "getConnectionName", "()Ljava/lang/String;", "_state", "Lio/reactivex/rxjava3/subjects/BehaviorSubject;", "Lorg/whispersystems/signalservice/api/websocket/WebSocketConnectionState;", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "getDisposable", "()Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "setDisposable", "(Lio/reactivex/rxjava3/disposables/CompositeDisposable;)V", "keepAliveTokens", "", "keepAliveChangeListeners", "Lkotlin/Function0;", "", "Lorg/whispersystems/signalservice/api/websocket/Listener;", "delayedDisconnectThread", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$DelayedDisconnectThread;", "state", "Lio/reactivex/rxjava3/core/Observable;", "getState", "()Lio/reactivex/rxjava3/core/Observable;", "stateSnapshot", "getStateSnapshot", "()Lorg/whispersystems/signalservice/api/websocket/WebSocketConnectionState;", "connect", "disconnect", "sendKeepAlive", "shouldSendKeepAlives", "", "registerKeepAliveToken", "token", "removeKeepAliveToken", "addKeepAliveChangeListener", "listener", "request", "Lio/reactivex/rxjava3/core/Single;", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "timeout", "request-HG0u8IE", "(Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;J)Lio/reactivex/rxjava3/core/Single;", "sendAck", "response", "Lorg/whispersystems/signalservice/api/messages/EnvelopeResponse;", "runWithChatConnection", "T", "callback", "Lkotlin/Function1;", "Lorg/signal/libsignal/net/ChatConnection;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getWebSocket", "startDelayedDisconnectIfNecessary", "forceNewWebSocket", "isAlive", "isSignalServiceEnvelope", "isSocketEmptyRequest", "getWebSocketResponse", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketResponseMessage;", "Companion", "DelayedDisconnectThread", "UnauthenticatedWebSocket", "AuthenticatedWebSocket", "CanConnect", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nSignalWebSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignalWebSocket.kt\norg/whispersystems/signalservice/api/websocket/SignalWebSocket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,486:1\n1869#2,2:487\n1869#2,2:489\n1#3:491\n*S KotlinDebug\n*F\n+ 1 SignalWebSocket.kt\norg/whispersystems/signalservice/api/websocket/SignalWebSocket\n*L\n135#1:487,2\n147#1:489,2\n*E\n"})
public abstract class SignalWebSocket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebSocketFactory connectionFactory;
    @NotNull
    private final CanConnect canConnect;
    @NotNull
    private final SleepTimer sleepTimer;
    private final long disconnectTimeout;
    @Nullable
    private WebSocketConnection connection;
    @NotNull
    private final BehaviorSubject<WebSocketConnectionState> _state;
    @NotNull
    private CompositeDisposable disposable;
    @NotNull
    private final Set<String> keepAliveTokens;
    @NotNull
    private final Set<Function0<Unit>> keepAliveChangeListeners;
    @Nullable
    private DelayedDisconnectThread delayedDisconnectThread;
    @NotNull
    private final Observable<WebSocketConnectionState> state;
    @NotNull
    private static final String TAG = Log.tag((KClass)Reflection.getOrCreateKotlinClass(SignalWebSocket.class));
    @NotNull
    public static final String SERVER_DELIVERED_TIMESTAMP_HEADER = "X-Signal-Timestamp";
    @NotNull
    public static final String FOREGROUND_KEEPALIVE = "Foregrounded";

    private SignalWebSocket(WebSocketFactory connectionFactory, CanConnect canConnect, SleepTimer sleepTimer, long disconnectTimeout) {
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)canConnect, (String)"canConnect");
        Intrinsics.checkNotNullParameter((Object)sleepTimer, (String)"sleepTimer");
        this.connectionFactory = connectionFactory;
        this.canConnect = canConnect;
        this.sleepTimer = sleepTimer;
        this.disconnectTimeout = disconnectTimeout;
        BehaviorSubject behaviorSubject = BehaviorSubject.createDefault((Object)((Object)WebSocketConnectionState.DISCONNECTED));
        Intrinsics.checkNotNullExpressionValue((Object)behaviorSubject, (String)"createDefault(...)");
        this._state = behaviorSubject;
        this.disposable = new CompositeDisposable();
        this.keepAliveTokens = new CopyOnWriteArraySet();
        this.keepAliveChangeListeners = new CopyOnWriteArraySet();
        this.state = (Observable)this._state;
    }

    @NotNull
    public final SleepTimer getSleepTimer() {
        return this.sleepTimer;
    }

    @NotNull
    public final String getConnectionName() {
        Object object = this.connection;
        if (object == null || (object = object.getName()) == null) {
            object = "[null]";
        }
        return object;
    }

    @NotNull
    protected final CompositeDisposable getDisposable() {
        return this.disposable;
    }

    protected final void setDisposable(@NotNull CompositeDisposable compositeDisposable) {
        Intrinsics.checkNotNullParameter((Object)compositeDisposable, (String)"<set-?>");
        this.disposable = compositeDisposable;
    }

    @NotNull
    public final Observable<WebSocketConnectionState> getState() {
        return this.state;
    }

    @NotNull
    public final WebSocketConnectionState getStateSnapshot() {
        Object object = this._state.getValue();
        Intrinsics.checkNotNull((Object)object);
        return (WebSocketConnectionState)((Object)object);
    }

    public final synchronized void connect() throws WebSocketUnavailableException {
        this.getWebSocket();
    }

    public final synchronized void disconnect() {
        if (this.connection != null) {
            this.disposable.dispose();
            WebSocketConnection webSocketConnection = this.connection;
            Intrinsics.checkNotNull((Object)webSocketConnection);
            webSocketConnection.disconnect();
            this.connection = null;
            Object object = this._state.getValue();
            Intrinsics.checkNotNull((Object)object);
            if (!((WebSocketConnectionState)((Object)object)).isFailure()) {
                this._state.onNext((Object)WebSocketConnectionState.DISCONNECTED);
            }
        }
    }

    public final synchronized void sendKeepAlive() throws IOException {
        if (this.canConnect.canConnect()) {
            Log.v((String)TAG, (String)(this.getConnectionName() + " keepAliveTokens: " + this.keepAliveTokens));
            this.getWebSocket().sendKeepAlive();
        }
    }

    public final boolean shouldSendKeepAlives() {
        return !((Collection)this.keepAliveTokens).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerKeepAliveToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        boolean changed = this.keepAliveTokens.add(token);
        if (changed) {
            Log.v((String)TAG, (String)(this.getConnectionName() + " Adding keepAliveToken: " + token + ", current: " + this.keepAliveTokens));
        }
        SignalWebSocket signalWebSocket = this;
        synchronized (signalWebSocket) {
            boolean $i$a$-synchronized-SignalWebSocket$registerKeepAliveToken$22 = false;
            DelayedDisconnectThread delayedDisconnectThread = this.delayedDisconnectThread;
            if (delayedDisconnectThread != null) {
                delayedDisconnectThread.abort();
            }
            this.delayedDisconnectThread = null;
            if (this.canConnect.canConnect()) {
                try {
                    this.connect();
                }
                catch (WebSocketUnavailableException e) {
                    Log.w((String)TAG, (String)(this.getConnectionName() + " Keep alive requested, but connection not available"), (Throwable)e);
                }
            } else {
                Log.w((String)TAG, (String)(this.getConnectionName() + " Keep alive requested, but connection not available"));
            }
            Unit $i$a$-synchronized-SignalWebSocket$registerKeepAliveToken$22 = Unit.INSTANCE;
        }
        if (changed) {
            Iterable $this$forEach$iv = this.keepAliveChangeListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl = false;
                it.invoke();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeKeepAliveToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (this.keepAliveTokens.remove(token)) {
            Log.v((String)TAG, (String)(this.getConnectionName() + " Removing keepAliveToken: " + token + ", remaining: " + this.keepAliveTokens));
            SignalWebSocket signalWebSocket = this;
            synchronized (signalWebSocket) {
                boolean $i$a$-synchronized-SignalWebSocket$removeKeepAliveToken$22 = false;
                this.startDelayedDisconnectIfNecessary();
                Unit $i$a$-synchronized-SignalWebSocket$removeKeepAliveToken$22 = Unit.INSTANCE;
            }
        }
        Iterable $this$forEach$iv = this.keepAliveChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final void addKeepAliveChangeListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.keepAliveChangeListeners.add(listener);
    }

    @NotNull
    public final Single<WebsocketResponse> request(@NotNull WebSocketRequestMessage request2) {
        Single<WebsocketResponse> single;
        Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
        try {
            DelayedDisconnectThread delayedDisconnectThread = this.delayedDisconnectThread;
            if (delayedDisconnectThread != null) {
                delayedDisconnectThread.resetLastInteractionTime();
            }
            single = this.getWebSocket().sendRequest(request2);
        }
        catch (IOException e) {
            Single<WebsocketResponse> single2 = Single.error((Throwable)e);
            Intrinsics.checkNotNull((Object)single2);
            single = single2;
        }
        return single;
    }

    @NotNull
    public final Single<WebsocketResponse> request-HG0u8IE(@NotNull WebSocketRequestMessage request2, long timeout) {
        Single<WebsocketResponse> single;
        Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
        try {
            DelayedDisconnectThread delayedDisconnectThread = this.delayedDisconnectThread;
            if (delayedDisconnectThread != null) {
                delayedDisconnectThread.resetLastInteractionTime();
            }
            single = this.getWebSocket().sendRequest(request2, Duration.getInWholeSeconds-impl((long)timeout));
        }
        catch (IOException e) {
            Single<WebsocketResponse> single2 = Single.error((Throwable)e);
            Intrinsics.checkNotNull((Object)single2);
            single = single2;
        }
        return single;
    }

    public final void sendAck(@NotNull EnvelopeResponse response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.getWebSocket().sendResponse(this.getWebSocketResponse(response.getWebsocketRequest()));
    }

    @Nullable
    public final <T> Object runWithChatConnection(@NotNull Function1<? super ChatConnection, ? extends T> callback, @NotNull Continuation<? super T> $completion) {
        return this.getWebSocket().runWithChatConnection(callback, $completion);
    }

    @NotNull
    protected final synchronized WebSocketConnection getWebSocket() throws WebSocketUnavailableException {
        block5: {
            block4: {
                if (!this.canConnect.canConnect()) {
                    throw new WebSocketUnavailableException();
                }
                if (this.connection == null) break block4;
                WebSocketConnection webSocketConnection = this.connection;
                boolean bl = webSocketConnection != null ? webSocketConnection.isDead() : false;
                if (!bl) break block5;
            }
            this.disposable.dispose();
            this.disposable = new CompositeDisposable();
            WebSocketConnection newConnection = this.connectionFactory.createConnection();
            Observable observable = newConnection.connect().subscribeOn(Schedulers.io()).observeOn(Schedulers.io());
            Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"observeOn(...)");
            DisposableKt.addTo((Disposable)SubscribersKt.subscribeBy$default((Observable)observable, null, null, arg_0 -> SignalWebSocket.getWebSocket$lambda$4(this, arg_0), (int)3, null), (CompositeDisposable)this.disposable);
            this.connection = newConnection;
            this.startDelayedDisconnectIfNecessary();
        }
        WebSocketConnection webSocketConnection = this.connection;
        Intrinsics.checkNotNull((Object)webSocketConnection);
        return webSocketConnection;
    }

    /*
     * WARNING - void declaration
     */
    private final void startDelayedDisconnectIfNecessary() {
        if (this.isAlive(this.connection) && this.keepAliveTokens.isEmpty()) {
            void it;
            DelayedDisconnectThread delayedDisconnectThread;
            DelayedDisconnectThread delayedDisconnectThread2 = this.delayedDisconnectThread;
            if (delayedDisconnectThread2 != null) {
                delayedDisconnectThread2.abort();
            }
            DelayedDisconnectThread delayedDisconnectThread3 = delayedDisconnectThread = new DelayedDisconnectThread();
            SignalWebSocket signalWebSocket = this;
            boolean bl = false;
            it.start();
            signalWebSocket.delayedDisconnectThread = delayedDisconnectThread;
        }
    }

    public final synchronized void forceNewWebSocket() {
        Log.i((String)TAG, (String)(this.getConnectionName() + " Forcing new WebSocket, canConnect: " + this.canConnect.canConnect()));
        this.disconnect();
    }

    private final boolean isAlive(WebSocketConnection $this$isAlive) {
        WebSocketConnection webSocketConnection = $this$isAlive;
        return webSocketConnection != null ? !webSocketConnection.isDead() : false;
    }

    protected final boolean isSignalServiceEnvelope(@NotNull WebSocketRequestMessage $this$isSignalServiceEnvelope) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isSignalServiceEnvelope), (String)"<this>");
        return Intrinsics.areEqual((Object)"PUT", (Object)$this$isSignalServiceEnvelope.verb) && Intrinsics.areEqual((Object)"/api/v1/message", (Object)$this$isSignalServiceEnvelope.path);
    }

    protected final boolean isSocketEmptyRequest(@NotNull WebSocketRequestMessage $this$isSocketEmptyRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isSocketEmptyRequest), (String)"<this>");
        return Intrinsics.areEqual((Object)"PUT", (Object)$this$isSocketEmptyRequest.verb) && Intrinsics.areEqual((Object)"/api/v1/queue/empty", (Object)$this$isSocketEmptyRequest.path);
    }

    private final WebSocketResponseMessage getWebSocketResponse(WebSocketRequestMessage $this$getWebSocketResponse) {
        return this.isSignalServiceEnvelope($this$getWebSocketResponse) ? new WebSocketResponseMessage.Builder().id($this$getWebSocketResponse.id).status(200).message("OK").build() : new WebSocketResponseMessage.Builder().id($this$getWebSocketResponse.id).status(400).message("Unknown").build();
    }

    private static final Unit getWebSocket$lambda$4(SignalWebSocket this$0, WebSocketConnectionState it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0._state.onNext((Object)it);
        return Unit.INSTANCE;
    }

    public /* synthetic */ SignalWebSocket(WebSocketFactory connectionFactory, CanConnect canConnect, SleepTimer sleepTimer, long disconnectTimeout, DefaultConstructorMarker $constructor_marker) {
        this(connectionFactory, canConnect, sleepTimer, disconnectTimeout);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\tH\u0002J\f\u0010\u0015\u001a\u00020\u0014*\u00020\u0016H\u0002J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\t*\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket;", "connectionFactory", "Lorg/whispersystems/signalservice/api/websocket/WebSocketFactory;", "canConnect", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$CanConnect;", "sleepTimer", "Lorg/whispersystems/signalservice/api/util/SleepTimer;", "disconnectTimeoutMs", "", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/WebSocketFactory;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$CanConnect;Lorg/whispersystems/signalservice/api/util/SleepTimer;J)V", "readMessageBatch", "", "timeout", "batchSize", "", "callback", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket$MessageReceivedCallback;", "waitForSingleMessage", "Lorg/whispersystems/signalservice/api/messages/EnvelopeResponse;", "toEnvelopeResponse", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "findHeader", "(Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;)Ljava/lang/Long;", "MessageReceivedCallback", "signal-service-java"})
    public static final class AuthenticatedWebSocket
    extends SignalWebSocket {
        public AuthenticatedWebSocket(@NotNull WebSocketFactory connectionFactory, @NotNull CanConnect canConnect, @NotNull SleepTimer sleepTimer, long disconnectTimeoutMs) {
            Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
            Intrinsics.checkNotNullParameter((Object)canConnect, (String)"canConnect");
            Intrinsics.checkNotNullParameter((Object)sleepTimer, (String)"sleepTimer");
            super(connectionFactory, canConnect, sleepTimer, DurationKt.toDuration((long)disconnectTimeoutMs, (DurationUnit)DurationUnit.MILLISECONDS), null);
        }

        public final boolean readMessageBatch(long timeout, int batchSize, @NotNull MessageReceivedCallback callback) throws TimeoutException, WebSocketUnavailableException, IOException {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            List responses = new ArrayList();
            boolean hitEndOfQueue = false;
            EnvelopeResponse firstEnvelope = this.waitForSingleMessage(timeout);
            if (firstEnvelope != null) {
                responses.add(firstEnvelope);
            } else {
                hitEndOfQueue = true;
            }
            if (!hitEndOfQueue) {
                WebSocketRequestMessage request2;
                for (int i = 1; i < batchSize && (request2 = (WebSocketRequestMessage)((Object)OptionalExtensionsKt.orNull(this.getWebSocket().readRequestIfAvailable()))) != null; ++i) {
                    if (this.isSignalServiceEnvelope(request2)) {
                        responses.add(this.toEnvelopeResponse(request2));
                        continue;
                    }
                    if (!this.isSocketEmptyRequest(request2)) continue;
                    hitEndOfQueue = true;
                    break;
                }
            }
            if (responses.size() > 0) {
                callback.onMessageBatch(responses);
            }
            return !hitEndOfQueue;
        }

        private final EnvelopeResponse waitForSingleMessage(long timeout) throws TimeoutException, WebSocketUnavailableException, IOException {
            WebSocketRequestMessage request2;
            do {
                if (!this.isSignalServiceEnvelope(request2 = this.getWebSocket().readRequest(timeout))) continue;
                return this.toEnvelopeResponse(request2);
            } while (!this.isSocketEmptyRequest(request2));
            return null;
        }

        private final EnvelopeResponse toEnvelopeResponse(WebSocketRequestMessage $this$toEnvelopeResponse) throws IOException {
            Long timestamp = this.findHeader($this$toEnvelopeResponse);
            if (timestamp == null) {
                Log.w((String)TAG, (String)"Failed to parse X-Signal-Timestamp");
            }
            ByteString byteString = $this$toEnvelopeResponse.body;
            Intrinsics.checkNotNull((Object)byteString);
            Envelope envelope = (Envelope)((Object)Envelope.ADAPTER.decode(byteString.toByteArray()));
            Long l = timestamp;
            return new EnvelopeResponse(envelope, l != null ? l : 0L, $this$toEnvelopeResponse);
        }

        private final Long findHeader(WebSocketRequestMessage $this$findHeader) {
            if ($this$findHeader.headers.isEmpty()) {
                return null;
            }
            String string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findHeader.headers), AuthenticatedWebSocket::findHeader$lambda$0), AuthenticatedWebSocket::findHeader$lambda$1), AuthenticatedWebSocket::findHeader$lambda$2), AuthenticatedWebSocket::findHeader$lambda$3), AuthenticatedWebSocket::findHeader$lambda$4));
            return string != null ? StringsKt.toLongOrNull((String)string) : null;
        }

        private static final boolean findHeader$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return StringsKt.startsWith$default((String)it, (String)SignalWebSocket.SERVER_DELIVERED_TIMESTAMP_HEADER, (boolean)false, (int)2, null);
        }

        private static final List findHeader$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String[] stringArray = new String[]{":"};
            return StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean findHeader$lambda$2(List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            if (it.size() != 2) return false;
            String string = ((Object)StringsKt.trim((CharSequence)((String)it.get(0)))).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = SignalWebSocket.SERVER_DELIVERED_TIMESTAMP_HEADER.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)string2)) return false;
            return true;
        }

        private static final String findHeader$lambda$3(List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((Object)StringsKt.trim((CharSequence)((String)it.get(1)))).toString();
        }

        private static final boolean findHeader$lambda$4(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((CharSequence)it).length() > 0;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket$MessageReceivedCallback;", "", "onMessageBatch", "", "envelopeResponses", "", "Lorg/whispersystems/signalservice/api/messages/EnvelopeResponse;", "signal-service-java"})
        public static interface MessageReceivedCallback {
            public void onMessageBatch(@NotNull List<EnvelopeResponse> var1);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$CanConnect;", "", "canConnect", "", "signal-service-java"})
    public static interface CanConnect {
        public boolean canConnect();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$Companion;", "", "<init>", "()V", "TAG", "", "SERVER_DELIVERED_TIMESTAMP_HEADER", "FOREGROUND_KEEPALIVE", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u000b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$DelayedDisconnectThread;", "Ljava/lang/Thread;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket;)V", "abort", "", "lastInteractionTime", "Lkotlin/time/Duration;", "J", "", "resetLastInteractionTime", "run", "signal-service-java"})
    private final class DelayedDisconnectThread
    extends Thread {
        private boolean abort;
        private volatile long lastInteractionTime = Duration.Companion.getZERO-UwyO8pc();

        public final void abort() {
            if (!this.abort && this.isAlive()) {
                Log.v((String)TAG, (String)(SignalWebSocket.this.getConnectionName() + " Scheduled disconnect aborted."));
                this.abort = true;
                this.interrupt();
            }
        }

        public final void resetLastInteractionTime() {
            this.lastInteractionTime = DurationKt.toDuration((long)System.currentTimeMillis(), (DurationUnit)DurationUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            Duration.Companion companion = Duration.Companion;
            this.lastInteractionTime = DurationKt.toDuration((long)System.currentTimeMillis(), (DurationUnit)DurationUnit.MILLISECONDS);
            try {
                while (!this.abort) {
                    Duration.Companion companion2 = Duration.Companion;
                    if (Duration.compareTo-LRDsOJo((long)Duration.plus-LRDsOJo((long)this.lastInteractionTime, (long)SignalWebSocket.this.disconnectTimeout), (long)DurationKt.toDuration((long)System.currentTimeMillis(), (DurationUnit)DurationUnit.MILLISECONDS)) > 0) {
                        long sleepDuration;
                        long now = DurationKt.toDuration((long)System.currentTimeMillis(), (DurationUnit)DurationUnit.MILLISECONDS);
                        if (Duration.compareTo-LRDsOJo((long)this.lastInteractionTime, (long)now) > 0) {
                            this.lastInteractionTime = now;
                        }
                        if (!Duration.isPositive-impl((long)(sleepDuration = Duration.minus-LRDsOJo((long)Duration.plus-LRDsOJo((long)this.lastInteractionTime, (long)SignalWebSocket.this.disconnectTimeout), (long)now)))) continue;
                        Log.v((String)TAG, (String)(SignalWebSocket.this.getConnectionName() + " Disconnect scheduled in " + Duration.toString-impl((long)sleepDuration)));
                        SignalWebSocket.this.getSleepTimer().sleep(Duration.getInWholeMilliseconds-impl((long)sleepDuration));
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.abort && !SignalWebSocket.this.shouldSendKeepAlives()) {
                SignalWebSocket.this.disconnect();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012JV\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u00150\u0014\"\u0004\b\u0000\u0010\u0016\"\b\b\u0001\u0010\u0017*\u00020\u00182$\u0010\u0019\u001a \u0012\u0004\u0012\u00020\u001b\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00170\u00150\u00140\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket;", "connectionFactory", "Lorg/whispersystems/signalservice/api/websocket/WebSocketFactory;", "canConnect", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$CanConnect;", "sleepTimer", "Lorg/whispersystems/signalservice/api/util/SleepTimer;", "disconnectTimeoutMs", "", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/WebSocketFactory;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$CanConnect;Lorg/whispersystems/signalservice/api/util/SleepTimer;J)V", "request", "Lio/reactivex/rxjava3/core/Single;", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "requestMessage", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "sealedSenderAccess", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "runCatchingWithUnauthChatConnection", "Lorg/signal/libsignal/internal/CompletableFuture;", "Lorg/signal/libsignal/net/RequestResult;", "Result", "Error", "Lorg/signal/libsignal/net/BadRequestError;", "callback", "Lkotlin/Function1;", "Lorg/signal/libsignal/net/UnauthenticatedChatConnection;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "signal-service-java"})
    public static final class UnauthenticatedWebSocket
    extends SignalWebSocket {
        public UnauthenticatedWebSocket(@NotNull WebSocketFactory connectionFactory, @NotNull CanConnect canConnect, @NotNull SleepTimer sleepTimer, long disconnectTimeoutMs) {
            Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
            Intrinsics.checkNotNullParameter((Object)canConnect, (String)"canConnect");
            Intrinsics.checkNotNullParameter((Object)sleepTimer, (String)"sleepTimer");
            super(connectionFactory, canConnect, sleepTimer, DurationKt.toDuration((long)disconnectTimeoutMs, (DurationUnit)DurationUnit.MILLISECONDS), null);
        }

        @NotNull
        public final Single<WebsocketResponse> request(@NotNull WebSocketRequestMessage requestMessage, @NotNull SealedSenderAccess sealedSenderAccess) {
            Intrinsics.checkNotNullParameter((Object)((Object)requestMessage), (String)"requestMessage");
            Intrinsics.checkNotNullParameter((Object)sealedSenderAccess, (String)"sealedSenderAccess");
            List headers = CollectionsKt.toMutableList((Collection)requestMessage.headers);
            if (sealedSenderAccess.applyHeader()) {
                headers.add(sealedSenderAccess.getHeader());
            }
            WebSocketRequestMessage message = requestMessage.newBuilder().headers(headers).build();
            try {
                Single single = this.request(message).flatMap(new Function(sealedSenderAccess, this, requestMessage){
                    final /* synthetic */ SealedSenderAccess $sealedSenderAccess;
                    final /* synthetic */ UnauthenticatedWebSocket this$0;
                    final /* synthetic */ WebSocketRequestMessage $requestMessage;
                    {
                        this.$sealedSenderAccess = $sealedSenderAccess;
                        this.this$0 = $receiver;
                        this.$requestMessage = $requestMessage;
                    }

                    public final SingleSource<? extends WebsocketResponse> apply(WebsocketResponse response) {
                        SealedSenderAccess fallback;
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        if (response.getStatus() == 401 && (fallback = this.$sealedSenderAccess.switchToFallback()) != null) {
                            return (SingleSource)this.this$0.request(this.$requestMessage, fallback);
                        }
                        return (SingleSource)Single.just((Object)response);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
                return single;
            }
            catch (IOException e) {
                Single single = Single.error((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)single, (String)"error(...)");
                return single;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final <Result, Error extends BadRequestError> Object runCatchingWithUnauthChatConnection(@NotNull Function1<? super UnauthenticatedChatConnection, ? extends CompletableFuture<RequestResult<Result, Error>>> var1_1, @NotNull Continuation<? super CompletableFuture<RequestResult<Result, Error>>> $completion) {
            if (!($completion instanceof runCatchingWithUnauthChatConnection.1)) ** GOTO lbl-1000
            var7_3 = $completion;
            if ((var7_3.label & -2147483648) != 0) {
                var7_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ UnauthenticatedWebSocket this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.runCatchingWithUnauthChatConnection(null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = this.getWebSocket().runWithChatConnection((Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, runCatchingWithUnauthChatConnection$lambda$0(kotlin.jvm.functions.Function1 org.signal.libsignal.net.ChatConnection ), (Lorg/signal/libsignal/net/ChatConnection;)Lorg/signal/libsignal/internal/CompletableFuture;)((Function1)callback), $continuation);
                    ** if (v0 != var8_5) goto lbl18
lbl17:
                    // 1 sources

                    return var8_5;
lbl18:
                    // 1 sources

                    ** GOTO lbl24
                }
                case 1: {
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        var4_6 = (CompletableFuture)v0;
                    }
                    catch (Throwable throwable) {
                        v1 = CompletableFuture.completedFuture((Object)SignalWebSocketKt.access$toNetworkRequestResult(throwable));
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"completedFuture(...)");
                        return v1;
                    }
                    requestFuture = var4_6;
                    v2 = requestFuture.handle((BiFunction<Object, Throwable, RequestResult>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, runCatchingWithUnauthChatConnection$lambda$2(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Throwable ), (Ljava/lang/Object;Ljava/lang/Throwable;)Lorg/signal/libsignal/net/RequestResult;)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, runCatchingWithUnauthChatConnection$lambda$1(org.signal.libsignal.net.RequestResult java.lang.Throwable ), (Lorg/signal/libsignal/net/RequestResult;Ljava/lang/Throwable;)Lorg/signal/libsignal/net/RequestResult;)()));
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"handle(...)");
                    return v2;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private static final CompletableFuture runCatchingWithUnauthChatConnection$lambda$0(Function1 $callback, ChatConnection chatConnection) {
            Intrinsics.checkNotNullParameter((Object)chatConnection, (String)"chatConnection");
            UnauthenticatedChatConnection unauthenticatedChatConnection = chatConnection instanceof UnauthenticatedChatConnection ? (UnauthenticatedChatConnection)chatConnection : null;
            if (unauthenticatedChatConnection == null) {
                throw new IllegalStateException("Expected unauthenticated chat connection but got " + chatConnection.getClass().getSimpleName());
            }
            UnauthenticatedChatConnection unauthenticatedConnection = unauthenticatedChatConnection;
            return (CompletableFuture)$callback.invoke((Object)unauthenticatedConnection);
        }

        private static final RequestResult runCatchingWithUnauthChatConnection$lambda$1(RequestResult result2, Throwable throwable) {
            RequestResult requestResult;
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                requestResult = SignalWebSocketKt.access$toNetworkRequestResult(throwable2);
            } else {
                requestResult = result2;
                if (requestResult == null) {
                    requestResult = (RequestResult)new RequestResult.ApplicationError((Throwable)new IllegalStateException("RequestResult was null"));
                }
            }
            return requestResult;
        }

        private static final RequestResult runCatchingWithUnauthChatConnection$lambda$2(Function2 $tmp0, Object p0, Throwable p1) {
            return (RequestResult)$tmp0.invoke(p0, (Object)p1);
        }
    }
}

