/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.username;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.signal.core.models.ServiceId;
import org.signal.core.util.Base64;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.net.RequestResult;
import org.signal.libsignal.net.RequestResultKt;
import org.signal.libsignal.net.UnauthUsernamesService;
import org.signal.libsignal.net.UnauthenticatedChatConnection;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.usernames.Username;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.username.UsernameApi;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.GetUsernameFromLinkResponseBody;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/whispersystems/signalservice/api/username/UsernameApi;", "", "unauthWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;)V", "getAciByUsername", "Lorg/signal/libsignal/net/RequestResult;", "Lorg/signal/core/models/ServiceId$ACI;", "", "username", "Lorg/signal/libsignal/usernames/Username;", "getEncryptedUsernameFromLinkServerId", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "serverId", "Ljava/util/UUID;", "signal-service-java"})
public final class UsernameApi {
    @NotNull
    private final SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket;

    public UsernameApi(@NotNull SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket) {
        Intrinsics.checkNotNullParameter((Object)unauthWebSocket, (String)"unauthWebSocket");
        this.unauthWebSocket = unauthWebSocket;
    }

    @NotNull
    public final RequestResult getAciByUsername(@NotNull Username username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        return (RequestResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super RequestResult>, Object>(this, username, null){
            int label;
            final /* synthetic */ UsernameApi this$0;
            final /* synthetic */ Username $username;
            {
                this.this$0 = $receiver;
                this.$username = $username;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = UsernameApi.access$getUnauthWebSocket$p(this.this$0).runCatchingWithUnauthChatConnection(arg_0 -> getAciByUsername.1.invokeSuspend$lambda$0(this.$username, arg_0), (Continuation)this);
                        if (object3 != object2) return RequestResultKt.getOrError((CompletableFuture)((CompletableFuture)object3)).map(getAciByUsername.1::invokeSuspend$lambda$2);
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return RequestResultKt.getOrError((CompletableFuture)((CompletableFuture)object3)).map(getAciByUsername.1::invokeSuspend$lambda$2);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super RequestResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final CompletableFuture invokeSuspend$lambda$0(Username $username, UnauthenticatedChatConnection chatConnection) {
                UnauthUsernamesService unauthUsernamesService = new UnauthUsernamesService(chatConnection);
                byte[] byArray = $username.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getHash(...)");
                return unauthUsernamesService.lookUpUsernameHash(byArray);
            }

            private static final ServiceId.ACI invokeSuspend$lambda$2(ServiceId.Aci it) {
                ServiceId.ACI aCI;
                ServiceId.Aci aci = it;
                if (aci != null) {
                    ServiceId.Aci it2 = aci;
                    boolean bl = false;
                    aCI = ServiceId.ACI.Companion.fromLibSignal(it2);
                } else {
                    aCI = null;
                }
                return aCI;
            }
        }), (int)1, null);
    }

    @NotNull
    public final NetworkResult<byte[]> getEncryptedUsernameFromLinkServerId(@NotNull UUID serverId) {
        Intrinsics.checkNotNullParameter((Object)serverId, (String)"serverId");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/accounts/username_link/" + serverId, null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(GetUsernameFromLinkResponseBody.class), 0L, 8, null).map(UsernameApi::getEncryptedUsernameFromLinkServerId$lambda$0);
    }

    private static final byte[] getEncryptedUsernameFromLinkServerId$lambda$0(GetUsernameFromLinkResponseBody it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Base64.decode((String)it.getUsernameLinkEncryptedValue());
    }

    public static final /* synthetic */ SignalWebSocket.UnauthenticatedWebSocket access$getUnauthWebSocket$p(UsernameApi $this) {
        return $this.unauthWebSocket;
    }
}

