/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.svr;

import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.Hex;
import org.signal.libsignal.attest.AttestationDataException;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.sgxsession.SgxCommunicationFailureException;
import org.signal.libsignal.svr2.Svr2Client;
import org.signal.svr2.proto.Request;
import org.whispersystems.signalservice.api.SignalUrlExtensionsKt;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.configuration.SignalSvr2Url;
import org.whispersystems.signalservice.internal.configuration.SignalUrl;
import org.whispersystems.signalservice.internal.push.AuthCredentials;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0003\u0012\u0013\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2Socket;", "", "configuration", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;", "mrEnclave", "", "<init>", "(Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;Ljava/lang/String;)V", "svr2Url", "Lorg/whispersystems/signalservice/internal/configuration/SignalSvr2Url;", "okhttp", "Lokhttp3/OkHttpClient;", "makeRequest", "Lorg/signal/svr2/proto/Response;", "authorization", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "clientRequest", "Lorg/signal/svr2/proto/Request;", "SvrWebSocketListener", "Stage", "Companion", "signal-service-java"})
public final class Svr2Socket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mrEnclave;
    @NotNull
    private final SignalSvr2Url svr2Url;
    @NotNull
    private final OkHttpClient okhttp;
    private static final String TAG = Svr2Socket.class.getSimpleName();

    public Svr2Socket(@NotNull SignalServiceConfiguration configuration, @NotNull String mrEnclave) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)mrEnclave, (String)"mrEnclave");
        this.mrEnclave = mrEnclave;
        this.svr2Url = (SignalSvr2Url)SignalUrlExtensionsKt.chooseUrl((SignalUrl[])configuration.getSignalSvr2Urls());
        this.okhttp = SignalUrlExtensionsKt.buildOkHttpClient((SignalUrl)this.svr2Url, configuration);
    }

    @NotNull
    public final org.signal.svr2.proto.Response makeRequest(@NotNull AuthCredentials authorization, @NotNull Request clientRequest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)((Object)clientRequest), (String)"clientRequest");
        Request.Builder builder = new Request.Builder().url(this.svr2Url.getUrl() + "/v1/" + this.mrEnclave);
        String string = authorization.asBasic();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asBasic(...)");
        Request.Builder openRequest = builder.addHeader("Authorization", string);
        if (this.svr2Url.getHostHeader().isPresent()) {
            String string2 = this.svr2Url.getHostHeader().get();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
            openRequest.addHeader("Host", string2);
            Log.w((String)TAG, (String)("Using alternate host: " + this.svr2Url.getHostHeader().get()));
        }
        SvrWebSocketListener listener = new SvrWebSocketListener(this.mrEnclave, clientRequest);
        this.okhttp.newWebSocket(openRequest.build(), (WebSocketListener)listener);
        return listener.blockAndWaitForResult();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2Socket$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2Socket$Stage;", "", "<init>", "(Ljava/lang/String;I)V", "WAITING_TO_INITIALIZE", "WAITING_FOR_CONNECTION", "WAITING_FOR_HANDSHAKE", "WAITING_FOR_RESPONSE", "CLOSED", "FAILED", "signal-service-java"})
    private static final class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage WAITING_TO_INITIALIZE = new Stage();
        public static final /* enum */ Stage WAITING_FOR_CONNECTION = new Stage();
        public static final /* enum */ Stage WAITING_FOR_HANDSHAKE = new Stage();
        public static final /* enum */ Stage WAITING_FOR_RESPONSE = new Stage();
        public static final /* enum */ Stage CLOSED = new Stage();
        public static final /* enum */ Stage FAILED = new Stage();
        private static final /* synthetic */ Stage[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String value) {
            return Enum.valueOf(Stage.class, value);
        }

        @NotNull
        public static EnumEntries<Stage> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stageArray = new Stage[]{Stage.WAITING_TO_INITIALIZE, Stage.WAITING_FOR_CONNECTION, Stage.WAITING_FOR_HANDSHAKE, Stage.WAITING_FOR_RESPONSE, Stage.CLOSED, Stage.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\"\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0018H\u0016J\u0006\u0010#\u001a\u00020\u0011J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/whispersystems/signalservice/api/svr/Svr2Socket$SvrWebSocketListener;", "Lokhttp3/WebSocketListener;", "mrEnclave", "", "clientRequest", "Lorg/signal/svr2/proto/Request;", "<init>", "(Ljava/lang/String;Lorg/signal/svr2/proto/Request;)V", "stage", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/whispersystems/signalservice/api/svr/Svr2Socket$Stage;", "kotlin.jvm.PlatformType", "client", "Lorg/signal/libsignal/svr2/Svr2Client;", "latch", "Ljava/util/concurrent/CountDownLatch;", "response", "Lorg/signal/svr2/proto/Response;", "exception", "Ljava/io/IOException;", "onOpen", "", "webSocket", "Lokhttp3/WebSocket;", "Lokhttp3/Response;", "onMessage", "bytes", "Lokio/ByteString;", "onClosing", "code", "", "reason", "onFailure", "t", "", "blockAndWaitForResult", "emitSuccess", "result", "emitError", "", "e", "signal-service-java"})
    @SourceDebugExtension(value={"SMAP\nSvr2Socket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Svr2Socket.kt\norg/whispersystems/signalservice/api/svr/Svr2Socket$SvrWebSocketListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
    private static final class SvrWebSocketListener
    extends WebSocketListener {
        @NotNull
        private final String mrEnclave;
        @NotNull
        private final Request clientRequest;
        @NotNull
        private final AtomicReference<Stage> stage;
        private Svr2Client client;
        @NotNull
        private final CountDownLatch latch;
        @Nullable
        private org.signal.svr2.proto.Response response;
        @Nullable
        private IOException exception;

        public SvrWebSocketListener(@NotNull String mrEnclave, @NotNull Request clientRequest) {
            Intrinsics.checkNotNullParameter((Object)mrEnclave, (String)"mrEnclave");
            Intrinsics.checkNotNullParameter((Object)((Object)clientRequest), (String)"clientRequest");
            this.mrEnclave = mrEnclave;
            this.clientRequest = clientRequest;
            this.stage = new AtomicReference<Stage>(Stage.WAITING_TO_INITIALIZE);
            this.latch = new CountDownLatch(1);
        }

        public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Log.d((String)TAG, (String)"[onOpen]");
            this.stage.set(Stage.WAITING_FOR_CONNECTION);
        }

        public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Log.d((String)TAG, (String)("[onMessage] stage: " + (Object)((Object)this.stage.get())));
            try {
                Stage stage = this.stage.get();
                Intrinsics.checkNotNull((Object)((Object)stage));
                switch (WhenMappings.$EnumSwitchMapping$0[stage.ordinal()]) {
                    case 1: {
                        throw new IOException("Received a message before we were open!");
                    }
                    case 2: {
                        byte[] byArray = Hex.fromStringCondensed((String)this.mrEnclave);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"fromStringCondensed(...)");
                        byte[] mrEnclave = byArray;
                        this.client = new Svr2Client(mrEnclave, bytes.toByteArray(), Instant.now());
                        Log.d((String)TAG, (String)"[onMessage] Sending initial handshake...");
                        Svr2Client svr2Client = this.client;
                        if (svr2Client == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            svr2Client = null;
                        }
                        byte[] byArray2 = svr2Client.initialRequest();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"initialRequest(...)");
                        webSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray2, (int)0, (int)0, (int)3, null));
                        this.stage.set(Stage.WAITING_FOR_HANDSHAKE);
                        break;
                    }
                    case 3: {
                        Svr2Client svr2Client = this.client;
                        if (svr2Client == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            svr2Client = null;
                        }
                        svr2Client.completeHandshake(bytes.toByteArray());
                        Log.d((String)TAG, (String)"[onMessage] Handshake read success. Sending request...");
                        Svr2Client svr2Client2 = this.client;
                        if (svr2Client2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            svr2Client2 = null;
                        }
                        byte[] ciphertextBytes = svr2Client2.establishedSend(this.clientRequest.encode());
                        Intrinsics.checkNotNull((Object)ciphertextBytes);
                        webSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])ciphertextBytes, (int)0, (int)0, (int)3, null));
                        Log.d((String)TAG, (String)"[onMessage] Request sent.");
                        this.stage.set(Stage.WAITING_FOR_RESPONSE);
                        break;
                    }
                    case 4: {
                        Log.d((String)TAG, (String)"[onMessage] Received response for our request.");
                        Svr2Client svr2Client = this.client;
                        if (svr2Client == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                            svr2Client = null;
                        }
                        byte[] byArray = svr2Client.establishedRecv(bytes.toByteArray());
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"establishedRecv(...)");
                        this.emitSuccess((org.signal.svr2.proto.Response)((Object)org.signal.svr2.proto.Response.ADAPTER.decode(byArray)));
                        Log.d((String)TAG, (String)"[onMessage] Success! Closing.");
                        webSocket.close(1000, "OK");
                        break;
                    }
                    case 5: {
                        Log.w((String)TAG, (String)"[onMessage] Received a message after the websocket closed! Ignoring.");
                        break;
                    }
                    case 6: {
                        Log.w((String)TAG, (String)"[onMessage] Received a message after we entered the failure state! Ignoring.");
                        webSocket.close(1000, "OK");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
                webSocket.close(1000, "OK");
                this.emitError(e);
            }
            catch (AttestationDataException e) {
                Log.w((String)TAG, (Throwable)e);
                webSocket.close(1007, "OK");
                this.emitError(new IOException(e));
            }
            catch (SgxCommunicationFailureException e) {
                Log.w((String)TAG, (Throwable)e);
                webSocket.close(1000, "OK");
                this.emitError(new IOException(e));
            }
        }

        public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Log.i((String)TAG, (String)("[onClosing] code: " + code + ", reason: " + reason));
            if (code == 1000) {
                this.emitError(new IOException("Websocket was closed with code 1000"));
                this.stage.set(Stage.CLOSED);
            } else {
                Log.w((String)TAG, (String)("Remote side is closing with non-normal code " + code));
                webSocket.close(1000, "Remote closed with code " + code);
                this.stage.set(Stage.FAILED);
                this.emitError(new NonSuccessfulResponseCodeException(code));
            }
        }

        public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
            IOException exception;
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            String string = t.getMessage();
            IOException iOException = exception = (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"404", (boolean)false, (int)2, null) : false) ? (IOException)new NonSuccessfulResponseCodeException(404) : new IOException(t);
            if (this.emitError(exception)) {
                Log.w((String)TAG, (String)("[onFailure] response? " + (response != null)), (Throwable)t);
                this.stage.set(Stage.FAILED);
                webSocket.close(1000, "OK");
            }
        }

        @NotNull
        public final org.signal.svr2.proto.Response blockAndWaitForResult() throws IOException {
            this.latch.await();
            IOException iOException = this.exception;
            if (iOException != null) {
                IOException it = iOException;
                boolean bl = false;
                throw it;
            }
            org.signal.svr2.proto.Response response = this.response;
            if (response != null) {
                org.signal.svr2.proto.Response it = response;
                boolean bl = false;
                return it;
            }
            throw new IllegalStateException("Neither the response nor exception were set!");
        }

        private final void emitSuccess(org.signal.svr2.proto.Response result2) {
            this.response = result2;
            this.latch.countDown();
        }

        private final boolean emitError(IOException e) {
            boolean isFirstError;
            boolean bl = isFirstError = this.exception == null;
            if (isFirstError) {
                this.exception = e;
            }
            this.latch.countDown();
            return isFirstError;
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Stage.values().length];
                try {
                    nArray[Stage.WAITING_TO_INITIALIZE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.WAITING_FOR_CONNECTION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.WAITING_FOR_HANDSHAKE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.WAITING_FOR_RESPONSE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.CLOSED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Stage.FAILED.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

