/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.svr;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.MasterKey;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.net.Network;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.svr.SecureValueRecovery;
import org.whispersystems.signalservice.api.svr.Svr3Credentials;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.ByteArrayDeserializerBase64;
import org.whispersystems.signalservice.internal.push.ByteArraySerializerBase64NoPadding;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0003#$%B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\b\u0010 \u001a\u00020\u000fH\u0016J\"\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\"\u001a\u00020\u0017*\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3;", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery;", "network", "Lorg/signal/libsignal/net/Network;", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "<init>", "(Lorg/signal/libsignal/net/Network;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;)V", "svrVersion", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$SvrVersion;", "getSvrVersion", "()Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$SvrVersion;", "setPin", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$PinChangeSession;", "userPin", "", "masterKey", "Lorg/signal/core/models/MasterKey;", "resumePinChangeSession", "serializedChangeSession", "restoreDataPreRegistration", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$RestoreResponse;", "authorization", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "shareSet", "", "restoreDataPostRegistration", "deleteData", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$DeleteResponse;", "svr3Authorization", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/api/svr/Svr3Credentials;", "toString", "restoreData", "toAuthCredential", "Companion", "Svr3PinChangeSession", "Svr3SessionData", "signal-service-java"})
public final class SecureValueRecoveryV3
implements SecureValueRecovery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Network network;
    @Nullable
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final SecureValueRecovery.SvrVersion svrVersion;
    @NotNull
    private static final String TAG = Log.tag((KClass)Reflection.getOrCreateKotlinClass(SecureValueRecoveryV3.class));

    public SecureValueRecoveryV3(@NotNull Network network, @Nullable SignalWebSocket.AuthenticatedWebSocket authWebSocket) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        this.network = network;
        this.authWebSocket = authWebSocket;
        this.svrVersion = SecureValueRecovery.SvrVersion.SVR3;
    }

    @Override
    @NotNull
    public SecureValueRecovery.SvrVersion getSvrVersion() {
        return this.svrVersion;
    }

    @Override
    @NotNull
    public SecureValueRecovery.PinChangeSession setPin(@NotNull String userPin, @NotNull MasterKey masterKey) {
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        return new Svr3PinChangeSession(userPin, masterKey, null);
    }

    @Override
    @NotNull
    public SecureValueRecovery.PinChangeSession resumePinChangeSession(@NotNull String userPin, @NotNull MasterKey masterKey, @NotNull String serializedChangeSession) {
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        Intrinsics.checkNotNullParameter((Object)serializedChangeSession, (String)"serializedChangeSession");
        Svr3SessionData svr3SessionData = JsonUtil.fromJson(serializedChangeSession, Svr3SessionData.class);
        Intrinsics.checkNotNullExpressionValue((Object)svr3SessionData, (String)"fromJson(...)");
        Svr3SessionData data = svr3SessionData;
        return Intrinsics.areEqual((Object)data.getUserPin(), (Object)userPin) && Intrinsics.areEqual((Object)data.getMasterKey(), (Object)masterKey) ? (SecureValueRecovery.PinChangeSession)new Svr3PinChangeSession(userPin, masterKey, data.getShareSet()) : (SecureValueRecovery.PinChangeSession)new Svr3PinChangeSession(userPin, masterKey, null);
    }

    @Override
    @NotNull
    public SecureValueRecovery.RestoreResponse restoreDataPreRegistration(@NotNull AuthCredentials authorization, @Nullable byte[] shareSet, @NotNull String userPin) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        return this.restoreData(authorization, shareSet, userPin);
    }

    @Override
    @NotNull
    public SecureValueRecovery.RestoreResponse restoreDataPostRegistration(@NotNull String userPin) {
        Svr3Credentials svr3Credentials;
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        try {
            svr3Credentials = this.svr3Authorization().successOrThrow();
        }
        catch (NonSuccessfulResponseCodeException e) {
            return new SecureValueRecovery.RestoreResponse.ApplicationError(e);
        }
        catch (IOException e) {
            return new SecureValueRecovery.RestoreResponse.NetworkError(e);
        }
        catch (Exception e) {
            return new SecureValueRecovery.RestoreResponse.ApplicationError(e);
        }
        Svr3Credentials authorization = svr3Credentials;
        return this.restoreData(this.toAuthCredential(authorization), authorization.getShareSet(), userPin);
    }

    @Override
    @NotNull
    public SecureValueRecovery.DeleteResponse deleteData() {
        throw new UnsupportedOperationException("SVR3 disabled for now");
    }

    @Override
    @NotNull
    public AuthCredentials authorization() throws IOException {
        return this.toAuthCredential(this.svr3Authorization().successOrThrow());
    }

    private final NetworkResult<Svr3Credentials> svr3Authorization() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v3/backup/auth", null, 2, null);
        SignalWebSocket.AuthenticatedWebSocket authenticatedWebSocket = this.authWebSocket;
        Intrinsics.checkNotNull((Object)authenticatedWebSocket);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, authenticatedWebSocket, request2, Reflection.getOrCreateKotlinClass(Svr3Credentials.class), 0L, 8, null);
    }

    @NotNull
    public String toString() {
        return "SVR3";
    }

    private final SecureValueRecovery.RestoreResponse restoreData(AuthCredentials authorization, byte[] shareSet, String userPin) {
        throw new UnsupportedOperationException("SVR3 disabled for now");
    }

    private final AuthCredentials toAuthCredential(Svr3Credentials $this$toAuthCredential) {
        AuthCredentials authCredentials = AuthCredentials.create($this$toAuthCredential.getUsername(), $this$toAuthCredential.getPassword());
        Intrinsics.checkNotNullExpressionValue((Object)authCredentials, (String)"create(...)");
        return authCredentials;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3$Companion;", "", "<init>", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3$Svr3PinChangeSession;", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$PinChangeSession;", "userPin", "", "masterKey", "Lorg/signal/core/models/MasterKey;", "shareSet", "", "<init>", "(Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3;Ljava/lang/String;Lorg/signal/core/models/MasterKey;[B)V", "execute", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$BackupResponse;", "serialize", "signal-service-java"})
    public final class Svr3PinChangeSession
    implements SecureValueRecovery.PinChangeSession {
        @NotNull
        private final String userPin;
        @NotNull
        private final MasterKey masterKey;
        @Nullable
        private byte[] shareSet;

        public Svr3PinChangeSession(@NotNull String userPin, @Nullable MasterKey masterKey, byte[] shareSet) {
            Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
            Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
            this.userPin = userPin;
            this.masterKey = masterKey;
            this.shareSet = shareSet;
        }

        @Override
        @NotNull
        public SecureValueRecovery.BackupResponse execute() {
            throw new UnsupportedOperationException("SVR3 disabled for now");
        }

        @Override
        @NotNull
        public String serialize() {
            String string = JsonUtil.toJson(new Svr3SessionData(this.userPin, this.masterKey, this.shareSet));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3$Svr3SessionData;", "", "userPin", "", "masterKey", "Lorg/signal/core/models/MasterKey;", "shareSet", "", "<init>", "(Ljava/lang/String;Lorg/signal/core/models/MasterKey;[B)V", "getUserPin", "()Ljava/lang/String;", "getMasterKey", "()Lorg/signal/core/models/MasterKey;", "getShareSet", "()[B", "signal-service-java"})
    public static final class Svr3SessionData {
        @NotNull
        private final String userPin;
        @NotNull
        private final MasterKey masterKey;
        @Nullable
        private final byte[] shareSet;

        public Svr3SessionData(@JsonProperty @NotNull String userPin, @JsonProperty @JsonSerialize(using=JsonUtil.MasterKeySerializer.class) @JsonDeserialize(using=JsonUtil.MasterKeyDeserializer.class) @NotNull MasterKey masterKey, @JsonProperty @JsonSerialize(using=ByteArraySerializerBase64NoPadding.class) @JsonDeserialize(using=ByteArrayDeserializerBase64.class) @Nullable byte[] shareSet) {
            Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
            Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
            this.userPin = userPin;
            this.masterKey = masterKey;
            this.shareSet = shareSet;
        }

        @NotNull
        public final String getUserPin() {
            return this.userPin;
        }

        @NotNull
        public final MasterKey getMasterKey() {
            return this.masterKey;
        }

        @Nullable
        public final byte[] getShareSet() {
            return this.shareSet;
        }
    }
}

