/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import com.squareup.wire.FieldEncoding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.storageservice.StorageCipherKey;
import org.signal.core.models.storageservice.StorageKey;
import org.signal.core.models.storageservice.StorageManifestKey;
import org.signal.core.util.ByteSize;
import org.signal.core.util.ProtoUtil;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.storage.ManifestRecordIdentifierExtensionsKt;
import org.whispersystems.signalservice.api.storage.RecordIkm;
import org.whispersystems.signalservice.api.storage.SignalStorageCipher;
import org.whispersystems.signalservice.api.storage.SignalStorageManifest;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.storage.StorageServiceApi;
import org.whispersystems.signalservice.internal.storage.protos.ManifestRecord;
import org.whispersystems.signalservice.internal.storage.protos.ReadOperation;
import org.whispersystems.signalservice.internal.storage.protos.StorageItem;
import org.whispersystems.signalservice.internal.storage.protos.StorageItems;
import org.whispersystems.signalservice.internal.storage.protos.StorageManifest;
import org.whispersystems.signalservice.internal.storage.protos.StorageRecord;
import org.whispersystems.signalservice.internal.storage.protos.WriteOperation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0005-./01B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015J$\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015J\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001aJ<\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00152\u0006\u0010\"\u001a\u00020#H\u0002J0\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0014\u0010'\u001a\u00020\u001a*\u00020(2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010'\u001a\u00020\u001c*\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001e\u0010,\u001a\u00020)*\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository;", "", "storageServiceApi", "Lorg/whispersystems/signalservice/api/storage/StorageServiceApi;", "<init>", "(Lorg/whispersystems/signalservice/api/storage/StorageServiceApi;)V", "getManifestVersion", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "getStorageManifest", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult;", "storageKey", "Lorg/signal/core/models/storageservice/StorageKey;", "getStorageManifestIfDifferentVersion", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult;", "manifestVersion", "readStorageRecords", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult;", "recordIkm", "Lorg/whispersystems/signalservice/api/storage/RecordIkm;", "storageIds", "", "Lorg/whispersystems/signalservice/api/storage/StorageId;", "writeStorageRecords", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult;", "signalManifest", "Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;", "insertItems", "Lorg/whispersystems/signalservice/api/storage/SignalStorageRecord;", "deleteRawIds", "", "resetAndWriteStorageRecords", "manifest", "writeUnchangedManifest", "clearAllExisting", "", "readStorageRecordsBatch", "auth", "", "toLocal", "Lorg/whispersystems/signalservice/internal/storage/protos/StorageManifest;", "Lorg/whispersystems/signalservice/internal/storage/protos/StorageItem;", "type", "", "toRemote", "Companion", "WriteStorageRecordsResult", "ManifestResult", "ManifestIfDifferentVersionResult", "StorageRecordResult", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nStorageServiceRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageServiceRepository.kt\norg/whispersystems/signalservice/api/storage/StorageServiceRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ByteExtensions.kt\norg/signal/core/util/ByteExtensionsKt\n*L\n1#1,339:1\n827#2:340\n855#2,2:341\n1563#2:343\n1634#2,3:344\n295#2,2:347\n774#2:349\n865#2,2:350\n1563#2:352\n1634#2,3:353\n1563#2:356\n1634#2,3:357\n1563#2:360\n1634#2,3:361\n1563#2:364\n1634#2,3:365\n1563#2:368\n1634#2,3:369\n2746#2,3:372\n1193#2,2:375\n1267#2,4:377\n1563#2:381\n1634#2,3:382\n1563#2:385\n1634#2,3:386\n1563#2:389\n1634#2,3:390\n1#3:393\n15#4:394\n*S KotlinDebug\n*F\n+ 1 StorageServiceRepository.kt\norg/whispersystems/signalservice/api/storage/StorageServiceRepository\n*L\n121#1:340\n121#1:341,2\n126#1:343\n126#1:344,3\n131#1:347,2\n137#1:349\n137#1:350,2\n138#1:352\n138#1:353,3\n141#1:356\n141#1:357,3\n185#1:360\n185#1:361,3\n213#1:364\n213#1:365,3\n218#1:368\n218#1:369,3\n241#1:372,3\n243#1:375,2\n243#1:377,4\n246#1:381\n246#1:382,3\n261#1:385\n261#1:386,3\n275#1:389\n275#1:390,3\n284#1:394\n*E\n"})
public final class StorageServiceRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StorageServiceApi storageServiceApi;
    @NotNull
    private static final String TAG = Log.tag((KClass)Reflection.getOrCreateKotlinClass(StorageServiceRepository.class));
    private static final int STORAGE_READ_MAX_ITEMS = 1000;

    public StorageServiceRepository(@NotNull StorageServiceApi storageServiceApi) {
        Intrinsics.checkNotNullParameter((Object)storageServiceApi, (String)"storageServiceApi");
        this.storageServiceApi = storageServiceApi;
    }

    @NotNull
    public final NetworkResult<Long> getManifestVersion() {
        return this.storageServiceApi.getAuth().then(arg_0 -> StorageServiceRepository.getManifestVersion$lambda$0(this, arg_0)).map(StorageServiceRepository::getManifestVersion$lambda$1);
    }

    @NotNull
    public final ManifestResult getStorageManifest(@NotNull StorageKey storageKey) {
        ManifestResult manifestResult;
        Intrinsics.checkNotNullParameter((Object)storageKey, (String)"storageKey");
        NetworkResult result2 = this.storageServiceApi.getAuth().then(arg_0 -> StorageServiceRepository.getStorageManifest$lambda$2(this, arg_0));
        boolean bl = false;
        NetworkResult networkResult = result2;
        if (!(networkResult instanceof NetworkResult.Success)) {
            if (networkResult instanceof NetworkResult.ApplicationError) {
                throw ((NetworkResult.ApplicationError)result2).getThrowable();
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                return new ManifestResult.NetworkError(((NetworkResult.NetworkError)result2).getException());
            }
            if (networkResult instanceof NetworkResult.StatusCodeError) {
                return ((NetworkResult.StatusCodeError)result2).getCode() == 404 ? (ManifestResult)ManifestResult.NotFoundError.INSTANCE : (ManifestResult)new ManifestResult.StatusCodeError(((NetworkResult.StatusCodeError)result2).getCode(), ((NetworkResult.StatusCodeError)result2).getException());
            }
            throw new NoWhenBranchMatchedException();
        }
        StorageManifest manifest = (StorageManifest)((Object)((NetworkResult.Success)result2).getResult());
        try {
            SignalStorageManifest decrypted = this.toLocal(manifest, storageKey);
            manifestResult = new ManifestResult.Success(decrypted);
        }
        catch (InvalidKeyException e) {
            manifestResult = new ManifestResult.DecryptionError((Exception)((Object)e));
        }
        return manifestResult;
    }

    @NotNull
    public final ManifestIfDifferentVersionResult getStorageManifestIfDifferentVersion(@NotNull StorageKey storageKey, long manifestVersion) {
        ManifestIfDifferentVersionResult manifestIfDifferentVersionResult;
        Intrinsics.checkNotNullParameter((Object)storageKey, (String)"storageKey");
        NetworkResult result2 = this.storageServiceApi.getAuth().then(arg_0 -> StorageServiceRepository.getStorageManifestIfDifferentVersion$lambda$4(this, manifestVersion, arg_0));
        boolean bl = false;
        NetworkResult networkResult = result2;
        if (!(networkResult instanceof NetworkResult.Success)) {
            if (networkResult instanceof NetworkResult.ApplicationError) {
                throw ((NetworkResult.ApplicationError)result2).getThrowable();
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                return new ManifestIfDifferentVersionResult.NetworkError(((NetworkResult.NetworkError)result2).getException());
            }
            if (networkResult instanceof NetworkResult.StatusCodeError) {
                return ((NetworkResult.StatusCodeError)result2).getCode() == 204 ? (ManifestIfDifferentVersionResult)ManifestIfDifferentVersionResult.SameVersion.INSTANCE : (ManifestIfDifferentVersionResult)new ManifestIfDifferentVersionResult.StatusCodeError(((NetworkResult.StatusCodeError)result2).getCode(), ((NetworkResult.StatusCodeError)result2).getException());
            }
            throw new NoWhenBranchMatchedException();
        }
        StorageManifest manifest = (StorageManifest)((Object)((NetworkResult.Success)result2).getResult());
        try {
            SignalStorageManifest decrypted = this.toLocal(manifest, storageKey);
            manifestIfDifferentVersionResult = new ManifestIfDifferentVersionResult.DifferentVersion(decrypted);
        }
        catch (InvalidKeyException e) {
            manifestIfDifferentVersionResult = new ManifestIfDifferentVersionResult.DecryptionError((Exception)((Object)e));
        }
        return manifestIfDifferentVersionResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StorageRecordResult readStorageRecords(@NotNull StorageKey storageKey, @Nullable RecordIkm recordIkm, @NotNull List<? extends StorageId> storageIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object v0;
        Iterable $this$firstOrNull$iv;
        List results;
        Collection collection;
        Object $this$map$iv3;
        block11: {
            void $this$mapTo$iv$iv3;
            Object it;
            void $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)storageKey, (String)"storageKey");
            Intrinsics.checkNotNullParameter(storageIds, (String)"storageIds");
            NetworkResult<String> result2 = this.storageServiceApi.getAuth();
            if (!(result2 instanceof NetworkResult.Success)) {
                if (result2 instanceof NetworkResult.ApplicationError) {
                    throw ((NetworkResult.ApplicationError)result2).getThrowable();
                }
                if (result2 instanceof NetworkResult.NetworkError) {
                    return new StorageRecordResult.NetworkError(((NetworkResult.NetworkError)result2).getException());
                }
                if (result2 instanceof NetworkResult.StatusCodeError) {
                    return new StorageRecordResult.StatusCodeError(((NetworkResult.StatusCodeError)result2).getCode(), ((NetworkResult.StatusCodeError)result2).getException());
                }
                throw new NoWhenBranchMatchedException();
            }
            String auth = (String)((NetworkResult.Success)result2).getResult();
            Iterable $this$filterNot$iv = storageIds;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo22 = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (StorageId)element$iv$iv;
                boolean bl = false;
                if (((StorageId)it).isUnknown()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List knownIds = (List)destination$iv$iv;
            List batches = CollectionsKt.chunked((Iterable)knownIds, (int)1000);
            Log.d((String)TAG, (String)("Reading " + knownIds.size() + " storage records in " + batches.size() + " batches of size 1000"));
            $this$map$iv3 = batches;
            boolean $i$f$map22 = false;
            Iterable $i$f$filterNotTo22 = $this$map$iv3;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void batch;
                List list = (List)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(this.readStorageRecordsBatch(auth, storageKey, recordIkm, (List<? extends StorageId>)batch));
            }
            results = (List)destination$iv$iv2;
            Iterable $i$f$map22 = results;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (StorageRecordResult)element$iv;
                boolean bl = false;
                if (!(!(it instanceof StorageRecordResult.Success))) continue;
                v0 = element$iv;
                break block11;
            }
            v0 = null;
        }
        $this$map$iv3 = v0;
        if ($this$map$iv3 != null) {
            Object firstFailedResult = $this$map$iv3;
            boolean bl = false;
            return firstFailedResult;
        }
        $this$firstOrNull$iv = storageIds;
        boolean $i$f$filter = false;
        void bl = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StorageId it = (StorageId)element$iv$iv;
            boolean bl2 = false;
            if (!it.isUnknown()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map32 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            StorageId it = (StorageId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(SignalStorageRecord.Companion.forUnknown(it));
        }
        List unknownRecordPlaceholders = (List)destination$iv$iv;
        Iterable $i$f$map32 = results;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StorageRecordResult bl3 = (StorageRecordResult)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.whispersystems.signalservice.api.storage.StorageServiceRepository.StorageRecordResult.Success");
            collection.add(((StorageRecordResult.Success)it).getRecords());
        }
        List allResults = CollectionsKt.plus((Collection)CollectionsKt.flatten((Iterable)((List)destination$iv$iv3)), (Iterable)unknownRecordPlaceholders);
        return new StorageRecordResult.Success(allResults);
    }

    @NotNull
    public final WriteStorageRecordsResult writeStorageRecords(@NotNull StorageKey storageKey, @NotNull SignalStorageManifest signalManifest, @NotNull List<SignalStorageRecord> insertItems, @NotNull List<byte[]> deleteRawIds) {
        Intrinsics.checkNotNullParameter((Object)storageKey, (String)"storageKey");
        Intrinsics.checkNotNullParameter((Object)signalManifest, (String)"signalManifest");
        Intrinsics.checkNotNullParameter(insertItems, (String)"insertItems");
        Intrinsics.checkNotNullParameter(deleteRawIds, (String)"deleteRawIds");
        return this.writeStorageRecords(storageKey, signalManifest, insertItems, deleteRawIds, false);
    }

    @NotNull
    public final WriteStorageRecordsResult resetAndWriteStorageRecords(@NotNull StorageKey storageKey, @NotNull SignalStorageManifest manifest, @NotNull List<SignalStorageRecord> insertItems) {
        Intrinsics.checkNotNullParameter((Object)storageKey, (String)"storageKey");
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        Intrinsics.checkNotNullParameter(insertItems, (String)"insertItems");
        return this.writeStorageRecords(storageKey, manifest, insertItems, CollectionsKt.emptyList(), true);
    }

    @NotNull
    public final WriteStorageRecordsResult writeUnchangedManifest(@NotNull StorageKey storageKey, @NotNull SignalStorageManifest manifest) {
        Intrinsics.checkNotNullParameter((Object)storageKey, (String)"storageKey");
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        return this.writeStorageRecords(storageKey, manifest, CollectionsKt.emptyList(), CollectionsKt.emptyList(), false);
    }

    /*
     * WARNING - void declaration
     */
    private final WriteStorageRecordsResult writeStorageRecords(StorageKey storageKey, SignalStorageManifest signalManifest, List<SignalStorageRecord> insertItems, List<byte[]> deleteRawIds, boolean clearAllExisting) {
        WriteStorageRecordsResult writeStorageRecordsResult;
        byte[] it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        long $this$mapTo$iv$iv22;
        List manifestIds;
        Iterable id;
        int $i$f$map;
        block18: {
            block17: {
                void $this$mapTo$iv$iv22;
                Iterable $this$map$iv2 = signalManifest.storageIds;
                $i$f$map = 0;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv22) {
                    StorageId storageId = (StorageId)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    ManifestRecord.Identifier.Builder builder = new ManifestRecord.Identifier.Builder();
                    byte[] byArray = ((StorageId)((Object)id)).getRaw();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getRaw(...)");
                    builder.raw = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null);
                    if (((StorageId)((Object)id)).isUnknown()) {
                        builder.type = ManifestRecord.Identifier.Type.UNKNOWN;
                        v1 = builder.addUnknownField(2, FieldEncoding.VARINT, ((StorageId)((Object)id)).getType());
                    } else {
                        ManifestRecord.Identifier.Type type = ManifestRecord.Identifier.Type.Companion.fromValue(((StorageId)((Object)id)).getType());
                        Intrinsics.checkNotNull((Object)((Object)type));
                        v1 = builder.type(type);
                    }
                    collection2.add(builder.build());
                }
                manifestIds = (List)destination$iv$iv;
                $i$f$map = signalManifest.getSourceDeviceId();
                $this$mapTo$iv$iv22 = signalManifest.version;
                object = signalManifest.recordIkm;
                if (object == null) break block17;
                byte[] byArray = ((RecordIkm)object).getValue();
                object = byArray;
                if (byArray != null && (object = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])object, (int)0, (int)0, (int)3, null)) != null) break block18;
            }
            object = ByteString.EMPTY;
        }
        Object $i$f$mapTo = object;
        ManifestRecord manifestRecord = new ManifestRecord($this$mapTo$iv$iv22, $i$f$map, manifestIds, (ByteString)$i$f$mapTo, null, 16, null);
        StorageManifestKey manifestKey = storageKey.deriveManifestKey(signalManifest.version);
        StorageManifest encryptedManifest = new StorageManifest(manifestRecord.version, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])SignalStorageCipher.encrypt((StorageCipherKey)manifestKey, manifestRecord.encode()), (int)0, (int)0, (int)3, null), null, 4, null);
        Object $this$writeStorageRecords_u24lambda_u2416 = $i$f$mapTo = new WriteOperation.Builder();
        boolean bl = false;
        ((WriteOperation.Builder)((Object)$this$writeStorageRecords_u24lambda_u2416)).manifest = encryptedManifest;
        id = insertItems;
        Object object2 = $this$writeStorageRecords_u24lambda_u2416;
        boolean $i$f$map2 = false;
        void var17_25 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SignalStorageRecord signalStorageRecord = (SignalStorageRecord)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.toRemote((SignalStorageRecord)it, storageKey, signalManifest.recordIkm));
        }
        ((WriteOperation.Builder)((Object)object2)).insertItem = (List)destination$iv$iv;
        if (clearAllExisting) {
            ((WriteOperation.Builder)((Object)$this$writeStorageRecords_u24lambda_u2416)).clearAll = true;
        } else {
            $this$map$iv = deleteRawIds;
            object2 = $this$writeStorageRecords_u24lambda_u2416;
            $i$f$map2 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (byte[])item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])it, (int)0, (int)0, (int)3, null));
            }
            ((WriteOperation.Builder)((Object)object2)).deleteKey = (List)destination$iv$iv;
        }
        WriteOperation writeOperation = ((WriteOperation.Builder)((Object)$i$f$mapTo)).build();
        NetworkResult result2 = this.storageServiceApi.getAuth().then(arg_0 -> StorageServiceRepository.writeStorageRecords$lambda$17(this, writeOperation, arg_0));
        NetworkResult networkResult = result2;
        if (networkResult instanceof NetworkResult.Success) {
            writeStorageRecordsResult = WriteStorageRecordsResult.Success.INSTANCE;
        } else {
            if (networkResult instanceof NetworkResult.ApplicationError) {
                throw ((NetworkResult.ApplicationError)result2).getThrowable();
            }
            if (networkResult instanceof NetworkResult.NetworkError) {
                writeStorageRecordsResult = new WriteStorageRecordsResult.NetworkError(((NetworkResult.NetworkError)result2).getException());
            } else if (networkResult instanceof NetworkResult.StatusCodeError) {
                writeStorageRecordsResult = ((NetworkResult.StatusCodeError)result2).getCode() == 409 ? (WriteStorageRecordsResult)WriteStorageRecordsResult.ConflictError.INSTANCE : (WriteStorageRecordsResult)new WriteStorageRecordsResult.StatusCodeError(((NetworkResult.StatusCodeError)result2).getCode(), ((NetworkResult.StatusCodeError)result2).getException());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return writeStorageRecordsResult;
    }

    /*
     * WARNING - void declaration
     */
    private final StorageRecordResult readStorageRecordsBatch(String auth, StorageKey storageKey, RecordIkm recordIkm, List<? extends StorageId> storageIds) {
        StorageRecordResult storageRecordResult;
        void $this$mapTo$iv$iv;
        Iterator iterator;
        Iterable $this$associateTo$iv$iv;
        Object it;
        boolean bl;
        block14: {
            if (!(storageIds.size() <= 1000)) {
                throw new IllegalStateException("Check failed.");
            }
            Iterable $this$none$iv = storageIds;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (StorageId)element$iv;
                    boolean bl2 = false;
                    if (!((StorageId)it).isUnknown()) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (!bl) {
            throw new IllegalStateException("Check failed.");
        }
        Iterable $this$associate$iv = storageIds;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        it = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            iterator = destination$iv$iv;
            StorageId it2 = (StorageId)element$iv$iv;
            boolean bl3 = false;
            byte[] byArray = it2.getRaw();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getRaw(...)");
            it2 = TuplesKt.to((Object)ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null), (Object)it2.getType());
            iterator.put(it2.getFirst(), it2.getSecond());
        }
        Map typesByKey = destination$iv$iv;
        Iterable $this$map$iv = storageIds;
        boolean $i$f$map = false;
        $this$associateTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            iterator = (StorageId)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl4 = false;
            byte[] byArray = it3.getRaw();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getRaw(...)");
            object.add(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        ByteString byteString = null;
        List list = (List)destination$iv$iv;
        ReadOperation readOperation = new ReadOperation(list, byteString, n, defaultConstructorMarker);
        NetworkResult<StorageItems> itemResult = this.storageServiceApi.readStorageItems(auth, readOperation);
        boolean bl5 = false;
        NetworkResult<StorageItems> $i$f$mapTo22 = itemResult;
        if (!($i$f$mapTo22 instanceof NetworkResult.Success)) {
            if ($i$f$mapTo22 instanceof NetworkResult.ApplicationError) {
                throw ((NetworkResult.ApplicationError)itemResult).getThrowable();
            }
            if ($i$f$mapTo22 instanceof NetworkResult.NetworkError) {
                return new StorageRecordResult.NetworkError(((NetworkResult.NetworkError)itemResult).getException());
            }
            if ($i$f$mapTo22 instanceof NetworkResult.StatusCodeError) {
                return new StorageRecordResult.StatusCodeError(((NetworkResult.StatusCodeError)itemResult).getCode(), ((NetworkResult.StatusCodeError)itemResult).getException());
            }
            throw new NoWhenBranchMatchedException();
        }
        StorageItems storageItems = (StorageItems)((Object)((NetworkResult.Success)itemResult).getResult());
        try {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = storageItems.items;
            boolean $i$f$map2 = false;
            $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void item;
                StorageItem bl3 = (StorageItem)((Object)item$iv$iv);
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                Object v = typesByKey.get(item.key);
                Intrinsics.checkNotNull(v);
                int type = ((Number)v).intValue();
                collection.add(this.toLocal((StorageItem)item, type, storageKey, recordIkm));
            }
            List items = (List)destination$iv$iv2;
            storageRecordResult = new StorageRecordResult.Success(items);
        }
        catch (InvalidKeyException e) {
            storageRecordResult = new StorageRecordResult.DecryptionError((Exception)((Object)e));
        }
        return storageRecordResult;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final SignalStorageManifest toLocal(StorageManifest $this$toLocal, StorageKey storageKey) throws IOException, InvalidKeyException {
        rawRecord = SignalStorageCipher.decrypt((StorageCipherKey)storageKey.deriveManifestKey($this$toLocal.version), $this$toLocal.value_.toByteArray());
        manifestRecord = (ManifestRecord)ManifestRecord.ADAPTER.decode(rawRecord);
        $this$map$iv = manifestRecord.identifiers;
        $i$f$map = false;
        var8_10 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_17 = (ManifestRecord.Identifier)item$iv$iv;
            var15_19 = destination$iv$iv;
            $i$a$-map-StorageServiceRepository$toLocal$ids$1 = false;
            var15_19.add(StorageId.forType(id.raw.toByteArray(), ManifestRecordIdentifierExtensionsKt.getTypeValue((ManifestRecord.Identifier)id)));
        }
        ids = (List)destination$iv$iv;
        $this$mapTo$iv$iv = $i$f$map = manifestRecord.recordIkm;
        var18_21 = manifestRecord.sourceDevice;
        var16_22 = manifestRecord.version;
        $i$a$-takeIf-StorageServiceRepository$toLocal$1 = false;
        var19_23 = ProtoUtil.isNotEmpty((ByteString)it);
        v0 = var16_22;
        v1 = var18_21;
        v2 /* !! */  = var19_23 != false ? $i$f$map : null;
        if (v2 /* !! */  == null) ** GOTO lbl-1000
        v3 = v2 /* !! */ .toByteArray();
        v2 /* !! */  = (ByteString)v3;
        if (v3 != null) {
            $i$a$-takeIf-StorageServiceRepository$toLocal$1 /* !! */  = v2 /* !! */ ;
            var18_21 = v1;
            var16_22 = v0;
            $i$a$-let-StorageServiceRepository$toLocal$2 = false;
            var19_24 = new RecordIkm((byte[])it);
            v0 = var16_22;
            v1 = var18_21;
            v4 = var19_24;
        } else lbl-1000:
        // 2 sources

        {
            v4 = null;
        }
        $this$bytes$iv = $this$toLocal.encode().length;
        $i$f$getBytes = false;
        var20_25 = new ByteSize((long)$this$bytes$iv);
        var21_26 = ids;
        var22_27 = v4;
        var23_28 = v1;
        var24_29 = v0;
        return new SignalStorageManifest(var24_29, var23_28, var22_27, var21_26, var20_25);
    }

    private final SignalStorageRecord toLocal(StorageItem $this$toLocal, int type, StorageKey storageKey, RecordIkm recordIkm) throws IOException, InvalidKeyException {
        byte[] rawId = $this$toLocal.key.toByteArray();
        RecordIkm recordIkm2 = recordIkm;
        if (recordIkm2 == null || (recordIkm2 = recordIkm2.deriveStorageItemKey(rawId)) == null) {
            recordIkm2 = storageKey.deriveItemKey(rawId);
        }
        RecordIkm key = recordIkm2;
        byte[] rawRecord = SignalStorageCipher.decrypt((StorageCipherKey)key, $this$toLocal.value_.toByteArray());
        StorageRecord record = (StorageRecord)((Object)StorageRecord.ADAPTER.decode(rawRecord));
        StorageId id = StorageId.forType(rawId, type);
        Intrinsics.checkNotNull((Object)id);
        return new SignalStorageRecord(id, record);
    }

    private final StorageItem toRemote(SignalStorageRecord $this$toRemote, StorageKey storageKey, RecordIkm recordIkm) {
        RecordIkm recordIkm2;
        block3: {
            block2: {
                recordIkm2 = recordIkm;
                if (recordIkm2 == null) break block2;
                byte[] byArray = $this$toRemote.getId().getRaw();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getRaw(...)");
                if ((recordIkm2 = recordIkm2.deriveStorageItemKey(byArray)) != null) break block3;
            }
            byte[] byArray = $this$toRemote.getId().getRaw();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getRaw(...)");
            recordIkm2 = storageKey.deriveItemKey(byArray);
        }
        RecordIkm key = recordIkm2;
        byte[] encryptedRecord = SignalStorageCipher.encrypt((StorageCipherKey)key, $this$toRemote.getProto().encode());
        StorageItem.Builder builder = new StorageItem.Builder();
        byte[] byArray = $this$toRemote.getId().getRaw();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getRaw(...)");
        return builder.key(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null)).value_(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])encryptedRecord, (int)0, (int)0, (int)3, null)).build();
    }

    private static final NetworkResult getManifestVersion$lambda$0(StorageServiceRepository this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.storageServiceApi.getStorageManifest(it);
    }

    private static final long getManifestVersion$lambda$1(StorageManifest it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.version;
    }

    private static final NetworkResult getStorageManifest$lambda$2(StorageServiceRepository this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.storageServiceApi.getStorageManifest(it);
    }

    private static final NetworkResult getStorageManifestIfDifferentVersion$lambda$4(StorageServiceRepository this$0, long $manifestVersion, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.storageServiceApi.getStorageManifestIfDifferentVersion(it, $manifestVersion);
    }

    private static final NetworkResult writeStorageRecords$lambda$17(StorageServiceRepository this$0, WriteOperation $writeOperation, String auth) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        return this$0.storageServiceApi.writeStorageItems(auth, $writeOperation);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$Companion;", "", "<init>", "()V", "TAG", "", "STORAGE_READ_MAX_ITEMS", "", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0005\u0002\u0003\u0004\u0005\u0006\u0082\u0001\u0005\u0007\b\t\n\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult;", "", "DifferentVersion", "SameVersion", "NetworkError", "DecryptionError", "StatusCodeError", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$DecryptionError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$DifferentVersion;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$NetworkError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$SameVersion;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$StatusCodeError;", "signal-service-java"})
    public static interface ManifestIfDifferentVersionResult {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$DecryptionError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult;", "exception", "Ljava/lang/Exception;", "<init>", "(Ljava/lang/Exception;)V", "getException", "()Ljava/lang/Exception;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class DecryptionError
        implements ManifestIfDifferentVersionResult {
            @NotNull
            private final Exception exception;

            public DecryptionError(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final Exception getException() {
                return this.exception;
            }

            @NotNull
            public final Exception component1() {
                return this.exception;
            }

            @NotNull
            public final DecryptionError copy(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new DecryptionError(exception);
            }

            public static /* synthetic */ DecryptionError copy$default(DecryptionError decryptionError, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    exception = decryptionError.exception;
                }
                return decryptionError.copy(exception);
            }

            @NotNull
            public String toString() {
                return "DecryptionError(exception=" + this.exception + ")";
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DecryptionError)) {
                    return false;
                }
                DecryptionError decryptionError = (DecryptionError)other;
                return Intrinsics.areEqual((Object)this.exception, (Object)decryptionError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$DifferentVersion;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult;", "manifest", "Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;", "<init>", "(Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;)V", "getManifest", "()Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class DifferentVersion
        implements ManifestIfDifferentVersionResult {
            @NotNull
            private final SignalStorageManifest manifest;

            public DifferentVersion(@NotNull SignalStorageManifest manifest) {
                Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
                this.manifest = manifest;
            }

            @NotNull
            public final SignalStorageManifest getManifest() {
                return this.manifest;
            }

            @NotNull
            public final SignalStorageManifest component1() {
                return this.manifest;
            }

            @NotNull
            public final DifferentVersion copy(@NotNull SignalStorageManifest manifest) {
                Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
                return new DifferentVersion(manifest);
            }

            public static /* synthetic */ DifferentVersion copy$default(DifferentVersion differentVersion, SignalStorageManifest signalStorageManifest, int n, Object object) {
                if ((n & 1) != 0) {
                    signalStorageManifest = differentVersion.manifest;
                }
                return differentVersion.copy(signalStorageManifest);
            }

            @NotNull
            public String toString() {
                return "DifferentVersion(manifest=" + this.manifest + ")";
            }

            public int hashCode() {
                return this.manifest.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DifferentVersion)) {
                    return false;
                }
                DifferentVersion differentVersion = (DifferentVersion)other;
                return Intrinsics.areEqual((Object)this.manifest, (Object)differentVersion.manifest);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\n\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$NetworkError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult;", "exception", "Ljava/io/IOException;", "Lokio/IOException;", "<init>", "(Ljava/io/IOException;)V", "getException", "()Ljava/io/IOException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class NetworkError
        implements ManifestIfDifferentVersionResult {
            @NotNull
            private final IOException exception;

            public NetworkError(@NotNull IOException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final IOException getException() {
                return this.exception;
            }

            @NotNull
            public final IOException component1() {
                return this.exception;
            }

            @NotNull
            public final NetworkError copy(@NotNull IOException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new NetworkError(exception);
            }

            public static /* synthetic */ NetworkError copy$default(NetworkError networkError, IOException iOException, int n, Object object) {
                if ((n & 1) != 0) {
                    iOException = networkError.exception;
                }
                return networkError.copy(iOException);
            }

            @NotNull
            public String toString() {
                return "NetworkError(exception=" + this.exception + ")";
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NetworkError)) {
                    return false;
                }
                NetworkError networkError = (NetworkError)other;
                return Intrinsics.areEqual((Object)this.exception, (Object)networkError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$SameVersion;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class SameVersion
        implements ManifestIfDifferentVersionResult {
            @NotNull
            public static final SameVersion INSTANCE = new SameVersion();

            private SameVersion() {
            }

            @NotNull
            public String toString() {
                return "SameVersion";
            }

            public int hashCode() {
                return 440935372;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SameVersion)) {
                    return false;
                }
                SameVersion cfr_ignored_0 = (SameVersion)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult$StatusCodeError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestIfDifferentVersionResult;", "code", "", "exception", "Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "<init>", "(ILorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;)V", "getCode", "()I", "getException", "()Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "signal-service-java"})
        public static final class StatusCodeError
        implements ManifestIfDifferentVersionResult {
            private final int code;
            @NotNull
            private final NonSuccessfulResponseCodeException exception;

            public StatusCodeError(int code, @NotNull NonSuccessfulResponseCodeException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.code = code;
                this.exception = exception;
            }

            public final int getCode() {
                return this.code;
            }

            @NotNull
            public final NonSuccessfulResponseCodeException getException() {
                return this.exception;
            }

            public final int component1() {
                return this.code;
            }

            @NotNull
            public final NonSuccessfulResponseCodeException component2() {
                return this.exception;
            }

            @NotNull
            public final StatusCodeError copy(int code, @NotNull NonSuccessfulResponseCodeException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new StatusCodeError(code, exception);
            }

            public static /* synthetic */ StatusCodeError copy$default(StatusCodeError statusCodeError, int n, NonSuccessfulResponseCodeException nonSuccessfulResponseCodeException, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = statusCodeError.code;
                }
                if ((n2 & 2) != 0) {
                    nonSuccessfulResponseCodeException = statusCodeError.exception;
                }
                return statusCodeError.copy(n, nonSuccessfulResponseCodeException);
            }

            @NotNull
            public String toString() {
                return "StatusCodeError(code=" + this.code + ", exception=" + this.exception + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.code);
                result2 = result2 * 31 + this.exception.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StatusCodeError)) {
                    return false;
                }
                StatusCodeError statusCodeError = (StatusCodeError)other;
                if (this.code != statusCodeError.code) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.exception, (Object)statusCodeError.exception);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0005\u0002\u0003\u0004\u0005\u0006\u0082\u0001\u0005\u0007\b\t\n\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult;", "", "Success", "NetworkError", "DecryptionError", "NotFoundError", "StatusCodeError", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$DecryptionError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$NetworkError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$NotFoundError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$StatusCodeError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$Success;", "signal-service-java"})
    public static interface ManifestResult {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$DecryptionError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult;", "exception", "Ljava/lang/Exception;", "<init>", "(Ljava/lang/Exception;)V", "getException", "()Ljava/lang/Exception;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class DecryptionError
        implements ManifestResult {
            @NotNull
            private final Exception exception;

            public DecryptionError(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final Exception getException() {
                return this.exception;
            }

            @NotNull
            public final Exception component1() {
                return this.exception;
            }

            @NotNull
            public final DecryptionError copy(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new DecryptionError(exception);
            }

            public static /* synthetic */ DecryptionError copy$default(DecryptionError decryptionError, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    exception = decryptionError.exception;
                }
                return decryptionError.copy(exception);
            }

            @NotNull
            public String toString() {
                return "DecryptionError(exception=" + this.exception + ")";
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DecryptionError)) {
                    return false;
                }
                DecryptionError decryptionError = (DecryptionError)other;
                return Intrinsics.areEqual((Object)this.exception, (Object)decryptionError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\n\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$NetworkError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult;", "exception", "Ljava/io/IOException;", "Lokio/IOException;", "<init>", "(Ljava/io/IOException;)V", "getException", "()Ljava/io/IOException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class NetworkError
        implements ManifestResult {
            @NotNull
            private final IOException exception;

            public NetworkError(@NotNull IOException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final IOException getException() {
                return this.exception;
            }

            @NotNull
            public final IOException component1() {
                return this.exception;
            }

            @NotNull
            public final NetworkError copy(@NotNull IOException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new NetworkError(exception);
            }

            public static /* synthetic */ NetworkError copy$default(NetworkError networkError, IOException iOException, int n, Object object) {
                if ((n & 1) != 0) {
                    iOException = networkError.exception;
                }
                return networkError.copy(iOException);
            }

            @NotNull
            public String toString() {
                return "NetworkError(exception=" + this.exception + ")";
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NetworkError)) {
                    return false;
                }
                NetworkError networkError = (NetworkError)other;
                return Intrinsics.areEqual((Object)this.exception, (Object)networkError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$NotFoundError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class NotFoundError
        implements ManifestResult {
            @NotNull
            public static final NotFoundError INSTANCE = new NotFoundError();

            private NotFoundError() {
            }

            @NotNull
            public String toString() {
                return "NotFoundError";
            }

            public int hashCode() {
                return 739738775;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotFoundError)) {
                    return false;
                }
                NotFoundError cfr_ignored_0 = (NotFoundError)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$StatusCodeError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult;", "code", "", "exception", "Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "<init>", "(ILorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;)V", "getCode", "()I", "getException", "()Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "signal-service-java"})
        public static final class StatusCodeError
        implements ManifestResult {
            private final int code;
            @NotNull
            private final NonSuccessfulResponseCodeException exception;

            public StatusCodeError(int code, @NotNull NonSuccessfulResponseCodeException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.code = code;
                this.exception = exception;
            }

            public final int getCode() {
                return this.code;
            }

            @NotNull
            public final NonSuccessfulResponseCodeException getException() {
                return this.exception;
            }

            public final int component1() {
                return this.code;
            }

            @NotNull
            public final NonSuccessfulResponseCodeException component2() {
                return this.exception;
            }

            @NotNull
            public final StatusCodeError copy(int code, @NotNull NonSuccessfulResponseCodeException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new StatusCodeError(code, exception);
            }

            public static /* synthetic */ StatusCodeError copy$default(StatusCodeError statusCodeError, int n, NonSuccessfulResponseCodeException nonSuccessfulResponseCodeException, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = statusCodeError.code;
                }
                if ((n2 & 2) != 0) {
                    nonSuccessfulResponseCodeException = statusCodeError.exception;
                }
                return statusCodeError.copy(n, nonSuccessfulResponseCodeException);
            }

            @NotNull
            public String toString() {
                return "StatusCodeError(code=" + this.code + ", exception=" + this.exception + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.code);
                result2 = result2 * 31 + this.exception.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StatusCodeError)) {
                    return false;
                }
                StatusCodeError statusCodeError = (StatusCodeError)other;
                if (this.code != statusCodeError.code) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.exception, (Object)statusCodeError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult$Success;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$ManifestResult;", "manifest", "Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;", "<init>", "(Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;)V", "getManifest", "()Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class Success
        implements ManifestResult {
            @NotNull
            private final SignalStorageManifest manifest;

            public Success(@NotNull SignalStorageManifest manifest) {
                Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
                this.manifest = manifest;
            }

            @NotNull
            public final SignalStorageManifest getManifest() {
                return this.manifest;
            }

            @NotNull
            public final SignalStorageManifest component1() {
                return this.manifest;
            }

            @NotNull
            public final Success copy(@NotNull SignalStorageManifest manifest) {
                Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
                return new Success(manifest);
            }

            public static /* synthetic */ Success copy$default(Success success, SignalStorageManifest signalStorageManifest, int n, Object object) {
                if ((n & 1) != 0) {
                    signalStorageManifest = success.manifest;
                }
                return success.copy(signalStorageManifest);
            }

            @NotNull
            public String toString() {
                return "Success(manifest=" + this.manifest + ")";
            }

            public int hashCode() {
                return this.manifest.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.manifest, (Object)success.manifest);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult;", "", "Success", "NetworkError", "DecryptionError", "StatusCodeError", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult$DecryptionError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult$NetworkError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult$StatusCodeError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult$Success;", "signal-service-java"})
    public static interface StorageRecordResult {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult$DecryptionError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult;", "exception", "Ljava/lang/Exception;", "<init>", "(Ljava/lang/Exception;)V", "getException", "()Ljava/lang/Exception;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class DecryptionError
        implements StorageRecordResult {
            @NotNull
            private final Exception exception;

            public DecryptionError(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final Exception getException() {
                return this.exception;
            }

            @NotNull
            public final Exception component1() {
                return this.exception;
            }

            @NotNull
            public final DecryptionError copy(@NotNull Exception exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new DecryptionError(exception);
            }

            public static /* synthetic */ DecryptionError copy$default(DecryptionError decryptionError, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    exception = decryptionError.exception;
                }
                return decryptionError.copy(exception);
            }

            @NotNull
            public String toString() {
                return "DecryptionError(exception=" + this.exception + ")";
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DecryptionError)) {
                    return false;
                }
                DecryptionError decryptionError = (DecryptionError)other;
                return Intrinsics.areEqual((Object)this.exception, (Object)decryptionError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\n\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult$NetworkError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult;", "exception", "Ljava/io/IOException;", "Lokio/IOException;", "<init>", "(Ljava/io/IOException;)V", "getException", "()Ljava/io/IOException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class NetworkError
        implements StorageRecordResult {
            @NotNull
            private final IOException exception;

            public NetworkError(@NotNull IOException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final IOException getException() {
                return this.exception;
            }

            @NotNull
            public final IOException component1() {
                return this.exception;
            }

            @NotNull
            public final NetworkError copy(@NotNull IOException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new NetworkError(exception);
            }

            public static /* synthetic */ NetworkError copy$default(NetworkError networkError, IOException iOException, int n, Object object) {
                if ((n & 1) != 0) {
                    iOException = networkError.exception;
                }
                return networkError.copy(iOException);
            }

            @NotNull
            public String toString() {
                return "NetworkError(exception=" + this.exception + ")";
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NetworkError)) {
                    return false;
                }
                NetworkError networkError = (NetworkError)other;
                return Intrinsics.areEqual((Object)this.exception, (Object)networkError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult$StatusCodeError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult;", "code", "", "exception", "Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "<init>", "(ILorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;)V", "getCode", "()I", "getException", "()Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "signal-service-java"})
        public static final class StatusCodeError
        implements StorageRecordResult {
            private final int code;
            @NotNull
            private final NonSuccessfulResponseCodeException exception;

            public StatusCodeError(int code, @NotNull NonSuccessfulResponseCodeException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.code = code;
                this.exception = exception;
            }

            public final int getCode() {
                return this.code;
            }

            @NotNull
            public final NonSuccessfulResponseCodeException getException() {
                return this.exception;
            }

            public final int component1() {
                return this.code;
            }

            @NotNull
            public final NonSuccessfulResponseCodeException component2() {
                return this.exception;
            }

            @NotNull
            public final StatusCodeError copy(int code, @NotNull NonSuccessfulResponseCodeException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new StatusCodeError(code, exception);
            }

            public static /* synthetic */ StatusCodeError copy$default(StatusCodeError statusCodeError, int n, NonSuccessfulResponseCodeException nonSuccessfulResponseCodeException, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = statusCodeError.code;
                }
                if ((n2 & 2) != 0) {
                    nonSuccessfulResponseCodeException = statusCodeError.exception;
                }
                return statusCodeError.copy(n, nonSuccessfulResponseCodeException);
            }

            @NotNull
            public String toString() {
                return "StatusCodeError(code=" + this.code + ", exception=" + this.exception + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.code);
                result2 = result2 * 31 + this.exception.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StatusCodeError)) {
                    return false;
                }
                StatusCodeError statusCodeError = (StatusCodeError)other;
                if (this.code != statusCodeError.code) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.exception, (Object)statusCodeError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult$Success;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$StorageRecordResult;", "records", "", "Lorg/whispersystems/signalservice/api/storage/SignalStorageRecord;", "<init>", "(Ljava/util/List;)V", "getRecords", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class Success
        implements StorageRecordResult {
            @NotNull
            private final List<SignalStorageRecord> records;

            public Success(@NotNull List<SignalStorageRecord> records) {
                Intrinsics.checkNotNullParameter(records, (String)"records");
                this.records = records;
            }

            @NotNull
            public final List<SignalStorageRecord> getRecords() {
                return this.records;
            }

            @NotNull
            public final List<SignalStorageRecord> component1() {
                return this.records;
            }

            @NotNull
            public final Success copy(@NotNull List<SignalStorageRecord> records) {
                Intrinsics.checkNotNullParameter(records, (String)"records");
                return new Success(records);
            }

            public static /* synthetic */ Success copy$default(Success success, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = success.records;
                }
                return success.copy(list);
            }

            @NotNull
            public String toString() {
                return "Success(records=" + this.records + ")";
            }

            public int hashCode() {
                return ((Object)this.records).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual(this.records, success.records);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult;", "", "Success", "NetworkError", "ConflictError", "StatusCodeError", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult$ConflictError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult$NetworkError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult$StatusCodeError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult$Success;", "signal-service-java"})
    public static interface WriteStorageRecordsResult {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult$ConflictError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class ConflictError
        implements WriteStorageRecordsResult {
            @NotNull
            public static final ConflictError INSTANCE = new ConflictError();

            private ConflictError() {
            }

            @NotNull
            public String toString() {
                return "ConflictError";
            }

            public int hashCode() {
                return 1704914475;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ConflictError)) {
                    return false;
                }
                ConflictError cfr_ignored_0 = (ConflictError)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\n\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult$NetworkError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult;", "exception", "Ljava/io/IOException;", "Lokio/IOException;", "<init>", "(Ljava/io/IOException;)V", "getException", "()Ljava/io/IOException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class NetworkError
        implements WriteStorageRecordsResult {
            @NotNull
            private final IOException exception;

            public NetworkError(@NotNull IOException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.exception = exception;
            }

            @NotNull
            public final IOException getException() {
                return this.exception;
            }

            @NotNull
            public final IOException component1() {
                return this.exception;
            }

            @NotNull
            public final NetworkError copy(@NotNull IOException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new NetworkError(exception);
            }

            public static /* synthetic */ NetworkError copy$default(NetworkError networkError, IOException iOException, int n, Object object) {
                if ((n & 1) != 0) {
                    iOException = networkError.exception;
                }
                return networkError.copy(iOException);
            }

            @NotNull
            public String toString() {
                return "NetworkError(exception=" + this.exception + ")";
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NetworkError)) {
                    return false;
                }
                NetworkError networkError = (NetworkError)other;
                return Intrinsics.areEqual((Object)this.exception, (Object)networkError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult$StatusCodeError;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult;", "code", "", "exception", "Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "<init>", "(ILorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;)V", "getCode", "()I", "getException", "()Lorg/whispersystems/signalservice/api/push/exceptions/NonSuccessfulResponseCodeException;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "signal-service-java"})
        public static final class StatusCodeError
        implements WriteStorageRecordsResult {
            private final int code;
            @NotNull
            private final NonSuccessfulResponseCodeException exception;

            public StatusCodeError(int code, @NotNull NonSuccessfulResponseCodeException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                this.code = code;
                this.exception = exception;
            }

            public final int getCode() {
                return this.code;
            }

            @NotNull
            public final NonSuccessfulResponseCodeException getException() {
                return this.exception;
            }

            public final int component1() {
                return this.code;
            }

            @NotNull
            public final NonSuccessfulResponseCodeException component2() {
                return this.exception;
            }

            @NotNull
            public final StatusCodeError copy(int code, @NotNull NonSuccessfulResponseCodeException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new StatusCodeError(code, exception);
            }

            public static /* synthetic */ StatusCodeError copy$default(StatusCodeError statusCodeError, int n, NonSuccessfulResponseCodeException nonSuccessfulResponseCodeException, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = statusCodeError.code;
                }
                if ((n2 & 2) != 0) {
                    nonSuccessfulResponseCodeException = statusCodeError.exception;
                }
                return statusCodeError.copy(n, nonSuccessfulResponseCodeException);
            }

            @NotNull
            public String toString() {
                return "StatusCodeError(code=" + this.code + ", exception=" + this.exception + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.code);
                result2 = result2 * 31 + this.exception.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StatusCodeError)) {
                    return false;
                }
                StatusCodeError statusCodeError = (StatusCodeError)other;
                if (this.code != statusCodeError.code) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.exception, (Object)statusCodeError.exception);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult$Success;", "Lorg/whispersystems/signalservice/api/storage/StorageServiceRepository$WriteStorageRecordsResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class Success
        implements WriteStorageRecordsResult {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
            }

            @NotNull
            public String toString() {
                return "Success";
            }

            public int hashCode() {
                return -1243584360;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success cfr_ignored_0 = (Success)other;
                return true;
            }
        }
    }
}

