/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.ByteSize;
import org.signal.core.util.OptionalExtensionsKt;
import org.signal.core.util.ProtoUtil;
import org.whispersystems.signalservice.api.storage.ManifestRecordIdentifierExtensionsKt;
import org.whispersystems.signalservice.api.storage.RecordIkm;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.ManifestRecord;
import org.whispersystems.signalservice.internal.storage.protos.StorageManifest;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0001-B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010&\u001a\u00020\fH\u00c6\u0003JC\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001J\t\u0010,\u001a\u00020\u0019H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;", "", "version", "", "sourceDeviceId", "", "recordIkm", "Lorg/whispersystems/signalservice/api/storage/RecordIkm;", "storageIds", "", "Lorg/whispersystems/signalservice/api/storage/StorageId;", "protoByteSize", "Lorg/signal/core/util/ByteSize;", "<init>", "(JILorg/whispersystems/signalservice/api/storage/RecordIkm;Ljava/util/List;Lorg/signal/core/util/ByteSize;)V", "(JILorg/whispersystems/signalservice/api/storage/RecordIkm;Ljava/util/List;)V", "getSourceDeviceId", "()I", "getProtoByteSize", "()Lorg/signal/core/util/ByteSize;", "storageIdsByType", "", "getStorageIdsByType", "()Ljava/util/Map;", "versionString", "", "getVersionString", "()Ljava/lang/String;", "accountStorageId", "Ljava/util/Optional;", "getAccountStorageId", "()Ljava/util/Optional;", "serialize", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nSignalStorageManifest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignalStorageManifest.kt\norg/whispersystems/signalservice/api/storage/SignalStorageManifest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 ByteExtensions.kt\norg/signal/core/util/ByteExtensionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1491#2:93\n1516#2,3:94\n1519#2,3:104\n1563#2:109\n1634#2,3:110\n382#3,7:97\n15#4:107\n1#5:108\n*S KotlinDebug\n*F\n+ 1 SignalStorageManifest.kt\norg/whispersystems/signalservice/api/storage/SignalStorageManifest\n*L\n67#1:93\n67#1:94,3\n67#1:104,3\n76#1:109\n76#1:110,3\n67#1:97,7\n27#1:107\n*E\n"})
public final class SignalStorageManifest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final long version;
    private final int sourceDeviceId;
    @JvmField
    @Nullable
    public final RecordIkm recordIkm;
    @JvmField
    @NotNull
    public final List<StorageId> storageIds;
    @NotNull
    private final ByteSize protoByteSize;
    @NotNull
    private final Map<Integer, List<StorageId>> storageIdsByType;
    @NotNull
    private static final SignalStorageManifest EMPTY = new SignalStorageManifest(0L, 1, null, CollectionsKt.emptyList());

    /*
     * WARNING - void declaration
     */
    public SignalStorageManifest(long version, int sourceDeviceId, @Nullable RecordIkm recordIkm, @NotNull List<? extends StorageId> storageIds, @NotNull ByteSize protoByteSize) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(storageIds, (String)"storageIds");
        Intrinsics.checkNotNullParameter((Object)protoByteSize, (String)"protoByteSize");
        this.version = version;
        this.sourceDeviceId = sourceDeviceId;
        this.recordIkm = recordIkm;
        this.storageIds = storageIds;
        this.protoByteSize = protoByteSize;
        Iterable iterable = this.storageIds;
        SignalStorageManifest signalStorageManifest = this;
        boolean $i$f$groupBy = false;
        void var9_9 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            StorageId it = (StorageId)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getType();
            Map map = destination$iv$iv;
            Integer key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        signalStorageManifest.storageIdsByType = destination$iv$iv;
    }

    public final int getSourceDeviceId() {
        return this.sourceDeviceId;
    }

    @NotNull
    public final ByteSize getProtoByteSize() {
        return this.protoByteSize;
    }

    public SignalStorageManifest(long version, int sourceDeviceId, @Nullable RecordIkm recordIkm, @NotNull List<? extends StorageId> storageIds) {
        Intrinsics.checkNotNullParameter(storageIds, (String)"storageIds");
        int $this$bytes$iv = SignalStorageManifest.Companion.toProto(version, storageIds, sourceDeviceId, recordIkm).encode().length;
        boolean $i$f$getBytes = false;
        this(version, sourceDeviceId, recordIkm, storageIds, new ByteSize((long)$this$bytes$iv));
    }

    @NotNull
    public final Map<Integer, List<StorageId>> getStorageIdsByType() {
        return this.storageIdsByType;
    }

    @NotNull
    public final String getVersionString() {
        return this.version + "." + this.sourceDeviceId;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Optional<StorageId> getAccountStorageId() {
        StorageId storageId;
        List<StorageId> list = this.storageIdsByType.get(ManifestRecord.Identifier.Type.ACCOUNT.getValue());
        if (list != null) {
            List<StorageId> list2;
            List<StorageId> it = list2 = list;
            boolean bl = false;
            list = !((Collection)it).isEmpty() ? list2 : null;
            if (list != null) {
                storageId = list.get(0);
                return OptionalExtensionsKt.toOptional(storageId);
            }
        }
        storageId = null;
        return OptionalExtensionsKt.toOptional(storageId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] serialize() {
        Object object;
        int n;
        List ids;
        Object object2;
        block4: {
            block3: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.storageIds;
                boolean $i$f$map = false;
                object2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void id;
                    StorageId storageId = (StorageId)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    int n2 = id.getType();
                    byte[] byArray = id.getRaw();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getRaw(...)");
                    collection.add(ManifestRecordIdentifierExtensionsKt.fromPossiblyUnknownType(ManifestRecord.Identifier.Companion, n2, byArray));
                }
                ids = (List)destination$iv$iv;
                n = this.sourceDeviceId;
                object = this.recordIkm;
                if (object == null) break block3;
                byte[] byArray = ((RecordIkm)object).getValue();
                object = byArray;
                if (byArray != null && (object = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])object, (int)0, (int)0, (int)3, null)) != null) break block4;
            }
            object = ByteString.EMPTY;
        }
        object2 = object;
        ManifestRecord manifestRecord = new ManifestRecord(0L, n, ids, (ByteString)object2, null, 17, null);
        return new StorageManifest(this.version, manifestRecord.encodeByteString(), null, 4, null).encode();
    }

    public final long component1() {
        return this.version;
    }

    public final int component2() {
        return this.sourceDeviceId;
    }

    @Nullable
    public final RecordIkm component3() {
        return this.recordIkm;
    }

    @NotNull
    public final List<StorageId> component4() {
        return this.storageIds;
    }

    @NotNull
    public final ByteSize component5() {
        return this.protoByteSize;
    }

    @NotNull
    public final SignalStorageManifest copy(long version, int sourceDeviceId, @Nullable RecordIkm recordIkm, @NotNull List<? extends StorageId> storageIds, @NotNull ByteSize protoByteSize) {
        Intrinsics.checkNotNullParameter(storageIds, (String)"storageIds");
        Intrinsics.checkNotNullParameter((Object)protoByteSize, (String)"protoByteSize");
        return new SignalStorageManifest(version, sourceDeviceId, recordIkm, storageIds, protoByteSize);
    }

    public static /* synthetic */ SignalStorageManifest copy$default(SignalStorageManifest signalStorageManifest, long l, int n, RecordIkm recordIkm, List list, ByteSize byteSize, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = signalStorageManifest.version;
        }
        if ((n2 & 2) != 0) {
            n = signalStorageManifest.sourceDeviceId;
        }
        if ((n2 & 4) != 0) {
            recordIkm = signalStorageManifest.recordIkm;
        }
        if ((n2 & 8) != 0) {
            list = signalStorageManifest.storageIds;
        }
        if ((n2 & 0x10) != 0) {
            byteSize = signalStorageManifest.protoByteSize;
        }
        return signalStorageManifest.copy(l, n, recordIkm, list, byteSize);
    }

    @NotNull
    public String toString() {
        return "SignalStorageManifest(version=" + this.version + ", sourceDeviceId=" + this.sourceDeviceId + ", recordIkm=" + this.recordIkm + ", storageIds=" + this.storageIds + ", protoByteSize=" + this.protoByteSize + ")";
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.version);
        result2 = result2 * 31 + Integer.hashCode(this.sourceDeviceId);
        result2 = result2 * 31 + (this.recordIkm == null ? 0 : this.recordIkm.hashCode());
        result2 = result2 * 31 + ((Object)this.storageIds).hashCode();
        result2 = result2 * 31 + this.protoByteSize.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SignalStorageManifest)) {
            return false;
        }
        SignalStorageManifest signalStorageManifest = (SignalStorageManifest)other;
        if (this.version != signalStorageManifest.version) {
            return false;
        }
        if (this.sourceDeviceId != signalStorageManifest.sourceDeviceId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.recordIkm, (Object)signalStorageManifest.recordIkm)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.storageIds, signalStorageManifest.storageIds)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.protoByteSize, (Object)signalStorageManifest.protoByteSize);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest$Companion;", "", "<init>", "()V", "EMPTY", "Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;", "getEMPTY", "()Lorg/whispersystems/signalservice/api/storage/SignalStorageManifest;", "deserialize", "serialized", "", "toProto", "Lorg/whispersystems/signalservice/internal/storage/protos/StorageManifest;", "version", "", "storageIds", "", "Lorg/whispersystems/signalservice/api/storage/StorageId;", "sourceDeviceId", "", "recordIkm", "Lorg/whispersystems/signalservice/api/storage/RecordIkm;", "signal-service-java"})
    @SourceDebugExtension(value={"SMAP\nSignalStorageManifest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignalStorageManifest.kt\norg/whispersystems/signalservice/api/storage/SignalStorageManifest$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ByteExtensions.kt\norg/signal/core/util/ByteExtensionsKt\n*L\n1#1,92:1\n1563#2:93\n1634#2,3:94\n1563#2:99\n1634#2,3:100\n1#3:97\n15#4:98\n*S KotlinDebug\n*F\n+ 1 SignalStorageManifest.kt\norg/whispersystems/signalservice/api/storage/SignalStorageManifest$Companion\n*L\n36#1:93\n36#1:94,3\n50#1:99\n50#1:100,3\n45#1:98\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SignalStorageManifest getEMPTY() {
            return EMPTY;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @NotNull
        public final SignalStorageManifest deserialize(@NotNull byte[] serialized) {
            Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
            manifest = (StorageManifest)StorageManifest.ADAPTER.decode(serialized);
            manifestRecord = (ManifestRecord)ManifestRecord.ADAPTER.decode(manifest.value_);
            $this$map$iv = manifestRecord.identifiers;
            $i$f$map = false;
            var7_9 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var12_16 = (ManifestRecord.Identifier)item$iv$iv;
                var14_18 = destination$iv$iv;
                $i$a$-map-SignalStorageManifest$Companion$deserialize$ids$1 = false;
                var14_18.add(StorageId.forType(id.raw.toByteArray(), ManifestRecordIdentifierExtensionsKt.getTypeValue((ManifestRecord.Identifier)id)));
            }
            ids = (List)destination$iv$iv;
            $this$mapTo$iv$iv = $i$f$map = manifestRecord.recordIkm;
            var17_20 = manifestRecord.sourceDevice;
            var15_21 = manifest.version;
            $i$a$-takeIf-SignalStorageManifest$Companion$deserialize$1 = false;
            var18_22 = ProtoUtil.isNotEmpty((ByteString)it);
            v0 = var15_21;
            v1 = var17_20;
            v2 /* !! */  = var18_22 != false ? $i$f$map : null;
            if (v2 /* !! */  == null) ** GOTO lbl-1000
            v3 = v2 /* !! */ .toByteArray();
            v2 /* !! */  = (ByteString)v3;
            if (v3 != null) {
                $i$a$-takeIf-SignalStorageManifest$Companion$deserialize$1 /* !! */  = v2 /* !! */ ;
                var17_20 = v1;
                var15_21 = v0;
                $i$a$-let-SignalStorageManifest$Companion$deserialize$2 = false;
                var18_23 = new RecordIkm((byte[])it);
                v0 = var15_21;
                v1 = var17_20;
                v4 = var18_23;
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            $this$bytes$iv = serialized.length;
            $i$f$getBytes = false;
            var19_24 = new ByteSize((long)$this$bytes$iv);
            var20_25 = ids;
            var21_26 = v4;
            var22_27 = v1;
            var23_28 = v0;
            return new SignalStorageManifest(var23_28, var22_27, var21_26, var20_25, var19_24);
        }

        /*
         * WARNING - void declaration
         */
        private final StorageManifest toProto(long version, List<? extends StorageId> storageIds, int sourceDeviceId, RecordIkm recordIkm) {
            Object object;
            List ids;
            block4: {
                block3: {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = storageIds;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void id;
                        StorageId storageId = (StorageId)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        int n = id.getType();
                        byte[] byArray = id.getRaw();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getRaw(...)");
                        collection.add(ManifestRecordIdentifierExtensionsKt.fromPossiblyUnknownType(ManifestRecord.Identifier.Companion, n, byArray));
                    }
                    ids = (List)destination$iv$iv;
                    object = recordIkm;
                    if (object == null) break block3;
                    byte[] byArray = ((RecordIkm)object).getValue();
                    object = byArray;
                    if (byArray != null && (object = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])object, (int)0, (int)0, (int)3, null)) != null) break block4;
                }
                object = ByteString.EMPTY;
            }
            Object object2 = object;
            ManifestRecord manifestRecord = new ManifestRecord(0L, sourceDeviceId, ids, (ByteString)object2, null, 17, null);
            return new StorageManifest(version, manifestRecord.encodeByteString(), null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

