/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.core.models.storageservice.StorageCipherKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.whispersystems.signalservice.internal.util.Util;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/storage/SignalStorageCipher;", "", "<init>", "()V", "IV_LENGTH", "", "encrypt", "", "key", "Lorg/signal/core/models/storageservice/StorageCipherKey;", "data", "decrypt", "signal-service-java"})
public final class SignalStorageCipher {
    @NotNull
    public static final SignalStorageCipher INSTANCE = new SignalStorageCipher();
    private static final int IV_LENGTH = 12;

    private SignalStorageCipher() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] encrypt(@NotNull StorageCipherKey key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] iv = Util.getSecretBytes(12);
            cipher.init(1, (Key)new SecretKeySpec(key.serialize(), "AES"), new GCMParameterSpec(128, iv));
            byte[] ciphertext = cipher.doFinal(data);
            Intrinsics.checkNotNull((Object)iv);
            Intrinsics.checkNotNull((Object)ciphertext);
            return ArraysKt.plus((byte[])iv, (byte[])ciphertext);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (java.security.InvalidKeyException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
        catch (BadPaddingException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new AssertionError((Object)e);
        }
    }

    @JvmStatic
    @NotNull
    public static final byte[] decrypt(@NotNull StorageCipherKey key, @NotNull byte[] data) throws InvalidKeyException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] iv = ArraysKt.copyOfRange((byte[])data, (int)0, (int)12);
            byte[] cipherText = ArraysKt.copyOfRange((byte[])data, (int)12, (int)data.length);
            cipher.init(2, (Key)new SecretKeySpec(key.serialize(), "AES"), new GCMParameterSpec(128, iv));
            byte[] byArray = cipher.doFinal(cipherText);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            return byArray;
        }
        catch (java.security.InvalidKeyException e) {
            throw new InvalidKeyException((Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException((Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchPaddingException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new AssertionError((Object)e);
        }
    }
}

