/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push;

import java.util.Objects;
import java.util.Optional;
import org.signal.core.models.ServiceId;
import org.signal.core.util.UuidUtil;
import org.whispersystems.signalservice.api.util.OptionalUtil;
import org.whispersystems.signalservice.api.util.Preconditions;

public class SignalServiceAddress {
    public static final int DEFAULT_DEVICE_ID = 1;
    private final ServiceId serviceId;
    private final Optional<String> e164;

    public SignalServiceAddress(ServiceId serviceId, Optional<String> e164) {
        this.serviceId = Preconditions.checkNotNull(serviceId);
        this.e164 = e164;
    }

    public SignalServiceAddress(ServiceId serviceId) {
        this.serviceId = Preconditions.checkNotNull(serviceId);
        this.e164 = Optional.empty();
    }

    public SignalServiceAddress(ServiceId serviceId, String e164) {
        this(serviceId, OptionalUtil.absentIfEmpty(e164));
    }

    public Optional<String> getNumber() {
        return this.e164;
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    public boolean hasValidServiceId() {
        return !this.serviceId.isUnknown();
    }

    public String getIdentifier() {
        return this.serviceId.toString();
    }

    public boolean matches(SignalServiceAddress other) {
        return this.serviceId.equals(other.serviceId);
    }

    public static boolean isValidAddress(String rawUuid) {
        return SignalServiceAddress.isValidAddress(rawUuid, null);
    }

    public static boolean isValidAddress(String rawUuid, String e164) {
        return UuidUtil.parseOrNull((String)rawUuid) != null;
    }

    public static Optional<SignalServiceAddress> fromRaw(String rawUuid, String e164) {
        if (SignalServiceAddress.isValidAddress(rawUuid, e164)) {
            return Optional.of(new SignalServiceAddress(ServiceId.parseOrThrow((String)rawUuid), e164));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalServiceAddress that = (SignalServiceAddress)o;
        return this.serviceId.equals(that.serviceId) && this.e164.equals(that.e164);
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.e164);
    }
}

