/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push;

import java.util.Objects;
import okio.ByteString;
import org.signal.core.models.ServiceId;

public final class ServiceIds {
    private final ServiceId.ACI aci;
    private final ServiceId.PNI pni;
    private ByteString aciByteString;
    private ByteString pniByteString;

    public ServiceIds(ServiceId.ACI aci, ServiceId.PNI pni) {
        this.aci = aci;
        this.pni = pni;
    }

    public ServiceId.ACI getAci() {
        return this.aci;
    }

    public ServiceId.PNI getPni() {
        return this.pni;
    }

    public ServiceId.PNI requirePni() {
        return Objects.requireNonNull(this.pni);
    }

    public boolean matches(ServiceId serviceId) {
        return serviceId.equals(this.aci) || this.pni != null && serviceId.equals(this.pni);
    }

    public boolean matches(ByteString serviceIdsBytes) {
        if (this.aciByteString == null) {
            this.aciByteString = this.aci.toByteString();
        }
        if (this.pniByteString == null && this.pni != null) {
            this.pniByteString = this.pni.toByteString();
        }
        return serviceIdsBytes.equals((Object)this.aciByteString) || serviceIdsBytes.equals((Object)this.pniByteString);
    }
}

