/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push;

import java.util.Objects;
import java.util.UUID;
import org.signal.core.util.UuidUtil;

public final class DistributionId {
    private static final String MY_STORY_STRING = "00000000-0000-0000-0000-000000000000";
    public static final DistributionId MY_STORY = DistributionId.from("00000000-0000-0000-0000-000000000000");
    private final UUID uuid;
    private final String stringValue;

    public static DistributionId from(String id) {
        return new DistributionId(UuidUtil.parseOrThrow((String)id));
    }

    public static DistributionId from(UUID uuid) {
        return new DistributionId(uuid);
    }

    public static DistributionId create() {
        return new DistributionId(UUID.randomUUID());
    }

    private DistributionId(UUID uuid) {
        this.uuid = uuid;
        this.stringValue = uuid.getLeastSignificantBits() == 0L && uuid.getMostSignificantBits() == 0L ? MY_STORY_STRING : this.uuid.toString();
    }

    public UUID asUuid() {
        return this.uuid;
    }

    public String toString() {
        return this.stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionId that = (DistributionId)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }
}

