/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.provisioning;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExceptionsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.Base64;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.registration.proto.RegistrationProvisionEnvelope;
import org.signal.registration.proto.RegistrationProvisionMessage;
import org.whispersystems.signalservice.api.SignalUrlExtensionsKt;
import org.whispersystems.signalservice.api.provisioning.ProvisioningSocket;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.configuration.SignalServiceUrl;
import org.whispersystems.signalservice.internal.configuration.SignalUrl;
import org.whispersystems.signalservice.internal.crypto.SecondaryProvisioningCipher;
import org.whispersystems.signalservice.internal.push.ProvisionEnvelope;
import org.whispersystems.signalservice.internal.push.ProvisionMessage;
import org.whispersystems.signalservice.internal.push.ProvisioningAddress;
import org.whispersystems.signalservice.internal.websocket.WebSocketMessage;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebSocketResponseMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 $*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0004$%&'B1\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u001e\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0086@\u00a2\u0006\u0002\u0010\u001fJ\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket;", "T", "", "mode", "Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$Mode;", "id", "", "identityKeyPair", "Lorg/signal/libsignal/protocol/IdentityKeyPair;", "configuration", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$Mode;ILorg/signal/libsignal/protocol/IdentityKeyPair;Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;Lkotlinx/coroutines/CoroutineScope;)V", "getId", "()I", "serviceUrl", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceUrl;", "okhttp", "Lokhttp3/OkHttpClient;", "cipher", "Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher;", "webSocket", "Lokhttp3/WebSocket;", "provisioningUrlDeferral", "Lkotlinx/coroutines/CompletableDeferred;", "", "provisioningMessageDeferral", "Lorg/whispersystems/signalservice/internal/crypto/SecondaryProvisioningCipher$ProvisioningDecryptResult;", "getProvisioningUrl", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getProvisioningMessageDecryptResult", "connect", "", "close", "Companion", "ProvisioningWebSocketListener", "Mode", "ProvisioningSocketExceptionHandler", "signal-service-java"})
public final class ProvisioningSocket<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Mode mode;
    private final int id;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final SignalServiceUrl serviceUrl;
    @NotNull
    private final OkHttpClient okhttp;
    @NotNull
    private final SecondaryProvisioningCipher cipher;
    @Nullable
    private WebSocket webSocket;
    @NotNull
    private final CompletableDeferred<String> provisioningUrlDeferral;
    @NotNull
    private final CompletableDeferred<SecondaryProvisioningCipher.ProvisioningDecryptResult<T>> provisioningMessageDeferral;
    @NotNull
    private static final String TAG = Log.tag((KClass)Reflection.getOrCreateKotlinClass(ProvisioningSocket.class));
    private static volatile int nextSocketId = 1000;
    private static final long LIFESPAN = DurationKt.toDuration((int)90, (DurationUnit)DurationUnit.SECONDS);

    private ProvisioningSocket(Mode mode, int id, IdentityKeyPair identityKeyPair, SignalServiceConfiguration configuration, CoroutineScope scope) {
        this.mode = mode;
        this.id = id;
        this.scope = scope;
        this.serviceUrl = (SignalServiceUrl)SignalUrlExtensionsKt.chooseUrl((SignalUrl[])configuration.getSignalServiceUrls());
        this.okhttp = SignalUrlExtensionsKt.buildOkHttpClient((SignalUrl)this.serviceUrl, configuration);
        this.cipher = new SecondaryProvisioningCipher(identityKeyPair);
        this.provisioningUrlDeferral = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.provisioningMessageDeferral = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    public final int getId() {
        return this.id;
    }

    @Nullable
    public final Object getProvisioningUrl(@NotNull Continuation<? super String> $completion) {
        return this.provisioningUrlDeferral.await($completion);
    }

    @Nullable
    public final Object getProvisioningMessageDecryptResult(@NotNull Continuation<? super SecondaryProvisioningCipher.ProvisioningDecryptResult<T>> $completion) {
        return this.provisioningMessageDeferral.await($completion);
    }

    private final void connect() {
        String string = this.serviceUrl.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        String uri = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"https://", (String)"wss://", (boolean)false, (int)4, null), (String)"http://", (String)"ws://", (boolean)false, (int)4, null);
        Request.Builder openRequest = new Request.Builder().url(uri + "/v1/websocket/provisioning/");
        if (this.serviceUrl.getHostHeader().isPresent()) {
            String string2 = this.serviceUrl.getHostHeader().get();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
            openRequest.addHeader("Host", string2);
            Log.w((String)TAG, (String)("Using alternate host: " + this.serviceUrl.getHostHeader().get()));
        }
        this.webSocket = this.okhttp.newWebSocket(openRequest.build(), (WebSocketListener)new ProvisioningWebSocketListener());
    }

    private final void close() {
        block0: {
            WebSocket webSocket = this.webSocket;
            if (webSocket == null) break block0;
            webSocket.close(1000, "Manual shutdown");
        }
    }

    public /* synthetic */ ProvisioningSocket(Mode mode, int id, IdentityKeyPair identityKeyPair, SignalServiceConfiguration configuration, CoroutineScope scope, DefaultConstructorMarker $constructor_marker) {
        this(mode, id, identityKeyPair, configuration, scope);
    }

    public static final /* synthetic */ void access$connect(ProvisioningSocket $this) {
        $this.connect();
    }

    public static final /* synthetic */ void access$close(ProvisioningSocket $this) {
        $this.close();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jf\u0010\r\u001a\u00020\u000e\"\u0004\b\u0001\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001723\u0010\u0018\u001a/\b\u0001\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019\u00a2\u0006\u0002\b\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!*\u00060\"j\u0002`#H\u0002J\f\u0010$\u001a\u00020\u0005*\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00020\t\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$Companion;", "", "<init>", "()V", "TAG", "", "nextSocketId", "", "LIFESPAN", "Lkotlin/time/Duration;", "getLIFESPAN-UwyO8pc", "()J", "J", "start", "Ljava/io/Closeable;", "T", "mode", "Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$Mode;", "identityKeyPair", "Lorg/signal/libsignal/protocol/IdentityKeyPair;", "configuration", "Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;", "handler", "Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$ProvisioningSocketExceptionHandler;", "block", "Lkotlin/Function3;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$Mode;Lorg/signal/libsignal/protocol/IdentityKeyPair;Lorg/whispersystems/signalservice/internal/configuration/SignalServiceConfiguration;Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$ProvisioningSocketExceptionHandler;Lkotlin/jvm/functions/Function3;)Ljava/io/Closeable;", "getRootCause", "", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "toMinimalString", "signal-service-java"})
    @SourceDebugExtension(value={"SMAP\nProvisioningSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvisioningSocket.kt\norg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$Companion\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,300:1\n46#2,4:301\n*S KotlinDebug\n*F\n+ 1 ProvisioningSocket.kt\norg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$Companion\n*L\n69#1:301,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final long getLIFESPAN-UwyO8pc() {
            return LIFESPAN;
        }

        @NotNull
        public final <T> Closeable start(@NotNull Mode mode, @NotNull IdentityKeyPair identityKeyPair, @NotNull SignalServiceConfiguration configuration, @NotNull ProvisioningSocketExceptionHandler handler, @NotNull Function3<? super CoroutineScope, ? super ProvisioningSocket<T>, ? super Continuation<? super Unit>, ? extends Object> block) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)identityKeyPair, (String)"identityKeyPair");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            int n = nextSocketId;
            nextSocketId = n + 1;
            int socketId = n;
            boolean $i$f$CoroutineExceptionHandler = false;
            CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
            CoroutineScope scope = CoroutineScopeKt.plus((CoroutineScope)CoroutineScopeKt.plus((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), (CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null))), (CoroutineContext)((CoroutineContext)new CoroutineExceptionHandler(key, handler, socketId){
                final /* synthetic */ ProvisioningSocketExceptionHandler $handler$inlined;
                final /* synthetic */ int $socketId$inlined;
                {
                    this.$handler$inlined = provisioningSocketExceptionHandler;
                    this.$socketId$inlined = n;
                    super((CoroutineContext.Key)$super_call_param$1);
                }

                public void handleException(CoroutineContext context, Throwable exception) {
                    Throwable t = exception;
                    boolean bl = false;
                    this.$handler$inlined.handleException(this.$socketId$inlined, t);
                }
            }));
            BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mode, socketId, identityKeyPair, configuration, scope, block, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Mode $mode;
                final /* synthetic */ int $socketId;
                final /* synthetic */ IdentityKeyPair $identityKeyPair;
                final /* synthetic */ SignalServiceConfiguration $configuration;
                final /* synthetic */ CoroutineScope $scope;
                final /* synthetic */ Function3<CoroutineScope, ProvisioningSocket<T>, Continuation<? super Unit>, Object> $block;
                {
                    this.$mode = $mode;
                    this.$socketId = $socketId;
                    this.$identityKeyPair = $identityKeyPair;
                    this.$configuration = $configuration;
                    this.$scope = $scope;
                    this.$block = $block;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            socket = null;
                            socket = new ProvisioningSocket<T>(this.$mode, this.$socketId, this.$identityKeyPair, this.$configuration, this.$scope, null);
                            ProvisioningSocket.access$connect(socket);
                            this.L$0 = socket;
                            this.label = 1;
                            v0 = this.$block.invoke((Object)$this$launch, socket, (Object)this);
                            ** if (v0 != var6_2) goto lbl16
lbl15:
                            // 1 sources

                            return var6_2;
lbl16:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            socket = (ProvisioningSocket<T>)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                            }
                            catch (CancellationException e) {
                                try {
                                    rootCause = org.whispersystems.signalservice.api.provisioning.ProvisioningSocket$Companion.access$getRootCause(ProvisioningSocket.Companion, e);
                                    if (rootCause == null) {
                                        Log.i((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + this.$socketId + "] Scope canceled expectedly, fail silently, " + org.whispersystems.signalservice.api.provisioning.ProvisioningSocket$Companion.access$toMinimalString(ProvisioningSocket.Companion, e)));
                                        throw e;
                                    }
                                    Log.w((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + this.$socketId + "] Unable to maintain web socket, " + org.whispersystems.signalservice.api.provisioning.ProvisioningSocket$Companion.access$toMinimalString(ProvisioningSocket.Companion, rootCause)), (Throwable)rootCause);
                                    throw rootCause;
                                }
                                catch (Throwable var4_6) {
                                    Log.d((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + this.$socketId + "] Closing web socket"));
                                    v2 = var3_4;
                                    if (v2 != null) {
                                        ProvisioningSocket.access$close((ProvisioningSocket)v2);
                                    }
                                    throw var4_6;
                                }
                            }
lbl23:
                            // 2 sources

                            Log.d((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + this.$socketId + "] Closing web socket"));
                            v1 = socket;
                            if (v1 != null) {
                                ProvisioningSocket.access$close(v1);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return () -> Companion.start$lambda$1(scope);
        }

        private final Throwable getRootCause(CancellationException $this$getRootCause) {
            Throwable cause = $this$getRootCause.getCause();
            while (cause != null && cause instanceof CancellationException) {
                cause = ((CancellationException)cause).getCause();
            }
            return cause;
        }

        private final String toMinimalString(Throwable $this$toMinimalString) {
            return $this$toMinimalString.getClass().getSimpleName() + "[" + $this$toMinimalString.getMessage() + "]";
        }

        private static final void start$lambda$1(CoroutineScope $scope) {
            CoroutineScopeKt.cancel$default((CoroutineScope)$scope, (String)"scope closed", null, (int)2, null);
        }

        public static final /* synthetic */ Throwable access$getRootCause(Companion $this, CancellationException $receiver) {
            return $this.getRootCause($receiver);
        }

        public static final /* synthetic */ String access$toMinimalString(Companion $this, Throwable $receiver) {
            return $this.toMinimalString($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$Mode;", "", "host", "", "params", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getParams", "REREG", "LINK", "signal-service-java"})
    public static final class Mode
    extends Enum<Mode> {
        @NotNull
        private final String host;
        @NotNull
        private final String params;
        public static final /* enum */ Mode REREG = new Mode("rereg", "");
        public static final /* enum */ Mode LINK = new Mode("linkdevice", "&capabilities=backup5");
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Mode(String host, String params) {
            this.host = host;
            this.params = params;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @NotNull
        public final String getParams() {
            return this.params;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.REREG, Mode.LINK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$ProvisioningSocketExceptionHandler;", "", "handleException", "", "id", "", "exception", "", "signal-service-java"})
    public static interface ProvisioningSocketExceptionHandler {
        public void handleException(int var1, @NotNull Throwable var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J\u0016\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket$ProvisioningWebSocketListener;", "Lokhttp3/WebSocketListener;", "<init>", "(Lorg/whispersystems/signalservice/api/provisioning/ProvisioningSocket;)V", "keepAliveJob", "Lkotlinx/coroutines/Job;", "lastKeepAliveId", "", "onOpen", "", "webSocket", "Lokhttp3/WebSocket;", "response", "Lokhttp3/Response;", "onMessage", "bytes", "Lokio/ByteString;", "onClosing", "code", "", "reason", "", "onFailure", "t", "", "generateProvisioningUrl", "deviceAddress", "keepAlive", "(Lokhttp3/WebSocket;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toResponse", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketMessage;", "Lorg/whispersystems/signalservice/internal/websocket/WebSocketRequestMessage;", "signal-service-java"})
    private final class ProvisioningWebSocketListener
    extends WebSocketListener {
        @Nullable
        private Job keepAliveJob;
        private volatile long lastKeepAliveId;

        public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Log.d((String)TAG, (String)("[" + ProvisioningSocket.this.getId() + "] [onOpen]"));
            this.keepAliveJob = BuildersKt.launch$default((CoroutineScope)ProvisioningSocket.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, webSocket, null){
                int label;
                final /* synthetic */ ProvisioningWebSocketListener this$0;
                final /* synthetic */ WebSocket $webSocket;
                {
                    this.this$0 = $receiver;
                    this.$webSocket = $webSocket;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = ProvisioningWebSocketListener.access$keepAlive(this.this$0, this.$webSocket, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            Job timeoutJob2 = BuildersKt.launch$default((CoroutineScope)ProvisioningSocket.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ProvisioningSocket.this, null){
                int label;
                final /* synthetic */ ProvisioningSocket<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            CoroutineScopeKt.cancel((CoroutineScope)ProvisioningSocket.access$getScope$p(this.this$0), (String)"Did not receive device id within 10 seconds", (Throwable)new SocketTimeoutException("No device id received"));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            Job webSocketExpireJob2 = BuildersKt.launch$default((CoroutineScope)ProvisioningSocket.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ProvisioningSocket.this, null){
                int label;
                final /* synthetic */ ProvisioningSocket<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)ProvisioningSocket.Companion.getLIFESPAN-UwyO8pc(), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            CoroutineScopeKt.cancel((CoroutineScope)ProvisioningSocket.access$getScope$p(this.this$0), (String)("Did not complete a registration within " + Duration.getInWholeSeconds-impl((long)ProvisioningSocket.Companion.getLIFESPAN-UwyO8pc()) + " seconds"), (Throwable)new SocketTimeoutException("No provisioning message received"));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            BuildersKt.launch$default((CoroutineScope)ProvisioningSocket.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ProvisioningSocket.this, timeoutJob2, webSocketExpireJob2, null){
                int label;
                final /* synthetic */ ProvisioningSocket<T> this$0;
                final /* synthetic */ Job $timeoutJob;
                final /* synthetic */ Job $webSocketExpireJob;
                {
                    this.this$0 = $receiver;
                    this.$timeoutJob = $timeoutJob;
                    this.$webSocketExpireJob = $webSocketExpireJob;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = ProvisioningSocket.access$getProvisioningUrlDeferral$p(this.this$0).await((Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            Job.DefaultImpls.cancel$default((Job)this.$timeoutJob, null, (int)1, null);
                            this.label = 2;
                            v1 = ProvisioningSocket.access$getProvisioningMessageDeferral$p(this.this$0).await((Continuation)this);
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl22
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl22:
                            // 2 sources

                            Job.DefaultImpls.cancel$default((Job)this.$webSocketExpireJob, null, (int)1, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            WebSocketMessage message = (WebSocketMessage)((Object)WebSocketMessage.ADAPTER.decode(bytes));
            if (message.response != null) {
                Long l = message.response.id;
                long l2 = this.lastKeepAliveId;
                if (l != null && l == l2) {
                    Log.d((String)TAG, (String)("[" + ProvisioningSocket.this.getId() + "] [onMessage] Keep alive received"));
                    return;
                }
            }
            if (message.request == null) {
                Log.w((String)TAG, (String)("[" + ProvisioningSocket.this.getId() + "] [onMessage] Received null request"));
                return;
            }
            boolean success = webSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])this.toResponse(message.request).encode(), (int)0, (int)0, (int)3, null));
            if (!success) {
                Log.w((String)TAG, (String)("[" + ProvisioningSocket.this.getId() + "] [onMessage] Failed to send response"));
                webSocket.close(1000, "OK");
                return;
            }
            Log.d((String)TAG, (String)("[" + ProvisioningSocket.this.getId() + "] [onMessage] Processing request"));
            if (Intrinsics.areEqual((Object)message.request.verb, (Object)"PUT") && message.request.body != null) {
                String string = message.request.path;
                if (Intrinsics.areEqual((Object)string, (Object)"/v1/address")) {
                    String address = ((ProvisioningAddress)((Object)ProvisioningAddress.ADAPTER.decode((ByteString)message.request.body))).address;
                    if (address == null) throw new IOException("Device address is null");
                    ProvisioningSocket.this.provisioningUrlDeferral.complete((Object)this.generateProvisioningUrl(address));
                    return;
                } else if (Intrinsics.areEqual((Object)string, (Object)"/v1/message")) {
                    switch (WhenMappings.$EnumSwitchMapping$0[ProvisioningSocket.this.mode.ordinal()]) {
                        case 1: {
                            CompletableDeferred completableDeferred = ProvisioningSocket.this.provisioningMessageDeferral;
                            SecondaryProvisioningCipher.ProvisioningDecryptResult<RegistrationProvisionMessage> provisioningDecryptResult = ProvisioningSocket.this.cipher.decrypt((RegistrationProvisionEnvelope)((Object)RegistrationProvisionEnvelope.ADAPTER.decode(message.request.body)));
                            Intrinsics.checkNotNull(provisioningDecryptResult, (String)"null cannot be cast to non-null type org.whispersystems.signalservice.internal.crypto.SecondaryProvisioningCipher.ProvisioningDecryptResult<T of org.whispersystems.signalservice.api.provisioning.ProvisioningSocket>");
                            boolean bl = completableDeferred.complete(provisioningDecryptResult);
                            return;
                        }
                        case 2: {
                            CompletableDeferred completableDeferred = ProvisioningSocket.this.provisioningMessageDeferral;
                            SecondaryProvisioningCipher.ProvisioningDecryptResult<ProvisionMessage> provisioningDecryptResult = ProvisioningSocket.this.cipher.decrypt((ProvisionEnvelope)((Object)ProvisionEnvelope.ADAPTER.decode(message.request.body)));
                            Intrinsics.checkNotNull(provisioningDecryptResult, (String)"null cannot be cast to non-null type org.whispersystems.signalservice.internal.crypto.SecondaryProvisioningCipher.ProvisioningDecryptResult<T of org.whispersystems.signalservice.api.provisioning.ProvisioningSocket>");
                            boolean bl = completableDeferred.complete(provisioningDecryptResult);
                            return;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                } else {
                    Log.w((String)TAG, (String)("[" + ProvisioningSocket.this.getId() + "] Unknown path requested"));
                }
                return;
            } else {
                Log.w((String)TAG, (String)("[" + ProvisioningSocket.this.getId() + "] Invalid data"));
            }
        }

        public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            BuildersKt.launch$default((CoroutineScope)ProvisioningSocket.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ProvisioningSocket.this, code, reason, webSocket, null){
                int label;
                final /* synthetic */ ProvisioningSocket<T> this$0;
                final /* synthetic */ int $code;
                final /* synthetic */ String $reason;
                final /* synthetic */ WebSocket $webSocket;
                {
                    this.this$0 = $receiver;
                    this.$code = $code;
                    this.$reason = $reason;
                    this.$webSocket = $webSocket;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Log.i((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + this.this$0.getId() + "] [onClosing] code: " + this.$code + " reason: " + this.$reason));
                            if (this.$code != 1000) {
                                Log.w((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + this.this$0.getId() + "] Remote side is closing with non-normal code " + this.$code));
                                this.$webSocket.close(1000, "Remote closed with code " + this.$code);
                            }
                            CoroutineScopeKt.cancel$default((CoroutineScope)ProvisioningSocket.access$getScope$p(this.this$0), null, (int)1, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            BuildersKt.launch$default((CoroutineScope)ProvisioningSocket.this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ProvisioningSocket.this, t, webSocket, null){
                int label;
                final /* synthetic */ ProvisioningSocket<T> this$0;
                final /* synthetic */ Throwable $t;
                final /* synthetic */ WebSocket $webSocket;
                {
                    this.this$0 = $receiver;
                    this.$t = $t;
                    this.$webSocket = $webSocket;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Log.w((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + this.this$0.getId() + "] [onFailure] Failed"), (Throwable)this.$t);
                            this.$webSocket.close(1000, "Failed " + this.$t.getMessage());
                            CoroutineScopeKt.cancel((CoroutineScope)ProvisioningSocket.access$getScope$p(this.this$0), (CancellationException)ExceptionsKt.CancellationException((String)"WebSocket Failure", (Throwable)this.$t));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private final String generateProvisioningUrl(String deviceAddress) {
            String encodedDeviceId = URLEncoder.encode(deviceAddress, "UTF-8");
            byte[] byArray = ProvisioningSocket.this.cipher.getSecondaryDevicePublicKey().serialize();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serialize(...)");
            String string = URLEncoder.encode(Base64.encodeWithoutPadding((byte[])byArray), "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
            String encodedPubKey = string;
            return "sgnl://" + ProvisioningSocket.this.mode.getHost() + "?uuid=" + encodedDeviceId + "&pub_key=" + encodedPubKey + ProvisioningSocket.this.mode.getParams();
        }

        /*
         * Unable to fully structure code
         */
        private final Object keepAlive(WebSocket var1_1, Continuation<? super Unit> $completion) {
            if (!($completion instanceof keepAlive.1)) ** GOTO lbl-1000
            var7_3 = $completion;
            if ((var7_3.label & -2147483648) != 0) {
                var7_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ ProvisioningWebSocketListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ProvisioningWebSocketListener.access$keepAlive(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    Log.i((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + ProvisioningSocket.this.getId() + "] [keepAlive] Starting"));
lbl14:
                    // 3 sources

                    while (true) {
                        $continuation.L$0 = this;
                        $continuation.L$1 = webSocket;
                        $continuation.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), (Continuation)$continuation);
                        if (v0 == var8_5) {
                            return var8_5;
                        }
                        ** GOTO lbl28
                        break;
                    }
                }
                case 1: {
                    webSocket = (WebSocket)$continuation.L$1;
                    this = (ProvisioningWebSocketListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    Log.i((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + ProvisioningSocket.this.getId() + "] [keepAlive] Sending..."));
                    id = System.currentTimeMillis();
                    message = new WebSocketMessage(WebSocketMessage.Type.REQUEST, new WebSocketRequestMessage("GET", "/v1/keepalive", null, null, Boxing.boxLong((long)id), null, 44, null), null, null, 12, null);
                    if (webSocket.send(message.encodeByteString())) ** GOTO lbl34
                    Log.w((String)ProvisioningSocket.access$getTAG$cp(), (String)("[" + ProvisioningSocket.this.getId() + "] [keepAlive] Send failed"));
                    ** GOTO lbl14
lbl34:
                    // 1 sources

                    this.lastKeepAliveId = id;
                    ** continue;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final WebSocketMessage toResponse(WebSocketRequestMessage $this$toResponse) {
            return new WebSocketMessage(WebSocketMessage.Type.RESPONSE, null, new WebSocketResponseMessage($this$toResponse.id, 200, "OK", null, null, null, 56, null), null, 10, null);
        }

        public static final /* synthetic */ Object access$keepAlive(ProvisioningWebSocketListener $this, WebSocket webSocket, Continuation $completion) {
            return $this.keepAlive(webSocket, (Continuation<? super Unit>)$completion);
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Mode.values().length];
                try {
                    nArray[Mode.REREG.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Mode.LINK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

