/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.profiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.math.BigDecimal;
import java.util.List;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredentialResponse;
import org.whispersystems.signalservice.internal.util.JsonUtil;

public class SignalServiceProfile {
    private static final String TAG = SignalServiceProfile.class.getSimpleName();
    @JsonProperty
    private String identityKey;
    @JsonProperty
    private String name;
    @JsonProperty
    private String about;
    @JsonProperty
    private String aboutEmoji;
    @JsonProperty
    private byte[] paymentAddress;
    @JsonProperty
    private String avatar;
    @JsonProperty
    private String unidentifiedAccess;
    @JsonProperty
    private boolean unrestrictedUnidentifiedAccess;
    @JsonProperty
    private Capabilities capabilities;
    @JsonProperty
    @JsonSerialize(using=JsonUtil.ServiceIdSerializer.class)
    @JsonDeserialize(using=JsonUtil.ServiceIdDeserializer.class)
    private ServiceId uuid;
    @JsonProperty
    private byte[] credential;
    @JsonProperty
    private List<Badge> badges;
    @JsonProperty
    private String phoneNumberSharing;
    @JsonIgnore
    private RequestType requestType;

    public String getIdentityKey() {
        return this.identityKey;
    }

    public String getName() {
        return this.name;
    }

    public String getAbout() {
        return this.about;
    }

    public String getAboutEmoji() {
        return this.aboutEmoji;
    }

    public byte[] getPaymentAddress() {
        return this.paymentAddress;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getUnidentifiedAccess() {
        return this.unidentifiedAccess;
    }

    public String getPhoneNumberSharing() {
        return this.phoneNumberSharing;
    }

    public boolean isUnrestrictedUnidentifiedAccess() {
        return this.unrestrictedUnidentifiedAccess;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public List<Badge> getBadges() {
        return this.badges;
    }

    public ServiceId getServiceId() {
        return this.uuid;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public ExpiringProfileKeyCredentialResponse getExpiringProfileKeyCredentialResponse() {
        if (this.credential == null) {
            return null;
        }
        try {
            return new ExpiringProfileKeyCredentialResponse(this.credential);
        }
        catch (InvalidInputException e) {
            Log.w((String)TAG, (Throwable)e);
            return null;
        }
    }

    public static class Capabilities {
        @JsonProperty
        private boolean storage;
        @JsonProperty(value="ssre2")
        private boolean storageServiceEncryptionV2;

        @JsonCreator
        public Capabilities() {
        }

        public Capabilities(boolean storage, boolean storageServiceEncryptionV2) {
            this.storage = storage;
            this.storageServiceEncryptionV2 = storageServiceEncryptionV2;
        }

        public boolean isStorage() {
            return this.storage;
        }

        public boolean isStorageServiceEncryptionV2() {
            return this.storageServiceEncryptionV2;
        }
    }

    public static enum RequestType {
        PROFILE,
        PROFILE_AND_CREDENTIAL;

    }

    public static class Badge {
        @JsonProperty
        private String id;
        @JsonProperty
        private String category;
        @JsonProperty
        private String name;
        @JsonProperty
        private String description;
        @JsonProperty
        private List<String> sprites6;
        @JsonProperty
        private BigDecimal expiration;
        @JsonProperty
        private boolean visible;
        @JsonProperty
        private long duration;

        public String getId() {
            return this.id;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getSprites6() {
            return this.sprites6;
        }

        public BigDecimal getExpiration() {
            return this.expiration;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

