/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.profiles;

import io.reactivex.rxjava3.core.Single;
import java.security.SecureRandom;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.ServiceId;
import org.signal.core.util.Hex;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.profiles.ClientZkProfileOperations;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCredentialRequestContext;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyVersion;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.crypto.ProfileCipher;
import org.whispersystems.signalservice.api.crypto.ProfileCipherOutputStream;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.profiles.AvatarUploadParams;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfile;
import org.whispersystems.signalservice.api.profiles.SignalServiceProfileWrite;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.PaymentAddress;
import org.whispersystems.signalservice.internal.push.ProfileAvatarData;
import org.whispersystems.signalservice.internal.push.ProfileAvatarUploadAttributes;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.push.http.ProfileCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJd\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ2\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#J&\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020 0\r2\u0006\u0010&\u001a\u00020'2\b\u0010\"\u001a\u0004\u0018\u00010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/whispersystems/signalservice/api/profiles/ProfileApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "unauthWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "clientZkProfileOperations", "Lorg/signal/libsignal/zkgroup/profiles/ClientZkProfileOperations;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;Lorg/signal/libsignal/zkgroup/profiles/ClientZkProfileOperations;)V", "setVersionedProfile", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "aci", "Lorg/signal/core/models/ServiceId$ACI;", "profileKey", "Lorg/signal/libsignal/zkgroup/profiles/ProfileKey;", "name", "about", "aboutEmoji", "paymentsAddress", "Lorg/whispersystems/signalservice/internal/push/PaymentAddress;", "avatar", "Lorg/whispersystems/signalservice/api/profiles/AvatarUploadParams;", "visibleBadgeIds", "", "phoneNumberSharing", "", "getVersionedProfileAndCredential", "Lkotlin/Pair;", "Lorg/whispersystems/signalservice/api/profiles/SignalServiceProfile;", "Lorg/signal/libsignal/zkgroup/profiles/ExpiringProfileKeyCredential;", "sealedSenderAccess", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "getVersionedProfile", "getUnversionedProfile", "serviceId", "Lorg/signal/core/models/ServiceId;", "Companion", "ProfileAndCredentialResponseConverter", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nProfileApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileApi.kt\norg/whispersystems/signalservice/api/profiles/ProfileApi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
public final class ProfileApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket;
    @NotNull
    private final PushServiceSocket pushServiceSocket;
    @NotNull
    private final ClientZkProfileOperations clientZkProfileOperations;
    @NotNull
    private static final String TAG = Log.tag((KClass)Reflection.getOrCreateKotlinClass(ProfileApi.class));

    public ProfileApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket, @NotNull SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket, @NotNull PushServiceSocket pushServiceSocket, @NotNull ClientZkProfileOperations clientZkProfileOperations) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        Intrinsics.checkNotNullParameter((Object)unauthWebSocket, (String)"unauthWebSocket");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        Intrinsics.checkNotNullParameter((Object)clientZkProfileOperations, (String)"clientZkProfileOperations");
        this.authWebSocket = authWebSocket;
        this.unauthWebSocket = unauthWebSocket;
        this.pushServiceSocket = pushServiceSocket;
        this.clientZkProfileOperations = clientZkProfileOperations;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NetworkResult<String> setVersionedProfile(@NotNull ServiceId.ACI aci, @NotNull ProfileKey profileKey, @Nullable String name, @Nullable String about, @Nullable String aboutEmoji, @Nullable PaymentAddress paymentsAddress, @NotNull AvatarUploadParams avatar, @NotNull List<String> visibleBadgeIds, boolean phoneNumberSharing) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)profileKey, (String)"profileKey");
        Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
        Intrinsics.checkNotNullParameter(visibleBadgeIds, (String)"visibleBadgeIds");
        ProfileCipher profileCipher = new ProfileCipher(profileKey);
        String string = profileKey.getProfileKeyVersion(aci.getLibSignalAci()).serialize();
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        String string3 = name;
        if (string3 == null) {
            string3 = "";
        }
        byte[] byArray2 = profileCipher.encryptString(string3, ProfileCipher.getTargetNameLength(name));
        byte[] byArray3 = byArray2;
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encryptString(...)");
        String string4 = about;
        if (string4 == null) {
            string4 = "";
        }
        byte[] byArray4 = profileCipher.encryptString(string4, ProfileCipher.getTargetAboutLength(about));
        byte[] byArray5 = byArray4;
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"encryptString(...)");
        String string5 = aboutEmoji;
        if (string5 == null) {
            string5 = "";
        }
        byte[] byArray6 = profileCipher.encryptString(string5, 32);
        byte[] byArray7 = byArray6;
        Intrinsics.checkNotNullExpressionValue((Object)byArray6, (String)"encryptString(...)");
        PaymentAddress paymentAddress = paymentsAddress;
        if (paymentAddress != null) {
            void it;
            PaymentAddress paymentAddress2 = paymentAddress;
            byte[] byArray8 = byArray7;
            byte[] byArray9 = byArray5;
            byte[] byArray10 = byArray3;
            String string6 = string2;
            boolean bl = false;
            byte[] byArray11 = profileCipher.encryptWithLength(it.encode(), 554);
            string2 = string6;
            byArray3 = byArray10;
            byArray5 = byArray9;
            byArray7 = byArray8;
            byArray = byArray11;
        } else {
            byArray = null;
        }
        byte[] byArray12 = profileCipher.encryptBoolean(phoneNumberSharing);
        Intrinsics.checkNotNullExpressionValue((Object)byArray12, (String)"encryptBoolean(...)");
        boolean bl = avatar.hasAvatar;
        boolean bl2 = avatar.keepTheSame;
        byte[] byArray13 = profileKey.getCommitment(aci.getLibSignalAci()).serialize();
        Intrinsics.checkNotNullExpressionValue((Object)byArray13, (String)"serialize(...)");
        List<String> list = visibleBadgeIds;
        byte[] byArray14 = byArray13;
        boolean bl3 = bl2;
        boolean bl4 = bl;
        byte[] byArray15 = byArray12;
        byte[] byArray16 = byArray;
        byte[] byArray17 = byArray7;
        byte[] byArray18 = byArray5;
        byte[] byArray19 = byArray3;
        String string7 = string2;
        SignalServiceProfileWrite profileWrite = new SignalServiceProfileWrite(string7, byArray19, byArray18, byArray17, byArray16, byArray15, bl4, bl3, byArray14, list);
        ProfileAvatarData profileAvatarData = avatar.stream != null && !avatar.keepTheSame ? new ProfileAvatarData(avatar.stream.getStream(), ProfileCipherOutputStream.getCiphertextLength(avatar.stream.getLength()), avatar.stream.getContentType(), new ProfileCipherOutputStreamFactory(profileKey)) : null;
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/profile", profileWrite, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(String.class), 0L, 8, null).then(arg_0 -> ProfileApi.setVersionedProfile$lambda$1(profileWrite, profileAvatarData, this, arg_0));
    }

    @NotNull
    public final NetworkResult<Pair<SignalServiceProfile, ExpiringProfileKeyCredential>> getVersionedProfileAndCredential(@NotNull ServiceId.ACI aci, @NotNull ProfileKey profileKey, @Nullable SealedSenderAccess sealedSenderAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)profileKey, (String)"profileKey");
        String profileVersion = profileKey.getProfileKeyVersion(aci.getLibSignalAci()).serialize();
        ProfileKeyCredentialRequestContext profileRequestContext = this.clientZkProfileOperations.createProfileKeyCredentialRequestContext(new SecureRandom(), aci.getLibSignalAci(), profileKey);
        String serializedProfileRequest = Hex.toStringCondensed((byte[])profileRequestContext.getRequest().serialize());
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/profile/" + aci + "/" + profileVersion + "/" + serializedProfileRequest + "?credentialType=expiringProfileKey", null, 2, null);
        Intrinsics.checkNotNull((Object)profileRequestContext);
        ProfileAndCredentialResponseConverter converter = new ProfileAndCredentialResponseConverter(this.clientZkProfileOperations, profileRequestContext);
        return sealedSenderAccess == null ? NetworkResult.Companion.fromWebSocket(converter, () -> ProfileApi.getVersionedProfileAndCredential$lambda$2(this, request2)) : NetworkResult.Companion.fromWebSocket(converter, () -> ProfileApi.getVersionedProfileAndCredential$lambda$3(this, request2, sealedSenderAccess)).fallback(ProfileApi::getVersionedProfileAndCredential$lambda$4, () -> ProfileApi.getVersionedProfileAndCredential$lambda$6(converter, this, request2));
    }

    @NotNull
    public final NetworkResult<SignalServiceProfile> getVersionedProfile(@NotNull ServiceId.ACI aci, @NotNull ProfileKey profileKey, @Nullable SealedSenderAccess sealedSenderAccess) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Intrinsics.checkNotNullParameter((Object)profileKey, (String)"profileKey");
        ProfileKeyVersion profileKeyIdentifier = profileKey.getProfileKeyVersion(aci.getLibSignalAci());
        String profileVersion = profileKeyIdentifier.serialize();
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/profile/" + aci + "/" + profileVersion, null, 2, null);
        NetworkResult.DefaultWebSocketConverter converter = new NetworkResult.DefaultWebSocketConverter(Reflection.getOrCreateKotlinClass(SignalServiceProfile.class));
        return sealedSenderAccess == null ? NetworkResult.Companion.fromWebSocket(converter, () -> ProfileApi.getVersionedProfile$lambda$7(this, request2)) : NetworkResult.Companion.fromWebSocket(converter, () -> ProfileApi.getVersionedProfile$lambda$8(this, request2, sealedSenderAccess)).fallback(ProfileApi::getVersionedProfile$lambda$9, () -> ProfileApi.getVersionedProfile$lambda$11(converter, this, request2));
    }

    @NotNull
    public final NetworkResult<SignalServiceProfile> getUnversionedProfile(@NotNull ServiceId serviceId, @Nullable SealedSenderAccess sealedSenderAccess) {
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/profile/" + serviceId, null, 2, null);
        NetworkResult.DefaultWebSocketConverter converter = new NetworkResult.DefaultWebSocketConverter(Reflection.getOrCreateKotlinClass(SignalServiceProfile.class));
        return sealedSenderAccess == null ? NetworkResult.Companion.fromWebSocket(converter, () -> ProfileApi.getUnversionedProfile$lambda$12(this, request2)) : NetworkResult.Companion.fromWebSocket(converter, () -> ProfileApi.getUnversionedProfile$lambda$13(this, request2, sealedSenderAccess)).fallback(ProfileApi::getUnversionedProfile$lambda$14, () -> ProfileApi.getUnversionedProfile$lambda$16(converter, this, request2));
    }

    private static final NetworkResult setVersionedProfile$lambda$1(SignalServiceProfileWrite $profileWrite, ProfileAvatarData $profileAvatarData, ProfileApi this$0, String fromResponse) {
        NetworkResult<String> networkResult;
        Intrinsics.checkNotNullParameter((Object)fromResponse, (String)"fromResponse");
        if ($profileWrite.getAvatar() && $profileAvatarData != null) {
            ProfileAvatarUploadAttributes formAttributes = JsonUtil.fromJsonResponse(fromResponse, ProfileAvatarUploadAttributes.class);
            networkResult = this$0.pushServiceSocket.uploadProfileAvatar(formAttributes, $profileAvatarData);
        } else {
            networkResult = (NetworkResult<String>)new NetworkResult.Success<Object>(null);
        }
        NetworkResult<String> networkResult2 = networkResult;
        Intrinsics.checkNotNull((Object)networkResult2);
        return networkResult2;
    }

    private static final Single getVersionedProfileAndCredential$lambda$2(ProfileApi this$0, WebSocketRequestMessage $request) {
        return this$0.authWebSocket.request($request);
    }

    private static final Single getVersionedProfileAndCredential$lambda$3(ProfileApi this$0, WebSocketRequestMessage $request, SealedSenderAccess $sealedSenderAccess) {
        return this$0.unauthWebSocket.request($request, $sealedSenderAccess);
    }

    private static final boolean getVersionedProfileAndCredential$lambda$4(NetworkResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof NetworkResult.StatusCodeError && ((NetworkResult.StatusCodeError)it).getCode() == 401;
    }

    private static final Single getVersionedProfileAndCredential$lambda$6$lambda$5(ProfileApi this$0, WebSocketRequestMessage $request) {
        return this$0.authWebSocket.request($request);
    }

    private static final NetworkResult getVersionedProfileAndCredential$lambda$6(ProfileAndCredentialResponseConverter $converter, ProfileApi this$0, WebSocketRequestMessage $request) {
        return NetworkResult.Companion.fromWebSocket($converter, () -> ProfileApi.getVersionedProfileAndCredential$lambda$6$lambda$5(this$0, $request));
    }

    private static final Single getVersionedProfile$lambda$7(ProfileApi this$0, WebSocketRequestMessage $request) {
        return this$0.authWebSocket.request($request);
    }

    private static final Single getVersionedProfile$lambda$8(ProfileApi this$0, WebSocketRequestMessage $request, SealedSenderAccess $sealedSenderAccess) {
        return this$0.unauthWebSocket.request($request, $sealedSenderAccess);
    }

    private static final boolean getVersionedProfile$lambda$9(NetworkResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof NetworkResult.StatusCodeError && ((NetworkResult.StatusCodeError)it).getCode() == 401;
    }

    private static final Single getVersionedProfile$lambda$11$lambda$10(ProfileApi this$0, WebSocketRequestMessage $request) {
        return this$0.authWebSocket.request($request);
    }

    private static final NetworkResult getVersionedProfile$lambda$11(NetworkResult.DefaultWebSocketConverter $converter, ProfileApi this$0, WebSocketRequestMessage $request) {
        return NetworkResult.Companion.fromWebSocket($converter, () -> ProfileApi.getVersionedProfile$lambda$11$lambda$10(this$0, $request));
    }

    private static final Single getUnversionedProfile$lambda$12(ProfileApi this$0, WebSocketRequestMessage $request) {
        return this$0.authWebSocket.request($request);
    }

    private static final Single getUnversionedProfile$lambda$13(ProfileApi this$0, WebSocketRequestMessage $request, SealedSenderAccess $sealedSenderAccess) {
        return this$0.unauthWebSocket.request($request, $sealedSenderAccess);
    }

    private static final boolean getUnversionedProfile$lambda$14(NetworkResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof NetworkResult.StatusCodeError && ((NetworkResult.StatusCodeError)it).getCode() == 401;
    }

    private static final Single getUnversionedProfile$lambda$16$lambda$15(ProfileApi this$0, WebSocketRequestMessage $request) {
        return this$0.authWebSocket.request($request);
    }

    private static final NetworkResult getUnversionedProfile$lambda$16(NetworkResult.DefaultWebSocketConverter $converter, ProfileApi this$0, WebSocketRequestMessage $request) {
        return NetworkResult.Companion.fromWebSocket($converter, () -> ProfileApi.getUnversionedProfile$lambda$16$lambda$15(this$0, $request));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/whispersystems/signalservice/api/profiles/ProfileApi$Companion;", "", "<init>", "()V", "TAG", "", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/whispersystems/signalservice/api/profiles/ProfileApi$ProfileAndCredentialResponseConverter;", "Lorg/whispersystems/signalservice/api/NetworkResult$WebSocketResponseConverter;", "Lkotlin/Pair;", "Lorg/whispersystems/signalservice/api/profiles/SignalServiceProfile;", "Lorg/signal/libsignal/zkgroup/profiles/ExpiringProfileKeyCredential;", "clientZkProfileOperations", "Lorg/signal/libsignal/zkgroup/profiles/ClientZkProfileOperations;", "requestContext", "Lorg/signal/libsignal/zkgroup/profiles/ProfileKeyCredentialRequestContext;", "<init>", "(Lorg/signal/libsignal/zkgroup/profiles/ClientZkProfileOperations;Lorg/signal/libsignal/zkgroup/profiles/ProfileKeyCredentialRequestContext;)V", "convert", "Lorg/whispersystems/signalservice/api/NetworkResult;", "response", "Lorg/whispersystems/signalservice/internal/websocket/WebsocketResponse;", "signal-service-java"})
    private static final class ProfileAndCredentialResponseConverter
    implements NetworkResult.WebSocketResponseConverter<Pair<? extends SignalServiceProfile, ? extends ExpiringProfileKeyCredential>> {
        @NotNull
        private final ClientZkProfileOperations clientZkProfileOperations;
        @NotNull
        private final ProfileKeyCredentialRequestContext requestContext;

        public ProfileAndCredentialResponseConverter(@NotNull ClientZkProfileOperations clientZkProfileOperations, @NotNull ProfileKeyCredentialRequestContext requestContext) {
            Intrinsics.checkNotNullParameter((Object)clientZkProfileOperations, (String)"clientZkProfileOperations");
            Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
            this.clientZkProfileOperations = clientZkProfileOperations;
            this.requestContext = requestContext;
        }

        @Override
        @NotNull
        public NetworkResult<Pair<SignalServiceProfile, ExpiringProfileKeyCredential>> convert(@NotNull WebsocketResponse response) {
            NetworkResult<Pair<SignalServiceProfile, ExpiringProfileKeyCredential>> networkResult;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (response.getStatus() != 200) {
                return this.toStatusCodeError(response);
            }
            try {
                networkResult = this.toSuccess(response, Reflection.getOrCreateKotlinClass(SignalServiceProfile.class)).map(arg_0 -> ProfileAndCredentialResponseConverter.convert$lambda$0(this, arg_0));
            }
            catch (VerificationFailedException e) {
                networkResult = new NetworkResult.ApplicationError(e);
            }
            return networkResult;
        }

        private static final Pair convert$lambda$0(ProfileAndCredentialResponseConverter this$0, SignalServiceProfile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ExpiringProfileKeyCredential credential = this$0.clientZkProfileOperations.receiveExpiringProfileKeyCredential(this$0.requestContext, it.getExpiringProfileKeyCredentialResponse());
            return TuplesKt.to((Object)it, (Object)credential);
        }
    }
}

