/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages.multidevice;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream {
    protected final InputStream in;

    public ChunkedInputStream(InputStream in) {
        this.in = in;
    }

    long readRawVarint32() throws IOException {
        long result2 = 0L;
        for (int shift = 0; shift < 32; shift += 7) {
            int tmpInt = this.in.read();
            if (tmpInt < 0) {
                return -1L;
            }
            byte b = (byte)tmpInt;
            result2 |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result2;
        }
        throw new IOException("Malformed varint!");
    }
}

