/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.ServiceId;
import org.signal.core.util.Base64;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.push.Envelope;
import org.whispersystems.signalservice.internal.serialize.protos.SignalServiceEnvelopeProto;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 H2\u00020\u0001:\u0001HB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rB\u008b\u0001\b\u0016\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u001eBk\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u0005\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u0016\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u001fJ\u0006\u0010(\u001a\u00020\u001aJ\u0006\u0010,\u001a\u00020\u001aJ\u0006\u00104\u001a\u00020\u001aJ\u0006\u0010C\u001a\u00020\u001aJ\b\u0010E\u001a\u00020FH\u0002J\u0006\u0010G\u001a\u00020\tR\u0011\u0010 \u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010%\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u00118F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010-\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b2\u0010$R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b3\u0010$R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b9\u00108R\u0011\u0010:\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b:\u00108R\u0011\u0010;\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b;\u00108R\u0011\u0010<\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b<\u00108R\u0013\u0010\u0018\u001a\u0004\u0018\u00010=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b@\u00108R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\bA\u0010'R\u0011\u0010B\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\bB\u00108R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\bD\u00106\u00a8\u0006I"}, d2={"Lorg/whispersystems/signalservice/api/messages/SignalServiceEnvelope;", "", "message", "", "serverDeliveredTimestamp", "", "<init>", "(Ljava/lang/String;J)V", "input", "", "([BJ)V", "envelope", "Lorg/whispersystems/signalservice/internal/push/Envelope;", "(Lorg/whispersystems/signalservice/internal/push/Envelope;J)V", "type", "", "sender", "Ljava/util/Optional;", "Lorg/whispersystems/signalservice/api/push/SignalServiceAddress;", "senderDevice", "timestamp", "content", "serverReceivedTimestamp", "uuid", "destinationServiceId", "urgent", "", "story", "reportingToken", "updatedPni", "(Ljava/lang/Integer;Ljava/util/Optional;Ljava/lang/Integer;Ljava/lang/Long;[BLjava/lang/Long;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;ZZ[BLjava/lang/String;)V", "(IJ[BJJLjava/lang/String;Ljava/lang/String;ZZ[BLjava/lang/String;)V", "proto", "getProto", "()Lorg/whispersystems/signalservice/internal/push/Envelope;", "getServerDeliveredTimestamp", "()J", "serverGuid", "getServerGuid", "()Ljava/lang/String;", "hasServerGuid", "sourceServiceId", "getSourceServiceId", "()Ljava/util/Optional;", "hasSourceDevice", "sourceDevice", "getSourceDevice", "()I", "getType", "()Ljava/lang/Integer;", "getTimestamp", "getServerReceivedTimestamp", "hasContent", "getContent", "()[B", "isSignalMessage", "()Z", "isPreKeySignalMessage", "isReceipt", "isUnidentifiedSender", "isPlaintextContent", "Lorg/signal/core/models/ServiceId;", "getDestinationServiceId", "()Lorg/signal/core/models/ServiceId;", "isUrgent", "getUpdatedPni", "isStory", "hasReportingToken", "getReportingToken", "serializeToProto", "Lorg/whispersystems/signalservice/internal/serialize/protos/SignalServiceEnvelopeProto$Builder;", "serialize", "Companion", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nSignalServiceEnvelope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignalServiceEnvelope.kt\norg/whispersystems/signalservice/api/messages/SignalServiceEnvelope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n1#2:293\n*E\n"})
public final class SignalServiceEnvelope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Envelope proto;
    private final long serverDeliveredTimestamp;
    private static final String TAG = SignalServiceEnvelope.class.getSimpleName();

    @NotNull
    public final Envelope getProto() {
        return this.proto;
    }

    public final long getServerDeliveredTimestamp() {
        return this.serverDeliveredTimestamp;
    }

    public SignalServiceEnvelope(@NotNull String message, long serverDeliveredTimestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this(Base64.decode((String)message), serverDeliveredTimestamp);
    }

    public SignalServiceEnvelope(@NotNull byte[] input, long serverDeliveredTimestamp) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this((Envelope)((Object)Envelope.ADAPTER.decode(input)), serverDeliveredTimestamp);
    }

    public SignalServiceEnvelope(@NotNull Envelope envelope, long serverDeliveredTimestamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)envelope), (String)"envelope");
        this.proto = envelope;
        this.serverDeliveredTimestamp = serverDeliveredTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    public SignalServiceEnvelope(@Nullable Integer type, @NotNull Optional<SignalServiceAddress> sender, @Nullable Integer senderDevice, @Nullable Long timestamp, @Nullable byte[] content, @Nullable Long serverReceivedTimestamp, @Nullable Long serverDeliveredTimestamp, @Nullable String uuid, @Nullable String destinationServiceId, boolean urgent, boolean story, @Nullable byte[] reportingToken, @Nullable String updatedPni) {
        Envelope.Type type2;
        Intrinsics.checkNotNullParameter(sender, (String)"sender");
        Envelope.Builder builder = new Envelope.Builder();
        Integer n = type;
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            Envelope.Builder builder2 = builder;
            boolean bl = false;
            type2 = Envelope.Type.Companion.fromValue((int)it);
            builder = builder2;
        } else {
            type2 = null;
        }
        Envelope.Builder builder3 = builder.type(type2).sourceDevice(senderDevice).timestamp(timestamp).serverTimestamp(serverReceivedTimestamp).destinationServiceId(destinationServiceId).urgent(urgent).updatedPni(updatedPni).story(story);
        if (sender.isPresent()) {
            builder3.sourceServiceId(sender.get().getServiceId().toString());
        }
        if (uuid != null) {
            builder3.serverGuid(uuid);
        }
        if (content != null) {
            builder3.content(ByteString.Companion.of(Arrays.copyOf(content, content.length)));
        }
        if (reportingToken != null) {
            builder3.report_spam_token(ByteString.Companion.of(Arrays.copyOf(reportingToken, reportingToken.length)));
        }
        this.proto = builder3.build();
        Long l = serverDeliveredTimestamp;
        this.serverDeliveredTimestamp = l != null ? l : 0L;
    }

    public SignalServiceEnvelope(int type, long timestamp, @Nullable byte[] content, long serverReceivedTimestamp, long serverDeliveredTimestamp, @Nullable String uuid, @Nullable String destinationServiceId, boolean urgent, boolean story, @Nullable byte[] reportingToken, @Nullable String updatedPni) {
        Envelope.Builder builder = new Envelope.Builder().type(Envelope.Type.Companion.fromValue(type)).timestamp(timestamp).serverTimestamp(serverReceivedTimestamp).destinationServiceId(destinationServiceId).urgent(urgent).updatedPni(updatedPni).story(story);
        if (uuid != null) {
            builder.serverGuid(uuid);
        }
        if (content != null) {
            builder.content(ByteString.Companion.of(Arrays.copyOf(content, content.length)));
        }
        if (reportingToken != null) {
            builder.report_spam_token(ByteString.Companion.of(Arrays.copyOf(reportingToken, reportingToken.length)));
        }
        this.proto = builder.build();
        this.serverDeliveredTimestamp = serverDeliveredTimestamp;
    }

    @Nullable
    public final String getServerGuid() {
        return this.proto.serverGuid;
    }

    public final boolean hasServerGuid() {
        return this.proto.serverGuid != null;
    }

    @NotNull
    public final Optional<String> getSourceServiceId() {
        Optional<String> optional = Optional.ofNullable(this.proto.sourceServiceId);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final boolean hasSourceDevice() {
        return this.proto.sourceDevice != null;
    }

    public final int getSourceDevice() {
        Integer n = this.proto.sourceDevice;
        return n != null ? n : 0;
    }

    @Nullable
    public final Integer getType() {
        Envelope.Type type = this.proto.type;
        return type != null ? Integer.valueOf(type.getValue()) : null;
    }

    public final long getTimestamp() {
        Long l = this.proto.timestamp;
        return l != null ? l : 0L;
    }

    public final long getServerReceivedTimestamp() {
        Long l = this.proto.serverTimestamp;
        return l != null ? l : 0L;
    }

    public final boolean hasContent() {
        return this.proto.content != null;
    }

    @Nullable
    public final byte[] getContent() {
        ByteString byteString = this.proto.content;
        return (byte[])(byteString != null ? byteString.toByteArray() : null);
    }

    public final boolean isSignalMessage() {
        return this.proto.type == Envelope.Type.CIPHERTEXT;
    }

    public final boolean isPreKeySignalMessage() {
        return this.proto.type == Envelope.Type.PREKEY_BUNDLE;
    }

    public final boolean isReceipt() {
        return this.proto.type == Envelope.Type.SERVER_DELIVERY_RECEIPT;
    }

    public final boolean isUnidentifiedSender() {
        return this.proto.type == Envelope.Type.UNIDENTIFIED_SENDER;
    }

    public final boolean isPlaintextContent() {
        return this.proto.type == Envelope.Type.PLAINTEXT_CONTENT;
    }

    @Nullable
    public final ServiceId getDestinationServiceId() {
        return ServiceId.Companion.parseOrNull$default((ServiceId.Companion)ServiceId.Companion, (String)this.proto.destinationServiceId, (boolean)false, (int)2, null);
    }

    public final boolean isUrgent() {
        return this.proto.urgent != null && this.proto.urgent != false;
    }

    @Nullable
    public final String getUpdatedPni() {
        return this.proto.updatedPni;
    }

    public final boolean isStory() {
        return this.proto.story != null && this.proto.story != false;
    }

    public final boolean hasReportingToken() {
        return this.proto.report_spam_token != null;
    }

    @Nullable
    public final byte[] getReportingToken() {
        ByteString byteString = this.proto.report_spam_token;
        return (byte[])(byteString != null ? byteString.toByteArray() : null);
    }

    private final SignalServiceEnvelopeProto.Builder serializeToProto() {
        byte[] reportingTokenBytes;
        byte[] contentBytes;
        SignalServiceEnvelopeProto.Builder builder = new SignalServiceEnvelopeProto.Builder().type(this.getType()).deviceId(this.getSourceDevice()).timestamp(this.getTimestamp()).serverReceivedTimestamp(this.getServerReceivedTimestamp()).serverDeliveredTimestamp(this.serverDeliveredTimestamp).urgent(this.isUrgent()).story(this.isStory());
        if (this.getSourceServiceId().isPresent()) {
            builder.sourceServiceId(this.getSourceServiceId().get());
        }
        if ((contentBytes = this.getContent()) != null) {
            builder.content(ByteString.Companion.of(Arrays.copyOf(contentBytes, contentBytes.length)));
        }
        if (this.hasServerGuid()) {
            builder.serverGuid(this.getServerGuid());
        }
        if (this.getDestinationServiceId() != null) {
            builder.destinationServiceId(String.valueOf(this.getDestinationServiceId()));
        }
        if ((reportingTokenBytes = this.getReportingToken()) != null) {
            builder.reportingToken(ByteString.Companion.of(Arrays.copyOf(reportingTokenBytes, reportingTokenBytes.length)));
        }
        return builder;
    }

    @NotNull
    public final byte[] serialize() {
        return this.serializeToProto().build().encode();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/messages/SignalServiceEnvelope$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "deserialize", "Lorg/whispersystems/signalservice/api/messages/SignalServiceEnvelope;", "serialized", "", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SignalServiceEnvelope deserialize(@NotNull byte[] serialized) {
            Intrinsics.checkNotNullParameter((Object)serialized, (String)"serialized");
            SignalServiceEnvelopeProto proto = null;
            try {
                proto = (SignalServiceEnvelopeProto)((Object)SignalServiceEnvelopeProto.ADAPTER.decode(serialized));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new AssertionError((Object)e);
            }
            ServiceId sourceServiceId = proto.sourceServiceId != null ? ServiceId.Companion.parseOrNull$default((ServiceId.Companion)ServiceId.Companion, (String)proto.sourceServiceId, (boolean)false, (int)2, null) : null;
            Integer n = proto.type;
            Optional<SignalServiceAddress> optional = sourceServiceId != null ? Optional.of(new SignalServiceAddress(sourceServiceId)) : Optional.empty();
            Intrinsics.checkNotNull(optional);
            return new SignalServiceEnvelope(n, optional, proto.deviceId, proto.timestamp, proto.content != null ? proto.content.toByteArray() : null, proto.serverReceivedTimestamp, proto.serverDeliveredTimestamp, proto.serverGuid, proto.destinationServiceId, proto.urgent != null && proto.urgent != false, proto.story != null && proto.story != false, proto.reportingToken != null ? proto.reportingToken.toByteArray() : null, "");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

