/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import com.squareup.wire.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.protocol.message.DecryptionErrorMessage;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialPresentation;
import org.whispersystems.signalservice.internal.push.AttachmentPointer;
import org.whispersystems.signalservice.internal.push.BodyRange;
import org.whispersystems.signalservice.internal.push.Content;
import org.whispersystems.signalservice.internal.push.DataMessage;
import org.whispersystems.signalservice.internal.push.EditMessage;
import org.whispersystems.signalservice.internal.push.Envelope;
import org.whispersystems.signalservice.internal.push.GroupContextV2;
import org.whispersystems.signalservice.internal.push.PniSignatureMessage;
import org.whispersystems.signalservice.internal.push.Preview;
import org.whispersystems.signalservice.internal.push.ReceiptMessage;
import org.whispersystems.signalservice.internal.push.StoryMessage;
import org.whispersystems.signalservice.internal.push.SyncMessage;
import org.whispersystems.signalservice.internal.push.TypingMessage;
import org.whispersystems.signalservice.internal.util.Util;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001@B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0015*\u00020\u0016H\u0002J \u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020#H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020/H\u0002J\u000e\u00100\u001a\u00020\u0015*\u0004\u0018\u000101H\u0002J\u000e\u00102\u001a\u00020\u0015*\u0004\u0018\u000101H\u0002J\u000e\u00103\u001a\u00020\u0015*\u0004\u0018\u000104H\u0002J\u000e\u00105\u001a\u00020\u0015*\u0004\u0018\u000104H\u0002J\u000e\u00106\u001a\u00020\u0015*\u0004\u0018\u000104H\u0002J\u000e\u00106\u001a\u00020\u0015*\u0004\u0018\u000107H\u0002J\u000e\u00108\u001a\u00020\u0015*\u0004\u0018\u000107H\u0002J\u000e\u00105\u001a\u00020\u0015*\u0004\u0018\u000109H\u0002J\u000e\u0010:\u001a\u00020\u0015*\u0004\u0018\u00010\rH\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010%2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u000204H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator;", "", "<init>", "()V", "MAX_POLL_QUESTION_CHARACTER_LENGTH", "", "MAX_POLL_CHARACTER_LENGTH", "MIN_POLL_OPTIONS", "validate", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "envelope", "Lorg/whispersystems/signalservice/internal/push/Envelope;", "content", "Lorg/whispersystems/signalservice/internal/push/Content;", "localAci", "Lorg/signal/core/models/ServiceId$ACI;", "ciphertextMessageType", "validateDataMessage", "dataMessage", "Lorg/whispersystems/signalservice/internal/push/DataMessage;", "hasInvalidPollQuestion", "", "Lorg/whispersystems/signalservice/internal/push/DataMessage$PollCreate;", "hasInvalidPollOptions", "validateSyncMessage", "syncMessage", "Lorg/whispersystems/signalservice/internal/push/SyncMessage;", "validateReceiptMessage", "receiptMessage", "Lorg/whispersystems/signalservice/internal/push/ReceiptMessage;", "validateTypingMessage", "typingMessage", "Lorg/whispersystems/signalservice/internal/push/TypingMessage;", "validateDecryptionErrorMessage", "serializedDecryptionErrorMessage", "", "validateSenderKeyDistributionMessage", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Invalid;", "serializedSenderKeyDistributionMessage", "validatePniSignatureMessage", "pniSignatureMessage", "Lorg/whispersystems/signalservice/internal/push/PniSignatureMessage;", "validateStoryMessage", "storyMessage", "Lorg/whispersystems/signalservice/internal/push/StoryMessage;", "validateEditMessage", "editMessage", "Lorg/whispersystems/signalservice/internal/push/EditMessage;", "isNullOrInvalid", "Lorg/whispersystems/signalservice/internal/push/AttachmentPointer;", "isPresentAndInvalid", "isValidServiceId", "", "isNullOrInvalidServiceId", "isNullOrInvalidAci", "Lokio/ByteString;", "isNullOrInvalidPni", "Lorg/signal/core/models/ServiceId;", "meetsStoryFlagCriteria", "validatePlaintextContent", "validateGroupContextV2", "groupContext", "Lorg/whispersystems/signalservice/internal/push/GroupContextV2;", "prefix", "Result", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nEnvelopeContentValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvelopeContentValidator.kt\norg/whispersystems/signalservice/api/messages/EnvelopeContentValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,477:1\n1#2:478\n1761#3,3:479\n1761#3,3:482\n1761#3,3:485\n1761#3,3:488\n1761#3,3:491\n1761#3,3:494\n1761#3,3:497\n1761#3,3:500\n1761#3,3:503\n1761#3,3:506\n1761#3,3:509\n1761#3,3:512\n*S KotlinDebug\n*F\n+ 1 EnvelopeContentValidator.kt\norg/whispersystems/signalservice/api/messages/EnvelopeContentValidator\n*L\n94#1:479,3\n98#1:482,3\n102#1:485,3\n140#1:488,3\n176#1:491,3\n230#1:494,3\n234#1:497,3\n246#1:500,3\n250#1:503,3\n341#1:506,3\n345#1:509,3\n349#1:512,3\n*E\n"})
public final class EnvelopeContentValidator {
    @NotNull
    public static final EnvelopeContentValidator INSTANCE = new EnvelopeContentValidator();
    private static final int MAX_POLL_QUESTION_CHARACTER_LENGTH = 200;
    private static final int MAX_POLL_CHARACTER_LENGTH = 100;
    private static final int MIN_POLL_OPTIONS = 2;

    private EnvelopeContentValidator() {
    }

    @NotNull
    public final Result validate(@NotNull Envelope envelope, @NotNull Content content, @NotNull ServiceId.ACI localAci, int ciphertextMessageType) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)((Object)envelope), (String)"envelope");
        Intrinsics.checkNotNullParameter((Object)((Object)content), (String)"content");
        Intrinsics.checkNotNullParameter((Object)localAci, (String)"localAci");
        if ((envelope.type == Envelope.Type.PLAINTEXT_CONTENT || ciphertextMessageType == 8) && (result2 = this.validatePlaintextContent(content)) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        ServiceId sourceServiceId = ServiceId.Companion.parseOrNull(envelope.sourceServiceId, envelope.sourceServiceIdBinary);
        Object object = new Object[]{envelope.sourceServiceId, envelope.sourceServiceIdBinary};
        if (Util.anyNotNull(object) && this.isNullOrInvalidServiceId(sourceServiceId)) {
            return new Result.Invalid("Envelope had an invalid sourceServiceId!", null, 2, null);
        }
        if (content.senderKeyDistributionMessage != null && (object = this.validateSenderKeyDistributionMessage(content.senderKeyDistributionMessage.toByteArray())) != null) {
            Object it = object;
            boolean bl = false;
            return (Result)it;
        }
        if (content.pniSignatureMessage != null && (object = this.validatePniSignatureMessage(content.pniSignatureMessage)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        return Intrinsics.areEqual((Object)envelope.story, (Object)true) && !this.meetsStoryFlagCriteria(content) ? (Result)new Result.Invalid("Envelope was flagged as a story, but it did not have any story-related content!", null, 2, null) : (content.dataMessage != null ? this.validateDataMessage(envelope, content.dataMessage) : (content.syncMessage != null ? this.validateSyncMessage(envelope, content.syncMessage, localAci) : (content.callMessage != null ? (Result)Result.Valid.INSTANCE : (content.nullMessage != null ? (Result)Result.Valid.INSTANCE : (content.receiptMessage != null ? this.validateReceiptMessage(content.receiptMessage) : (content.typingMessage != null ? this.validateTypingMessage(envelope, content.typingMessage) : (content.decryptionErrorMessage != null ? this.validateDecryptionErrorMessage(content.decryptionErrorMessage.toByteArray()) : (content.storyMessage != null ? this.validateStoryMessage(content.storyMessage) : (content.editMessage != null ? this.validateEditMessage(content.editMessage) : (content.pniSignatureMessage != null ? (Result)Result.Valid.INSTANCE : (content.senderKeyDistributionMessage != null ? (Result)Result.Valid.INSTANCE : (Result)new Result.Invalid("Content is empty!", null, 2, null))))))))))));
    }

    private final Result validateDataMessage(Envelope envelope, DataMessage dataMessage) {
        Result.Invalid invalid;
        boolean bl;
        block39: {
            boolean bl2;
            Message it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block38: {
                boolean bl3;
                block37: {
                    boolean bl4;
                    block36: {
                        if (dataMessage.requiredProtocolVersion != null && dataMessage.requiredProtocolVersion > DataMessage.ProtocolVersion.CURRENT.getValue()) {
                            return new Result.UnsupportedDataMessage(DataMessage.ProtocolVersion.CURRENT.getValue(), dataMessage.requiredProtocolVersion);
                        }
                        if (dataMessage.timestamp == null) {
                            return new Result.Invalid("[DataMessage] Missing timestamp!", null, 2, null);
                        }
                        if (!Intrinsics.areEqual((Object)dataMessage.timestamp, (Object)envelope.timestamp)) {
                            return new Result.Invalid("[DataMessage] Timestamps don't match! envelope: " + envelope.timestamp + ", content: " + dataMessage.timestamp, null, 2, null);
                        }
                        if (dataMessage.quote != null && this.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(dataMessage.quote.authorAci, dataMessage.quote.authorAciBinary))) {
                            return new Result.Invalid("[DataMessage] Invalid ACI on quote!", null, 2, null);
                        }
                        $this$any$iv = dataMessage.contact;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (DataMessage.Contact)((Object)element$iv);
                                boolean bl5 = false;
                                if (!(it.avatar != null && INSTANCE.isPresentAndInvalid(it.avatar.avatar))) continue;
                                bl4 = true;
                                break block36;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        return new Result.Invalid("[DataMessage] Invalid AttachmentPointer on DataMessage.contactList.avatar!", null, 2, null);
                    }
                    $this$any$iv = dataMessage.preview;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Preview)((Object)element$iv);
                            boolean bl6 = false;
                            if (!(it.image != null && INSTANCE.isPresentAndInvalid(it.image))) continue;
                            bl3 = true;
                            break block37;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return new Result.Invalid("[DataMessage] Invalid AttachmentPointer on DataMessage.previewList.image!", null, 2, null);
                }
                $this$any$iv = dataMessage.bodyRanges;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (BodyRange)((Object)element$iv);
                        boolean bl7 = false;
                        Object[] objectArray = new Object[]{it.mentionAci, it.mentionAciBinary};
                        if (!(Util.anyNotNull(objectArray) && INSTANCE.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(it.mentionAci, it.mentionAciBinary)))) continue;
                        bl2 = true;
                        break block38;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return new Result.Invalid("[DataMessage] Invalid ACI on body range!", null, 2, null);
            }
            if (dataMessage.sticker != null && this.isNullOrInvalid(dataMessage.sticker.data_)) {
                return new Result.Invalid("[DataMessage] Invalid AttachmentPointer on DataMessage.sticker!", null, 2, null);
            }
            if (dataMessage.reaction != null) {
                if (dataMessage.reaction.targetSentTimestamp == null) {
                    return new Result.Invalid("[DataMessage] Missing timestamp on DataMessage.reaction!", null, 2, null);
                }
                if (this.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(dataMessage.reaction.targetAuthorAci, dataMessage.reaction.targetAuthorAciBinary))) {
                    return new Result.Invalid("[DataMessage] Invalid ACI on DataMessage.reaction!", null, 2, null);
                }
            }
            if (dataMessage.delete != null && dataMessage.delete.targetSentTimestamp == null) {
                return new Result.Invalid("[DataMessage] Missing timestamp on DataMessage.delete!", null, 2, null);
            }
            if (dataMessage.storyContext != null && this.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(dataMessage.storyContext.authorAci, dataMessage.storyContext.authorAciBinary))) {
                return new Result.Invalid("[DataMessage] Invalid ACI on DataMessage.storyContext!", null, 2, null);
            }
            if (dataMessage.giftBadge != null) {
                if (dataMessage.giftBadge.receiptCredentialPresentation == null) {
                    return new Result.Invalid("[DataMessage] Missing DataMessage.giftBadge.receiptCredentialPresentation!", null, 2, null);
                }
                try {
                    new ReceiptCredentialPresentation(dataMessage.giftBadge.receiptCredentialPresentation.toByteArray());
                }
                catch (InvalidInputException e) {
                    return new Result.Invalid("[DataMessage] Invalid DataMessage.giftBadge.receiptCredentialPresentation!", null, 2, null);
                }
            }
            $this$any$iv = dataMessage.attachments;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (AttachmentPointer)((Object)element$iv);
                    boolean bl8 = false;
                    if (!INSTANCE.isNullOrInvalid((AttachmentPointer)it)) continue;
                    bl = true;
                    break block39;
                }
                bl = false;
            }
        }
        if (bl) {
            return new Result.Invalid("[DataMessage] Invalid attachments!", null, 2, null);
        }
        if (dataMessage.groupV2 != null && (invalid = this.validateGroupContextV2(dataMessage.groupV2, "[DataMessage]")) != null) {
            Result.Invalid it = invalid;
            boolean bl9 = false;
            return it;
        }
        if (dataMessage.pollCreate != null && (this.hasInvalidPollQuestion(dataMessage.pollCreate) || this.hasInvalidPollOptions(dataMessage.pollCreate) || dataMessage.pollCreate.allowMultiple == null)) {
            return new Result.Invalid("[DataMessage] Invalid poll create!", null, 2, null);
        }
        if (dataMessage.pollTerminate != null && dataMessage.pollTerminate.targetSentTimestamp == null) {
            return new Result.Invalid("[DataMessage] Invalid poll terminate!", null, 2, null);
        }
        if (dataMessage.pollVote != null && (this.isNullOrInvalidAci(dataMessage.pollVote.targetAuthorAciBinary) || dataMessage.pollVote.targetSentTimestamp == null || dataMessage.pollVote.voteCount == null)) {
            return new Result.Invalid("[DataMessage] Invalid poll vote!", null, 2, null);
        }
        if (dataMessage.pinMessage != null && (this.isNullOrInvalidAci(dataMessage.pinMessage.targetAuthorAciBinary) || dataMessage.pinMessage.targetSentTimestamp == null || dataMessage.pinMessage.pinDurationSeconds == null && dataMessage.pinMessage.pinDurationForever == null)) {
            return new Result.Invalid("[DataMessage] Invalid pin message!", null, 2, null);
        }
        if (dataMessage.unpinMessage != null && (this.isNullOrInvalidAci(dataMessage.unpinMessage.targetAuthorAciBinary) || dataMessage.unpinMessage.targetSentTimestamp == null)) {
            return new Result.Invalid("[DataMessage] Invalid unpin message!", null, 2, null);
        }
        return Result.Valid.INSTANCE;
    }

    private final boolean hasInvalidPollQuestion(DataMessage.PollCreate $this$hasInvalidPollQuestion) {
        CharSequence charSequence = $this$hasInvalidPollQuestion.question;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || $this$hasInvalidPollQuestion.question.length() > 200;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasInvalidPollOptions(DataMessage.PollCreate $this$hasInvalidPollOptions) {
        boolean bl;
        if ($this$hasInvalidPollOptions.options.size() < 2) return true;
        Iterable $this$any$iv = $this$hasInvalidPollOptions.options;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String option = (String)element$iv;
            boolean bl2 = false;
            if (option.length() > 100) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final Result validateSyncMessage(Envelope envelope, SyncMessage syncMessage, ServiceId.ACI localAci) {
        boolean bl;
        Object it;
        boolean $i$f$any;
        Iterable $this$any$iv;
        block37: {
            boolean bl2;
            block36: {
                boolean bl3;
                block35: {
                    ServiceId sourceServiceId = ServiceId.Companion.parseOrThrow(envelope.sourceServiceId, envelope.sourceServiceIdBinary);
                    if (!Intrinsics.areEqual((Object)sourceServiceId, (Object)localAci)) {
                        return new Result.Invalid("[SyncMessage] Source was not our own account!", null, 2, null);
                    }
                    if (syncMessage.sent != null) {
                        Object object;
                        boolean hasEditMessageGroup;
                        boolean validAddress = ServiceId.Companion.parseOrNull(syncMessage.sent.destinationServiceId, syncMessage.sent.destinationServiceIdBinary) != null;
                        DataMessage dataMessage = syncMessage.sent.message;
                        boolean hasDataGroup = (dataMessage != null ? dataMessage.groupV2 : null) != null;
                        DataMessage dataMessage2 = syncMessage.sent.message;
                        boolean isRemoteDelete = (dataMessage2 != null ? dataMessage2.delete : null) != null;
                        StoryMessage storyMessage = syncMessage.sent.storyMessage;
                        boolean hasStoryGroup = (storyMessage != null ? storyMessage.group : null) != null;
                        boolean hasStoryManifest = !((Collection)syncMessage.sent.storyMessageRecipients).isEmpty();
                        Message message = syncMessage.sent.editMessage;
                        boolean bl4 = hasEditMessageGroup = (message != null && (message = message.dataMessage) != null ? message.groupV2 : null) != null;
                        if (hasDataGroup) {
                            DataMessage dataMessage3 = syncMessage.sent.message;
                            Intrinsics.checkNotNull((Object)((Object)dataMessage3));
                            GroupContextV2 groupContextV2 = dataMessage3.groupV2;
                            Intrinsics.checkNotNull((Object)((Object)groupContextV2));
                            object = this.validateGroupContextV2(groupContextV2, "[SyncMessage.Sent.Message]");
                            if (object != null) {
                                Object it2 = object;
                                boolean bl5 = false;
                                return (Result)it2;
                            }
                        }
                        if (hasStoryGroup) {
                            StoryMessage storyMessage2 = syncMessage.sent.storyMessage;
                            Intrinsics.checkNotNull((Object)((Object)storyMessage2));
                            GroupContextV2 groupContextV2 = storyMessage2.group;
                            Intrinsics.checkNotNull((Object)((Object)groupContextV2));
                            object = this.validateGroupContextV2(groupContextV2, "[SyncMessage.Sent.StoryMessage]");
                            if (object != null) {
                                Object it3 = object;
                                boolean bl6 = false;
                                return (Result)it3;
                            }
                        }
                        if (hasEditMessageGroup) {
                            EditMessage editMessage = syncMessage.sent.editMessage;
                            Intrinsics.checkNotNull((Object)((Object)editMessage));
                            DataMessage dataMessage4 = editMessage.dataMessage;
                            Intrinsics.checkNotNull((Object)((Object)dataMessage4));
                            GroupContextV2 groupContextV2 = dataMessage4.groupV2;
                            Intrinsics.checkNotNull((Object)((Object)groupContextV2));
                            object = this.validateGroupContextV2(groupContextV2, "[SyncMessage.Sent.EditMessage]");
                            if (object != null) {
                                Object it4 = object;
                                boolean bl7 = false;
                                return (Result)it4;
                            }
                        }
                        if (!(validAddress || hasDataGroup || hasStoryGroup || hasStoryManifest || hasEditMessageGroup || isRemoteDelete)) {
                            return new Result.Invalid("[SyncMessage] No valid destination! Checked the destination, DataMessage.group, StoryMessage.group, EditMessage.group and storyMessageRecipientList", null, 2, null);
                        }
                        for (SyncMessage.Sent.UnidentifiedDeliveryStatus status : syncMessage.sent.unidentifiedStatus) {
                            if (!this.isNullOrInvalidServiceId(ServiceId.Companion.parseOrNull(status.destinationServiceId, status.destinationServiceIdBinary))) continue;
                            return new Result.Invalid("[SyncMessage] Invalid ServiceId in SyncMessage.sent.unidentifiedStatusList!", null, 2, null);
                        }
                        return syncMessage.sent.message != null ? this.validateDataMessage(envelope, syncMessage.sent.message) : (syncMessage.sent.storyMessage != null ? this.validateStoryMessage(syncMessage.sent.storyMessage) : (!((Collection)syncMessage.sent.storyMessageRecipients).isEmpty() ? (Result)Result.Valid.INSTANCE : (syncMessage.sent.editMessage != null ? this.validateEditMessage(syncMessage.sent.editMessage) : (Result)new Result.Invalid("[SyncMessage] Empty SyncMessage.sent!", null, 2, null))));
                    }
                    $this$any$iv = syncMessage.read;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (SyncMessage.Read)((Object)element$iv);
                            boolean bl8 = false;
                            if (!INSTANCE.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(it.senderAci, it.senderAciBinary))) continue;
                            bl3 = true;
                            break block35;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.readList!", null, 2, null);
                }
                $this$any$iv = syncMessage.viewed;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (SyncMessage.Viewed)((Object)element$iv);
                        boolean bl9 = false;
                        if (!INSTANCE.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(it.senderAci, it.senderAciBinary))) continue;
                        bl2 = true;
                        break block36;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.viewList!", null, 2, null);
            }
            if (syncMessage.viewOnceOpen != null && this.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(syncMessage.viewOnceOpen.senderAci, syncMessage.viewOnceOpen.senderAciBinary))) {
                return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.viewOnceOpen!", null, 2, null);
            }
            if (syncMessage.verified != null && this.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(syncMessage.verified.destinationAci, syncMessage.verified.destinationAciBinary))) {
                return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.verified!", null, 2, null);
            }
            $this$any$iv = syncMessage.stickerPackOperation;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (SyncMessage.StickerPackOperation)((Object)element$iv);
                    boolean bl10 = false;
                    if (!(it.packId == null)) continue;
                    bl = true;
                    break block37;
                }
                bl = false;
            }
        }
        if (bl) {
            return new Result.Invalid("[SyncMessage] Missing packId in stickerPackOperationList!", null, 2, null);
        }
        if (syncMessage.blocked != null) {
            boolean bl11;
            block38: {
                $this$any$iv = syncMessage.blocked.acis;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl11 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl12 = false;
                        if (!INSTANCE.isNullOrInvalidAci((String)it)) continue;
                        bl11 = true;
                        break block38;
                    }
                    bl11 = false;
                }
            }
            if (bl11) {
                boolean bl13;
                block39: {
                    $this$any$iv = syncMessage.blocked.acisBinary;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl13 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (ByteString)element$iv;
                            boolean bl14 = false;
                            if (!INSTANCE.isNullOrInvalidAci((ByteString)it)) continue;
                            bl13 = true;
                            break block39;
                        }
                        bl13 = false;
                    }
                }
                if (bl13) {
                    return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.blocked!", null, 2, null);
                }
            }
        }
        if (syncMessage.messageRequestResponse != null && syncMessage.messageRequestResponse.groupId == null && this.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(syncMessage.messageRequestResponse.threadAci, syncMessage.messageRequestResponse.threadAciBinary))) {
            return new Result.Invalid("[SyncMessage] Invalid ACI in SyncMessage.messageRequestResponse!", null, 2, null);
        }
        if (syncMessage.outgoingPayment != null && this.isNullOrInvalidServiceId(syncMessage.outgoingPayment.recipientServiceId)) {
            return new Result.Invalid("[SyncMessage] Invalid ServiceId in SyncMessage.outgoingPayment!", null, 2, null);
        }
        return Result.Valid.INSTANCE;
    }

    private final Result validateReceiptMessage(ReceiptMessage receiptMessage) {
        return receiptMessage.type == null ? (Result)new Result.Invalid("[ReceiptMessage] Missing type!", null, 2, null) : (Result)Result.Valid.INSTANCE;
    }

    private final Result validateTypingMessage(Envelope envelope, TypingMessage typingMessage) {
        if (typingMessage.timestamp == null) {
            return new Result.Invalid("[TypingMessage] Missing timestamp!", null, 2, null);
        }
        return !Intrinsics.areEqual((Object)typingMessage.timestamp, (Object)envelope.timestamp) ? (Result)new Result.Invalid("[TypingMessage] Timestamps don't match! envelope: " + envelope.timestamp + ", content: " + typingMessage.timestamp, null, 2, null) : (typingMessage.action == null ? (Result)new Result.Invalid("[TypingMessage] Missing action!", null, 2, null) : (Result)Result.Valid.INSTANCE);
    }

    private final Result validateDecryptionErrorMessage(byte[] serializedDecryptionErrorMessage) {
        Result result2;
        try {
            new DecryptionErrorMessage(serializedDecryptionErrorMessage);
            result2 = Result.Valid.INSTANCE;
        }
        catch (Exception e) {
            result2 = new Result.Invalid("[DecryptionErrorMessage] Bad decryption error message!", e);
        }
        return result2;
    }

    private final Result.Invalid validateSenderKeyDistributionMessage(byte[] serializedSenderKeyDistributionMessage) {
        Result.Invalid invalid;
        try {
            new SenderKeyDistributionMessage(serializedSenderKeyDistributionMessage);
            invalid = null;
        }
        catch (Exception e) {
            invalid = new Result.Invalid("[SenderKeyDistributionMessage] Bad sender key distribution message!", e);
        }
        return invalid;
    }

    private final Result validatePniSignatureMessage(PniSignatureMessage pniSignatureMessage) {
        if (this.isNullOrInvalidPni(pniSignatureMessage.pni)) {
            return new Result.Invalid("[PniSignatureMessage] Invalid PNI", null, 2, null);
        }
        if (pniSignatureMessage.signature == null) {
            return new Result.Invalid("[PniSignatureMessage] Signature is null", null, 2, null);
        }
        return null;
    }

    private final Result validateStoryMessage(StoryMessage storyMessage) {
        if (storyMessage.group != null) {
            Result.Invalid invalid = this.validateGroupContextV2(storyMessage.group, "[StoryMessage]");
            if (invalid != null) {
                Result.Invalid it = invalid;
                boolean bl = false;
                return it;
            }
        }
        return Result.Valid.INSTANCE;
    }

    private final Result validateEditMessage(EditMessage editMessage) {
        Result.Invalid invalid;
        boolean bl;
        DataMessage dataMessage;
        block18: {
            boolean bl2;
            Message it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block17: {
                boolean bl3;
                block16: {
                    if (editMessage.dataMessage == null) {
                        return new Result.Invalid("[EditMessage] No data message present", null, 2, null);
                    }
                    if (editMessage.targetSentTimestamp == null) {
                        return new Result.Invalid("[EditMessage] No targetSentTimestamp specified", null, 2, null);
                    }
                    dataMessage = editMessage.dataMessage;
                    if (dataMessage.requiredProtocolVersion != null && dataMessage.requiredProtocolVersion > DataMessage.ProtocolVersion.CURRENT.getValue()) {
                        return new Result.UnsupportedDataMessage(DataMessage.ProtocolVersion.CURRENT.getValue(), dataMessage.requiredProtocolVersion);
                    }
                    $this$any$iv = dataMessage.preview;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Preview)((Object)element$iv);
                            boolean bl4 = false;
                            if (!(it.image != null && INSTANCE.isPresentAndInvalid(it.image))) continue;
                            bl3 = true;
                            break block16;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return new Result.Invalid("[EditMessage] Invalid AttachmentPointer on DataMessage.previewList.image!", null, 2, null);
                }
                $this$any$iv = dataMessage.bodyRanges;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (BodyRange)((Object)element$iv);
                        boolean bl5 = false;
                        Object[] objectArray = new Object[]{it.mentionAci, it.mentionAciBinary};
                        if (!(Util.anyNotNull(objectArray) && INSTANCE.isNullOrInvalidServiceId((ServiceId)ServiceId.ACI.Companion.parseOrNull(it.mentionAci, it.mentionAciBinary)))) continue;
                        bl2 = true;
                        break block17;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return new Result.Invalid("[EditMessage] Invalid UUID on body range!", null, 2, null);
            }
            $this$any$iv = dataMessage.attachments;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (AttachmentPointer)((Object)element$iv);
                    boolean bl6 = false;
                    if (!INSTANCE.isNullOrInvalid((AttachmentPointer)it)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        if (bl) {
            return new Result.Invalid("[EditMessage] Invalid attachments!", null, 2, null);
        }
        if (dataMessage.groupV2 != null && (invalid = this.validateGroupContextV2(dataMessage.groupV2, "[EditMessage]")) != null) {
            Result.Invalid it = invalid;
            boolean bl7 = false;
            return it;
        }
        return Result.Valid.INSTANCE;
    }

    private final boolean isNullOrInvalid(AttachmentPointer $this$isNullOrInvalid) {
        return $this$isNullOrInvalid == null || $this$isNullOrInvalid.cdnId == null && $this$isNullOrInvalid.cdnKey == null;
    }

    private final boolean isPresentAndInvalid(AttachmentPointer $this$isPresentAndInvalid) {
        return $this$isPresentAndInvalid != null && $this$isPresentAndInvalid.cdnId == null && $this$isPresentAndInvalid.cdnKey == null;
    }

    private final boolean isValidServiceId(String $this$isValidServiceId) {
        ServiceId parsed = ServiceId.Companion.parseOrNull$default((ServiceId.Companion)ServiceId.Companion, (String)$this$isValidServiceId, (boolean)false, (int)2, null);
        return parsed != null && parsed.isValid();
    }

    private final boolean isNullOrInvalidServiceId(String $this$isNullOrInvalidServiceId) {
        ServiceId parsed = ServiceId.Companion.parseOrNull$default((ServiceId.Companion)ServiceId.Companion, (String)$this$isNullOrInvalidServiceId, (boolean)false, (int)2, null);
        return parsed == null || parsed.isUnknown();
    }

    private final boolean isNullOrInvalidAci(String $this$isNullOrInvalidAci) {
        ServiceId.ACI parsed = ServiceId.ACI.Companion.parseOrNull($this$isNullOrInvalidAci);
        return parsed == null || parsed.isUnknown();
    }

    private final boolean isNullOrInvalidAci(ByteString $this$isNullOrInvalidAci) {
        ServiceId.ACI aCI;
        ByteString byteString = $this$isNullOrInvalidAci;
        if (byteString != null) {
            ByteString it = byteString;
            boolean bl = false;
            aCI = ServiceId.ACI.Companion.parseOrNull($this$isNullOrInvalidAci);
        } else {
            aCI = null;
        }
        ServiceId.ACI parsed = aCI;
        return parsed == null || parsed.isUnknown();
    }

    private final boolean isNullOrInvalidPni(ByteString $this$isNullOrInvalidPni) {
        ByteString byteString = $this$isNullOrInvalidPni;
        ServiceId.PNI parsed = ServiceId.PNI.Companion.parseOrNull((byte[])(byteString != null ? byteString.toByteArray() : null));
        return parsed == null || parsed.isUnknown();
    }

    private final boolean isNullOrInvalidServiceId(ServiceId $this$isNullOrInvalidServiceId) {
        return $this$isNullOrInvalidServiceId == null || $this$isNullOrInvalidServiceId.isUnknown();
    }

    private final boolean meetsStoryFlagCriteria(Content $this$meetsStoryFlagCriteria) {
        return $this$meetsStoryFlagCriteria == null ? false : ($this$meetsStoryFlagCriteria.senderKeyDistributionMessage != null ? true : ($this$meetsStoryFlagCriteria.storyMessage != null ? true : ($this$meetsStoryFlagCriteria.dataMessage != null && $this$meetsStoryFlagCriteria.dataMessage.storyContext != null && $this$meetsStoryFlagCriteria.dataMessage.groupV2 != null ? true : $this$meetsStoryFlagCriteria.dataMessage != null && $this$meetsStoryFlagCriteria.dataMessage.delete != null)));
    }

    private final Result validatePlaintextContent(Content content) {
        List errors = new ArrayList();
        if (content.decryptionErrorMessage == null) {
            ((Collection)errors).add("Missing DecryptionErrorMessage");
        }
        if (content.dataMessage != null) {
            ((Collection)errors).add("Unexpected DataMessage");
        }
        if (content.syncMessage != null) {
            ((Collection)errors).add("Unexpected SyncMessage");
        }
        if (content.callMessage != null) {
            ((Collection)errors).add("Unexpected CallMessage");
        }
        if (content.nullMessage != null) {
            ((Collection)errors).add("Unexpected NullMessage");
        }
        if (content.receiptMessage != null) {
            ((Collection)errors).add("Unexpected ReceiptMessage");
        }
        if (content.typingMessage != null) {
            ((Collection)errors).add("Unexpected TypingMessage");
        }
        if (content.senderKeyDistributionMessage != null) {
            ((Collection)errors).add("Unexpected SenderKeyDistributionMessage");
        }
        if (content.storyMessage != null) {
            ((Collection)errors).add("Unexpected StoryMessage");
        }
        if (content.pniSignatureMessage != null) {
            ((Collection)errors).add("Unexpected PniSignatureMessage");
        }
        if (content.editMessage != null) {
            ((Collection)errors).add("Unexpected EditMessage");
        }
        return !((Collection)errors).isEmpty() ? (Result)new Result.Invalid("Invalid PLAINTEXT_CONTENT! Errors: " + errors, null, 2, null) : null;
    }

    private final Result.Invalid validateGroupContextV2(GroupContextV2 groupContext, String prefix) {
        Result.Invalid invalid;
        if (groupContext.masterKey == null) {
            invalid = new Result.Invalid(prefix + " Missing GV2 master key!", null, 2, null);
        } else if (groupContext.revision == null) {
            invalid = new Result.Invalid(prefix + " Missing GV2 revision!", null, 2, null);
        } else {
            Result.Invalid invalid2;
            try {
                new GroupMasterKey(groupContext.masterKey.toByteArray());
                invalid2 = null;
            }
            catch (InvalidInputException e) {
                invalid2 = new Result.Invalid(prefix + " Bad GV2 master key!", e);
            }
            invalid = invalid2;
        }
        return invalid;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "", "<init>", "()V", "Valid", "UnsupportedDataMessage", "Invalid", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Invalid;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$UnsupportedDataMessage;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Valid;", "signal-service-java"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Invalid;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "reason", "", "throwable", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "getReason", "()Ljava/lang/String;", "getThrowable", "()Ljava/lang/Throwable;", "signal-service-java"})
        public static final class Invalid
        extends Result {
            @NotNull
            private final String reason;
            @NotNull
            private final Throwable throwable;

            public Invalid(@NotNull String reason, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                super(null);
                this.reason = reason;
                this.throwable = throwable;
            }

            public /* synthetic */ Invalid(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    throwable = new Throwable();
                }
                this(string, throwable);
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final Throwable getThrowable() {
                return this.throwable;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$UnsupportedDataMessage;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "ourVersion", "", "theirVersion", "<init>", "(ILjava/lang/Integer;)V", "getOurVersion", "()I", "getTheirVersion", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "signal-service-java"})
        public static final class UnsupportedDataMessage
        extends Result {
            private final int ourVersion;
            @Nullable
            private final Integer theirVersion;

            public UnsupportedDataMessage(int ourVersion, @Nullable Integer theirVersion) {
                super(null);
                this.ourVersion = ourVersion;
                this.theirVersion = theirVersion;
            }

            public final int getOurVersion() {
                return this.ourVersion;
            }

            @Nullable
            public final Integer getTheirVersion() {
                return this.theirVersion;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result$Valid;", "Lorg/whispersystems/signalservice/api/messages/EnvelopeContentValidator$Result;", "<init>", "()V", "signal-service-java"})
        public static final class Valid
        extends Result {
            @NotNull
            public static final Valid INSTANCE = new Valid();

            private Valid() {
                super(null);
            }
        }
    }
}

