/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okio.ByteString;
import org.signal.core.models.ServiceId;
import org.signal.core.util.UuidUtil;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.NotarySignature;
import org.signal.libsignal.zkgroup.ServerPublicParams;
import org.signal.libsignal.zkgroup.VerificationFailedException;
import org.signal.libsignal.zkgroup.auth.ClientZkAuthOperations;
import org.signal.libsignal.zkgroup.groups.ClientZkGroupCipher;
import org.signal.libsignal.zkgroup.groups.GroupIdentifier;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.libsignal.zkgroup.groups.ProfileKeyCiphertext;
import org.signal.libsignal.zkgroup.groups.UuidCiphertext;
import org.signal.libsignal.zkgroup.groupsend.GroupSendEndorsementsResponse;
import org.signal.libsignal.zkgroup.profiles.ClientZkProfileOperations;
import org.signal.libsignal.zkgroup.profiles.ExpiringProfileKeyCredential;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKeyCredentialPresentation;
import org.signal.storageservice.storage.protos.groups.AccessControl;
import org.signal.storageservice.storage.protos.groups.Group;
import org.signal.storageservice.storage.protos.groups.GroupAttributeBlob;
import org.signal.storageservice.storage.protos.groups.GroupChange;
import org.signal.storageservice.storage.protos.groups.GroupJoinInfo;
import org.signal.storageservice.storage.protos.groups.Member;
import org.signal.storageservice.storage.protos.groups.MemberBanned;
import org.signal.storageservice.storage.protos.groups.MemberPendingAdminApproval;
import org.signal.storageservice.storage.protos.groups.MemberPendingProfileKey;
import org.signal.storageservice.storage.protos.groups.local.DecryptedApproveMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedBannedMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroupJoinInfo;
import org.signal.storageservice.storage.protos.groups.local.DecryptedMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedModifyMemberLabel;
import org.signal.storageservice.storage.protos.groups.local.DecryptedModifyMemberRole;
import org.signal.storageservice.storage.protos.groups.local.DecryptedPendingMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedPendingMemberRemoval;
import org.signal.storageservice.storage.protos.groups.local.DecryptedRequestingMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedString;
import org.signal.storageservice.storage.protos.groups.local.DecryptedTimer;
import org.signal.storageservice.storage.protos.groups.local.EnabledState;
import org.whispersystems.signalservice.api.groupsv2.ClientZkOperations;
import org.whispersystems.signalservice.api.groupsv2.DecryptChangeVerificationMode;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupResponse;
import org.whispersystems.signalservice.api.groupsv2.GroupCandidate;
import org.whispersystems.signalservice.api.groupsv2.InvalidGroupStateException;
import org.whispersystems.signalservice.api.groupsv2.ReceivedGroupSendEndorsements;

public final class GroupsV2Operations {
    private static final String TAG = GroupsV2Operations.class.getSimpleName();
    public static final UUID UNKNOWN_UUID = UuidUtil.UNKNOWN_UUID;
    public static final int HIGHEST_KNOWN_EPOCH = 6;
    private final ServerPublicParams serverPublicParams;
    private final ClientZkProfileOperations clientZkProfileOperations;
    private final ClientZkAuthOperations clientZkAuthOperations;
    private final int maxGroupSize;
    private final SecureRandom random;

    public GroupsV2Operations(ClientZkOperations clientZkOperations, int maxGroupSize) {
        this.serverPublicParams = clientZkOperations.getServerPublicParams();
        this.clientZkProfileOperations = clientZkOperations.getProfileOperations();
        this.clientZkAuthOperations = clientZkOperations.getAuthOperations();
        this.maxGroupSize = maxGroupSize;
        this.random = new SecureRandom();
    }

    public NewGroup createNewGroup(GroupSecretParams groupSecretParams, String title, Optional<byte[]> avatar, GroupCandidate self, Set<GroupCandidate> members, Member.Role memberRole, int disappearingMessageTimerSeconds) {
        if (members.contains(self)) {
            throw new IllegalArgumentException("Members must not contain self");
        }
        GroupOperations groupOperations = this.forGroup(groupSecretParams);
        Group.Builder group = new Group.Builder().version(0).publicKey(ByteString.of((byte[])groupSecretParams.getPublicParams().serialize())).title(groupOperations.encryptTitle(title)).disappearingMessagesTimer(groupOperations.encryptTimer(disappearingMessageTimerSeconds)).accessControl(new AccessControl.Builder().attributes(AccessControl.AccessRequired.MEMBER).members(AccessControl.AccessRequired.MEMBER).build());
        ArrayList<Member> groupMembers = new ArrayList<Member>();
        ArrayList<MemberPendingProfileKey> groupPendingMembers = new ArrayList<MemberPendingProfileKey>();
        groupMembers.add(groupOperations.member(self.requireExpiringProfileKeyCredential(), Member.Role.ADMINISTRATOR).build());
        for (GroupCandidate credential : members) {
            ExpiringProfileKeyCredential expiringProfileKeyCredential = credential.getExpiringProfileKeyCredential().orElse(null);
            if (expiringProfileKeyCredential != null) {
                groupMembers.add(groupOperations.member(expiringProfileKeyCredential, memberRole).build());
                continue;
            }
            groupPendingMembers.add(groupOperations.invitee(credential.getServiceId(), memberRole).build());
        }
        group.members(groupMembers).membersPendingProfileKey(groupPendingMembers);
        return new NewGroup(groupSecretParams, group.build(), avatar);
    }

    public GroupOperations forGroup(GroupSecretParams groupSecretParams) {
        return new GroupOperations(groupSecretParams);
    }

    public ClientZkProfileOperations getProfileOperations() {
        return this.clientZkProfileOperations;
    }

    public ClientZkAuthOperations getAuthOperations() {
        return this.clientZkAuthOperations;
    }

    public final class GroupOperations {
        private final GroupSecretParams groupSecretParams;
        private final ClientZkGroupCipher clientZkGroupCipher;

        public GroupOperations(GroupSecretParams groupSecretParams) {
            this.groupSecretParams = groupSecretParams;
            this.clientZkGroupCipher = new ClientZkGroupCipher(groupSecretParams);
        }

        public GroupChange.Actions.Builder createModifyGroupTitle(String title) {
            return new GroupChange.Actions.Builder().modifyTitle(new GroupChange.Actions.ModifyTitleAction.Builder().title(this.encryptTitle(title)).build());
        }

        public GroupChange.Actions.ModifyDescriptionAction.Builder createModifyGroupDescriptionAction(String description) {
            return new GroupChange.Actions.ModifyDescriptionAction.Builder().description(this.encryptDescription(description));
        }

        public GroupChange.Actions.Builder createModifyGroupDescription(String description) {
            return new GroupChange.Actions.Builder().modifyDescription(this.createModifyGroupDescriptionAction(description).build());
        }

        public GroupChange.Actions.Builder createModifyGroupMembershipChange(Set<GroupCandidate> membersToAdd, Set<org.signal.core.models.ServiceId> bannedMembers, ServiceId.ACI selfAci) {
            GroupOperations groupOperations = GroupsV2Operations.this.forGroup(this.groupSecretParams);
            Set<org.signal.core.models.ServiceId> membersToUnban = membersToAdd.stream().map(GroupCandidate::getServiceId).filter(bannedMembers::contains).collect(Collectors.toSet());
            GroupChange.Actions.Builder actions = membersToUnban.isEmpty() ? new GroupChange.Actions.Builder() : this.createUnbanServiceIdsChange(membersToUnban);
            ArrayList<GroupChange.Actions.AddMemberAction> addGroupMembers = new ArrayList<GroupChange.Actions.AddMemberAction>(actions.addMembers);
            ArrayList<GroupChange.Actions.AddMemberPendingProfileKeyAction> addGroupPendingMembers = new ArrayList<GroupChange.Actions.AddMemberPendingProfileKeyAction>(actions.addMembersPendingProfileKey);
            for (GroupCandidate credential : membersToAdd) {
                Member.Role newMemberRole = Member.Role.DEFAULT;
                ExpiringProfileKeyCredential expiringProfileKeyCredential = credential.getExpiringProfileKeyCredential().orElse(null);
                if (expiringProfileKeyCredential != null) {
                    addGroupMembers.add(new GroupChange.Actions.AddMemberAction.Builder().added(groupOperations.member(expiringProfileKeyCredential, newMemberRole).build()).build());
                    continue;
                }
                addGroupPendingMembers.add(new GroupChange.Actions.AddMemberPendingProfileKeyAction.Builder().added(groupOperations.invitee(credential.getServiceId(), newMemberRole).addedByUserId(this.encryptServiceId((org.signal.core.models.ServiceId)selfAci)).build()).build());
            }
            return actions.addMembers(addGroupMembers).addMembersPendingProfileKey(addGroupPendingMembers);
        }

        public GroupChange.Actions.Builder createGroupJoinRequest(ExpiringProfileKeyCredential expiringProfileKeyCredential) {
            GroupOperations groupOperations = GroupsV2Operations.this.forGroup(this.groupSecretParams);
            GroupChange.Actions.Builder actions = new GroupChange.Actions.Builder();
            actions.addMembersPendingAdminApproval = Collections.singletonList(new GroupChange.Actions.AddMemberPendingAdminApprovalAction.Builder().added(groupOperations.requestingMember(expiringProfileKeyCredential).build()).build());
            return actions;
        }

        public GroupChange.Actions.Builder createGroupJoinDirect(ExpiringProfileKeyCredential expiringProfileKeyCredential) {
            GroupOperations groupOperations = GroupsV2Operations.this.forGroup(this.groupSecretParams);
            GroupChange.Actions.Builder actions = new GroupChange.Actions.Builder();
            actions.addMembers = Collections.singletonList(new GroupChange.Actions.AddMemberAction.Builder().added(groupOperations.member(expiringProfileKeyCredential, Member.Role.DEFAULT).build()).build());
            return actions;
        }

        public GroupChange.Actions.Builder createRefuseGroupJoinRequest(Set<? extends org.signal.core.models.ServiceId> requestsToRemove, boolean alsoBan, List<DecryptedBannedMember> bannedMembers) {
            GroupChange.Actions.Builder actions = alsoBan ? this.createBanServiceIdsChange(requestsToRemove, false, bannedMembers) : new GroupChange.Actions.Builder();
            ArrayList<GroupChange.Actions.DeleteMemberPendingAdminApprovalAction> DeleteMemberPendingAdminApprovalActions = new ArrayList<GroupChange.Actions.DeleteMemberPendingAdminApprovalAction>(actions.deleteMembersPendingAdminApproval);
            for (org.signal.core.models.ServiceId serviceId : requestsToRemove) {
                if (!(serviceId instanceof ServiceId.ACI)) continue;
                DeleteMemberPendingAdminApprovalActions.add(new GroupChange.Actions.DeleteMemberPendingAdminApprovalAction.Builder().deletedUserId(this.encryptServiceId(serviceId)).build());
            }
            return actions.deleteMembersPendingAdminApproval(DeleteMemberPendingAdminApprovalActions);
        }

        public GroupChange.Actions.Builder createApproveGroupJoinRequest(Set<UUID> requestsToApprove) {
            GroupChange.Actions.Builder actions = new GroupChange.Actions.Builder();
            actions.promoteMembersPendingAdminApproval = requestsToApprove.stream().map(uuid -> new GroupChange.Actions.PromoteMemberPendingAdminApprovalAction.Builder().role(Member.Role.DEFAULT).userId(this.encryptServiceId((org.signal.core.models.ServiceId)ServiceId.ACI.from((UUID)uuid))).build()).collect(Collectors.toList());
            return actions;
        }

        public GroupChange.Actions.Builder createRemoveMembersChange(Set<ServiceId.ACI> membersToRemove, boolean alsoBan, List<DecryptedBannedMember> bannedMembers) {
            GroupChange.Actions.Builder actions = alsoBan ? this.createBanServiceIdsChange(membersToRemove, false, bannedMembers) : new GroupChange.Actions.Builder();
            ArrayList<GroupChange.Actions.DeleteMemberAction> deleteMemberActions = new ArrayList<GroupChange.Actions.DeleteMemberAction>(actions.deleteMembers);
            for (ServiceId.ACI remove : membersToRemove) {
                deleteMemberActions.add(new GroupChange.Actions.DeleteMemberAction.Builder().deletedUserId(this.encryptServiceId((org.signal.core.models.ServiceId)remove)).build());
            }
            return actions.deleteMembers(deleteMemberActions);
        }

        public GroupChange.Actions.Builder createLeaveAndPromoteMembersToAdmin(ServiceId.ACI self, List<UUID> membersToMakeAdmin) {
            GroupChange.Actions.Builder actions = this.createRemoveMembersChange(Collections.singleton(self), false, Collections.emptyList());
            ArrayList<GroupChange.Actions.ModifyMemberRoleAction> modifyMemberRoleActions = new ArrayList<GroupChange.Actions.ModifyMemberRoleAction>(actions.modifyMemberRoles);
            for (UUID member : membersToMakeAdmin) {
                modifyMemberRoleActions.add(new GroupChange.Actions.ModifyMemberRoleAction.Builder().userId(this.encryptServiceId((org.signal.core.models.ServiceId)ServiceId.ACI.from((UUID)member))).role(Member.Role.ADMINISTRATOR).build());
            }
            return actions.modifyMemberRoles(modifyMemberRoleActions);
        }

        public GroupChange.Actions.Builder createModifyGroupTimerChange(int timerDurationSeconds) {
            return new GroupChange.Actions.Builder().modifyDisappearingMessageTimer(new GroupChange.Actions.ModifyDisappearingMessageTimerAction.Builder().timer(this.encryptTimer(timerDurationSeconds)).build());
        }

        public GroupChange.Actions.Builder createUpdateProfileKeyCredentialChange(ExpiringProfileKeyCredential expiringProfileKeyCredential) {
            ProfileKeyCredentialPresentation presentation = GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(GroupsV2Operations.this.random, this.groupSecretParams, expiringProfileKeyCredential);
            return new GroupChange.Actions.Builder().modifyMemberProfileKeys(Collections.singletonList(new GroupChange.Actions.ModifyMemberProfileKeyAction.Builder().presentation(ByteString.of((byte[])presentation.serialize())).build()));
        }

        public GroupChange.Actions.Builder createAcceptInviteChange(ExpiringProfileKeyCredential credential) {
            ProfileKeyCredentialPresentation presentation = GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(GroupsV2Operations.this.random, this.groupSecretParams, credential);
            return new GroupChange.Actions.Builder().promoteMembersPendingProfileKey(Collections.singletonList(new GroupChange.Actions.PromoteMemberPendingProfileKeyAction.Builder().presentation(ByteString.of((byte[])presentation.serialize())).build()));
        }

        public GroupChange.Actions.Builder createAcceptPniInviteChange(ExpiringProfileKeyCredential credential) {
            ByteString presentation = ByteString.of((byte[])GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(GroupsV2Operations.this.random, this.groupSecretParams, credential).serialize());
            return new GroupChange.Actions.Builder().promote_members_pending_pni_aci_profile_key(Collections.singletonList(new GroupChange.Actions.PromoteMemberPendingPniAciProfileKeyAction.Builder().presentation(presentation).build()));
        }

        public GroupChange.Actions.Builder createRemoveInvitationChange(Set<UuidCiphertext> uuidCipherTextsFromInvitesToRemove) {
            GroupChange.Actions.Builder builder = new GroupChange.Actions.Builder();
            builder.deleteMembersPendingProfileKey = uuidCipherTextsFromInvitesToRemove.stream().map(uuidCipherText -> new GroupChange.Actions.DeleteMemberPendingProfileKeyAction.Builder().deletedUserId(ByteString.of((byte[])uuidCipherText.serialize())).build()).collect(Collectors.toList());
            return builder;
        }

        public GroupChange.Actions.Builder createModifyGroupLinkPasswordChange(byte[] groupLinkPassword) {
            return new GroupChange.Actions.Builder().modifyInviteLinkPassword(new GroupChange.Actions.ModifyInviteLinkPasswordAction.Builder().inviteLinkPassword(ByteString.of((byte[])groupLinkPassword)).build());
        }

        public GroupChange.Actions.Builder createModifyGroupLinkPasswordAndRightsChange(byte[] groupLinkPassword, AccessControl.AccessRequired newRights) {
            GroupChange.Actions.Builder change = this.createModifyGroupLinkPasswordChange(groupLinkPassword);
            return change.modifyAddFromInviteLinkAccess(new GroupChange.Actions.ModifyAddFromInviteLinkAccessControlAction.Builder().addFromInviteLinkAccess(newRights).build());
        }

        public GroupChange.Actions.Builder createChangeJoinByLinkRights(AccessControl.AccessRequired newRights) {
            return new GroupChange.Actions.Builder().modifyAddFromInviteLinkAccess(new GroupChange.Actions.ModifyAddFromInviteLinkAccessControlAction.Builder().addFromInviteLinkAccess(newRights).build());
        }

        public GroupChange.Actions.Builder createChangeMembershipRights(AccessControl.AccessRequired newRights) {
            return new GroupChange.Actions.Builder().modifyMemberAccess(new GroupChange.Actions.ModifyMembersAccessControlAction.Builder().membersAccess(newRights).build());
        }

        public GroupChange.Actions.Builder createChangeAttributesRights(AccessControl.AccessRequired newRights) {
            return new GroupChange.Actions.Builder().modifyAttributesAccess(new GroupChange.Actions.ModifyAttributesAccessControlAction.Builder().attributesAccess(newRights).build());
        }

        public GroupChange.Actions.Builder createAnnouncementGroupChange(boolean isAnnouncementGroup) {
            return new GroupChange.Actions.Builder().modify_announcements_only(new GroupChange.Actions.ModifyAnnouncementsOnlyAction.Builder().announcements_only(isAnnouncementGroup).build());
        }

        public GroupChange.Actions.Builder createBanServiceIdsChange(Set<? extends org.signal.core.models.ServiceId> banServiceIds, boolean rejectJoinRequest, List<DecryptedBannedMember> bannedMembersList) {
            GroupChange.Actions.Builder builder = rejectJoinRequest ? this.createRefuseGroupJoinRequest(banServiceIds, false, Collections.emptyList()) : new GroupChange.Actions.Builder();
            int spacesToFree = bannedMembersList.size() + banServiceIds.size() - GroupsV2Operations.this.maxGroupSize;
            if (spacesToFree > 0) {
                List unban = bannedMembersList.stream().sorted(Comparator.comparingLong(m -> m.timestamp)).limit(spacesToFree).map(m -> m.serviceIdBytes).collect(Collectors.toList());
                ArrayList<GroupChange.Actions.DeleteMemberBannedAction> deleteBannedMemberActions = new ArrayList<GroupChange.Actions.DeleteMemberBannedAction>(builder.delete_members_banned);
                for (ByteString serviceIdBinary : unban) {
                    deleteBannedMemberActions.add(new GroupChange.Actions.DeleteMemberBannedAction.Builder().deletedUserId(this.encryptServiceId(org.signal.core.models.ServiceId.parseOrThrow((byte[])serviceIdBinary.toByteArray()))).build());
                }
                builder.delete_members_banned(deleteBannedMemberActions);
            }
            ArrayList<GroupChange.Actions.AddMemberBannedAction> AddMemberBannedActions = new ArrayList<GroupChange.Actions.AddMemberBannedAction>(builder.add_members_banned);
            for (org.signal.core.models.ServiceId serviceId : banServiceIds) {
                AddMemberBannedActions.add(new GroupChange.Actions.AddMemberBannedAction.Builder().added(new MemberBanned.Builder().userId(this.encryptServiceId(serviceId)).build()).build());
            }
            builder.add_members_banned(AddMemberBannedActions);
            return builder;
        }

        public GroupChange.Actions.Builder createUnbanServiceIdsChange(Set<org.signal.core.models.ServiceId> serviceIds) {
            GroupChange.Actions.Builder builder = new GroupChange.Actions.Builder();
            builder.delete_members_banned = serviceIds.stream().map(serviceId -> new GroupChange.Actions.DeleteMemberBannedAction.Builder().deletedUserId(this.encryptServiceId((org.signal.core.models.ServiceId)serviceId)).build()).collect(Collectors.toList());
            return builder;
        }

        public GroupChange.Actions.Builder replaceAddMembers(GroupChange.Actions.Builder change, List<GroupCandidate> candidates) throws InvalidInputException {
            if (change.addMembers.size() != candidates.size()) {
                throw new InvalidInputException("Replacement candidates not same size as original add");
            }
            ArrayList<GroupChange.Actions.AddMemberAction> addMemberActions = new ArrayList<GroupChange.Actions.AddMemberAction>(change.addMembers);
            for (int i = 0; i < addMemberActions.size(); ++i) {
                GroupChange.Actions.AddMemberAction original = (GroupChange.Actions.AddMemberAction)((Object)addMemberActions.get(i));
                GroupCandidate candidate = candidates.get(i);
                ExpiringProfileKeyCredential expiringProfileKeyCredential = candidate.getExpiringProfileKeyCredential().orElse(null);
                if (expiringProfileKeyCredential == null) {
                    throw new InvalidInputException("Replacement candidate missing credential");
                }
                addMemberActions.set(i, new GroupChange.Actions.AddMemberAction.Builder().added(this.member(expiringProfileKeyCredential, original.added.role).build()).build());
            }
            return change.addMembers(addMemberActions);
        }

        private Member.Builder member(ExpiringProfileKeyCredential credential, Member.Role role) {
            ProfileKeyCredentialPresentation presentation = GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(new SecureRandom(), this.groupSecretParams, credential);
            return new Member.Builder().role(role).presentation(ByteString.of((byte[])presentation.serialize()));
        }

        private MemberPendingAdminApproval.Builder requestingMember(ExpiringProfileKeyCredential credential) {
            ProfileKeyCredentialPresentation presentation = GroupsV2Operations.this.clientZkProfileOperations.createProfileKeyCredentialPresentation(new SecureRandom(), this.groupSecretParams, credential);
            return new MemberPendingAdminApproval.Builder().presentation(ByteString.of((byte[])presentation.serialize()));
        }

        public MemberPendingProfileKey.Builder invitee(org.signal.core.models.ServiceId serviceId, Member.Role role) {
            UuidCiphertext uuidCiphertext = this.clientZkGroupCipher.encrypt(serviceId.getLibSignalServiceId());
            Member member = new Member.Builder().role(role).userId(ByteString.of((byte[])uuidCiphertext.serialize())).build();
            return new MemberPendingProfileKey.Builder().member(member);
        }

        @Nonnull
        public DecryptedGroupResponse decryptGroup(@Nonnull Group group, @Nonnull byte[] groupSendEndorsementsBytes) throws VerificationFailedException, InvalidGroupStateException, InvalidInputException {
            DecryptedGroup decryptedGroup = this.decryptGroup(group);
            GroupSendEndorsementsResponse groupSendEndorsementsResponse = groupSendEndorsementsBytes.length > 0 ? new GroupSendEndorsementsResponse(groupSendEndorsementsBytes) : null;
            return new DecryptedGroupResponse(decryptedGroup, groupSendEndorsementsResponse);
        }

        public DecryptedGroup decryptGroup(Group group) throws VerificationFailedException, InvalidGroupStateException {
            List<Member> membersList = group.members;
            List<MemberPendingProfileKey> pendingMembersList = group.membersPendingProfileKey;
            List<MemberPendingAdminApproval> requestingMembersList = group.membersPendingAdminApproval;
            ArrayList<DecryptedMember> decryptedMembers = new ArrayList<DecryptedMember>(membersList.size());
            ArrayList<DecryptedPendingMember> decryptedPendingMembers = new ArrayList<DecryptedPendingMember>(pendingMembersList.size());
            ArrayList<DecryptedRequestingMember> decryptedRequestingMembers = new ArrayList<DecryptedRequestingMember>(requestingMembersList.size());
            ArrayList<DecryptedBannedMember> decryptedBannedMembers = new ArrayList<DecryptedBannedMember>(group.members_banned.size());
            for (Member member : membersList) {
                try {
                    decryptedMembers.add(this.decryptMember(member).build());
                }
                catch (InvalidInputException e) {
                    throw new InvalidGroupStateException(e);
                }
            }
            for (MemberPendingProfileKey memberPendingProfileKey : pendingMembersList) {
                decryptedPendingMembers.add(this.decryptMember(memberPendingProfileKey));
            }
            for (MemberPendingAdminApproval memberPendingAdminApproval : requestingMembersList) {
                decryptedRequestingMembers.add(this.decryptRequestingMember(memberPendingAdminApproval));
            }
            for (MemberBanned memberBanned : group.members_banned) {
                decryptedBannedMembers.add(new DecryptedBannedMember.Builder().serviceIdBytes(this.decryptServiceIdToBinary(memberBanned.userId)).timestamp(memberBanned.timestamp).build());
            }
            return new DecryptedGroup.Builder().title(this.decryptTitle(group.title)).description(this.decryptDescription(group.description)).isAnnouncementGroup(group.announcements_only ? EnabledState.ENABLED : EnabledState.DISABLED).avatar(group.avatarUrl).accessControl(group.accessControl).revision(group.version).members(decryptedMembers).pendingMembers(decryptedPendingMembers).requestingMembers(decryptedRequestingMembers).disappearingMessagesTimer(new DecryptedTimer.Builder().duration(this.decryptDisappearingMessagesTimer(group.disappearingMessagesTimer)).build()).inviteLinkPassword(group.inviteLinkPassword).bannedMembers(decryptedBannedMembers).build();
        }

        public Optional<DecryptedGroupChange> decryptChange(GroupChange groupChange, @Nonnull DecryptChangeVerificationMode verification) throws IOException, VerificationFailedException, InvalidGroupStateException {
            GroupIdentifier groupId;
            GroupChange.Actions actions;
            if (groupChange.changeEpoch > 6) {
                Log.w((String)TAG, (String)String.format(Locale.US, "Ignoring change from Epoch %d. Highest known Epoch is %d", groupChange.changeEpoch, 6));
                return Optional.empty();
            }
            GroupChange.Actions actions2 = actions = verification.verify() ? this.getVerifiedActions(groupChange) : this.getActions(groupChange);
            if (verification.verify() && ((groupId = verification.groupId()) == null || !Arrays.equals(groupId.serialize(), actions.group_id.toByteArray()))) {
                throw new VerificationFailedException("Invalid group id");
            }
            return Optional.of(this.decryptChange(actions));
        }

        public DecryptedGroupChange decryptChange(GroupChange.Actions actions) throws VerificationFailedException, InvalidGroupStateException {
            return this.decryptChange(actions, null);
        }

        /*
         * WARNING - void declaration
         */
        public DecryptedGroupChange decryptChange(GroupChange.Actions actions, org.signal.core.models.ServiceId source) throws VerificationFailedException, InvalidGroupStateException {
            DecryptedGroupChange.Builder builder = new DecryptedGroupChange.Builder();
            org.signal.core.models.ServiceId editorServiceId = source != null ? source : this.decryptServiceId(actions.sourceUserId);
            builder.editorServiceIdBytes(editorServiceId.toByteString());
            builder.revision(actions.version);
            ArrayList<DecryptedMember> newMembers = new ArrayList<DecryptedMember>(actions.addMembers.size());
            for (GroupChange.Actions.AddMemberAction addMemberAction : actions.addMembers) {
                try {
                    newMembers.add(this.decryptMember(addMemberAction.added).joinedAtRevision(actions.version).build());
                }
                catch (InvalidInputException invalidInputException) {
                    throw new InvalidGroupStateException(invalidInputException);
                }
            }
            builder.newMembers(newMembers);
            ArrayList<ByteString> deleteMembers = new ArrayList<ByteString>(actions.deleteMembers.size());
            for (GroupChange.Actions.DeleteMemberAction deleteMemberAction : actions.deleteMembers) {
                deleteMembers.add(this.decryptAciToBinary(deleteMemberAction.deletedUserId));
            }
            builder.deleteMembers(deleteMembers);
            ArrayList<DecryptedModifyMemberRole> arrayList = new ArrayList<DecryptedModifyMemberRole>(actions.modifyMemberRoles.size());
            for (GroupChange.Actions.ModifyMemberRoleAction modifyMemberRoleAction : actions.modifyMemberRoles) {
                arrayList.add(new DecryptedModifyMemberRole.Builder().role(modifyMemberRoleAction.role).aciBytes(this.decryptAciToBinary(modifyMemberRoleAction.userId)).build());
            }
            builder.modifyMemberRoles(arrayList);
            ArrayList<DecryptedMember> arrayList2 = new ArrayList<DecryptedMember>(actions.modifyMemberProfileKeys.size());
            for (GroupChange.Actions.ModifyMemberProfileKeyAction modifyMemberProfileKeyAction : actions.modifyMemberProfileKeys) {
                try {
                    void var12_28;
                    void var11_20;
                    if (modifyMemberProfileKeyAction.user_id.size() == 0 || modifyMemberProfileKeyAction.profile_key.size() == 0) {
                        ProfileKeyCredentialPresentation profileKeyCredentialPresentation = new ProfileKeyCredentialPresentation(modifyMemberProfileKeyAction.presentation.toByteArray());
                        ServiceId.ACI aCI = this.decryptAci(ByteString.of((byte[])profileKeyCredentialPresentation.getUuidCiphertext().serialize()));
                        ProfileKey profileKey = this.decryptProfileKey(ByteString.of((byte[])profileKeyCredentialPresentation.getProfileKeyCiphertext().serialize()), aCI);
                    } else {
                        ServiceId.ACI aCI = this.decryptAci(modifyMemberProfileKeyAction.user_id);
                        ProfileKey profileKey = this.decryptProfileKey(modifyMemberProfileKeyAction.profile_key, aCI);
                    }
                    arrayList2.add(new DecryptedMember.Builder().role(Member.Role.UNKNOWN).joinedAtRevision(-1).aciBytes(var11_20.toByteString()).profileKey(ByteString.of((byte[])var12_28.serialize())).build());
                }
                catch (InvalidInputException invalidInputException) {
                    throw new InvalidGroupStateException(invalidInputException);
                }
            }
            builder.modifiedProfileKeys(arrayList2);
            ArrayList<DecryptedPendingMember> arrayList3 = new ArrayList<DecryptedPendingMember>(actions.addMembersPendingProfileKey.size());
            for (GroupChange.Actions.AddMemberPendingProfileKeyAction addMemberPendingProfileKeyAction : actions.addMembersPendingProfileKey) {
                MemberPendingProfileKey memberPendingProfileKey = addMemberPendingProfileKeyAction.added;
                Member member = memberPendingProfileKey.member;
                ByteString byteString = member.userId;
                org.signal.core.models.ServiceId serviceId = this.decryptServiceIdOrUnknown(byteString);
                arrayList3.add(new DecryptedPendingMember.Builder().serviceIdBytes(serviceId.toByteString()).serviceIdCipherText(byteString).role(member.role).addedByAci(this.decryptAciToBinary(memberPendingProfileKey.addedByUserId)).timestamp(memberPendingProfileKey.timestamp).build());
            }
            builder.newPendingMembers(arrayList3);
            ArrayList<DecryptedPendingMemberRemoval> arrayList4 = new ArrayList<DecryptedPendingMemberRemoval>(actions.deleteMembersPendingProfileKey.size());
            for (GroupChange.Actions.DeleteMemberPendingProfileKeyAction deleteMemberPendingProfileKeyAction : actions.deleteMembersPendingProfileKey) {
                ByteString byteString = deleteMemberPendingProfileKeyAction.deletedUserId;
                org.signal.core.models.ServiceId serviceId = this.decryptServiceIdOrUnknown(byteString);
                arrayList4.add(new DecryptedPendingMemberRemoval.Builder().serviceIdBytes(serviceId.toByteString()).serviceIdCipherText(byteString).build());
            }
            builder.deletePendingMembers(arrayList4);
            ArrayList<DecryptedMember> arrayList5 = new ArrayList<DecryptedMember>(actions.promoteMembersPendingProfileKey.size());
            for (GroupChange.Actions.PromoteMemberPendingProfileKeyAction promoteMemberPendingProfileKeyAction : actions.promoteMembersPendingProfileKey) {
                try {
                    void var15_63;
                    void var14_53;
                    if (promoteMemberPendingProfileKeyAction.user_id.size() == 0 || promoteMemberPendingProfileKeyAction.profile_key.size() == 0) {
                        ProfileKeyCredentialPresentation profileKeyCredentialPresentation = new ProfileKeyCredentialPresentation(promoteMemberPendingProfileKeyAction.presentation.toByteArray());
                        ServiceId.ACI aCI = this.decryptAci(ByteString.of((byte[])profileKeyCredentialPresentation.getUuidCiphertext().serialize()));
                        ProfileKey profileKey = this.decryptProfileKey(ByteString.of((byte[])profileKeyCredentialPresentation.getProfileKeyCiphertext().serialize()), aCI);
                    } else {
                        ServiceId.ACI aCI = this.decryptAci(promoteMemberPendingProfileKeyAction.user_id);
                        ProfileKey profileKey = this.decryptProfileKey(promoteMemberPendingProfileKeyAction.profile_key, aCI);
                    }
                    arrayList5.add(new DecryptedMember.Builder().joinedAtRevision(-1).role(Member.Role.DEFAULT).aciBytes(var14_53.toByteString()).profileKey(ByteString.of((byte[])var15_63.serialize())).build());
                }
                catch (InvalidInputException invalidInputException) {
                    throw new InvalidGroupStateException(invalidInputException);
                }
            }
            builder.promotePendingMembers(arrayList5);
            if (actions.modifyTitle != null) {
                builder.newTitle(new DecryptedString.Builder().value_(this.decryptTitle(actions.modifyTitle.title)).build());
            }
            if (actions.modifyAvatar != null) {
                builder.newAvatar(new DecryptedString.Builder().value_(actions.modifyAvatar.avatar).build());
            }
            if (actions.modifyDisappearingMessageTimer != null) {
                int n = this.decryptDisappearingMessagesTimer(actions.modifyDisappearingMessageTimer.timer);
                builder.newTimer(new DecryptedTimer.Builder().duration(n).build());
            }
            if (actions.modifyAttributesAccess != null) {
                builder.newAttributeAccess(actions.modifyAttributesAccess.attributesAccess);
            }
            if (actions.modifyMemberAccess != null) {
                builder.newMemberAccess(actions.modifyMemberAccess.membersAccess);
            }
            if (actions.modifyAddFromInviteLinkAccess != null) {
                builder.newInviteLinkAccess(actions.modifyAddFromInviteLinkAccess.addFromInviteLinkAccess);
            }
            ArrayList<DecryptedRequestingMember> arrayList6 = new ArrayList<DecryptedRequestingMember>(actions.addMembersPendingAdminApproval.size());
            for (GroupChange.Actions.AddMemberPendingAdminApprovalAction addMemberPendingAdminApprovalAction : actions.addMembersPendingAdminApproval) {
                arrayList6.add(this.decryptRequestingMember(addMemberPendingAdminApprovalAction.added));
            }
            builder.newRequestingMembers(arrayList6);
            ArrayList<ByteString> arrayList7 = new ArrayList<ByteString>(actions.deleteMembersPendingAdminApproval.size());
            for (GroupChange.Actions.DeleteMemberPendingAdminApprovalAction deleteMemberPendingAdminApprovalAction : actions.deleteMembersPendingAdminApproval) {
                arrayList7.add(this.decryptServiceIdToBinary(deleteMemberPendingAdminApprovalAction.deletedUserId));
            }
            builder.deleteRequestingMembers(arrayList7);
            ArrayList<DecryptedApproveMember> arrayList8 = new ArrayList<DecryptedApproveMember>(actions.promoteMembersPendingAdminApproval.size());
            for (GroupChange.Actions.PromoteMemberPendingAdminApprovalAction promoteMemberPendingAdminApprovalAction : actions.promoteMembersPendingAdminApproval) {
                arrayList8.add(new DecryptedApproveMember.Builder().role(promoteMemberPendingAdminApprovalAction.role).aciBytes(this.decryptAciToBinary(promoteMemberPendingAdminApprovalAction.userId)).build());
            }
            builder.promoteRequestingMembers(arrayList8);
            if (actions.modifyInviteLinkPassword != null) {
                builder.newInviteLinkPassword(actions.modifyInviteLinkPassword.inviteLinkPassword);
            }
            if (actions.modifyDescription != null) {
                builder.newDescription(new DecryptedString.Builder().value_(this.decryptDescription(actions.modifyDescription.description)).build());
            }
            if (actions.modify_announcements_only != null) {
                builder.newIsAnnouncementGroup(actions.modify_announcements_only.announcements_only ? EnabledState.ENABLED : EnabledState.DISABLED);
            }
            ArrayList<DecryptedBannedMember> arrayList9 = new ArrayList<DecryptedBannedMember>(actions.add_members_banned.size());
            for (GroupChange.Actions.AddMemberBannedAction addMemberBannedAction : actions.add_members_banned) {
                arrayList9.add(new DecryptedBannedMember.Builder().serviceIdBytes(this.decryptServiceIdToBinary(addMemberBannedAction.added.userId)).timestamp(addMemberBannedAction.added.timestamp).build());
            }
            builder.newBannedMembers(arrayList9);
            ArrayList<DecryptedBannedMember> arrayList10 = new ArrayList<DecryptedBannedMember>(actions.delete_members_banned.size());
            for (GroupChange.Actions.DeleteMemberBannedAction deleteMemberBannedAction : actions.delete_members_banned) {
                arrayList10.add(new DecryptedBannedMember.Builder().serviceIdBytes(this.decryptServiceIdToBinary(deleteMemberBannedAction.deletedUserId)).build());
            }
            builder.deleteBannedMembers(arrayList10);
            ArrayList<DecryptedMember> arrayList11 = new ArrayList<DecryptedMember>(actions.promote_members_pending_pni_aci_profile_key.size());
            for (GroupChange.Actions.PromoteMemberPendingPniAciProfileKeyAction promoteMemberPendingPniAciProfileKeyAction : actions.promote_members_pending_pni_aci_profile_key) {
                ServiceId.ACI aci = this.decryptAci(promoteMemberPendingPniAciProfileKeyAction.user_id);
                org.signal.core.models.ServiceId pni = this.decryptServiceId(promoteMemberPendingPniAciProfileKeyAction.pni);
                ProfileKey profileKey = this.decryptProfileKey(promoteMemberPendingPniAciProfileKeyAction.profile_key, aci);
                if (!(pni instanceof ServiceId.PNI)) {
                    throw new InvalidGroupStateException();
                }
                builder.editorServiceIdBytes(aci.toByteString());
                arrayList11.add(new DecryptedMember.Builder().aciBytes(aci.toByteString()).role(Member.Role.DEFAULT).profileKey(ByteString.of((byte[])profileKey.serialize())).joinedAtRevision(actions.version).pniBytes(pni.toByteString()).build());
            }
            builder.promotePendingPniAciMembers(arrayList11);
            ArrayList<DecryptedModifyMemberLabel> arrayList12 = new ArrayList<DecryptedModifyMemberLabel>(actions.modifyMemberLabels.size());
            for (GroupChange.Actions.ModifyMemberLabelAction action4 : actions.modifyMemberLabels) {
                arrayList12.add(new DecryptedModifyMemberLabel.Builder().aciBytes(this.decryptAciToBinary(action4.userId)).labelEmoji(Objects.requireNonNullElse(this.decryptString(action4.labelEmoji), "")).labelString(Objects.requireNonNullElse(this.decryptString(action4.labelString), "")).build());
            }
            builder.modifyMemberLabels(arrayList12);
            if (editorServiceId instanceof ServiceId.PNI) {
                if (actions.addMembers.size() == 1 && builder.newMembers.size() == 1) {
                    GroupChange.Actions.AddMemberAction addMemberAction = actions.addMembers.get(0);
                    DecryptedMember decryptedMember = builder.newMembers.get(0);
                    if (addMemberAction.joinFromInviteLink) {
                        Log.d((String)TAG, (String)"Replacing PNI editor with ACI for buggy join from invite link");
                        builder.editorServiceIdBytes(decryptedMember.aciBytes);
                    } else {
                        Log.w((String)TAG, (String)"Unable to replace PNI editor with ACI for add member update");
                        builder.editorServiceIdBytes(ByteString.EMPTY);
                    }
                } else if (actions.deleteMembersPendingProfileKey.isEmpty() && actions.promote_members_pending_pni_aci_profile_key.isEmpty()) {
                    Log.w((String)TAG, (String)"Received group change with PNI editor for a non-PNI editor eligible update, clearing editor");
                    builder.editorServiceIdBytes(ByteString.EMPTY);
                }
            }
            return builder.build();
        }

        public DecryptedGroupJoinInfo decryptGroupJoinInfo(GroupJoinInfo joinInfo) {
            return new DecryptedGroupJoinInfo.Builder().title(this.decryptTitle(joinInfo.title)).avatar(joinInfo.avatar).memberCount(joinInfo.memberCount).addFromInviteLink(joinInfo.addFromInviteLink).revision(joinInfo.version).pendingAdminApproval(joinInfo.pendingAdminApproval).description(this.decryptDescription(joinInfo.description)).build();
        }

        private DecryptedMember.Builder decryptMember(Member member) throws InvalidGroupStateException, VerificationFailedException, InvalidInputException {
            String labelEmoji = Objects.requireNonNullElse(this.decryptString(member.labelEmoji), "");
            String labelString = Objects.requireNonNullElse(this.decryptString(member.labelString), "");
            if (member.presentation.size() == 0) {
                ServiceId.ACI aci = this.decryptAci(member.userId);
                return new DecryptedMember.Builder().aciBytes(aci.toByteString()).joinedAtRevision(member.joinedAtVersion).profileKey(this.decryptProfileKeyToByteString(member.profileKey, aci)).role(member.role).labelEmoji(labelEmoji).labelString(labelString);
            }
            ProfileKeyCredentialPresentation profileKeyCredentialPresentation = new ProfileKeyCredentialPresentation(member.presentation.toByteArray());
            org.signal.core.models.ServiceId serviceId = org.signal.core.models.ServiceId.fromLibSignal((ServiceId)this.clientZkGroupCipher.decrypt(profileKeyCredentialPresentation.getUuidCiphertext()));
            if (!(serviceId instanceof ServiceId.ACI)) {
                throw new InvalidGroupStateException();
            }
            ServiceId.ACI aci = (ServiceId.ACI)serviceId;
            ProfileKey profileKey = this.clientZkGroupCipher.decryptProfileKey(profileKeyCredentialPresentation.getProfileKeyCiphertext(), aci.getLibSignalAci());
            return new DecryptedMember.Builder().aciBytes(aci.toByteString()).joinedAtRevision(member.joinedAtVersion).profileKey(ByteString.of((byte[])profileKey.serialize())).role(member.role).labelEmoji(labelEmoji).labelString(labelString);
        }

        private DecryptedPendingMember decryptMember(MemberPendingProfileKey member) throws InvalidGroupStateException, VerificationFailedException {
            ByteString userIdCipherText = member.member.userId;
            org.signal.core.models.ServiceId serviceId = this.decryptServiceIdOrUnknown(userIdCipherText);
            ServiceId.ACI addedBy = this.decryptAci(member.addedByUserId);
            Member.Role role = member.member.role;
            if (role != Member.Role.ADMINISTRATOR && role != Member.Role.DEFAULT) {
                role = Member.Role.DEFAULT;
            }
            return new DecryptedPendingMember.Builder().serviceIdBytes(serviceId.toByteString()).serviceIdCipherText(userIdCipherText).addedByAci(addedBy.toByteString()).role(role).timestamp(member.timestamp).build();
        }

        private DecryptedRequestingMember decryptRequestingMember(MemberPendingAdminApproval member) throws InvalidGroupStateException, VerificationFailedException {
            ProfileKeyCredentialPresentation profileKeyCredentialPresentation;
            if (member.presentation.size() == 0) {
                ServiceId.ACI aci = this.decryptAci(member.userId);
                return new DecryptedRequestingMember.Builder().aciBytes(aci.toByteString()).profileKey(this.decryptProfileKeyToByteString(member.profileKey, aci)).timestamp(member.timestamp).build();
            }
            try {
                profileKeyCredentialPresentation = new ProfileKeyCredentialPresentation(member.presentation.toByteArray());
            }
            catch (InvalidInputException e) {
                throw new InvalidGroupStateException(e);
            }
            org.signal.core.models.ServiceId serviceId = org.signal.core.models.ServiceId.fromLibSignal((ServiceId)this.clientZkGroupCipher.decrypt(profileKeyCredentialPresentation.getUuidCiphertext()));
            if (!(serviceId instanceof ServiceId.ACI)) {
                throw new InvalidGroupStateException();
            }
            ServiceId.ACI aci = (ServiceId.ACI)serviceId;
            ProfileKey profileKey = this.clientZkGroupCipher.decryptProfileKey(profileKeyCredentialPresentation.getProfileKeyCiphertext(), aci.getLibSignalAci());
            return new DecryptedRequestingMember.Builder().aciBytes(aci.toByteString()).profileKey(ByteString.of((byte[])profileKey.serialize())).build();
        }

        private ProfileKey decryptProfileKey(ByteString profileKey, ServiceId.ACI aci) throws VerificationFailedException, InvalidGroupStateException {
            try {
                ProfileKeyCiphertext profileKeyCiphertext = new ProfileKeyCiphertext(profileKey.toByteArray());
                return this.clientZkGroupCipher.decryptProfileKey(profileKeyCiphertext, aci.getLibSignalAci());
            }
            catch (InvalidInputException e) {
                throw new InvalidGroupStateException(e);
            }
        }

        private ByteString decryptProfileKeyToByteString(ByteString profileKey, ServiceId.ACI aci) throws VerificationFailedException, InvalidGroupStateException {
            return ByteString.of((byte[])this.decryptProfileKey(profileKey, aci).serialize());
        }

        private ByteString decryptServiceIdToBinary(ByteString userId) throws InvalidGroupStateException, VerificationFailedException {
            return this.decryptServiceId(userId).toByteString();
        }

        private ByteString decryptAciToBinary(ByteString userId) throws InvalidGroupStateException, VerificationFailedException {
            return this.decryptAci(userId).toByteString();
        }

        public ByteString encryptServiceId(org.signal.core.models.ServiceId serviceId) {
            return ByteString.of((byte[])this.clientZkGroupCipher.encrypt(serviceId.getLibSignalServiceId()).serialize());
        }

        private org.signal.core.models.ServiceId decryptServiceId(ByteString userId) throws InvalidGroupStateException, VerificationFailedException {
            try {
                return org.signal.core.models.ServiceId.fromLibSignal((ServiceId)this.clientZkGroupCipher.decrypt(new UuidCiphertext(userId.toByteArray())));
            }
            catch (InvalidInputException e) {
                throw new InvalidGroupStateException(e);
            }
        }

        private ServiceId.ACI decryptAci(ByteString userId) throws InvalidGroupStateException, VerificationFailedException {
            org.signal.core.models.ServiceId result2 = this.decryptServiceId(userId);
            if (result2 instanceof ServiceId.ACI) {
                return (ServiceId.ACI)result2;
            }
            throw new InvalidGroupStateException();
        }

        private org.signal.core.models.ServiceId decryptServiceIdOrUnknown(ByteString userId) {
            try {
                return org.signal.core.models.ServiceId.fromLibSignal((ServiceId)this.clientZkGroupCipher.decrypt(new UuidCiphertext(userId.toByteArray())));
            }
            catch (InvalidInputException | VerificationFailedException e) {
                return ServiceId.ACI.UNKNOWN;
            }
        }

        private ServiceId.ACI decryptAciOrUnknown(ByteString userId) {
            try {
                org.signal.core.models.ServiceId result2 = org.signal.core.models.ServiceId.fromLibSignal((ServiceId)this.clientZkGroupCipher.decrypt(new UuidCiphertext(userId.toByteArray())));
                if (result2 instanceof ServiceId.ACI) {
                    return (ServiceId.ACI)result2;
                }
                return ServiceId.ACI.UNKNOWN;
            }
            catch (InvalidInputException | VerificationFailedException e) {
                return ServiceId.ACI.UNKNOWN;
            }
        }

        ByteString encryptTitle(String title) {
            try {
                GroupAttributeBlob blob = new GroupAttributeBlob.Builder().title(title).build();
                return ByteString.of((byte[])this.clientZkGroupCipher.encryptBlob(blob.encode()));
            }
            catch (VerificationFailedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private String decryptTitle(ByteString cipherText) {
            String title = this.decryptBlob((ByteString)cipherText).title;
            return title != null ? title.trim() : "";
        }

        ByteString encryptDescription(String description) {
            try {
                GroupAttributeBlob blob = new GroupAttributeBlob.Builder().descriptionText(description).build();
                return ByteString.of((byte[])this.clientZkGroupCipher.encryptBlob(blob.encode()));
            }
            catch (VerificationFailedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private String decryptDescription(ByteString cipherText) {
            String description = this.decryptBlob((ByteString)cipherText).descriptionText;
            return description != null ? description.trim() : "";
        }

        private int decryptDisappearingMessagesTimer(ByteString encryptedTimerMessage) {
            Integer disappearingMessagesDuration = this.decryptBlob((ByteString)encryptedTimerMessage).disappearingMessagesDuration;
            return disappearingMessagesDuration != null ? disappearingMessagesDuration : 0;
        }

        public byte[] decryptAvatar(byte[] bytes) {
            return this.decryptBlob((byte[])bytes).avatar.toByteArray();
        }

        private GroupAttributeBlob decryptBlob(ByteString blob) {
            return this.decryptBlob(blob.toByteArray());
        }

        private GroupAttributeBlob decryptBlob(byte[] bytes) {
            if (bytes == null || bytes.length == 0) {
                return new GroupAttributeBlob();
            }
            if (bytes.length < 29) {
                Log.w((String)TAG, (String)"Bad encrypted blob length");
                return new GroupAttributeBlob();
            }
            try {
                return (GroupAttributeBlob)((Object)GroupAttributeBlob.ADAPTER.decode(this.clientZkGroupCipher.decryptBlob(bytes)));
            }
            catch (IOException | VerificationFailedException e) {
                Log.w((String)TAG, (String)"Bad encrypted blob");
                return new GroupAttributeBlob();
            }
        }

        ByteString encryptTimer(int timerDurationSeconds) {
            try {
                GroupAttributeBlob timer = new GroupAttributeBlob.Builder().disappearingMessagesDuration(timerDurationSeconds).build();
                return ByteString.of((byte[])this.clientZkGroupCipher.encryptBlob(timer.encode()));
            }
            catch (VerificationFailedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private ByteString encryptString(@Nullable String value) {
            if (value == null || value.isEmpty()) {
                return ByteString.EMPTY;
            }
            try {
                return ByteString.of((byte[])this.clientZkGroupCipher.encryptBlob(value.getBytes(StandardCharsets.UTF_8)));
            }
            catch (VerificationFailedException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Nullable
        private String decryptString(@Nullable ByteString cipherText) throws VerificationFailedException {
            if (cipherText == null || cipherText.size() == 0) {
                return null;
            }
            byte[] decryptedBytes = this.clientZkGroupCipher.decryptBlob(cipherText.toByteArray());
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }

        private GroupChange.Actions getVerifiedActions(GroupChange groupChange) throws VerificationFailedException, IOException {
            NotarySignature signature;
            byte[] actionsByteArray = groupChange.actions.toByteArray();
            try {
                signature = new NotarySignature(groupChange.serverSignature.toByteArray());
            }
            catch (InvalidInputException e) {
                Log.w((String)TAG, (String)"Invalid input while verifying group change", (Throwable)e);
                throw new VerificationFailedException();
            }
            GroupsV2Operations.this.serverPublicParams.verifySignature(actionsByteArray, signature);
            return (GroupChange.Actions)((Object)GroupChange.Actions.ADAPTER.decode(actionsByteArray));
        }

        private GroupChange.Actions getActions(GroupChange groupChange) throws IOException {
            return (GroupChange.Actions)((Object)GroupChange.Actions.ADAPTER.decode(groupChange.actions));
        }

        public GroupChange.Actions.Builder createChangeMemberRole(ServiceId.ACI memberAci, Member.Role role) {
            return new GroupChange.Actions.Builder().modifyMemberRoles(Collections.singletonList(new GroupChange.Actions.ModifyMemberRoleAction.Builder().userId(this.encryptServiceId((org.signal.core.models.ServiceId)memberAci)).role(role).build()));
        }

        public GroupChange.Actions.Builder createChangeMemberLabel(@Nonnull ServiceId.ACI memberAci, @Nonnull String labelString, @Nullable String labelEmoji) {
            return new GroupChange.Actions.Builder().modifyMemberLabels(Collections.singletonList(new GroupChange.Actions.ModifyMemberLabelAction.Builder().userId(this.encryptServiceId((org.signal.core.models.ServiceId)memberAci)).labelEmoji(this.encryptString(labelEmoji)).labelString(this.encryptString(labelString)).build()));
        }

        public List<org.signal.core.models.ServiceId> decryptAddMembers(List<GroupChange.Actions.AddMemberAction> addMembers) throws InvalidGroupStateException, InvalidInputException, VerificationFailedException {
            ArrayList<org.signal.core.models.ServiceId> ids = new ArrayList<org.signal.core.models.ServiceId>(addMembers.size());
            for (GroupChange.Actions.AddMemberAction addMember : addMembers) {
                if (addMember.added.presentation.size() == 0) {
                    ids.add((org.signal.core.models.ServiceId)this.decryptAci(addMember.added.userId));
                    continue;
                }
                ProfileKeyCredentialPresentation profileKeyCredentialPresentation = new ProfileKeyCredentialPresentation(addMember.added.presentation.toByteArray());
                ids.add(org.signal.core.models.ServiceId.fromLibSignal((ServiceId)this.clientZkGroupCipher.decrypt(profileKeyCredentialPresentation.getUuidCiphertext())));
            }
            return ids;
        }

        @Nullable
        public ReceivedGroupSendEndorsements receiveGroupSendEndorsements(@Nonnull ServiceId.ACI selfAci, @Nonnull DecryptedGroup decryptedGroup, @Nullable ByteString groupSendEndorsementsResponse) {
            if (groupSendEndorsementsResponse != null && groupSendEndorsementsResponse.size() > 0) {
                try {
                    return this.receiveGroupSendEndorsements(selfAci, decryptedGroup, new GroupSendEndorsementsResponse(groupSendEndorsementsResponse.toByteArray()));
                }
                catch (InvalidInputException e) {
                    Log.w((String)TAG, (String)"Unable to parse send endorsements response", (Throwable)e);
                }
            }
            return null;
        }

        @Nullable
        public ReceivedGroupSendEndorsements receiveGroupSendEndorsements(@Nonnull ServiceId.ACI selfAci, @Nonnull DecryptedGroup decryptedGroup, @Nullable GroupSendEndorsementsResponse groupSendEndorsementsResponse) {
            if (groupSendEndorsementsResponse == null) {
                return null;
            }
            List<ServiceId.ACI> members = decryptedGroup.members.stream().map(m -> ServiceId.ACI.parseOrThrow((ByteString)m.aciBytes)).collect(Collectors.toList());
            if (!members.contains(selfAci)) {
                Log.w((String)TAG, (String)"Attempting to receive endorsements for group state we aren't in, aborting");
                return null;
            }
            GroupSendEndorsementsResponse.ReceivedEndorsements endorsements = null;
            try {
                endorsements = groupSendEndorsementsResponse.receive(members.stream().map(ServiceId.ACI::getLibSignalAci).collect(Collectors.toList()), selfAci.getLibSignalAci(), this.groupSecretParams, GroupsV2Operations.this.serverPublicParams);
            }
            catch (VerificationFailedException e) {
                Log.w((String)TAG, (String)"Unable to receive send endorsements for group", (Throwable)e);
            }
            return endorsements != null ? new ReceivedGroupSendEndorsements(groupSendEndorsementsResponse.getExpiration(), members, endorsements) : null;
        }
    }

    public static class NewGroup {
        private final GroupSecretParams groupSecretParams;
        private final Group newGroupMessage;
        private final Optional<byte[]> avatar;

        private NewGroup(GroupSecretParams groupSecretParams, Group newGroupMessage, Optional<byte[]> avatar) {
            this.groupSecretParams = groupSecretParams;
            this.newGroupMessage = newGroupMessage;
            this.avatar = avatar;
        }

        public GroupSecretParams getGroupSecretParams() {
            return this.groupSecretParams;
        }

        public Group getNewGroupMessage() {
            return this.newGroupMessage;
        }

        public Optional<byte[]> getAvatar() {
            return this.avatar;
        }
    }
}

