/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import okio.ByteString;
import org.signal.storageservice.storage.protos.groups.GroupChange;
import org.signal.storageservice.storage.protos.groups.local.DecryptedApproveMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedBannedMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.storage.protos.groups.local.DecryptedMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedModifyMemberLabel;
import org.signal.storageservice.storage.protos.groups.local.DecryptedModifyMemberRole;
import org.signal.storageservice.storage.protos.groups.local.DecryptedPendingMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedPendingMemberRemoval;
import org.signal.storageservice.storage.protos.groups.local.DecryptedRequestingMember;
import org.whispersystems.signalservice.api.groupsv2.ChangeSetModifier;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupChangeActionsBuilderChangeSetModifier;
import org.whispersystems.signalservice.api.groupsv2.GroupChangeActionsBuilderChangeSetModifier;

public final class GroupChangeUtil {
    private GroupChangeUtil() {
    }

    public static boolean changeIsEmpty(GroupChange.Actions change) {
        return change.addMembers.size() == 0 && change.deleteMembers.size() == 0 && change.modifyMemberRoles.size() == 0 && change.modifyMemberProfileKeys.size() == 0 && change.addMembersPendingProfileKey.size() == 0 && change.deleteMembersPendingProfileKey.size() == 0 && change.promoteMembersPendingProfileKey.size() == 0 && change.modifyTitle == null && change.modifyAvatar == null && change.modifyDisappearingMessageTimer == null && change.modifyAttributesAccess == null && change.modifyMemberAccess == null && change.modifyAddFromInviteLinkAccess == null && change.addMembersPendingAdminApproval.size() == 0 && change.deleteMembersPendingAdminApproval.size() == 0 && change.promoteMembersPendingAdminApproval.size() == 0 && change.modifyInviteLinkPassword == null && change.modifyDescription == null && change.modify_announcements_only == null && change.add_members_banned.size() == 0 && change.delete_members_banned.size() == 0 && change.promote_members_pending_pni_aci_profile_key.size() == 0 && change.modifyMemberLabels.isEmpty();
    }

    public static GroupChange.Actions.Builder resolveConflict(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, GroupChange.Actions encryptedChange) {
        GroupChange.Actions.Builder result2 = encryptedChange.newBuilder();
        GroupChangeUtil.resolveConflict(groupState, conflictingChange, new GroupChangeActionsBuilderChangeSetModifier(result2));
        return result2;
    }

    public static DecryptedGroupChange.Builder resolveConflict(DecryptedGroup groupState, DecryptedGroupChange conflictingChange) {
        DecryptedGroupChange.Builder result2 = conflictingChange.newBuilder();
        GroupChangeUtil.resolveConflict(groupState, conflictingChange, new DecryptedGroupChangeActionsBuilderChangeSetModifier(result2));
        return result2;
    }

    private static void resolveConflict(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier changeSetModifier) {
        HashMap<ByteString, DecryptedMember> fullMembersByUuid = new HashMap<ByteString, DecryptedMember>(groupState.members.size());
        HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId = new HashMap<ByteString, DecryptedPendingMember>(groupState.pendingMembers.size());
        HashMap<ByteString, DecryptedRequestingMember> requestingMembersByUuid = new HashMap<ByteString, DecryptedRequestingMember>(groupState.members.size());
        HashMap<ByteString, DecryptedBannedMember> bannedMembersByServiceId = new HashMap<ByteString, DecryptedBannedMember>(groupState.bannedMembers.size());
        for (DecryptedMember decryptedMember : groupState.members) {
            fullMembersByUuid.put(decryptedMember.aciBytes, decryptedMember);
        }
        for (DecryptedPendingMember decryptedPendingMember : groupState.pendingMembers) {
            pendingMembersByServiceId.put(decryptedPendingMember.serviceIdBytes, decryptedPendingMember);
        }
        for (DecryptedRequestingMember decryptedRequestingMember : groupState.requestingMembers) {
            requestingMembersByUuid.put(decryptedRequestingMember.aciBytes, decryptedRequestingMember);
        }
        for (DecryptedBannedMember decryptedBannedMember : groupState.bannedMembers) {
            bannedMembersByServiceId.put(decryptedBannedMember.serviceIdBytes, decryptedBannedMember);
        }
        GroupChangeUtil.resolveField3AddMembers(conflictingChange, changeSetModifier, fullMembersByUuid, pendingMembersByServiceId);
        GroupChangeUtil.resolveField4DeleteMembers(conflictingChange, changeSetModifier, fullMembersByUuid);
        GroupChangeUtil.resolveField5ModifyMemberRoles(conflictingChange, changeSetModifier, fullMembersByUuid);
        GroupChangeUtil.resolveField6ModifyProfileKeys(conflictingChange, changeSetModifier, fullMembersByUuid);
        GroupChangeUtil.resolveField7AddPendingMembers(conflictingChange, changeSetModifier, fullMembersByUuid, pendingMembersByServiceId);
        GroupChangeUtil.resolveField8DeletePendingMembers(conflictingChange, changeSetModifier, pendingMembersByServiceId);
        GroupChangeUtil.resolveField9PromotePendingMembers(conflictingChange, changeSetModifier, pendingMembersByServiceId);
        GroupChangeUtil.resolveField10ModifyTitle(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField11ModifyAvatar(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField12modifyDisappearingMessagesTimer(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField13modifyAttributesAccess(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField14modifyAttributesAccess(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField15modifyAddFromInviteLinkAccess(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField16AddRequestingMembers(conflictingChange, changeSetModifier, fullMembersByUuid, pendingMembersByServiceId);
        GroupChangeUtil.resolveField17DeleteMembers(conflictingChange, changeSetModifier, requestingMembersByUuid);
        GroupChangeUtil.resolveField18PromoteRequestingMembers(conflictingChange, changeSetModifier, requestingMembersByUuid);
        GroupChangeUtil.resolveField20ModifyDescription(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField21ModifyAnnouncementsOnly(groupState, conflictingChange, changeSetModifier);
        GroupChangeUtil.resolveField22AddBannedMembers(conflictingChange, changeSetModifier, bannedMembersByServiceId);
        GroupChangeUtil.resolveField23DeleteBannedMembers(conflictingChange, changeSetModifier, bannedMembersByServiceId);
        GroupChangeUtil.resolveField24PromotePendingPniAciMembers(conflictingChange, changeSetModifier, fullMembersByUuid);
        GroupChangeUtil.resolveField26ModifyMemberLabels(conflictingChange, changeSetModifier, fullMembersByUuid);
    }

    private static void resolveField3AddMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedMember> fullMembersByUuid, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedMember> newMembersList = conflictingChange.newMembers;
        for (int i = newMembersList.size() - 1; i >= 0; --i) {
            DecryptedMember member = newMembersList.get(i);
            if (fullMembersByUuid.containsKey(member.aciBytes)) {
                result2.removeAddMembers(i);
                continue;
            }
            if (!pendingMembersByServiceId.containsKey(member.aciBytes) && !pendingMembersByServiceId.containsKey(member.pniBytes)) continue;
            result2.moveAddToPromote(i);
        }
    }

    private static void resolveField4DeleteMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedMember> fullMembersByUuid) {
        List<ByteString> deletedMembersList = conflictingChange.deleteMembers;
        for (int i = deletedMembersList.size() - 1; i >= 0; --i) {
            ByteString member = deletedMembersList.get(i);
            if (fullMembersByUuid.containsKey(member)) continue;
            result2.removeDeleteMembers(i);
        }
    }

    private static void resolveField5ModifyMemberRoles(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedMember> fullMembersByUuid) {
        List<DecryptedModifyMemberRole> modifyRolesList = conflictingChange.modifyMemberRoles;
        for (int i = modifyRolesList.size() - 1; i >= 0; --i) {
            DecryptedModifyMemberRole modifyRoleAction = modifyRolesList.get(i);
            DecryptedMember memberInGroup = fullMembersByUuid.get(modifyRoleAction.aciBytes);
            if (memberInGroup != null && memberInGroup.role != modifyRoleAction.role) continue;
            result2.removeModifyMemberRoles(i);
        }
    }

    private static void resolveField6ModifyProfileKeys(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedMember> fullMembersByUuid) {
        List<DecryptedMember> modifyProfileKeysList = conflictingChange.modifiedProfileKeys;
        for (int i = modifyProfileKeysList.size() - 1; i >= 0; --i) {
            DecryptedMember member = modifyProfileKeysList.get(i);
            DecryptedMember memberInGroup = fullMembersByUuid.get(member.aciBytes);
            if (memberInGroup != null && !member.profileKey.equals((Object)memberInGroup.profileKey)) continue;
            result2.removeModifyMemberProfileKeys(i);
        }
    }

    private static void resolveField7AddPendingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedMember> fullMembersByUuid, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedPendingMember> newPendingMembersList = conflictingChange.newPendingMembers;
        for (int i = newPendingMembersList.size() - 1; i >= 0; --i) {
            DecryptedPendingMember member = newPendingMembersList.get(i);
            if (!fullMembersByUuid.containsKey(member.serviceIdBytes) && !pendingMembersByServiceId.containsKey(member.serviceIdBytes)) continue;
            result2.removeAddPendingMembers(i);
        }
    }

    private static void resolveField8DeletePendingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedPendingMemberRemoval> deletePendingMembersList = conflictingChange.deletePendingMembers;
        for (int i = deletePendingMembersList.size() - 1; i >= 0; --i) {
            DecryptedPendingMemberRemoval member = deletePendingMembersList.get(i);
            if (pendingMembersByServiceId.containsKey(member.serviceIdBytes)) continue;
            result2.removeDeletePendingMembers(i);
        }
    }

    private static void resolveField9PromotePendingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedMember> promotePendingMembersList = conflictingChange.promotePendingMembers;
        for (int i = promotePendingMembersList.size() - 1; i >= 0; --i) {
            DecryptedMember member = promotePendingMembersList.get(i);
            if (pendingMembersByServiceId.containsKey(member.aciBytes) || pendingMembersByServiceId.containsKey(member.pniBytes)) continue;
            result2.removePromotePendingMembers(i);
        }
    }

    private static void resolveField10ModifyTitle(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result2) {
        if (conflictingChange.newTitle != null && conflictingChange.newTitle.value_.equals(groupState.title)) {
            result2.clearModifyTitle();
        }
    }

    private static void resolveField11ModifyAvatar(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result2) {
        if (conflictingChange.newAvatar != null && conflictingChange.newAvatar.value_.equals(groupState.avatar)) {
            result2.clearModifyAvatar();
        }
    }

    private static void resolveField12modifyDisappearingMessagesTimer(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result2) {
        if (groupState.disappearingMessagesTimer != null && conflictingChange.newTimer != null && conflictingChange.newTimer.duration == groupState.disappearingMessagesTimer.duration) {
            result2.clearModifyDisappearingMessagesTimer();
        }
    }

    private static void resolveField13modifyAttributesAccess(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result2) {
        if (groupState.accessControl != null && conflictingChange.newAttributeAccess == groupState.accessControl.attributes) {
            result2.clearModifyAttributesAccess();
        }
    }

    private static void resolveField14modifyAttributesAccess(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result2) {
        if (groupState.accessControl != null && conflictingChange.newMemberAccess == groupState.accessControl.members) {
            result2.clearModifyMemberAccess();
        }
    }

    private static void resolveField15modifyAddFromInviteLinkAccess(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result2) {
        if (groupState.accessControl != null && conflictingChange.newInviteLinkAccess == groupState.accessControl.addFromInviteLink) {
            result2.clearModifyAddFromInviteLinkAccess();
        }
    }

    private static void resolveField16AddRequestingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedMember> fullMembersByUuid, HashMap<ByteString, DecryptedPendingMember> pendingMembersByServiceId) {
        List<DecryptedRequestingMember> newMembersList = conflictingChange.newRequestingMembers;
        for (int i = newMembersList.size() - 1; i >= 0; --i) {
            DecryptedRequestingMember member = newMembersList.get(i);
            if (fullMembersByUuid.containsKey(member.aciBytes)) {
                result2.removeAddRequestingMembers(i);
                continue;
            }
            if (!pendingMembersByServiceId.containsKey(member.aciBytes)) continue;
            result2.moveAddRequestingMembersToPromote(i);
        }
    }

    private static void resolveField17DeleteMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedRequestingMember> requestingMembers) {
        List<ByteString> deletedMembersList = conflictingChange.deleteRequestingMembers;
        for (int i = deletedMembersList.size() - 1; i >= 0; --i) {
            ByteString member = deletedMembersList.get(i);
            if (requestingMembers.containsKey(member)) continue;
            result2.removeDeleteRequestingMembers(i);
        }
    }

    private static void resolveField18PromoteRequestingMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedRequestingMember> requestingMembersByUuid) {
        List<DecryptedApproveMember> promoteRequestingMembersList = conflictingChange.promoteRequestingMembers;
        for (int i = promoteRequestingMembersList.size() - 1; i >= 0; --i) {
            DecryptedApproveMember member = promoteRequestingMembersList.get(i);
            if (requestingMembersByUuid.containsKey(member.aciBytes)) continue;
            result2.removePromoteRequestingMembers(i);
        }
    }

    private static void resolveField20ModifyDescription(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result2) {
        if (conflictingChange.newDescription != null && conflictingChange.newDescription.value_.equals(groupState.description)) {
            result2.clearModifyDescription();
        }
    }

    private static void resolveField21ModifyAnnouncementsOnly(DecryptedGroup groupState, DecryptedGroupChange conflictingChange, ChangeSetModifier result2) {
        if (conflictingChange.newIsAnnouncementGroup.equals((Object)groupState.isAnnouncementGroup)) {
            result2.clearModifyAnnouncementsOnly();
        }
    }

    private static void resolveField22AddBannedMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedBannedMember> bannedMembersByServiceId) {
        List<DecryptedBannedMember> newBannedMembersList = conflictingChange.newBannedMembers;
        for (int i = newBannedMembersList.size() - 1; i >= 0; --i) {
            DecryptedBannedMember member = newBannedMembersList.get(i);
            if (!bannedMembersByServiceId.containsKey(member.serviceIdBytes)) continue;
            result2.removeAddBannedMembers(i);
        }
    }

    private static void resolveField23DeleteBannedMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedBannedMember> bannedMembersByServiceId) {
        List<DecryptedBannedMember> deleteBannedMembersList = conflictingChange.deleteBannedMembers;
        for (int i = deleteBannedMembersList.size() - 1; i >= 0; --i) {
            DecryptedBannedMember member = deleteBannedMembersList.get(i);
            if (bannedMembersByServiceId.containsKey(member.serviceIdBytes)) continue;
            result2.removeDeleteBannedMembers(i);
        }
    }

    private static void resolveField24PromotePendingPniAciMembers(DecryptedGroupChange conflictingChange, ChangeSetModifier result2, HashMap<ByteString, DecryptedMember> fullMembersByAci) {
        List<DecryptedMember> promotePendingPniAciMembersList = conflictingChange.promotePendingPniAciMembers;
        for (int i = promotePendingPniAciMembersList.size() - 1; i >= 0; --i) {
            DecryptedMember member = promotePendingPniAciMembersList.get(i);
            if (!fullMembersByAci.containsKey(member.aciBytes)) continue;
            result2.removePromotePendingPniAciMembers(i);
        }
    }

    private static void resolveField26ModifyMemberLabels(@Nonnull DecryptedGroupChange conflictingChange, @Nonnull ChangeSetModifier result2, @Nonnull Map<ByteString, DecryptedMember> fullMembersByAci) {
        List<DecryptedModifyMemberLabel> actions = conflictingChange.modifyMemberLabels;
        for (int i = actions.size() - 1; i >= 0; --i) {
            DecryptedModifyMemberLabel action2 = actions.get(i);
            DecryptedMember member = fullMembersByAci.get(action2.aciBytes);
            if (member != null && (!action2.labelEmoji.equals(member.labelEmoji) || !action2.labelString.equals(member.labelString))) continue;
            result2.removeModifyMemberLabels(i);
        }
    }
}

