/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import okio.ByteString;
import org.signal.storageservice.storage.protos.groups.local.DecryptedApproveMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedBannedMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.storage.protos.groups.local.DecryptedMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedModifyMemberLabel;
import org.signal.storageservice.storage.protos.groups.local.DecryptedModifyMemberRole;
import org.signal.storageservice.storage.protos.groups.local.DecryptedPendingMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedPendingMemberRemoval;
import org.signal.storageservice.storage.protos.groups.local.DecryptedRequestingMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedString;

public final class GroupChangeReconstruct {
    public static DecryptedGroupChange reconstructGroupChange(DecryptedGroup fromState, DecryptedGroup toState) {
        DecryptedGroupChange.Builder builder = new DecryptedGroupChange.Builder().revision(toState.revision);
        if (!fromState.title.equals(toState.title)) {
            builder.newTitle(new DecryptedString.Builder().value_(toState.title).build());
        }
        if (!fromState.description.equals(toState.description)) {
            builder.newDescription(new DecryptedString.Builder().value_(toState.description).build());
        }
        if (!fromState.isAnnouncementGroup.equals((Object)toState.isAnnouncementGroup)) {
            builder.newIsAnnouncementGroup(toState.isAnnouncementGroup);
        }
        if (!fromState.avatar.equals(toState.avatar)) {
            builder.newAvatar(new DecryptedString.Builder().value_(toState.avatar).build());
        }
        if (!Objects.equals((Object)fromState.disappearingMessagesTimer, (Object)toState.disappearingMessagesTimer)) {
            builder.newTimer(toState.disappearingMessagesTimer);
        }
        if ((fromState.accessControl == null || toState.accessControl != null && !fromState.accessControl.attributes.equals((Object)toState.accessControl.attributes)) && toState.accessControl != null) {
            builder.newAttributeAccess(toState.accessControl.attributes);
        }
        if ((fromState.accessControl == null || toState.accessControl != null && !fromState.accessControl.members.equals((Object)toState.accessControl.members)) && toState.accessControl != null) {
            builder.newMemberAccess(toState.accessControl.members);
        }
        Set<ByteString> fromStateMemberAcis = GroupChangeReconstruct.membersToSetOfAcis(fromState.members);
        Set<ByteString> toStateMemberAcis = GroupChangeReconstruct.membersToSetOfAcis(toState.members);
        Set<ByteString> pendingMembersListA = GroupChangeReconstruct.pendingMembersToSetOfServiceIds(fromState.pendingMembers);
        Set<ByteString> pendingMembersListB = GroupChangeReconstruct.pendingMembersToSetOfServiceIds(toState.pendingMembers);
        Set<ByteString> requestingMembersListA = GroupChangeReconstruct.requestingMembersToSetOfAcis(fromState.requestingMembers);
        Set<ByteString> requestingMembersListB = GroupChangeReconstruct.requestingMembersToSetOfAcis(toState.requestingMembers);
        Set<ByteString> bannedMembersListA = GroupChangeReconstruct.bannedMembersToSetOfServiceIds(fromState.bannedMembers);
        Set<ByteString> bannedMembersListB = GroupChangeReconstruct.bannedMembersToSetOfServiceIds(toState.bannedMembers);
        Set<ByteString> removedPendingMemberServiceIds = GroupChangeReconstruct.subtract(pendingMembersListA, pendingMembersListB);
        Set<ByteString> removedRequestingMemberAcis = GroupChangeReconstruct.subtract(requestingMembersListA, requestingMembersListB);
        Set<ByteString> newPendingMemberServiceIds = GroupChangeReconstruct.subtract(pendingMembersListB, pendingMembersListA);
        Set<ByteString> newRequestingMemberAcis = GroupChangeReconstruct.subtract(requestingMembersListB, requestingMembersListA);
        Set<ByteString> removedMemberAcis = GroupChangeReconstruct.subtract(fromStateMemberAcis, toStateMemberAcis);
        Set<ByteString> newMemberAcis = GroupChangeReconstruct.subtract(toStateMemberAcis, fromStateMemberAcis);
        Set<ByteString> removedBannedMemberServiceIds = GroupChangeReconstruct.subtract(bannedMembersListA, bannedMembersListB);
        Set<ByteString> newBannedMemberServiceIds = GroupChangeReconstruct.subtract(bannedMembersListB, bannedMembersListA);
        Set<ByteString> addedByInvitationAcis = GroupChangeReconstruct.intersect(newMemberAcis, removedPendingMemberServiceIds);
        Set<ByteString> addedByRequestApprovalAcis = GroupChangeReconstruct.intersect(newMemberAcis, removedRequestingMemberAcis);
        Set<DecryptedMember> addedMembersByInvitation = GroupChangeReconstruct.intersectByAci(toState.members, addedByInvitationAcis);
        Set<DecryptedMember> addedMembersByRequestApproval = GroupChangeReconstruct.intersectByAci(toState.members, addedByRequestApprovalAcis);
        Set<DecryptedMember> addedMembers = GroupChangeReconstruct.intersectByAci(toState.members, GroupChangeReconstruct.subtract(newMemberAcis, addedByInvitationAcis, addedByRequestApprovalAcis));
        Set<DecryptedPendingMember> uninvitedMembers = GroupChangeReconstruct.intersectPendingByServiceId(fromState.pendingMembers, GroupChangeReconstruct.subtract(removedPendingMemberServiceIds, addedByInvitationAcis));
        Set<DecryptedRequestingMember> rejectedRequestMembers = GroupChangeReconstruct.intersectRequestingByAci(fromState.requestingMembers, GroupChangeReconstruct.subtract(removedRequestingMemberAcis, addedByRequestApprovalAcis));
        builder.deleteMembers(GroupChangeReconstruct.intersectByAci(fromState.members, removedMemberAcis).stream().map(m -> m.aciBytes).collect(Collectors.toList()));
        builder.newMembers(new ArrayList<DecryptedMember>(addedMembers));
        builder.promotePendingMembers(new ArrayList<DecryptedMember>(addedMembersByInvitation));
        builder.deletePendingMembers(uninvitedMembers.stream().map(uninvitedMember -> new DecryptedPendingMemberRemoval.Builder().serviceIdBytes(uninvitedMember.serviceIdBytes).serviceIdCipherText(uninvitedMember.serviceIdCipherText).build()).collect(Collectors.toList()));
        builder.newPendingMembers(new ArrayList<DecryptedPendingMember>(GroupChangeReconstruct.intersectPendingByServiceId(toState.pendingMembers, newPendingMemberServiceIds)));
        Set<ByteString> consistentMemberAcis = GroupChangeReconstruct.intersect(fromStateMemberAcis, toStateMemberAcis);
        Set<DecryptedMember> changedMembers = GroupChangeReconstruct.intersectByAci(GroupChangeReconstruct.subtract(toState.members, fromState.members), consistentMemberAcis);
        Map<ByteString, DecryptedMember> membersAciMap = GroupChangeReconstruct.mapByAci(fromState.members);
        Map<ByteString, DecryptedBannedMember> bannedMembersServiceIdMap = GroupChangeReconstruct.bannedServiceIdMap(toState.bannedMembers);
        ArrayList<DecryptedModifyMemberRole> modifiedMemberRoles = new ArrayList<DecryptedModifyMemberRole>(changedMembers.size());
        ArrayList<DecryptedMember> modifiedProfileKeys = new ArrayList<DecryptedMember>(changedMembers.size());
        ArrayList<DecryptedModifyMemberLabel> modifiedMemberLabels = new ArrayList<DecryptedModifyMemberLabel>(changedMembers.size());
        for (DecryptedMember newState : changedMembers) {
            DecryptedMember oldState = membersAciMap.get(newState.aciBytes);
            if (oldState.role != newState.role) {
                modifiedMemberRoles.add(new DecryptedModifyMemberRole.Builder().aciBytes(newState.aciBytes).role(newState.role).build());
            }
            if (!oldState.profileKey.equals((Object)newState.profileKey)) {
                modifiedProfileKeys.add(newState);
            }
            if (oldState.labelEmoji.equals(newState.labelEmoji) && oldState.labelString.equals(newState.labelString)) continue;
            modifiedMemberLabels.add(new DecryptedModifyMemberLabel.Builder().aciBytes(newState.aciBytes).labelEmoji(newState.labelEmoji).labelString(newState.labelString).build());
        }
        builder.modifyMemberRoles(modifiedMemberRoles);
        builder.modifiedProfileKeys(modifiedProfileKeys);
        builder.modifyMemberLabels(modifiedMemberLabels);
        if ((fromState.accessControl == null || toState.accessControl != null && !fromState.accessControl.addFromInviteLink.equals((Object)toState.accessControl.addFromInviteLink)) && toState.accessControl != null) {
            builder.newInviteLinkAccess(toState.accessControl.addFromInviteLink);
        }
        builder.newRequestingMembers(new ArrayList<DecryptedRequestingMember>(GroupChangeReconstruct.intersectRequestingByAci(toState.requestingMembers, newRequestingMemberAcis)));
        builder.deleteRequestingMembers(rejectedRequestMembers.stream().map(requestingMember -> requestingMember.aciBytes).collect(Collectors.toList()));
        builder.promoteRequestingMembers(addedMembersByRequestApproval.stream().map(member -> new DecryptedApproveMember.Builder().aciBytes(member.aciBytes).role(member.role).build()).collect(Collectors.toList()));
        if (!fromState.inviteLinkPassword.equals((Object)toState.inviteLinkPassword)) {
            builder.newInviteLinkPassword(toState.inviteLinkPassword);
        }
        builder.deleteBannedMembers(removedBannedMemberServiceIds.stream().map(serviceIdBinary -> new DecryptedBannedMember.Builder().serviceIdBytes((ByteString)serviceIdBinary).build()).collect(Collectors.toList()));
        builder.newBannedMembers(newBannedMemberServiceIds.stream().map(serviceIdBinary -> {
            DecryptedBannedMember.Builder newBannedBuilder = new DecryptedBannedMember.Builder().serviceIdBytes((ByteString)serviceIdBinary);
            DecryptedBannedMember bannedMember = (DecryptedBannedMember)((Object)((Object)bannedMembersServiceIdMap.get(serviceIdBinary)));
            if (bannedMember != null) {
                newBannedBuilder.timestamp(bannedMember.timestamp);
            }
            return newBannedBuilder.build();
        }).collect(Collectors.toList()));
        return builder.build();
    }

    private static Map<ByteString, DecryptedMember> mapByAci(List<DecryptedMember> membersList) {
        LinkedHashMap<ByteString, DecryptedMember> map = new LinkedHashMap<ByteString, DecryptedMember>(membersList.size());
        for (DecryptedMember member : membersList) {
            map.put(member.aciBytes, member);
        }
        return map;
    }

    private static Map<ByteString, DecryptedBannedMember> bannedServiceIdMap(List<DecryptedBannedMember> membersList) {
        LinkedHashMap<ByteString, DecryptedBannedMember> map = new LinkedHashMap<ByteString, DecryptedBannedMember>(membersList.size());
        for (DecryptedBannedMember member : membersList) {
            map.put(member.serviceIdBytes, member);
        }
        return map;
    }

    private static Set<DecryptedMember> intersectByAci(Collection<DecryptedMember> members, Set<ByteString> acis) {
        LinkedHashSet<DecryptedMember> result2 = new LinkedHashSet<DecryptedMember>(members.size());
        for (DecryptedMember member : members) {
            if (!acis.contains(member.aciBytes)) continue;
            result2.add(member);
        }
        return result2;
    }

    private static Set<DecryptedPendingMember> intersectPendingByServiceId(Collection<DecryptedPendingMember> members, Set<ByteString> serviceIds) {
        LinkedHashSet<DecryptedPendingMember> result2 = new LinkedHashSet<DecryptedPendingMember>(members.size());
        for (DecryptedPendingMember member : members) {
            if (!serviceIds.contains(member.serviceIdBytes)) continue;
            result2.add(member);
        }
        return result2;
    }

    private static Set<DecryptedRequestingMember> intersectRequestingByAci(Collection<DecryptedRequestingMember> members, Set<ByteString> acis) {
        LinkedHashSet<DecryptedRequestingMember> result2 = new LinkedHashSet<DecryptedRequestingMember>(members.size());
        for (DecryptedRequestingMember member : members) {
            if (!acis.contains(member.aciBytes)) continue;
            result2.add(member);
        }
        return result2;
    }

    private static Set<ByteString> pendingMembersToSetOfServiceIds(Collection<DecryptedPendingMember> pendingMembers) {
        LinkedHashSet<ByteString> serviceIds = new LinkedHashSet<ByteString>(pendingMembers.size());
        for (DecryptedPendingMember pendingMember : pendingMembers) {
            serviceIds.add(pendingMember.serviceIdBytes);
        }
        return serviceIds;
    }

    private static Set<ByteString> requestingMembersToSetOfAcis(Collection<DecryptedRequestingMember> requestingMembers) {
        LinkedHashSet<ByteString> acis = new LinkedHashSet<ByteString>(requestingMembers.size());
        for (DecryptedRequestingMember requestingMember : requestingMembers) {
            acis.add(requestingMember.aciBytes);
        }
        return acis;
    }

    private static Set<ByteString> membersToSetOfAcis(Collection<DecryptedMember> members) {
        LinkedHashSet<ByteString> acis = new LinkedHashSet<ByteString>(members.size());
        for (DecryptedMember member : members) {
            acis.add(member.aciBytes);
        }
        return acis;
    }

    private static Set<ByteString> bannedMembersToSetOfServiceIds(Collection<DecryptedBannedMember> bannedMembers) {
        LinkedHashSet<ByteString> serviceIds = new LinkedHashSet<ByteString>(bannedMembers.size());
        for (DecryptedBannedMember bannedMember : bannedMembers) {
            serviceIds.add(bannedMember.serviceIdBytes);
        }
        return serviceIds;
    }

    private static <T> Set<T> subtract(Collection<T> a, Collection<T> b) {
        LinkedHashSet<T> result2 = new LinkedHashSet<T>(a);
        result2.removeAll(b);
        return result2;
    }

    private static <T> Set<T> subtract(Collection<T> a, Collection<T> b, Collection<T> c) {
        LinkedHashSet<T> result2 = new LinkedHashSet<T>(a);
        result2.removeAll(b);
        result2.removeAll(c);
        return result2;
    }

    private static <T> Set<T> intersect(Collection<T> a, Collection<T> b) {
        LinkedHashSet<T> result2 = new LinkedHashSet<T>(a);
        result2.retainAll(b);
        return result2;
    }
}

