/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import okio.ByteString;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.storageservice.storage.protos.groups.AccessControl;
import org.signal.storageservice.storage.protos.groups.Member;
import org.signal.storageservice.storage.protos.groups.local.DecryptedApproveMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedBannedMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.storage.protos.groups.local.DecryptedMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedModifyMemberRole;
import org.signal.storageservice.storage.protos.groups.local.DecryptedPendingMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedPendingMemberRemoval;
import org.signal.storageservice.storage.protos.groups.local.DecryptedRequestingMember;
import org.signal.storageservice.storage.protos.groups.local.EnabledState;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupExtensions;
import org.whispersystems.signalservice.api.groupsv2.NotAbleToApplyGroupV2ChangeException;
import org.whispersystems.signalservice.api.push.ServiceIds;

public final class DecryptedGroupUtil {
    private static final String TAG = DecryptedGroupUtil.class.getSimpleName();

    public static ArrayList<ServiceId.ACI> toAciListWithUnknowns(Collection<DecryptedMember> membersList) {
        ArrayList<ServiceId.ACI> serviceIdList = new ArrayList<ServiceId.ACI>(membersList.size());
        for (DecryptedMember member : membersList) {
            serviceIdList.add(ServiceId.ACI.parseOrUnknown((ByteString)member.aciBytes));
        }
        return serviceIdList;
    }

    public static ArrayList<ServiceId.ACI> toAciList(Collection<DecryptedMember> membersList) {
        ArrayList<ServiceId.ACI> serviceIdList = new ArrayList<ServiceId.ACI>(membersList.size());
        for (DecryptedMember member : membersList) {
            ServiceId.ACI aci = ServiceId.ACI.parseOrNull((ByteString)member.aciBytes);
            if (aci == null) continue;
            serviceIdList.add(aci);
        }
        return serviceIdList;
    }

    public static Set<ByteString> membersToAciByteStringSet(Collection<DecryptedMember> membersList) {
        HashSet<ByteString> aciList = new HashSet<ByteString>(membersList.size());
        for (DecryptedMember member : membersList) {
            aciList.add(member.aciBytes);
        }
        return aciList;
    }

    public static ArrayList<ServiceId> pendingToServiceIdList(Collection<DecryptedPendingMember> membersList) {
        ArrayList<ServiceId> serviceIdList = new ArrayList<ServiceId>(membersList.size());
        for (DecryptedPendingMember member : membersList) {
            ServiceId serviceId = ServiceId.parseOrNull((ByteString)member.serviceIdBytes);
            if (serviceId != null) {
                serviceIdList.add(serviceId);
                continue;
            }
            serviceIdList.add((ServiceId)ServiceId.ACI.UNKNOWN);
        }
        return serviceIdList;
    }

    public static ArrayList<ServiceId> removedMembersServiceIdList(DecryptedGroupChange groupChange) {
        List<ByteString> deletedMembers = groupChange.deleteMembers;
        ArrayList<ServiceId> serviceIdList = new ArrayList<ServiceId>(deletedMembers.size());
        for (ByteString member : deletedMembers) {
            ServiceId serviceId = ServiceId.parseOrNull((ByteString)member);
            if (serviceId == null) continue;
            serviceIdList.add(serviceId);
        }
        return serviceIdList;
    }

    public static ArrayList<ServiceId> removedPendingMembersServiceIdList(DecryptedGroupChange groupChange) {
        List<DecryptedPendingMemberRemoval> deletedPendingMembers = groupChange.deletePendingMembers;
        ArrayList<ServiceId> serviceIdList = new ArrayList<ServiceId>(deletedPendingMembers.size());
        for (DecryptedPendingMemberRemoval member : deletedPendingMembers) {
            ServiceId serviceId = ServiceId.parseOrNull((ByteString)member.serviceIdBytes);
            if (serviceId == null) continue;
            serviceIdList.add(serviceId);
        }
        return serviceIdList;
    }

    public static ArrayList<ServiceId> removedRequestingMembersServiceIdList(DecryptedGroupChange groupChange) {
        List<ByteString> deleteRequestingMembers = groupChange.deleteRequestingMembers;
        ArrayList<ServiceId> serviceIdList = new ArrayList<ServiceId>(deleteRequestingMembers.size());
        for (ByteString member : deleteRequestingMembers) {
            ServiceId serviceId = ServiceId.parseOrNull((ByteString)member);
            if (serviceId == null) continue;
            serviceIdList.add(serviceId);
        }
        return serviceIdList;
    }

    public static Set<ServiceId> bannedMembersToServiceIdSet(Collection<DecryptedBannedMember> membersList) {
        HashSet<ServiceId> serviceIdSet = new HashSet<ServiceId>(membersList.size());
        for (DecryptedBannedMember member : membersList) {
            ServiceId serviceId = ServiceId.parseOrNull((ByteString)member.serviceIdBytes);
            if (serviceId == null) continue;
            serviceIdSet.add(serviceId);
        }
        return serviceIdSet;
    }

    public static Optional<ServiceId> editorServiceId(DecryptedGroupChange change) {
        return Optional.ofNullable(change != null ? ServiceId.parseOrNull((ByteString)change.editorServiceIdBytes) : null);
    }

    public static Optional<DecryptedMember> findMemberByAci(@Nonnull Collection<DecryptedMember> members, @Nonnull ServiceId.ACI aci) {
        ByteString aciBytes = aci.toByteString();
        for (DecryptedMember member : members) {
            if (!aciBytes.equals((Object)member.aciBytes)) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    public static Optional<DecryptedPendingMember> findPendingByServiceId(Collection<DecryptedPendingMember> members, ServiceId serviceId) {
        ByteString serviceIdBinary = serviceId.toByteString();
        for (DecryptedPendingMember member : members) {
            if (!serviceIdBinary.equals((Object)member.serviceIdBytes)) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    public static Optional<DecryptedPendingMember> findPendingByServiceIds(Collection<DecryptedPendingMember> members, ServiceIds serviceIds) {
        for (DecryptedPendingMember member : members) {
            if (!serviceIds.matches(member.serviceIdBytes)) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    private static int findPendingIndexByServiceIdCipherText(List<DecryptedPendingMember> members, ByteString cipherText) {
        for (int i = 0; i < members.size(); ++i) {
            DecryptedPendingMember member = members.get(i);
            if (!cipherText.equals((Object)member.serviceIdCipherText)) continue;
            return i;
        }
        return -1;
    }

    private static int findPendingIndexByServiceId(List<DecryptedPendingMember> members, ByteString serviceIdBinary) {
        for (int i = 0; i < members.size(); ++i) {
            DecryptedPendingMember member = members.get(i);
            if (!serviceIdBinary.equals((Object)member.serviceIdBytes)) continue;
            return i;
        }
        return -1;
    }

    public static Optional<DecryptedRequestingMember> findRequestingByAci(Collection<DecryptedRequestingMember> members, ServiceId.ACI aci) {
        ByteString aciBytes = aci.toByteString();
        for (DecryptedRequestingMember member : members) {
            if (!aciBytes.equals((Object)member.aciBytes)) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    public static Optional<DecryptedRequestingMember> findRequestingByServiceIds(Collection<DecryptedRequestingMember> members, ServiceIds serviceIds) {
        for (DecryptedRequestingMember member : members) {
            if (!serviceIds.matches(member.aciBytes)) continue;
            return Optional.of(member);
        }
        return Optional.empty();
    }

    public static boolean isPendingOrRequesting(DecryptedGroup group, ServiceIds serviceIds) {
        return DecryptedGroupUtil.findPendingByServiceIds(group.pendingMembers, serviceIds).isPresent() || DecryptedGroupUtil.findRequestingByServiceIds(group.requestingMembers, serviceIds).isPresent();
    }

    public static boolean isRequesting(DecryptedGroup group, ServiceId.ACI aci) {
        return DecryptedGroupUtil.findRequestingByAci(group.requestingMembers, aci).isPresent();
    }

    public static DecryptedGroup removeMember(DecryptedGroup group, ServiceId.ACI aci, int revision) {
        DecryptedGroup.Builder builder = group.newBuilder();
        ByteString aciByteString = aci.toByteString();
        boolean removed = false;
        ArrayList<DecryptedMember> decryptedMembers = new ArrayList<DecryptedMember>(builder.members);
        Iterator<DecryptedMember> membersList = decryptedMembers.iterator();
        while (membersList.hasNext()) {
            if (!aciByteString.equals((Object)membersList.next().aciBytes)) continue;
            membersList.remove();
            removed = true;
        }
        if (removed) {
            return builder.members(decryptedMembers).revision(revision).build();
        }
        return group;
    }

    public static DecryptedGroup apply(DecryptedGroup group, DecryptedGroupChange change) throws NotAbleToApplyGroupV2ChangeException {
        if (change.revision != group.revision + 1) {
            throw new NotAbleToApplyGroupV2ChangeException();
        }
        return DecryptedGroupUtil.applyWithoutRevisionCheck(group, change);
    }

    public static DecryptedGroup applyWithoutRevisionCheck(DecryptedGroup group, DecryptedGroupChange change) throws NotAbleToApplyGroupV2ChangeException {
        DecryptedGroup.Builder builder = group.newBuilder().revision(change.revision);
        DecryptedGroupUtil.applyAddMemberAction(builder, change.newMembers);
        DecryptedGroupUtil.applyDeleteMemberActions(builder, change.deleteMembers);
        DecryptedGroupUtil.applyModifyMemberRoleActions(builder, change.modifyMemberRoles);
        DecryptedGroupUtil.applyModifyMemberProfileKeyActions(builder, change.modifiedProfileKeys);
        DecryptedGroupUtil.applyAddMemberPendingProfileKeyActions(builder, change.newPendingMembers);
        DecryptedGroupUtil.applyDeleteMemberPendingProfileKeyActions(builder, change.deletePendingMembers);
        DecryptedGroupUtil.applyPromoteMemberPendingProfileKeyActions(builder, change.promotePendingMembers);
        DecryptedGroupUtil.applyModifyTitleAction(builder, change);
        DecryptedGroupUtil.applyModifyDescriptionAction(builder, change);
        DecryptedGroupUtil.applyModifyIsAnnouncementGroupAction(builder, change);
        DecryptedGroupUtil.applyModifyAvatarAction(builder, change);
        DecryptedGroupUtil.applyModifyDisappearingMessagesTimerAction(builder, change);
        DecryptedGroupUtil.applyModifyAttributesAccessControlAction(builder, change);
        DecryptedGroupUtil.applyModifyMembersAccessControlAction(builder, change);
        DecryptedGroupUtil.applyModifyAddFromInviteLinkAccessControlAction(builder, change);
        DecryptedGroupUtil.applyAddRequestingMembers(builder, change.newRequestingMembers);
        DecryptedGroupUtil.applyDeleteRequestingMembers(builder, change.deleteRequestingMembers);
        DecryptedGroupUtil.applyPromoteMemberPendingAdminApprovalActions(builder, change.promoteRequestingMembers);
        DecryptedGroupUtil.applyInviteLinkPassword(builder, change);
        DecryptedGroupUtil.applyAddBannedMembersActions(builder, change.newBannedMembers);
        DecryptedGroupUtil.applyDeleteBannedMembersActions(builder, change.deleteBannedMembers);
        DecryptedGroupUtil.applyPromotePendingPniAciMemberActions(builder, change.promotePendingPniAciMembers);
        DecryptedGroupExtensions.setModifyMemberLabelActions(builder, change.modifyMemberLabels);
        return builder.build();
    }

    private static void applyAddMemberAction(DecryptedGroup.Builder builder, List<DecryptedMember> newMembersList) {
        if (newMembersList.isEmpty()) {
            return;
        }
        LinkedHashMap<ByteString, DecryptedMember> members = new LinkedHashMap<ByteString, DecryptedMember>();
        for (DecryptedMember member : builder.members) {
            members.put(member.aciBytes, member);
        }
        for (DecryptedMember member : newMembersList) {
            members.put(member.aciBytes, member);
        }
        builder.members(new ArrayList<DecryptedMember>(members.values()));
        DecryptedGroupUtil.removePendingAndRequestingMembersNowInGroup(builder);
    }

    private static void applyDeleteMemberActions(DecryptedGroup.Builder builder, List<ByteString> deleteMembersList) {
        ArrayList<DecryptedMember> members = new ArrayList<DecryptedMember>(builder.members);
        for (ByteString removedMember : deleteMembersList) {
            int index = DecryptedGroupUtil.indexOfAci(members, removedMember);
            if (index == -1) {
                Log.w((String)TAG, (String)"Deleted member on change not found in group");
                continue;
            }
            members.remove(index);
        }
        builder.members(members);
    }

    private static void applyModifyMemberRoleActions(DecryptedGroup.Builder builder, List<DecryptedModifyMemberRole> modifyMemberRolesList) throws NotAbleToApplyGroupV2ChangeException {
        ArrayList<DecryptedMember> members = new ArrayList<DecryptedMember>(builder.members);
        for (DecryptedModifyMemberRole modifyMemberRole : modifyMemberRolesList) {
            int index = DecryptedGroupUtil.indexOfAci(members, modifyMemberRole.aciBytes);
            if (index == -1) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            Member.Role role = modifyMemberRole.role;
            DecryptedGroupUtil.ensureKnownRole(role);
            members.set(index, ((DecryptedMember)((Object)members.get(index))).newBuilder().role(role).build());
        }
        builder.members(members);
    }

    private static void applyModifyMemberProfileKeyActions(DecryptedGroup.Builder builder, List<DecryptedMember> modifiedProfileKeysList) throws NotAbleToApplyGroupV2ChangeException {
        ArrayList<DecryptedMember> members = new ArrayList<DecryptedMember>(builder.members);
        for (DecryptedMember modifyProfileKey : modifiedProfileKeysList) {
            int index = DecryptedGroupUtil.indexOfAci(members, modifyProfileKey.aciBytes);
            if (index == -1) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            members.set(index, DecryptedGroupUtil.withNewProfileKey((DecryptedMember)((Object)members.get(index)), modifyProfileKey.profileKey));
        }
        builder.members(members);
    }

    private static void applyAddMemberPendingProfileKeyActions(DecryptedGroup.Builder builder, List<DecryptedPendingMember> newPendingMembersList) throws NotAbleToApplyGroupV2ChangeException {
        Set<ByteString> fullMemberSet = DecryptedGroupUtil.getMemberAciSet(builder.members);
        Set<ByteString> pendingMemberCipherTexts = DecryptedGroupUtil.getPendingMemberCipherTextSet(builder.pendingMembers);
        ArrayList<DecryptedPendingMember> pendingMembers = new ArrayList<DecryptedPendingMember>(builder.pendingMembers);
        for (DecryptedPendingMember pendingMember : newPendingMembersList) {
            if (fullMemberSet.contains(pendingMember.serviceIdBytes)) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            if (pendingMemberCipherTexts.contains(pendingMember.serviceIdCipherText)) continue;
            pendingMembers.add(pendingMember);
        }
        builder.pendingMembers(pendingMembers);
    }

    private static void applyDeleteMemberPendingProfileKeyActions(DecryptedGroup.Builder builder, List<DecryptedPendingMemberRemoval> deletePendingMembersList) {
        ArrayList<DecryptedPendingMember> pendingMembers = new ArrayList<DecryptedPendingMember>(builder.pendingMembers);
        for (DecryptedPendingMemberRemoval removedMember : deletePendingMembersList) {
            int index = DecryptedGroupUtil.findPendingIndexByServiceIdCipherText(pendingMembers, removedMember.serviceIdCipherText);
            if (index == -1) {
                Log.w((String)TAG, (String)"Deleted pending member on change not found in group");
                continue;
            }
            pendingMembers.remove(index);
        }
        builder.pendingMembers(pendingMembers);
    }

    private static void applyPromoteMemberPendingProfileKeyActions(DecryptedGroup.Builder builder, List<DecryptedMember> promotePendingMembersList) throws NotAbleToApplyGroupV2ChangeException {
        ArrayList<DecryptedMember> members = new ArrayList<DecryptedMember>(builder.members);
        ArrayList<DecryptedPendingMember> pendingMembers = new ArrayList<DecryptedPendingMember>(builder.pendingMembers);
        for (DecryptedMember newMember : promotePendingMembersList) {
            int index = DecryptedGroupUtil.findPendingIndexByServiceId(pendingMembers, newMember.aciBytes);
            if (index == -1) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            pendingMembers.remove(index);
            members.add(newMember);
        }
        builder.pendingMembers(pendingMembers);
        builder.members(members);
    }

    private static void applyModifyTitleAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.newTitle != null) {
            builder.title(change.newTitle.value_);
        }
    }

    private static void applyModifyDescriptionAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.newDescription != null) {
            builder.description(change.newDescription.value_);
        }
    }

    private static void applyModifyIsAnnouncementGroupAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.newIsAnnouncementGroup != EnabledState.UNKNOWN) {
            builder.isAnnouncementGroup(change.newIsAnnouncementGroup);
        }
    }

    private static void applyModifyAvatarAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.newAvatar != null) {
            builder.avatar(change.newAvatar.value_);
        }
    }

    private static void applyModifyDisappearingMessagesTimerAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.newTimer != null) {
            builder.disappearingMessagesTimer(change.newTimer);
        }
    }

    private static void applyModifyAttributesAccessControlAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        AccessControl.AccessRequired newAccessLevel = change.newAttributeAccess;
        if (newAccessLevel != AccessControl.AccessRequired.UNKNOWN) {
            AccessControl.Builder accessControlBuilder = builder.accessControl != null ? builder.accessControl.newBuilder() : new AccessControl.Builder();
            builder.accessControl(accessControlBuilder.attributes(change.newAttributeAccess).build());
        }
    }

    private static void applyModifyMembersAccessControlAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        AccessControl.AccessRequired newAccessLevel = change.newMemberAccess;
        if (newAccessLevel != AccessControl.AccessRequired.UNKNOWN) {
            AccessControl.Builder accessControlBuilder = builder.accessControl != null ? builder.accessControl.newBuilder() : new AccessControl.Builder();
            builder.accessControl(accessControlBuilder.members(change.newMemberAccess).build());
        }
    }

    private static void applyModifyAddFromInviteLinkAccessControlAction(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        AccessControl.AccessRequired newAccessLevel = change.newInviteLinkAccess;
        if (newAccessLevel != AccessControl.AccessRequired.UNKNOWN) {
            AccessControl.Builder accessControlBuilder = builder.accessControl != null ? builder.accessControl.newBuilder() : new AccessControl.Builder();
            builder.accessControl(accessControlBuilder.addFromInviteLink(newAccessLevel).build());
        }
    }

    private static void applyAddRequestingMembers(DecryptedGroup.Builder builder, List<DecryptedRequestingMember> newRequestingMembers) {
        ArrayList<DecryptedRequestingMember> requestingMembers = new ArrayList<DecryptedRequestingMember>(builder.requestingMembers);
        requestingMembers.addAll(newRequestingMembers);
        builder.requestingMembers(requestingMembers);
    }

    private static void applyDeleteRequestingMembers(DecryptedGroup.Builder builder, List<ByteString> deleteRequestingMembersList) {
        ArrayList<DecryptedRequestingMember> requestingMembers = new ArrayList<DecryptedRequestingMember>(builder.requestingMembers);
        for (ByteString removedMember : deleteRequestingMembersList) {
            int index = DecryptedGroupUtil.indexOfAciInRequestingList(requestingMembers, removedMember);
            if (index == -1) {
                Log.w((String)TAG, (String)"Deleted requesting member on change not found in group");
                continue;
            }
            requestingMembers.remove(index);
        }
        builder.requestingMembers(requestingMembers);
    }

    private static void applyPromoteMemberPendingAdminApprovalActions(DecryptedGroup.Builder builder, List<DecryptedApproveMember> promoteRequestingMembers) throws NotAbleToApplyGroupV2ChangeException {
        ArrayList<DecryptedMember> members = new ArrayList<DecryptedMember>(builder.members);
        ArrayList<DecryptedRequestingMember> requestingMembers = new ArrayList<DecryptedRequestingMember>(builder.requestingMembers);
        for (DecryptedApproveMember approvedMember : promoteRequestingMembers) {
            int index = DecryptedGroupUtil.indexOfAciInRequestingList(requestingMembers, approvedMember.aciBytes);
            if (index == -1) {
                Log.w((String)TAG, (String)"Promote member on change not found in group");
                continue;
            }
            DecryptedRequestingMember requestingMember = (DecryptedRequestingMember)((Object)requestingMembers.get(index));
            Member.Role role = approvedMember.role;
            DecryptedGroupUtil.ensureKnownRole(role);
            requestingMembers.remove(index);
            members.add(new DecryptedMember.Builder().aciBytes(approvedMember.aciBytes).profileKey(requestingMember.profileKey).role(role).build());
        }
        builder.members(members);
        builder.requestingMembers(requestingMembers);
    }

    private static void applyInviteLinkPassword(DecryptedGroup.Builder builder, DecryptedGroupChange change) {
        if (change.newInviteLinkPassword.size() > 0) {
            builder.inviteLinkPassword(change.newInviteLinkPassword);
        }
    }

    private static void applyAddBannedMembersActions(DecryptedGroup.Builder builder, List<DecryptedBannedMember> newBannedMembersList) {
        Set<ByteString> bannedMemberServiceIdSet = DecryptedGroupUtil.getBannedMemberServiceIdSet(builder.bannedMembers);
        ArrayList<DecryptedBannedMember> bannedMembers = new ArrayList<DecryptedBannedMember>(builder.bannedMembers);
        for (DecryptedBannedMember member : newBannedMembersList) {
            if (bannedMemberServiceIdSet.contains(member.serviceIdBytes)) {
                Log.w((String)TAG, (String)"Banned member already in banned list");
                continue;
            }
            bannedMembers.add(member);
        }
        builder.bannedMembers(bannedMembers);
    }

    private static void applyDeleteBannedMembersActions(DecryptedGroup.Builder builder, List<DecryptedBannedMember> deleteMembersList) {
        ArrayList<DecryptedBannedMember> bannedMembers = new ArrayList<DecryptedBannedMember>(builder.bannedMembers);
        for (DecryptedBannedMember removedMember : deleteMembersList) {
            int index = DecryptedGroupUtil.indexOfServiceIdInBannedMemberList(bannedMembers, removedMember.serviceIdBytes);
            if (index == -1) {
                Log.w((String)TAG, (String)"Deleted banned member on change not found in banned list");
                continue;
            }
            bannedMembers.remove(index);
        }
        builder.bannedMembers(bannedMembers);
    }

    private static void applyPromotePendingPniAciMemberActions(DecryptedGroup.Builder builder, List<DecryptedMember> promotePendingPniAciMembersList) throws NotAbleToApplyGroupV2ChangeException {
        ArrayList<DecryptedMember> members = new ArrayList<DecryptedMember>(builder.members);
        ArrayList<DecryptedPendingMember> pendingMembers = new ArrayList<DecryptedPendingMember>(builder.pendingMembers);
        for (DecryptedMember newMember : promotePendingPniAciMembersList) {
            int index = DecryptedGroupUtil.findPendingIndexByServiceId(pendingMembers, newMember.pniBytes);
            if (index == -1) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            pendingMembers.remove(index);
            members.add(newMember);
        }
        builder.members(members);
        builder.pendingMembers(pendingMembers);
    }

    private static DecryptedMember withNewProfileKey(DecryptedMember member, ByteString profileKey) {
        return member.newBuilder().profileKey(profileKey).build();
    }

    private static Set<ByteString> getMemberAciSet(List<DecryptedMember> membersList) {
        HashSet<ByteString> memberAcis = new HashSet<ByteString>(membersList.size());
        for (DecryptedMember members : membersList) {
            memberAcis.add(members.aciBytes);
        }
        return memberAcis;
    }

    private static Set<ByteString> getPendingMemberCipherTextSet(List<DecryptedPendingMember> pendingMemberList) {
        HashSet<ByteString> pendingMemberCipherTexts = new HashSet<ByteString>(pendingMemberList.size());
        for (DecryptedPendingMember pendingMember : pendingMemberList) {
            pendingMemberCipherTexts.add(pendingMember.serviceIdCipherText);
        }
        return pendingMemberCipherTexts;
    }

    private static Set<ByteString> getBannedMemberServiceIdSet(List<DecryptedBannedMember> bannedMemberList) {
        HashSet<ByteString> memberServiceIds = new HashSet<ByteString>(bannedMemberList.size());
        for (DecryptedBannedMember member : bannedMemberList) {
            memberServiceIds.add(member.serviceIdBytes);
        }
        return memberServiceIds;
    }

    private static void removePendingAndRequestingMembersNowInGroup(DecryptedGroup.Builder builder) {
        Set<ByteString> allMembers = DecryptedGroupUtil.membersToAciByteStringSet(builder.members);
        ArrayList<DecryptedPendingMember> pendingMembers = new ArrayList<DecryptedPendingMember>(builder.pendingMembers);
        for (int i = pendingMembers.size() - 1; i >= 0; --i) {
            DecryptedPendingMember pendingMember = (DecryptedPendingMember)((Object)pendingMembers.get(i));
            if (!allMembers.contains(pendingMember.serviceIdBytes)) continue;
            pendingMembers.remove(i);
        }
        builder.pendingMembers(pendingMembers);
        ArrayList<DecryptedRequestingMember> requestingMembers = new ArrayList<DecryptedRequestingMember>(builder.requestingMembers);
        for (int i = requestingMembers.size() - 1; i >= 0; --i) {
            DecryptedRequestingMember requestingMember = (DecryptedRequestingMember)((Object)requestingMembers.get(i));
            if (!allMembers.contains(requestingMember.aciBytes)) continue;
            requestingMembers.remove(i);
        }
        builder.requestingMembers(requestingMembers);
    }

    private static void ensureKnownRole(Member.Role role) throws NotAbleToApplyGroupV2ChangeException {
        if (role != Member.Role.ADMINISTRATOR && role != Member.Role.DEFAULT) {
            throw new NotAbleToApplyGroupV2ChangeException();
        }
    }

    private static int indexOfAci(List<DecryptedMember> memberList, ByteString aci) {
        for (int i = 0; i < memberList.size(); ++i) {
            if (!aci.equals((Object)memberList.get((int)i).aciBytes)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfAciInRequestingList(List<DecryptedRequestingMember> memberList, ByteString aci) {
        for (int i = 0; i < memberList.size(); ++i) {
            if (!aci.equals((Object)memberList.get((int)i).aciBytes)) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfServiceIdInBannedMemberList(List<DecryptedBannedMember> memberList, ByteString serviceIdBinary) {
        for (int i = 0; i < memberList.size(); ++i) {
            if (!serviceIdBinary.equals((Object)memberList.get((int)i).serviceIdBytes)) continue;
            return i;
        }
        return -1;
    }
}

