/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.groupsv2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.signal.core.models.ServiceId;
import org.signal.storageservice.storage.protos.groups.AccessControl;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroup;
import org.signal.storageservice.storage.protos.groups.local.DecryptedGroupChange;
import org.signal.storageservice.storage.protos.groups.local.DecryptedMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedModifyMemberLabel;
import org.signal.storageservice.storage.protos.groups.local.DecryptedPendingMember;
import org.signal.storageservice.storage.protos.groups.local.DecryptedRequestingMember;
import org.signal.storageservice.storage.protos.groups.local.EnabledState;
import org.whispersystems.signalservice.api.groupsv2.DecryptedGroupUtil;
import org.whispersystems.signalservice.api.groupsv2.GroupChangeField;
import org.whispersystems.signalservice.api.groupsv2.NotAbleToApplyGroupV2ChangeException;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\u0002\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007*\b\u0012\u0004\u0012\u00020\n0\u00032\u0006\u0010\b\u001a\u00020\u0002\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007*\b\u0012\u0004\u0012\u00020\f0\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0001\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u0017\u001a\u001c\u0010\u0018\u001a\u00020\u0019*\u00020\u00172\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0007\u00a8\u0006\u001b"}, d2={"toAciListWithUnknowns", "", "Lorg/signal/core/models/ServiceId$ACI;", "", "Lorg/signal/storageservice/storage/protos/groups/local/DecryptedMember;", "toAciList", "findMemberByAci", "Ljava/util/Optional;", "aci", "findRequestingByAci", "Lorg/signal/storageservice/storage/protos/groups/local/DecryptedRequestingMember;", "findPendingByServiceId", "Lorg/signal/storageservice/storage/protos/groups/local/DecryptedPendingMember;", "serviceId", "Lorg/signal/core/models/ServiceId;", "setModifyMemberLabelActions", "", "Lorg/signal/storageservice/storage/protos/groups/local/DecryptedGroup$Builder;", "actions", "Lorg/signal/storageservice/storage/protos/groups/local/DecryptedModifyMemberLabel;", "getChangedFields", "", "Lorg/whispersystems/signalservice/api/groupsv2/GroupChangeField;", "Lorg/signal/storageservice/storage/protos/groups/local/DecryptedGroupChange;", "isSilent", "", "changedFields", "signal-service-java"})
@JvmName(name="DecryptedGroupExtensions")
@SourceDebugExtension(value={"SMAP\nDecryptedGroupExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecryptedGroupExtensions.kt\norg/whispersystems/signalservice/api/groupsv2/DecryptedGroupExtensions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1869#2:138\n360#2,7:139\n1870#2:146\n*S KotlinDebug\n*F\n+ 1 DecryptedGroupExtensions.kt\norg/whispersystems/signalservice/api/groupsv2/DecryptedGroupExtensions\n*L\n47#1:138\n48#1:139,7\n47#1:146\n*E\n"})
public final class DecryptedGroupExtensions {
    @NotNull
    public static final List<ServiceId.ACI> toAciListWithUnknowns(@NotNull Collection<DecryptedMember> $this$toAciListWithUnknowns) {
        Intrinsics.checkNotNullParameter($this$toAciListWithUnknowns, (String)"<this>");
        ArrayList<ServiceId.ACI> arrayList = DecryptedGroupUtil.toAciListWithUnknowns($this$toAciListWithUnknowns);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"toAciListWithUnknowns(...)");
        return arrayList;
    }

    @NotNull
    public static final List<ServiceId.ACI> toAciList(@NotNull Collection<DecryptedMember> $this$toAciList) {
        Intrinsics.checkNotNullParameter($this$toAciList, (String)"<this>");
        ArrayList<ServiceId.ACI> arrayList = DecryptedGroupUtil.toAciList($this$toAciList);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"toAciList(...)");
        return arrayList;
    }

    @NotNull
    public static final Optional<DecryptedMember> findMemberByAci(@NotNull Collection<DecryptedMember> $this$findMemberByAci, @NotNull ServiceId.ACI aci) {
        Intrinsics.checkNotNullParameter($this$findMemberByAci, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Optional<DecryptedMember> optional = DecryptedGroupUtil.findMemberByAci($this$findMemberByAci, aci);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findMemberByAci(...)");
        return optional;
    }

    @NotNull
    public static final Optional<DecryptedRequestingMember> findRequestingByAci(@NotNull Collection<DecryptedRequestingMember> $this$findRequestingByAci, @NotNull ServiceId.ACI aci) {
        Intrinsics.checkNotNullParameter($this$findRequestingByAci, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        Optional<DecryptedRequestingMember> optional = DecryptedGroupUtil.findRequestingByAci($this$findRequestingByAci, aci);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findRequestingByAci(...)");
        return optional;
    }

    @NotNull
    public static final Optional<DecryptedPendingMember> findPendingByServiceId(@NotNull Collection<DecryptedPendingMember> $this$findPendingByServiceId, @NotNull ServiceId serviceId) {
        Intrinsics.checkNotNullParameter($this$findPendingByServiceId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Optional<DecryptedPendingMember> optional = DecryptedGroupUtil.findPendingByServiceId($this$findPendingByServiceId, serviceId);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findPendingByServiceId(...)");
        return optional;
    }

    public static final void setModifyMemberLabelActions(@NotNull DecryptedGroup.Builder $this$setModifyMemberLabelActions, @NotNull List<DecryptedModifyMemberLabel> actions) throws NotAbleToApplyGroupV2ChangeException {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setModifyMemberLabelActions), (String)"<this>");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        List updatedMembers = CollectionsKt.toMutableList((Collection)$this$setModifyMemberLabelActions.members);
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int modifiedMemberIndex;
            DecryptedModifyMemberLabel action2;
            block4: {
                int n;
                action2 = (DecryptedModifyMemberLabel)((Object)element$iv);
                boolean bl = false;
                List $this$indexOfFirst$iv = updatedMembers;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    DecryptedMember it = (DecryptedMember)((Object)item$iv);
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.aciBytes, (Object)action2.aciBytes)) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = modifiedMemberIndex = -1;
            }
            if (modifiedMemberIndex < 0) {
                throw new NotAbleToApplyGroupV2ChangeException();
            }
            updatedMembers.set(modifiedMemberIndex, ((DecryptedMember)((Object)updatedMembers.get(modifiedMemberIndex))).newBuilder().labelEmoji(action2.labelEmoji).labelString(action2.labelString).build());
        }
        $this$setModifyMemberLabelActions.members = updatedMembers;
    }

    @NotNull
    public static final Set<GroupChangeField> getChangedFields(@NotNull DecryptedGroupChange $this$getChangedFields) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getChangedFields), (String)"<this>");
        Set $this$getChangedFields_u24lambda_u242 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        if ($this$getChangedFields.newIsAnnouncementGroup != EnabledState.UNKNOWN) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.ANNOUNCEMENT_GROUP);
        }
        if ($this$getChangedFields.newAttributeAccess != AccessControl.AccessRequired.UNKNOWN) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.ATTRIBUTE_ACCESS);
        }
        if ($this$getChangedFields.newAvatar != null) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.AVATAR);
        }
        if (!((Collection)$this$getChangedFields.deleteBannedMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.BANNED_MEMBER_REMOVALS);
        }
        if (!((Collection)$this$getChangedFields.newBannedMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.BANNED_MEMBERS);
        }
        if ($this$getChangedFields.newDescription != null) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.DESCRIPTION);
        }
        if ($this$getChangedFields.newInviteLinkAccess != AccessControl.AccessRequired.UNKNOWN) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.INVITE_LINK_ACCESS);
        }
        if ($this$getChangedFields.newInviteLinkPassword.size() != 0) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.INVITE_LINK_PASSWORD);
        }
        if ($this$getChangedFields.newMemberAccess != AccessControl.AccessRequired.UNKNOWN) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.MEMBER_ACCESS);
        }
        if (!((Collection)$this$getChangedFields.modifyMemberLabels).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.MEMBER_LABELS);
        }
        if (!((Collection)$this$getChangedFields.deleteMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.MEMBER_REMOVALS);
        }
        if (!((Collection)$this$getChangedFields.modifyMemberRoles).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.MEMBER_ROLES);
        }
        if (!((Collection)$this$getChangedFields.newMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.MEMBERS);
        }
        if (!((Collection)$this$getChangedFields.promotePendingMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.PENDING_MEMBER_PROMOTIONS);
        }
        if (!((Collection)$this$getChangedFields.deletePendingMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.PENDING_MEMBER_REMOVALS);
        }
        if (!((Collection)$this$getChangedFields.newPendingMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.PENDING_MEMBERS);
        }
        if (!((Collection)$this$getChangedFields.promotePendingPniAciMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.PNI_ACI_PROMOTIONS);
        }
        if (!((Collection)$this$getChangedFields.modifiedProfileKeys).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.PROFILE_KEYS);
        }
        if (!((Collection)$this$getChangedFields.promoteRequestingMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.REQUESTING_MEMBER_APPROVALS);
        }
        if (!((Collection)$this$getChangedFields.deleteRequestingMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.REQUESTING_MEMBER_REMOVALS);
        }
        if (!((Collection)$this$getChangedFields.newRequestingMembers).isEmpty()) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.REQUESTING_MEMBERS);
        }
        if ($this$getChangedFields.newTimer != null) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.TIMER);
        }
        if ($this$getChangedFields.newTitle != null) {
            $this$getChangedFields_u24lambda_u242.add(GroupChangeField.TITLE);
        }
        return SetsKt.build((Set)set);
    }

    @JvmOverloads
    public static final boolean isSilent(@NotNull DecryptedGroupChange $this$isSilent, @NotNull Set<? extends GroupChangeField> changedFields) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isSilent), (String)"<this>");
        Intrinsics.checkNotNullParameter(changedFields, (String)"changedFields");
        return GroupChangeField.Companion.getSilentChanges().containsAll((Collection)changedFields);
    }

    public static /* synthetic */ boolean isSilent$default(DecryptedGroupChange decryptedGroupChange, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = DecryptedGroupExtensions.getChangedFields(decryptedGroupChange);
        }
        return DecryptedGroupExtensions.isSilent(decryptedGroupChange, set);
    }

    @JvmOverloads
    public static final boolean isSilent(@NotNull DecryptedGroupChange $this$isSilent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isSilent), (String)"<this>");
        return DecryptedGroupExtensions.isSilent$default($this$isSilent, null, 1, null);
    }
}

