/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.signal.core.util.CryptoUtil;
import org.whispersystems.signalservice.api.crypto.InvalidCiphertextException;
import org.whispersystems.util.ByteArrayUtil;

public final class HmacSIV {
    private static final byte[] AUTH_BYTES = "auth".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ENC_BYTES = "enc".getBytes(StandardCharsets.UTF_8);

    public static byte[] encrypt(byte[] K, byte[] M) {
        if (K.length != 32) {
            throw new AssertionError((Object)"K was wrong length");
        }
        if (M.length != 32) {
            throw new AssertionError((Object)"M was wrong length");
        }
        byte[] Ka = CryptoUtil.hmacSha256((byte[])K, (byte[])AUTH_BYTES);
        byte[] Ke = CryptoUtil.hmacSha256((byte[])K, (byte[])ENC_BYTES);
        byte[] IV = Arrays.copyOfRange(CryptoUtil.hmacSha256((byte[])Ka, (byte[])M), 0, 16);
        byte[] Kx = CryptoUtil.hmacSha256((byte[])Ke, (byte[])IV);
        byte[] C = ByteArrayUtil.xor(Kx, M);
        return ByteArrayUtil.concat(IV, C);
    }

    public static byte[] decrypt(byte[] K, byte[] IVC) throws InvalidCiphertextException {
        byte[] Ke;
        byte[] Kx;
        byte[] M;
        if (K.length != 32) {
            throw new AssertionError((Object)"K was wrong length");
        }
        if (IVC.length != 48) {
            throw new InvalidCiphertextException("IVC was wrong length");
        }
        byte[] IV = Arrays.copyOfRange(IVC, 0, 16);
        byte[] C = Arrays.copyOfRange(IVC, 16, 48);
        byte[] Ka = CryptoUtil.hmacSha256((byte[])K, (byte[])AUTH_BYTES);
        byte[] eExpectedIV = Arrays.copyOfRange(CryptoUtil.hmacSha256((byte[])Ka, (byte[])(M = ByteArrayUtil.xor(Kx = CryptoUtil.hmacSha256((byte[])(Ke = CryptoUtil.hmacSha256((byte[])K, (byte[])ENC_BYTES)), (byte[])IV), C))), 0, 16);
        if (Arrays.equals(IV, eExpectedIV)) {
            return M;
        }
        throw new InvalidCiphertextException("IV was incorrect");
    }
}

