/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.cds;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.signal.core.models.ServiceId;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.net.CdsiLookupRequest;
import org.signal.libsignal.net.CdsiLookupResponse;
import org.signal.libsignal.net.CdsiProtocolException;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.RetryLaterException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.push.exceptions.CdsiInvalidArgumentException;
import org.whispersystems.signalservice.api.push.exceptions.CdsiInvalidTokenException;
import org.whispersystems.signalservice.api.push.exceptions.CdsiResourceExhaustedException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;

public final class CdsiV2Service {
    private final CdsiRequestHandler cdsiRequestHandler = (username, password, request2, tokenSaver) -> {
        try {
            CompletableFuture cdsiRequest = network.cdsiLookup(username, password, CdsiV2Service.buildLibsignalRequest(request2), tokenSaver);
            return Single.fromFuture((Future)cdsiRequest).onErrorResumeNext(err -> {
                if (err instanceof ExecutionException && err.getCause() != null) {
                    err = err.getCause();
                }
                return Single.error((Throwable)CdsiV2Service.mapLibsignalError(err));
            }).map(CdsiV2Service::parseLibsignalResponse).toObservable();
        }
        catch (Exception exception) {
            return Observable.error((Throwable)CdsiV2Service.mapLibsignalError(exception));
        }
    };

    public CdsiV2Service(@Nonnull Network network) {
    }

    public Single<NetworkResult<Response>> getRegisteredUsers(String username, String password, Request request2, Consumer<byte[]> tokenSaver) {
        return this.cdsiRequestHandler.handleRequest(username, password, request2, tokenSaver).collect(Collectors.toList()).flatMap(pages -> {
            HashMap<String, ResponseItem> all = new HashMap<String, ResponseItem>();
            int quotaUsed = 0;
            for (Response page : pages) {
                all.putAll(page.getResults());
                quotaUsed += page.getQuotaUsedDebugOnly();
            }
            return Single.just(new NetworkResult.Success<Response>(new Response(all, quotaUsed)));
        }).onErrorReturn(error -> {
            if (error instanceof NonSuccessfulResponseCodeException) {
                return new NetworkResult.StatusCodeError((NonSuccessfulResponseCodeException)error);
            }
            if (error instanceof IOException) {
                return new NetworkResult.NetworkError((IOException)error);
            }
            return new NetworkResult.ApplicationError((Throwable)error);
        });
    }

    private static CdsiLookupRequest buildLibsignalRequest(Request request2) {
        HashMap serviceIds = new HashMap(request2.serviceIds.size());
        request2.serviceIds.forEach((key, value) -> serviceIds.put(key.getLibSignalServiceId(), value));
        return new CdsiLookupRequest(request2.previousE164s, request2.newE164s, serviceIds, Optional.ofNullable(request2.token));
    }

    private static Response parseLibsignalResponse(CdsiLookupResponse response) {
        HashMap<String, ResponseItem> responses = new HashMap<String, ResponseItem>(response.entries().size());
        response.entries().forEach((key, value) -> responses.put((String)key, new ResponseItem(new ServiceId.PNI(value.pni), Optional.ofNullable(value.aci).map(ServiceId.ACI::new))));
        return new Response(responses, response.debugPermitsUsed);
    }

    private static Throwable mapLibsignalError(Throwable lookupError) {
        if (lookupError instanceof org.signal.libsignal.net.CdsiInvalidTokenException) {
            return new CdsiInvalidTokenException();
        }
        if (lookupError instanceof RetryLaterException) {
            RetryLaterException e = (RetryLaterException)lookupError;
            return new CdsiResourceExhaustedException((int)e.duration.getSeconds());
        }
        if (lookupError instanceof IllegalArgumentException) {
            return new CdsiInvalidArgumentException();
        }
        if (lookupError instanceof CdsiProtocolException) {
            return new IOException(lookupError);
        }
        return lookupError;
    }

    private static interface CdsiRequestHandler {
        public Observable<Response> handleRequest(String var1, String var2, Request var3, Consumer<byte[]> var4);
    }

    public static final class Request {
        final Set<String> previousE164s;
        final Set<String> newE164s;
        final Set<String> removedE164s;
        final Map<ServiceId, ProfileKey> serviceIds;
        final byte[] token;

        public Request(Set<String> previousE164s, Set<String> newE164s, Map<ServiceId, ProfileKey> serviceIds, Optional<byte[]> token) {
            if (previousE164s.size() > 0 && !token.isPresent()) {
                throw new IllegalArgumentException("You must have a token if you have previousE164s!");
            }
            this.previousE164s = previousE164s;
            this.newE164s = newE164s;
            this.removedE164s = Collections.emptySet();
            this.serviceIds = serviceIds;
            this.token = token.orElse(null);
        }

        public int serviceIdSize() {
            return this.previousE164s.size() + this.newE164s.size() + this.removedE164s.size() + this.serviceIds.size();
        }
    }

    public static final class Response {
        private final Map<String, ResponseItem> results;
        private final int quotaUsed;

        public Response(Map<String, ResponseItem> results, int quoteUsed) {
            this.results = results;
            this.quotaUsed = quoteUsed;
        }

        public Map<String, ResponseItem> getResults() {
            return this.results;
        }

        public int getQuotaUsedDebugOnly() {
            return this.quotaUsed;
        }
    }

    public static final class ResponseItem {
        private final ServiceId.PNI pni;
        private final Optional<ServiceId.ACI> aci;

        public ResponseItem(ServiceId.PNI pni, Optional<ServiceId.ACI> aci) {
            this.pni = pni;
            this.aci = aci;
        }

        public ServiceId.PNI getPni() {
            return this.pni;
        }

        public Optional<ServiceId.ACI> getAci() {
            return this.aci;
        }

        public boolean hasAci() {
            return this.aci.isPresent();
        }
    }
}

