/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.cds;

import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.models.ServiceId;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.net.CdsiProtocolException;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.cds.CdsiV2Service;
import org.whispersystems.signalservice.api.push.exceptions.CdsiInvalidTokenException;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.CdsiAuthResponse;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Jo\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/whispersystems/signalservice/api/cds/CdsApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;)V", "getRegisteredUsers", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/api/cds/CdsiV2Service$Response;", "previousE164s", "", "", "newE164s", "serviceIds", "", "Lorg/signal/core/models/ServiceId;", "Lorg/signal/libsignal/zkgroup/profiles/ProfileKey;", "token", "Ljava/util/Optional;", "", "timeoutMs", "", "libsignalNetwork", "Lorg/signal/libsignal/net/Network;", "tokenSaver", "Ljava/util/function/Consumer;", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;Ljava/util/Optional;Ljava/lang/Long;Lorg/signal/libsignal/net/Network;Ljava/util/function/Consumer;)Lorg/whispersystems/signalservice/api/NetworkResult;", "Companion", "signal-service-java"})
public final class CdsApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private static final String TAG = Log.tag((KClass)Reflection.getOrCreateKotlinClass(CdsApi.class));

    public CdsApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        this.authWebSocket = authWebSocket;
    }

    @NotNull
    public final NetworkResult<CdsiV2Service.Response> getRegisteredUsers(@NotNull Set<String> previousE164s, @NotNull Set<String> newE164s, @NotNull Map<ServiceId, ProfileKey> serviceIds, @NotNull Optional<byte[]> token, @Nullable Long timeoutMs, @NotNull Network libsignalNetwork, @NotNull Consumer<byte[]> tokenSaver) {
        Intrinsics.checkNotNullParameter(previousE164s, (String)"previousE164s");
        Intrinsics.checkNotNullParameter(newE164s, (String)"newE164s");
        Intrinsics.checkNotNullParameter(serviceIds, (String)"serviceIds");
        Intrinsics.checkNotNullParameter(token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)libsignalNetwork, (String)"libsignalNetwork");
        Intrinsics.checkNotNullParameter(tokenSaver, (String)"tokenSaver");
        WebSocketRequestMessage authRequest = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v2/directory/auth", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, authRequest, Reflection.getOrCreateKotlinClass(CdsiAuthResponse.class), 0L, 8, null).then(arg_0 -> CdsApi.getRegisteredUsers$lambda$0(libsignalNetwork, previousE164s, newE164s, serviceIds, token, tokenSaver, timeoutMs, arg_0));
    }

    private static final NetworkResult getRegisteredUsers$lambda$0(Network $libsignalNetwork, Set $previousE164s, Set $newE164s, Map $serviceIds, Optional $token, Consumer $tokenSaver, Long $timeoutMs, CdsiAuthResponse auth) {
        NetworkResult networkResult;
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        CdsiV2Service service = new CdsiV2Service($libsignalNetwork);
        CdsiV2Service.Request request2 = new CdsiV2Service.Request($previousE164s, $newE164s, $serviceIds, $token);
        Single<NetworkResult<CdsiV2Service.Response>> single = service.getRegisteredUsers(auth.getUsername(), auth.getPassword(), request2, $tokenSaver);
        try {
            networkResult = $timeoutMs == null ? (NetworkResult)single.blockingGet() : (NetworkResult)single.timeout($timeoutMs.longValue(), TimeUnit.MILLISECONDS).blockingGet();
            Intrinsics.checkNotNull((Object)networkResult);
        }
        catch (RuntimeException e) {
            NetworkResult.NetworkError networkError;
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                networkError = new NetworkResult.NetworkError(new IOException("Interrupted", cause));
            } else if (cause instanceof TimeoutException) {
                networkError = new NetworkResult.NetworkError(new IOException("Timed out"));
            } else if (cause instanceof CdsiProtocolException) {
                networkError = new NetworkResult.NetworkError(new IOException("CdsiProtocol", cause));
            } else if (cause instanceof CdsiInvalidTokenException) {
                networkError = new NetworkResult.NetworkError(new IOException("CdsiInvalidToken", cause));
            } else {
                Log.w((String)TAG, (String)"Unexpected exception", (Throwable)cause);
                networkError = new NetworkResult.NetworkError(new IOException(cause));
            }
            networkResult = networkError;
        }
        return networkResult;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/whispersystems/signalservice/api/cds/CdsApi$Companion;", "", "<init>", "()V", "TAG", "", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

