/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.calling;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredentialRequest;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredentialResponse;
import org.signal.storageservice.protos.calls.quality.SubmitCallQualitySurveyRequest;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.messages.calls.CallingResponse;
import org.whispersystems.signalservice.api.messages.calls.TurnServerInfo;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.CreateCallLinkAuthRequest;
import org.whispersystems.signalservice.internal.push.CreateCallLinkAuthResponse;
import org.whispersystems.signalservice.internal.push.GetCallingRelaysResponse;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000bJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b2\u0006\u0010\r\u001a\u00020\u0014JJ\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u001a\u0010\u001c\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001d\u0018\u00010\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/whispersystems/signalservice/api/calling/CallingApi;", "", "auth", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "unAuth", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "submitCallQualitySurvey", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "request", "Lorg/signal/storageservice/protos/calls/quality/SubmitCallQualitySurveyRequest;", "getTurnServerInfo", "", "Lorg/whispersystems/signalservice/api/messages/calls/TurnServerInfo;", "createCallLinkCredential", "Lorg/signal/libsignal/zkgroup/calllinks/CreateCallLinkCredentialResponse;", "Lorg/signal/libsignal/zkgroup/calllinks/CreateCallLinkCredentialRequest;", "makeCallingRequest", "Lorg/whispersystems/signalservice/api/messages/calls/CallingResponse;", "requestId", "", "url", "", "httpMethod", "headers", "Lkotlin/Pair;", "body", "", "signal-service-java"})
public final class CallingApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket auth;
    @NotNull
    private final SignalWebSocket.UnauthenticatedWebSocket unAuth;
    @NotNull
    private final PushServiceSocket pushServiceSocket;

    public CallingApi(@NotNull SignalWebSocket.AuthenticatedWebSocket auth, @NotNull SignalWebSocket.UnauthenticatedWebSocket unAuth, @NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)unAuth, (String)"unAuth");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.auth = auth;
        this.unAuth = unAuth;
        this.pushServiceSocket = pushServiceSocket;
    }

    @NotNull
    public final NetworkResult<Unit> submitCallQualitySurvey(@NotNull SubmitCallQualitySurveyRequest request2) {
        Intrinsics.checkNotNullParameter((Object)((Object)request2), (String)"request");
        WebSocketRequestMessage webSocketRequestMessage = WebSocketRequestExtKt.putCustom(WebSocketRequestMessage.Companion, "/v1/call_quality_survey", request2.encode(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/octet-stream")));
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.unAuth, webSocketRequestMessage, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<List<TurnServerInfo>> getTurnServerInfo() {
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v2/calling/relays", null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.auth, request2, Reflection.getOrCreateKotlinClass(GetCallingRelaysResponse.class), 0L, 8, null).map(CallingApi::getTurnServerInfo$lambda$0);
    }

    @NotNull
    public final NetworkResult<CreateCallLinkCredentialResponse> createCallLinkCredential(@NotNull CreateCallLinkCredentialRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        WebSocketRequestMessage request3 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/call-link/create-auth", CreateCallLinkAuthRequest.Companion.create(request2), null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.auth, request3, Reflection.getOrCreateKotlinClass(CreateCallLinkAuthResponse.class), 0L, 8, null).map(CallingApi::createCallLinkCredential$lambda$1);
    }

    @NotNull
    public final NetworkResult<CallingResponse> makeCallingRequest(long requestId, @NotNull String url, @NotNull String httpMethod, @Nullable List<Pair<String, String>> headers, @Nullable byte[] body) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        NetworkResult result2 = NetworkResult.Companion.fromFetch(() -> CallingApi.makeCallingRequest$lambda$2(this, requestId, url, httpMethod, headers, body));
        return result2 instanceof NetworkResult.Success ? result2 : (NetworkResult)new NetworkResult.Success<CallingResponse.Error>(new CallingResponse.Error(requestId, result2.getCause()));
    }

    private static final List getTurnServerInfo$lambda$0(GetCallingRelaysResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = it.getRelays();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final CreateCallLinkCredentialResponse createCallLinkCredential$lambda$1(CreateCallLinkAuthResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCreateCallLinkCredentialResponse();
    }

    private static final CallingResponse makeCallingRequest$lambda$2(CallingApi this$0, long $requestId, String $url, String $httpMethod, List $headers, byte[] $body) {
        return this$0.pushServiceSocket.makeCallingRequest($requestId, $url, $httpMethod, $headers, $body);
    }
}

